/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.invcloud;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.invcloud.bean.aws.InvoiceCloudCfg;
import kd.scm.common.invcloud.bean.aws.InvoiceTitleTax;
import kd.scm.common.util.ParamUtil;
import org.apache.commons.lang3.StringUtils;

public class KingdeeInvoiceCloudConfig {
    private static final Log logger = LogFactory.getLog(KingdeeInvoiceCloudConfig.class);
    private static final String ER_BD_KDINVOICECLOUDCFGCT = "er_bd_kdinvoicecloudcfgct";
    public static final String ER_BD_KDINVOICECLOUDCFG = "er_bd_kdinvoicecloudcfg";
    public static final String KEY_APLIT = "::";
    private static final Object NULL_OBJECT = new Object();

    public static Boolean reimed_ci(Long companyId) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(companyId);
        return config == null ? null : config.getReimedCi();
    }

    public static String getCompanyNameBy(Long companyId) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(companyId);
        return config == null ? null : config.getFirmname();
    }

    public static String getTicketParam(Long companyId) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(companyId);
        if (config == null) {
            return "11111";
        }
        return (config.getReimedCi() != false ? "1" : "0") + (config.getNameNotMatchCi() != false ? "1" : "0") + (config.getTaxNumNotMatchCi() != false ? "1" : "0") + (config.getCheckNotPassCi() != false ? "1" : "0") + (config.getBuyerNameLessEqual5Ci() != false ? "1" : "0");
    }

    public static String getInvoiceConfigPattern() {
        String result = KingdeeInvoiceCloudConfig.get("invoicecloud.configpattern");
        return result;
    }

    public static boolean isEnableXhInvoiceCloud() {
        String isenableinvcloudStr;
        Object isenableinvcloud = ParamUtil.getParamObj((String)"eae607fb000143ac", (String)"invoicecloudxh");
        return isenableinvcloud == null || !"aws".equals(isenableinvcloudStr = String.valueOf(isenableinvcloud));
    }

    public static String getInvoiceSelectURL_PC() {
        String domain = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        return domain + KingdeeInvoiceCloudConfig.get("invoicecloud.pc_surl_prod");
    }

    public static String getInvoiceListURL_PC() {
        String domain = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        return domain + KingdeeInvoiceCloudConfig.get("invoicecloud.pc_vlisturl_prod");
    }

    public static String getInvoiceViewURL_PC() {
        String domain = KingdeeInvoiceCloudConfig.getInvoiceDomain();
        return domain + KingdeeInvoiceCloudConfig.get("invoicecloud.pc_vurl_prod");
    }

    public static String getInvoiceDomain() {
        boolean not_prod = KingdeeInvoiceCloudConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? KingdeeInvoiceCloudConfig.get("invoicecloud.domain_test") : KingdeeInvoiceCloudConfig.get("invoicecloud.domain_prod");
    }

    public static String gridParam() {
        String defaultGridParam = "1100";
        String result = KingdeeInvoiceCloudConfig.get("invoicecloud.gridParam");
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return result.trim();
        }
        return defaultGridParam;
    }

    public static boolean isProduct() {
        String notProduct = KingdeeInvoiceCloudConfig.get("invoicecloud.not_prod");
        if (StringUtils.isBlank((CharSequence)notProduct)) {
            return true;
        }
        return !Boolean.parseBoolean(notProduct);
    }

    public static String get(String key) {
        String paramvalue = "";
        DynamicObject queryOne = BusinessDataServiceHelper.loadSingleFromCache((String)"pur_updateparamconfig", (String)"id,paramvalue,paramkey", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)key)});
        if (queryOne != null) {
            paramvalue = queryOne.getString("paramvalue");
        }
        return paramvalue;
    }

    public static boolean getBoolean(String key) {
        String value = KingdeeInvoiceCloudConfig.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static InvoiceCloudCfg getConfig(Long invoiceOrgId) {
        if (invoiceOrgId == null) {
            return null;
        }
        String key = String.format("kd.scm.common.invcloud.KingdeeInvoiceCloudConfig.getConfig(Long),%s", invoiceOrgId);
        Object value = null;
        if (ThreadCache.exists((Object)key)) {
            value = ThreadCache.get((Object)key);
            if (value == NULL_OBJECT) {
                value = null;
            }
        } else {
            String invoiceConfigPattern = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern();
            value = StringUtils.isNotEmpty((CharSequence)invoiceConfigPattern) && StringUtils.equals((CharSequence)invoiceConfigPattern.trim(), (CharSequence)"2") ? KingdeeInvoiceCloudConfig.getGroupConfig(invoiceOrgId) : KingdeeInvoiceCloudConfig.getConfigOrgId(invoiceOrgId);
            if (value == null) {
                ThreadCache.put((Object)key, (Object)NULL_OBJECT);
            } else {
                ThreadCache.put((Object)key, (Object)value);
            }
        }
        return (InvoiceCloudCfg)value;
    }

    private static InvoiceCloudCfg getConfigOrgId(Long invoiceOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)invoiceOrgId), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)ER_BD_KDINVOICECLOUDCFG, (QFilter[])filters);
        if (config == null) {
            return null;
        }
        InvoiceCloudCfg invoiceCloudCfgBO = KingdeeInvoiceCloudConfig.transferInvoiceCfg(config);
        long id = config.getLong("id");
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u6a21\u5f0f\u53d1\u7968\u4e91\u914d\u7f6eid: " + id);
        invoiceCloudCfgBO.setEntityName(ER_BD_KDINVOICECLOUDCFG);
        invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
        invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
        return invoiceCloudCfgBO;
    }

    public static InvoiceCloudCfg transferInvoiceCfg(DynamicObject config) {
        if (config == null) {
            return null;
        }
        InvoiceCloudCfg invoiceCloudCfgBO = new InvoiceCloudCfg();
        invoiceCloudCfgBO.setClientId(config.getString("client_id"));
        invoiceCloudCfgBO.setClientSecret(config.getString("client_secret"));
        invoiceCloudCfgBO.setEncryptKey(config.getString("encrypt_key"));
        invoiceCloudCfgBO.setReimedCi(config.getBoolean("reimed_ci"));
        invoiceCloudCfgBO.setNameNotMatchCi(config.getBoolean("namenotmatch_ci"));
        invoiceCloudCfgBO.setTaxNumNotMatchCi(config.getBoolean("taxnumnotmatch_ci"));
        invoiceCloudCfgBO.setCheckNotPassCi(config.getBoolean("checknotpass_ci"));
        invoiceCloudCfgBO.setBuyerNameLessEqual5Ci(config.getBoolean("buyernamele5_ci"));
        String firmName = config.getString("firmname");
        firmName = firmName.replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09");
        invoiceCloudCfgBO.setFirmname(firmName);
        invoiceCloudCfgBO.setTaxRegnum(config.getString("taxregnum"));
        return invoiceCloudCfgBO;
    }

    private static InvoiceCloudCfg getGroupConfig(Long invoiceOrgId) {
        QFilter enableQFilter;
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)ER_BD_KDINVOICECLOUDCFGCT, (Long)invoiceOrgId);
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)ER_BD_KDINVOICECLOUDCFGCT, (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)true)});
        if (configMap == null || configMap.isEmpty()) {
            return null;
        }
        Collection configs = configMap.values();
        DynamicObject mainConfig = configs.stream().sorted((c1, c2) -> {
            Date modifyDate2;
            Long createOrg1 = KingdeeInvoiceCloudConfig.getPk(c1.getDynamicObject("createorg"));
            Long createOrg2 = KingdeeInvoiceCloudConfig.getPk(c2.getDynamicObject("createorg"));
            if (Objects.equals(createOrg1, invoiceOrgId) && !Objects.equals(createOrg2, invoiceOrgId)) {
                return -1;
            }
            if (Objects.equals(createOrg2, invoiceOrgId) && !Objects.equals(createOrg1, invoiceOrgId)) {
                return 1;
            }
            String ctlStrategy1 = c1.getString("ctrlstrategy");
            String ctlStrategy2 = c2.getString("ctrlstrategy");
            if ("7".equals(ctlStrategy1) && !"7".equals(ctlStrategy2)) {
                return -1;
            }
            if ("7".equals(ctlStrategy2) && !"7".equals(ctlStrategy1)) {
                return 1;
            }
            Date modifyDate1 = c1.getDate("modifytime");
            if (modifyDate1.compareTo(modifyDate2 = c2.getDate("modifytime")) < 0) {
                return 1;
            }
            return -1;
        }).findFirst().orElse(null);
        InvoiceCloudCfg invoiceCloudCfgBO = new InvoiceCloudCfg();
        long id = mainConfig.getLong("id");
        logger.info("\u83b7\u53d6\u96c6\u56e2\u6a21\u5f0f\u53d1\u7968\u4e91\u914d\u7f6eid: " + id);
        invoiceCloudCfgBO.setId(id);
        invoiceCloudCfgBO.setEntityName(ER_BD_KDINVOICECLOUDCFGCT);
        invoiceCloudCfgBO.setClientId(mainConfig.getString("client_id"));
        invoiceCloudCfgBO.setClientSecret(mainConfig.getString("client_secret"));
        invoiceCloudCfgBO.setEncryptKey(mainConfig.getString("encrypt_key"));
        invoiceCloudCfgBO.setReimedCi(mainConfig.getBoolean("reimed_ci"));
        invoiceCloudCfgBO.setNameNotMatchCi(mainConfig.getBoolean("namenotmatch_ci"));
        invoiceCloudCfgBO.setTaxNumNotMatchCi(mainConfig.getBoolean("taxnumnotmatch_ci"));
        invoiceCloudCfgBO.setCheckNotPassCi(mainConfig.getBoolean("checknotpass_ci"));
        invoiceCloudCfgBO.setBuyerNameLessEqual5Ci(mainConfig.getBoolean("buyernamele5_ci"));
        invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
        String taxRegNums = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("taxregnum"), (CharSequence)"")).collect(Collectors.joining("="));
        String firmnames = configs.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("firmname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09"), (CharSequence)"")).collect(Collectors.joining("="));
        List<InvoiceTitleTax> titleTaxList = configs.stream().map(config -> new InvoiceTitleTax(config.getString("firmname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09"), config.getString("taxregnum"))).collect(Collectors.toList());
        invoiceCloudCfgBO.setTaxRegnum(taxRegNums);
        invoiceCloudCfgBO.setFirmname(firmnames);
        invoiceCloudCfgBO.setTitleTaxList(titleTaxList);
        return invoiceCloudCfgBO;
    }

    public static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        if (entity instanceof Integer) {
            return Long.valueOf(entity.toString());
        }
        return null;
    }
}

