/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class BussinessTypeUtils {
    public static final String BIZTYPE_GENERAL_110 = "110";
    public static final String BIZTYPE_GOODS_140 = "140";
    public static final String BIZTYPE_PMOM_604 = "604";
    public static final String BIZTYPE_CPOM_WX110 = "WX110";
    public static final String BIZTYPE_ACCEPT_113 = "113";
    public static final String BIZTYPE_ACCEPT_112 = "112";

    public static boolean isOmBussinessType(String bussnissTypeNumber) {
        return StringUtils.isNotBlank((String)bussnissTypeNumber) ? bussnissTypeNumber.startsWith(BIZTYPE_PMOM_604) || bussnissTypeNumber.startsWith(BIZTYPE_CPOM_WX110) : false;
    }

    public static boolean checkOmBussinessType(DynamicObject bussnissType) {
        boolean isOmBusinessType = BussinessTypeUtils.checkIsPmOmBussinessType(bussnissType) || BussinessTypeUtils.checkIsCpOmBussinessType(bussnissType);
        return isOmBusinessType;
    }

    public static boolean checkIsPmOmBizTypeId(Long bussnissTypeId) {
        return BussinessTypeUtils.checkBizTypeId(bussnissTypeId, BIZTYPE_PMOM_604);
    }

    public static boolean checkIsPmOmBussinessType(DynamicObject bussnissType) {
        return BussinessTypeUtils.checkBussinessType(bussnissType, BIZTYPE_PMOM_604);
    }

    public static boolean isPmOmBussinessType(String bussnissTypeNumber) {
        return BussinessTypeUtils.IsBizType(bussnissTypeNumber, BIZTYPE_PMOM_604);
    }

    public static boolean checkIsCpOmBizTypeId(Long bussnissTypeId) {
        return BussinessTypeUtils.checkBizTypeId(bussnissTypeId, BIZTYPE_CPOM_WX110);
    }

    public static boolean checkIsCpOmBussinessType(DynamicObject bussnissType) {
        return BussinessTypeUtils.checkBussinessType(bussnissType, BIZTYPE_CPOM_WX110);
    }

    public static boolean isIsCPOmBussinessType(String bussnissTypeNumber) {
        return BussinessTypeUtils.IsBizType(bussnissTypeNumber, BIZTYPE_CPOM_WX110);
    }

    public static boolean checkBizTypeId(Long bussnissTypeId, String suffix) {
        if (!Objects.isNull(bussnissTypeId)) {
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bussnissTypeId, (String)"bd_biztype");
            return BussinessTypeUtils.checkBussinessType(bizType, suffix);
        }
        return false;
    }

    public static boolean checkBussinessType(DynamicObject bussnissType, String suffix) {
        if (bussnissType == null) {
            return false;
        }
        String number = bussnissType.getString("number");
        return BussinessTypeUtils.IsBizType(number, suffix);
    }

    public static boolean IsBizType(String bizTypeNumber, String suffix) {
        return StringUtils.isNotBlank((String)bizTypeNumber) ? bizTypeNumber.startsWith(suffix) : false;
    }

    public static List<Long> getPmOmBussnissTypeIds() {
        return BussinessTypeUtils.getBussnissTypeIdsBySuffix(BIZTYPE_PMOM_604);
    }

    public static List<Long> getOmBussnissTypeIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(BIZTYPE_PMOM_604);
        arrayList.add(BIZTYPE_CPOM_WX110);
        return BussinessTypeUtils.getBussnissTypeIdsBySuffixs(arrayList);
    }

    private static List<Long> getBussnissTypeIdsBySuffixs(List<String> suffixs) {
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter qf = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (suffixs != null) {
            for (int i = 0; i < suffixs.size(); ++i) {
                String suffix = suffixs.get(i);
                if (i == 0) {
                    qf.and("number", "like", (Object)(suffix + "%"));
                    continue;
                }
                qf.or("number", "like", (Object)(suffix + "%"));
            }
        }
        DynamicObjectCollection bizTypes = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dy : bizTypes) {
            ids.add(dy.getLong("id"));
        }
        return ids;
    }

    public static List<Long> getBussnissTypeIdsBySuffix(String suffix) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(suffix);
        return BussinessTypeUtils.getBussnissTypeIdsBySuffixs(arrayList);
    }
}

