/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillAssistUtil;

public class GenericLogisticsInfoQueryUtil {
    public List<DynamicObject> queryDynamicObjectDataForMall(String purBillNo) {
        String[] entityKeys = new String[]{"scp_order", "scp_saloutstock"};
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(16);
        for (String entityKey : entityKeys) {
            HashMap<String, Object> poBillMap = new HashMap<String, Object>();
            poBillMap.put("match", purBillNo);
            Map<String, Map<String, Object>> filterMap = BillAssistUtil.assembleBillNO(entityKey, poBillMap);
            HashMap<String, String> billStatusFilter = new HashMap<String, String>(8);
            billStatusFilter.put("=", BillStatusEnum.AUDIT.getVal());
            filterMap.put("billstatus", billStatusFilter);
            data.addAll(this.queryDynamicData(entityKey, this.assembleSelectFlied(entityKey), filterMap));
        }
        return data;
    }

    public List<DynamicObject> queryDynamicData(String entryKey, String flied, Map<String, Map<String, Object>> filterMap) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        DynamicObjectCollection dynamicObjects = null;
        dynamicObjects = ORMUtil.queryDynamicObjectCollection((String)entryKey, (String)flied, filterMap, (String)"logentryentity.logdate desc");
        HashSet<String> logBillNoSet = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String logBillNo = dynamicObject.getString("logbillno");
                if (logBillNo == null || !logBillNoSet.add(logBillNo)) continue;
                dynamicObjectList.add(dynamicObject);
            }
        }
        return dynamicObjectList;
    }

    public String assembleSelectFlied(String billKey) {
        switch (billKey) {
            case "scp_order": {
                return "id,billno,billdate billdate,supplier.id supplier,rcvorg.id rcvorg,logentryentity.id logid,logentryentity.logsupplier logsupplier,logentryentity.logsupplier.number logsuppliernumber,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_saloutstock": {
                return "id,billno,billdate billdate,org.id rcvorg,supplier.id supplier,logentryentity.id logid,logentryentity.logsupplier logsupplier,logentryentity.logsupplier.number logsuppliernumber,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_receive": {
                return "id,billno,billdate billdate,rcvorg.id rcvorg,supplier.id supplier,logentryentity.id logid,logentryentity.logsupplier logsupplier,logentryentity.logsupplier.number logsuppliernumber,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
            case "scp_invoice": {
                return "id,billno,billdate billdate,org.id org,supplier.id supplier,logentryentity.id logid,logentryentity.logsupplier logsupplier,logentryentity.logsupplier.number logsuppliernumber,logentryentity.logbillno logbillno,logentryentity.logdate logdate,logentryentity.logdelidate logdelidate,logentryentity.lognote lognote";
            }
        }
        return null;
    }
}

