/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.AutoPushSalOutUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.SynOrderUtil;
import kd.scm.common.util.WriteBackUtil;

public class OrderUtil {
    private static final Log log = LogFactory.getLog(OrderUtil.class);

    private OrderUtil() {
    }

    @Deprecated
    public static void updateOrderCfmStatusByPks(Object[] pks, String entityKey) {
        DynamicObject[] orders = OrderUtil.getOrderInfo(pks, entityKey);
        OrderUtil.updateOrderCfmStatusByOrders(orders);
    }

    public static void updateOrderCfmStatusByOrders(DynamicObject[] orders) {
        if (orders.length == 0) {
            return;
        }
        OrderUtil.updateOrderCfmStatus(orders);
        OrderUtil.updateVmiInstockQty(orders);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        AutoPushSalOutUtil.updateOrdersConfirmed(orders);
    }

    public static void updateMalOrderByOrder(DynamicObject[] orders) {
        HashMap<String, String> logisticMap = new HashMap<String, String>();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        HashMap<String, String> receiptQtyMap = new HashMap<String, String>();
        HashMap<String, String> suminstockqtyMap = new HashMap<String, String>();
        HashMap<Long, String> billNoMap = new HashMap<Long, String>();
        HashMap<String, BigDecimal> orderQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> rowLogStatusMap = new HashMap<String, String>();
        for (DynamicObject order : orders) {
            String srcType = order.getString("srctype");
            if (null == srcType || !srcType.equalsIgnoreCase(ProductSourceEnum.PRODUCTSOURCE_SELF.getVal()) && !srcType.equalsIgnoreCase(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) continue;
            logisticMap.put(order.getString("billno"), order.getString("logstatus"));
            statusMap.put(order.getString("billno"), order.getString("billstatus"));
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
            String cfmStatus = "";
            if (order.containsProperty("cfmstatus")) {
                cfmStatus = order.getString("cfmstatus");
            }
            for (DynamicObject entry : entrys) {
                String srcEntryId = entry.getString("srcentryid");
                if (!StringUtils.isNotEmpty((CharSequence)srcEntryId)) continue;
                receiptQtyMap.put(srcEntryId, String.valueOf(entry.getBigDecimal("sumreceiptqty").subtract(entry.getBigDecimal("sumrecretqty"))));
                suminstockqtyMap.put(srcEntryId, String.valueOf(entry.getBigDecimal("suminstockqty").subtract(entry.getBigDecimal("suminstockretqty"))));
                orderQtyMap.put(srcEntryId, entry.getBigDecimal("qty"));
                billNoMap.put(Long.valueOf(srcEntryId), order.getString("billno"));
                String rowlogstatus = entry.getString("rowlogstatus");
                if (StringUtils.isBlank((CharSequence)rowlogstatus)) {
                    if (!StringUtils.isNotBlank((CharSequence)cfmStatus)) continue;
                    String newRowlogstatus = OrderUtil.stateMapping(cfmStatus);
                    rowLogStatusMap.put(srcEntryId, newRowlogstatus);
                    continue;
                }
                rowLogStatusMap.put(srcEntryId, entry.getString("rowlogstatus"));
            }
        }
        String selectFields = "id,entryentity.id,entryentity.erpbillnumber,entryentity.erplogstatus,entryentity.erpbillstatus,entryentity.sumreceiptqty,entryentity.suminstockqty,entryentity.sumorderqty";
        QFilter filter = new QFilter("entryentity.id", "in", billNoMap.keySet());
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (null != dyos && dyos.length > 0) {
            for (DynamicObject bill : dyos) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    BigDecimal entrySumorderQty = (BigDecimal)orderQtyMap.get(entry.getPkValue().toString());
                    if (entrySumorderQty == null) continue;
                    String purOrderNo = (String)billNoMap.get(entry.getLong("id"));
                    entry.set("erpbillnumber", (Object)purOrderNo);
                    entry.set("erpbillstatus", statusMap.get(purOrderNo));
                    String logisticMapValue = (String)logisticMap.get(purOrderNo);
                    if (logisticMapValue == null) continue;
                    entry.set("erplogstatus", rowLogStatusMap.get(entry.getPkValue().toString()));
                    if (null == receiptQtyMap.get(entry.getPkValue().toString())) continue;
                    entry.set("sumreceiptqty", receiptQtyMap.get(entry.getPkValue().toString()));
                    entry.set("suminstockqty", suminstockqtyMap.get(entry.getPkValue().toString()));
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyos);
        }
    }

    private static String stateMapping(String cfmStatus) {
        if (cfmStatus.isEmpty()) {
            return "";
        }
        String rowlogstatus = "";
        if (ConfirmStatusEnum.UNCONFIRM.getVal().equals(cfmStatus)) {
            rowlogstatus = LogisticsStatusEnum.BECONFIRMING.getVal();
        } else if (ConfirmStatusEnum.CONFIRM.getVal().equals(cfmStatus)) {
            rowlogstatus = LogisticsStatusEnum.CONFIRMED.getVal();
        } else if (ConfirmStatusEnum.REJECT.getVal().equals(cfmStatus)) {
            rowlogstatus = LogisticsStatusEnum.REJECT.getVal();
        }
        return rowlogstatus;
    }

    @Deprecated
    public static void updateOrderCfmStatus(DynamicObject[] orders) {
        OrderUtil.updateOrderCfmStatus(orders, true);
    }

    @Deprecated
    public static void updateOrderCfmStatus(List<String> poEntryPks) {
        String seltcor = "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.sumrefundqty,materialentry.entrystatus,materialentry.rowlogstatus,materialentry.linetype,materialentry.taxamount,materialentry.sumaccepttaxamount,materialentry.sumapaccepttaxamount,materialentry.relateapaccepttaxamount";
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pur_order", (String)seltcor, (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryPks)});
        OrderUtil.updateOrderCfmStatus(orders, poEntryPks);
    }

    @Deprecated
    public static void updateOrderCfmStatus(DynamicObject[] orders, List<String> poEntryPks) {
        OrderUtil.updateOrderCfmStatus(orders, poEntryPks, false);
    }

    @Deprecated
    public static void updateOrderCfmStatus(DynamicObject[] orders, boolean isUpdateMalOrder) {
        ArrayList<String> poEntryPks = new ArrayList<String>(orders.length);
        for (DynamicObject order : orders) {
            DynamicObjectCollection orderDynamicObjectCollection = order.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : orderDynamicObjectCollection) {
                String poEntryId = row.getString("poentryid");
                if (poEntryId == null || poEntryId.isEmpty()) continue;
                poEntryPks.add(poEntryId);
            }
        }
        OrderUtil.excuteOrderStatus(orders, poEntryPks);
        if (isUpdateMalOrder) {
            OrderUtil.updateMalOrderByOrder(orders);
        }
    }

    public static void updateOrderCfmStatus(DynamicObject[] orders, List<String> poEntryPks, Boolean inTrans) {
        OrderUtil.excuteOrderStatus(orders, poEntryPks);
        if (!inTrans.booleanValue()) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
        OrderUtil.updateMalOrderByOrder(orders);
    }

    private static void excuteOrderStatusByAmount(DynamicObject[] orders, List<String> poEntryPks) {
        for (int i = 0; i < orders.length; ++i) {
            DynamicObject order = orders[i];
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
            DynamicObjectType entrysDynamicObjectType = entrys.getDynamicObjectType();
            Boolean isAllAmountControlCriterion = true;
            boolean isPartOutStock = false;
            boolean isPartRecipt = false;
            for (DynamicObject row : entrys) {
                boolean isRowPartOutStock = false;
                boolean isRowAllOutStock = false;
                boolean isRowPartRecipt = false;
                boolean isRowAllRecipt = false;
                boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)row);
                if (!amountLineTypeControlCriterion) {
                    isAllAmountControlCriterion = false;
                    continue;
                }
                BigDecimal taxAmount = CommonUtil.getBigDecimalPro((Object)row.get("taxamount"));
                BigDecimal sumApacceptTaxAmount = BigDecimal.ZERO;
                if (entrysDynamicObjectType.getProperty("sumapaccepttaxamount") != null) {
                    sumApacceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumapaccepttaxamount"));
                }
                if (sumApacceptTaxAmount.compareTo(BigDecimal.ZERO) > 0 && sumApacceptTaxAmount.compareTo(taxAmount) < 0) {
                    isRowPartOutStock = true;
                    isRowAllOutStock = false;
                    isPartOutStock = true;
                } else if (sumApacceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                    isRowPartOutStock = false;
                    isRowAllOutStock = false;
                } else if (sumApacceptTaxAmount.compareTo(taxAmount) >= 0) {
                    isRowPartOutStock = false;
                    isRowAllOutStock = true;
                }
                BigDecimal sumAcceptTaxAmount = BigDecimal.ZERO;
                if (entrysDynamicObjectType.getProperty("sumaccepttaxamount") != null) {
                    sumAcceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumaccepttaxamount"));
                }
                if (sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) > 0 && sumAcceptTaxAmount.compareTo(taxAmount) < 0) {
                    isRowPartRecipt = true;
                    isRowAllRecipt = false;
                    isPartRecipt = true;
                } else if (sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = false;
                } else if (sumAcceptTaxAmount.compareTo(taxAmount) >= 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = true;
                }
                OrderUtil.setRowLogisticsStatus(isRowPartOutStock, isRowAllOutStock, isRowPartRecipt, isRowAllRecipt, false, false, orders[i], row);
            }
            if (!isAllAmountControlCriterion.booleanValue()) continue;
            OrderUtil.setAmountLogisticsStatus(order, isPartOutStock, isPartRecipt);
        }
    }

    private static void setAmountLogisticsStatus(DynamicObject order, boolean isPartOutStock, boolean isPartRecipt) {
        boolean isAllOutStock = false;
        boolean isAllRecipt = false;
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
        DynamicObjectType entrysDynamicObjectType = entrys.getDynamicObjectType();
        BigDecimal total_taxAmount = BigDecimal.ZERO;
        BigDecimal total_sumApacceptTaxAmount = BigDecimal.ZERO;
        BigDecimal total_sumAcceptTaxAmount = BigDecimal.ZERO;
        for (DynamicObject row : entrys) {
            boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)row);
            if (!amountLineTypeControlCriterion) continue;
            if (entrysDynamicObjectType.getProperty("taxamount") != null) {
                total_taxAmount = total_taxAmount.add(row.getBigDecimal("taxamount"));
            }
            if (entrysDynamicObjectType.getProperty("sumapaccepttaxamount") != null) {
                BigDecimal sumApacceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumapaccepttaxamount"));
                total_sumApacceptTaxAmount = total_sumApacceptTaxAmount.add(sumApacceptTaxAmount);
            }
            if (entrysDynamicObjectType.getProperty("sumaccepttaxamount") == null) continue;
            BigDecimal sumAcceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumaccepttaxamount"));
            total_sumAcceptTaxAmount = total_sumAcceptTaxAmount.add(sumAcceptTaxAmount);
        }
        if (total_sumApacceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
            isAllOutStock = false;
            isPartOutStock = false;
        } else if (isPartOutStock || total_taxAmount.compareTo(total_sumApacceptTaxAmount) > 0) {
            isAllOutStock = false;
            isPartOutStock = true;
        } else {
            isAllOutStock = true;
            isPartOutStock = false;
        }
        if (total_sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
            isAllRecipt = false;
            isPartRecipt = false;
        } else if (isPartRecipt || total_taxAmount.compareTo(total_sumAcceptTaxAmount) > 0) {
            isAllRecipt = false;
            isPartRecipt = true;
        } else {
            isAllRecipt = true;
            isPartRecipt = false;
        }
        OrderUtil.setLogisticsStatus(isPartOutStock, isAllOutStock, isPartRecipt, isAllRecipt, false, false, order);
    }

    private static void excuteOrderStatus(DynamicObject[] orders, List<String> poEntryPks) {
        for (int i = 0; i < orders.length; ++i) {
            BigDecimal realtotal_sumInstockQty = BigDecimal.ZERO;
            BigDecimal realtotal_sumReciptQty = BigDecimal.ZERO;
            BigDecimal realtotal_sumOutStockQty = BigDecimal.ZERO;
            BigDecimal realtotal_sumReFundQty = BigDecimal.ZERO;
            BigDecimal realtotal_qty = BigDecimal.ZERO;
            DynamicObjectCollection entrys = orders[i].getDynamicObjectCollection("materialentry");
            DynamicObjectType entrysDynamicObjectType = entrys.getDynamicObjectType();
            for (DynamicObject row : entrys) {
                boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)row);
                if (amountLineTypeControlCriterion) continue;
                realtotal_qty = realtotal_qty.add(row.getBigDecimal("qty"));
                realtotal_sumInstockQty = realtotal_sumInstockQty.add(row.getBigDecimal("suminstockqty"));
                realtotal_sumReciptQty = realtotal_sumReciptQty.add(row.getBigDecimal("sumreceiptqty"));
                realtotal_sumOutStockQty = realtotal_sumOutStockQty.add(row.getBigDecimal("sumoutstockqty"));
                if (entrysDynamicObjectType.getProperty("sumrefundqty") == null) continue;
                realtotal_sumReFundQty = realtotal_sumReFundQty.add(row.getBigDecimal("sumrefundqty"));
            }
            boolean isPartOutStock = false;
            boolean isAllOutStock = false;
            boolean isPartRecipt = false;
            boolean isAllRecipt = false;
            boolean isPartInstock = false;
            boolean isAllInstock = false;
            BigDecimal total_sumInstockQty = BigDecimal.ZERO;
            BigDecimal total_sumReciptQty = BigDecimal.ZERO;
            BigDecimal total_sumOutStockQty = BigDecimal.ZERO;
            BigDecimal total_sumReFundQty = BigDecimal.ZERO;
            BigDecimal total_qty = BigDecimal.ZERO;
            for (DynamicObject entry : entrys) {
                BigDecimal receiptStatusQty;
                BigDecimal inStockStatusQty;
                BigDecimal suminstockretqty;
                BigDecimal sumrecretqty;
                BigDecimal sumReFundQty;
                BigDecimal sumOutStockQty;
                BigDecimal sumReciptQty;
                BigDecimal sumInstockQty;
                BigDecimal qty;
                String poentryid = entry.getString("poentryid");
                boolean isRowPartOutStock = false;
                boolean isRowAllOutStock = false;
                boolean isRowPartRecipt = false;
                boolean isRowAllRecipt = false;
                boolean isRowPartInstock = false;
                boolean isRowAllInstock = false;
                boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)entry);
                if (amountLineTypeControlCriterion) continue;
                if (!poentryid.isEmpty() && poEntryPks.contains(poentryid)) {
                    qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty"));
                    sumInstockQty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("suminstockqty") != null) {
                        sumInstockQty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockqty"));
                    }
                    sumReciptQty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumreceiptqty") != null) {
                        sumReciptQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumreceiptqty"));
                    }
                    sumOutStockQty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumoutstockqty") != null) {
                        sumOutStockQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumoutstockqty"));
                    }
                    sumReFundQty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumrefundqty") != null) {
                        sumReFundQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumrefundqty"));
                    }
                    sumrecretqty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumrecretqty") != null) {
                        sumrecretqty = CommonUtil.getBigDecimalPro((Object)entry.get("sumrecretqty"));
                    }
                    suminstockretqty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("suminstockretqty") != null) {
                        suminstockretqty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockretqty"));
                    }
                    total_qty = total_qty.add(qty);
                    inStockStatusQty = BigDecimal.ZERO;
                    inStockStatusQty = suminstockretqty.compareTo(BigDecimal.ZERO) > 0 && sumReFundQty.compareTo(BigDecimal.ZERO) > 0 ? sumInstockQty.subtract(sumReFundQty.abs().subtract(sumrecretqty.abs())) : sumInstockQty;
                    total_sumInstockQty = total_sumInstockQty.add(inStockStatusQty);
                    if (inStockStatusQty.compareTo(BigDecimal.ZERO) > 0 && inStockStatusQty.compareTo(qty) < 0) {
                        isRowPartInstock = true;
                        isRowAllInstock = false;
                    } else if (inStockStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartInstock = false;
                        isRowAllInstock = false;
                    } else if (inStockStatusQty.compareTo(qty) >= 0) {
                        isRowPartInstock = false;
                        isRowAllInstock = true;
                    }
                    if (isAllInstock && inStockStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isPartInstock = true;
                        isAllInstock = false;
                    } else if (inStockStatusQty.compareTo(BigDecimal.ZERO) != 0 && !isPartInstock) {
                        if (qty.compareTo(inStockStatusQty) > 0) {
                            isPartInstock = true;
                            isAllInstock = false;
                        } else if (!isPartInstock && qty.compareTo(inStockStatusQty) <= 0) {
                            isPartInstock = false;
                            isAllInstock = true;
                        }
                    }
                    receiptStatusQty = BigDecimal.ZERO;
                    receiptStatusQty = sumrecretqty.compareTo(BigDecimal.ZERO) > 0 && sumReFundQty.compareTo(BigDecimal.ZERO) > 0 ? sumReciptQty.subtract(sumReFundQty.abs().subtract(suminstockretqty.abs())) : sumReciptQty;
                    total_sumReciptQty = total_sumReciptQty.add(receiptStatusQty);
                    if (receiptStatusQty.compareTo(BigDecimal.ZERO) > 0 && receiptStatusQty.compareTo(qty) < 0) {
                        isRowPartRecipt = true;
                        isRowAllRecipt = false;
                    } else if (receiptStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartRecipt = false;
                        isRowAllRecipt = false;
                    } else if (receiptStatusQty.compareTo(qty) >= 0) {
                        isRowPartRecipt = false;
                        isRowAllRecipt = true;
                    }
                    if (isAllRecipt && receiptStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isPartRecipt = true;
                        isAllRecipt = false;
                    } else if (!isPartRecipt && receiptStatusQty.compareTo(BigDecimal.ZERO) != 0) {
                        if (qty.compareTo(receiptStatusQty) > 0) {
                            isPartRecipt = true;
                            isAllRecipt = false;
                        } else if (!isPartRecipt && qty.compareTo(receiptStatusQty) <= 0) {
                            isAllRecipt = true;
                            isPartRecipt = false;
                        }
                    }
                    total_sumOutStockQty = total_sumOutStockQty.add(sumOutStockQty);
                    if (sumOutStockQty.compareTo(BigDecimal.ZERO) > 0 && sumOutStockQty.compareTo(qty) < 0) {
                        isRowPartOutStock = true;
                        isRowAllOutStock = false;
                    } else if (sumOutStockQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartOutStock = false;
                        isRowAllOutStock = false;
                    } else if (sumOutStockQty.compareTo(qty) >= 0) {
                        isRowPartOutStock = false;
                        isRowAllOutStock = true;
                    }
                    if (isAllOutStock && sumOutStockQty.compareTo(BigDecimal.ZERO) == 0) {
                        isPartOutStock = true;
                        isAllOutStock = false;
                    } else if (sumOutStockQty.compareTo(BigDecimal.ZERO) != 0 && !isPartOutStock) {
                        if (qty.compareTo(sumOutStockQty) > 0) {
                            isPartOutStock = true;
                            isAllOutStock = false;
                        } else if (!isPartOutStock && qty.compareTo(sumOutStockQty) <= 0) {
                            isAllOutStock = true;
                            isPartOutStock = false;
                        }
                    }
                } else {
                    qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty"));
                    sumInstockQty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockqty"));
                    sumReciptQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumreceiptqty"));
                    sumOutStockQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumoutstockqty"));
                    total_sumOutStockQty = total_sumOutStockQty.add(sumOutStockQty);
                    if (entrysDynamicObjectType.getProperty("sumrefundqty") != null) {
                        total_sumReFundQty = total_sumReFundQty.add(CommonUtil.getBigDecimalPro((Object)entry.get("sumrefundqty")));
                    }
                    sumReFundQty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumrefundqty") != null) {
                        sumReFundQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumrefundqty"));
                    }
                    sumrecretqty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("sumrecretqty") != null) {
                        sumrecretqty = CommonUtil.getBigDecimalPro((Object)entry.get("sumrecretqty"));
                    }
                    suminstockretqty = BigDecimal.ZERO;
                    if (entrysDynamicObjectType.getProperty("suminstockretqty") != null) {
                        suminstockretqty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockretqty"));
                    }
                    inStockStatusQty = BigDecimal.ZERO;
                    inStockStatusQty = suminstockretqty.compareTo(BigDecimal.ZERO) > 0 && sumReFundQty.compareTo(BigDecimal.ZERO) > 0 ? sumInstockQty.subtract(sumReFundQty.abs().subtract(sumrecretqty.abs())) : sumInstockQty;
                    total_sumInstockQty = total_sumInstockQty.add(inStockStatusQty);
                    if (inStockStatusQty.compareTo(BigDecimal.ZERO) > 0 && inStockStatusQty.compareTo(qty) < 0) {
                        isRowPartInstock = true;
                        isRowAllInstock = false;
                        isPartInstock = true;
                    } else if (inStockStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartInstock = false;
                        isRowAllInstock = false;
                    } else if (inStockStatusQty.compareTo(qty) >= 0) {
                        isRowPartInstock = false;
                        isRowAllInstock = true;
                    }
                    receiptStatusQty = BigDecimal.ZERO;
                    receiptStatusQty = sumrecretqty.compareTo(BigDecimal.ZERO) > 0 && sumReFundQty.compareTo(BigDecimal.ZERO) > 0 ? sumReciptQty.subtract(sumReFundQty.abs().subtract(suminstockretqty.abs())) : sumReciptQty;
                    total_sumReciptQty = total_sumReciptQty.add(receiptStatusQty);
                    if (receiptStatusQty.compareTo(BigDecimal.ZERO) > 0 && receiptStatusQty.compareTo(qty) < 0) {
                        isRowPartRecipt = true;
                        isRowAllRecipt = false;
                        isPartRecipt = true;
                    } else if (receiptStatusQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartRecipt = false;
                        isRowAllRecipt = false;
                    } else if (receiptStatusQty.compareTo(qty) >= 0) {
                        isRowPartRecipt = false;
                        isRowAllRecipt = true;
                    }
                    if (sumOutStockQty.compareTo(BigDecimal.ZERO) > 0 && sumOutStockQty.compareTo(qty) < 0) {
                        isRowPartOutStock = true;
                        isRowAllOutStock = false;
                        isPartOutStock = true;
                    } else if (sumOutStockQty.compareTo(BigDecimal.ZERO) == 0) {
                        isRowPartOutStock = false;
                        isRowAllOutStock = false;
                    } else if (sumOutStockQty.compareTo(qty) >= 0) {
                        isRowPartOutStock = false;
                        isRowAllOutStock = true;
                    }
                }
                OrderUtil.setRowLogisticsStatus(isRowPartOutStock, isRowAllOutStock, isRowPartRecipt, isRowAllRecipt, isRowPartInstock, isRowAllInstock, orders[i], entry);
            }
            if (total_sumOutStockQty.compareTo(BigDecimal.ZERO) == 0) {
                isAllOutStock = false;
                isPartOutStock = false;
            } else if (realtotal_qty.compareTo(realtotal_sumOutStockQty) > 0) {
                isAllOutStock = false;
                isPartOutStock = true;
            } else if (!isPartOutStock && realtotal_qty.compareTo(realtotal_sumOutStockQty) <= 0) {
                isAllOutStock = true;
            }
            if (total_sumReciptQty.compareTo(BigDecimal.ZERO) == 0) {
                isAllRecipt = false;
                isPartRecipt = false;
            } else if (realtotal_qty.compareTo(realtotal_sumReciptQty) > 0) {
                isPartRecipt = true;
                isAllRecipt = false;
            } else if (!isPartRecipt && realtotal_qty.compareTo(realtotal_sumReciptQty) <= 0) {
                isAllRecipt = true;
            }
            if (total_sumInstockQty.compareTo(BigDecimal.ZERO) == 0) {
                isPartInstock = false;
                isAllInstock = false;
            } else if (realtotal_qty.compareTo(realtotal_sumInstockQty) > 0) {
                isPartInstock = true;
                isAllInstock = false;
            } else if (!isPartInstock && realtotal_qty.compareTo(realtotal_sumInstockQty) <= 0) {
                isAllInstock = true;
            }
            OrderUtil.setLogisticsStatus(isPartOutStock, isAllOutStock, isPartRecipt, isAllRecipt, isPartInstock, isAllInstock, orders[i]);
        }
        OrderUtil.excuteOrderStatusByAmount(orders, poEntryPks);
    }

    @Deprecated
    public static DynamicObject[] getOrderInfo(Object[] pks, String entityKey) {
        HashMap param = new HashMap(1);
        HashMap<String, Object[]> idMap = new HashMap<String, Object[]>(1);
        idMap.put("in", pks);
        param.put("id", idMap);
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus,org,srctype").append(",materialentry.pobillid,materialentry.poentryid,materialentry.srcbillid").append(",materialentry.id,materialentry.qty,materialentry.sumreceiveqty,materialentry.sumoutstockqty").append(",materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.vmistockqty,materialentry.srcentryid,materialentry.entrystatus,materialentry.rowlogstatus").append(",materialentry.sumrefundqty").append(",materialentry.linetype,materialentry.taxamount,materialentry.sumaccepttaxamount,materialentry.sumapaccepttaxamount,materialentry.relateapaccepttaxamount");
        return ORMUtil.load((String)entityKey, (String)selectSb.toString(), param);
    }

    public static DynamicObject[] getOrdersByPoBillIdS(String filed, Set<String> poBillIdSet) {
        return BusinessDataServiceHelper.load((String)"scp_order", (String)filed, (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", poBillIdSet)});
    }

    public static DynamicObject[] getOrdersByPoEntryIdS(String filed, Set<String> poEntryIdSet) {
        return BusinessDataServiceHelper.load((String)"scp_order", (String)filed, (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryIdSet)});
    }

    public static Map<String, String> getPKValueStr(DynamicObject[] objs) {
        HashMap<String, String> pobillidMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("materialentry");
            if (dynamicObjects.size() <= 0) continue;
            pobillidMap.put(((DynamicObject)dynamicObjects.get(0)).get("pobillid").toString(), dynamicObject.get("logstatus").toString());
        }
        return pobillidMap;
    }

    public static Set<String> getPkValueSet(DynamicObject[] dynamicObjects, boolean isAllrecipt) {
        HashSet<String> orderIdSet = new HashSet<String>();
        DynamicObjectCollection entrys = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String logStatus = dynamicObject.getString("logstatus");
            entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            String poBillId = ((DynamicObject)entrys.get(0)).getString("pobillid").trim();
            if (LogisticsStatusEnum.ALLOUTSTOCK.getVal().equals(logStatus)) {
                if (!isAllrecipt) continue;
                orderIdSet.add(poBillId);
                continue;
            }
            if (isAllrecipt || !LogisticsStatusEnum.PARTOUTSTOCK.getVal().equals(logStatus)) continue;
            orderIdSet.add(poBillId);
        }
        return orderIdSet;
    }

    public static void updateCfmStatusByEntry(DynamicObject billObj, DynamicObject entry) {
        OrderUtil.updateOrderCfmStatus(new DynamicObject[]{billObj});
    }

    private static boolean setLogisticsStatus(boolean isPartOutStock, boolean isAllOutStock, boolean isPartRecipt, boolean isAllRecipt, boolean isPartInstock, boolean isAllInstock, DynamicObject billObj) {
        boolean isContinue = false;
        if (isAllInstock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.ALLINSTOCK.getVal());
        } else if (isPartInstock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.PARTINSTOCK.getVal());
        } else if (isAllRecipt) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.ALLRECIPT.getVal());
        } else if (isPartRecipt) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
        } else if (isAllOutStock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
        } else if (isPartOutStock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.PARTOUTSTOCK.getVal());
        } else if (billObj.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal())) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
        } else {
            billObj.set("logstatus", (Object)"");
        }
        return isContinue;
    }

    private static boolean setRowLogisticsStatus(boolean isPartOutStock, boolean isAllOutStock, boolean isPartRecipt, boolean isAllRecipt, boolean isPartInstock, boolean isAllInstock, DynamicObject bill, DynamicObject row) {
        boolean isContinue = false;
        if (isAllInstock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLINSTOCK.getVal());
        } else if (isPartInstock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.PARTINSTOCK.getVal());
        } else if (isAllRecipt) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLRECIPT.getVal());
        } else if (isPartRecipt) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
        } else if (isAllOutStock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
        } else if (isPartOutStock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.PARTOUTSTOCK.getVal());
        } else if (bill.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal())) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
            if (PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal().equalsIgnoreCase(bill.getString("srctype"))) {
                row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            }
        } else {
            row.set("rowlogstatus", (Object)"");
        }
        return isContinue;
    }

    @Deprecated
    public static DynamicObjectCollection querySrcBillInfo(List<Object> poEntryIdList) {
        DynamicObjectCollection dynaCols = null;
        String selectFields = "id,taxtype,centersettle,settleorg,materialentry.id entryId,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.purtype purtypeid,materialentry.price price,materialentry.taxprice taxprice,materialentry.dctrate dctrate,materialentry.taxrate taxrate,materialentry.material material,materialentry.goods goods";
        ArrayList<String> newPoEntryIdList = new ArrayList<String>(poEntryIdList.size());
        for (Object poEntryId : poEntryIdList) {
            newPoEntryIdList.add(String.valueOf(poEntryId));
        }
        HashMap paramMap = new HashMap();
        HashMap<String, ArrayList<String>> idMap = new HashMap<String, ArrayList<String>>();
        idMap.put("in", newPoEntryIdList);
        paramMap.put("materialentry.poentryid", idMap);
        dynaCols = ORMUtil.queryDynamicObjectCollection((String)"pur_order", (String)selectFields, paramMap);
        return dynaCols;
    }

    @Deprecated
    public static DynamicObject getSrcBillEntry(DynamicObjectCollection srcBillObjs, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String poEntryId = srcBill.getString("poentryid");
            if (!srcBillEntryId.equals(poEntryId)) continue;
            return srcBill;
        }
        return entry;
    }

    public static void updateVmiInstockQty(DynamicObject[] orders) {
        BigDecimal vmiStockQty = BigDecimal.ZERO;
        BigDecimal sumReciptQty = BigDecimal.ZERO;
        BigDecimal sumInstockQty = BigDecimal.ZERO;
        for (DynamicObject order : orders) {
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                sumInstockQty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockqty"));
                sumReciptQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumreceiptqty"));
                vmiStockQty = sumReciptQty.subtract(sumInstockQty);
                entry.set("vmistockqty", (Object)vmiStockQty);
            }
        }
    }

    public static Object synCreateEasOrder(List<DynamicObject> dataList) {
        return SynOrderUtil.synCreateEasOrder(dataList);
    }

    public static Object synCreateEasOrder(List<DynamicObject> dataList, Boolean isSpecificUser) {
        return SynOrderUtil.synCreateEasOrder(dataList, (Boolean)isSpecificUser);
    }

    public static Object synCreateEasOrder(List<DynamicObject> dataList, Map<String, String> orderExtEntryPro, Boolean isSpecificUser) {
        return SynOrderUtil.synCreateEasOrder(dataList, orderExtEntryPro, (Boolean)isSpecificUser);
    }

    public static Object synCreateEasOrder(List<Object> ids, String entityName, Boolean isSpecificUser) {
        return SynOrderUtil.synCreateEasOrder(ids, (String)entityName, (Boolean)isSpecificUser);
    }

    @Deprecated
    public static Object synCreateEasOrder(List<Object> ids, String entityName) {
        return SynOrderUtil.synCreateEasOrder(ids, (String)entityName);
    }

    public static Object synCreateEasOrder(List<Object> ids, String entityName, Map<String, String> orderExtEntryPro, Boolean isSpecificUser) {
        return SynOrderUtil.synCreateEasOrder(ids, (String)entityName, orderExtEntryPro, (Boolean)isSpecificUser);
    }

    public static Object synCreateEasOrder(List<Object> ids, String entityName, Map<String, String> orderExtEntryPro) {
        return SynOrderUtil.synCreateEasOrder(ids, (String)entityName, orderExtEntryPro);
    }

    public static Object synCreateEasPurRequest(List<Object> ids, String entityName) {
        return SynOrderUtil.synCreateEasPurRequest(ids, (String)entityName);
    }

    public static void setPurTypeByOrder(List<DynamicObject> objs, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap, String entryKey) {
        BizLog.log((String)"@\u8fdb\u5165\u4fee\u6539\u91c7\u8d2d\u7c7b\u578b\u5f00\u59cb=======>");
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
            Object poEntryId = entry.getValue().get("poentryid");
            if (null == poEntryId || poEntryId.toString().isEmpty()) continue;
            poEntryIdList.add(poEntryId);
        }
        HashMap<String, DynamicObject> orderEntryMap = new HashMap<String, DynamicObject>();
        if (poEntryIdList.size() > 0) {
            DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
            for (DynamicObject dynamicObject : srcBillObjects) {
                orderEntryMap.put(dynamicObject.getString("poentryid"), dynamicObject);
            }
        }
        DynamicObject orderEntry = null;
        Object purTypeId = null;
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entryCols = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryCol : entryCols) {
                Object poEntryId = entryCol.get("poentryid");
                BizLog.log((String)("@\u4fee\u6539\u91c7\u8d2d\u7c7b\u578b\u5f00\u59cb=======>poEntryId:" + poEntryId));
                orderEntry = (DynamicObject)orderEntryMap.get(poEntryId);
                if (null != orderEntry) {
                    purTypeId = orderEntry.get("purtypeid");
                    if (null == purTypeId || "0".equals(purTypeId.toString())) {
                        purTypeId = 530841016689795072L;
                    }
                    try {
                        entryCol.set("purtype", purTypeId);
                        entryCol.set("material", orderEntry.get("material"));
                        entryCol.set("goods", orderEntry.get("goods"));
                    }
                    catch (Exception e) {
                        log.info("###orderUtil purType exception:" + e.getMessage());
                    }
                } else {
                    purTypeId = 530841016689795072L;
                    entryCol.set("purtype", purTypeId);
                }
                BizLog.log((String)("@\u4fee\u6539\u91c7\u8d2d\u7c7b\u578b\u7ed3\u675f=======>purTypeId:" + purTypeId));
            }
        }
    }

    public static void setIsCenterSettleByOrder(List<DynamicObject> objs, Map<String, Map<String, Object>> entryDataMap, String entryKey) {
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
            Object poEntryId = entry.getValue().get("poentryid");
            if (null == poEntryId) continue;
            poEntryIdList.add(poEntryId);
        }
        HashSet<String> isCenterSettleSet = new HashSet<String>();
        if (poEntryIdList.size() > 0) {
            DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
            for (DynamicObject billObj : srcBillObjects) {
                boolean centerSettle = billObj.getBoolean("centersettle");
                if (!centerSettle) continue;
                isCenterSettleSet.add(billObj.getString("pobillid"));
            }
        }
        block2: for (DynamicObject obj : objs) {
            DynamicObjectCollection entryCols = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryCol : entryCols) {
                Object poBillId = entryCol.get("pobillid");
                if (null == poBillId || !isCenterSettleSet.contains(poBillId.toString())) continue;
                obj.set("iscentersettle", (Object)"1");
                continue block2;
            }
        }
    }

    @Deprecated
    public static DynamicObjectCollection getSrcOrderCols(List<DynamicObject> objs, String entryKey) {
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection(entryKey);
            entrys.forEach(entry -> {
                Object poEntryId = entry.get("poentryid");
                if (poEntryId != null && poEntryId.toString().trim().length() > 0) {
                    poEntryIdList.add(entry.get("poentryid"));
                }
            });
        }
        DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
        return srcBillObjects;
    }

    public static void writeBackOrderReturnInfo(List<DynamicObject> objs, List<String> proList, String entryKey, String operation) {
        DynamicObjectCollection srcBillObjects = OrderUtil.getSrcOrderCols(objs, entryKey);
        Map poEntryId_orderEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)srcBillObjects, (String)"poentryid");
        BigDecimal qty = BigDecimal.ZERO;
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                DynamicObject poBillEntry;
                String srcEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty() || (poBillEntry = (DynamicObject)poEntryId_orderEntryMap.get(srcPoEntryId)) == null) continue;
                String poEntryId = poBillEntry.getString("entryId");
                qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty")).abs();
                if (null != srcEntryId_qtyMap.get(poEntryId)) {
                    srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(qty));
                } else {
                    srcEntryId_qtyMap.put(poEntryId, qty);
                }
                srcEntryIdList.add(Long.valueOf(poEntryId));
            }
        }
        HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
        proListMap.put("materialentry", proList);
        String replenishtype = objs.get(0).getString("replenishtype");
        if ("1".equals(replenishtype)) {
            WriteBackUtil.writeBackBillByReturnAdd("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, operation);
        } else {
            WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, operation);
        }
    }

    public static void writeBackOrderRefundInfo(DynamicObject[] dyns, boolean isAdd, boolean isReceiptReturn) {
        DynamicObject[] poDyns;
        if (dyns == null || dyns.length <= 0) {
            return;
        }
        HashSet<String> poIdSet = new HashSet<String>(16);
        HashMap<String, DynamicObject> poEntryIdReceiveEntryMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dyn : dyns) {
            boolean isreturn = true;
            if (isReceiptReturn) {
                isreturn = dyn.getBoolean("isreturn");
            }
            String replenishtype = dyn.getString("replenishtype");
            if (!isreturn || !"1".equals(replenishtype)) continue;
            DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                String poEntryId = entry.getString("poentryid");
                if (!StringUtils.isNotBlank((CharSequence)poEntryId)) continue;
                poIdSet.add(entry.getString("pobillid"));
                poEntryIdReceiveEntryMap.put(poEntryId, entry);
            }
        }
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("materialentry.pobillid,materialentry.poentryid").append(",materialentry.sumrefundqty,materialentry.sumrefundbaseqty").append(",materialentry.material,materialentry.unit,materialentry.basicunit");
        for (DynamicObject dyn : poDyns = BusinessDataServiceHelper.load((String)"pur_order", (String)selectSb.toString(), (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", poIdSet)})) {
            for (DynamicObject entry : dyn.getDynamicObjectCollection("materialentry")) {
                BigDecimal sumrefundbaseqty;
                DynamicObject receiveEntryDyn = (DynamicObject)poEntryIdReceiveEntryMap.get(entry.getString("poentryid"));
                if (receiveEntryDyn == null) continue;
                BigDecimal returnQty = receiveEntryDyn.getBigDecimal("qty").abs();
                BigDecimal sumrefundqty = entry.getBigDecimal("sumrefundqty");
                DynamicObject materialObj = entry.getDynamicObject("material");
                DynamicObject unitObj = entry.getDynamicObject("unit");
                DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                if (isAdd) {
                    sumrefundqty = sumrefundqty.add(returnQty);
                    sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                } else {
                    sumrefundqty = sumrefundqty.subtract(returnQty);
                    sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                }
                entry.set("sumrefundqty", (Object)sumrefundqty);
                entry.set("sumrefundbaseqty", (Object)sumrefundbaseqty);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])poDyns);
    }

    public static List<DynamicObject> getWriteBackObjesByOrder(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, String entryKey) {
        log.info("###start getWriteBackObjesByOrder");
        DynamicObjectCollection srcBillObjects = OrderUtil.getSrcOrderCols(dynamicObjects, entryKey);
        Map poBillId_orderMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)srcBillObjects, (String)"pobillid");
        log.info("###poBillId_orderMap:" + poBillId_orderMap);
        ArrayList<DynamicObject> writeBackDynamicObjects = new ArrayList<DynamicObject>();
        for (DynamicObject obj : dynamicObjects) {
            DynamicObject order;
            String srcBillIdStr;
            DynamicObject entry;
            Object srcPoBillId;
            String billno = obj.getString("billno");
            if (!"1".equals(headDataMap.get(billno.toLowerCase()).get("type"))) {
                if ("1".equals(headDataMap.get(billno.toLowerCase()).get("hasvirtual"))) continue;
                writeBackDynamicObjects.add(obj);
                continue;
            }
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(entryKey);
            if (cols.size() == 0 || null == (srcPoBillId = (entry = (DynamicObject)cols.get(0)).get("pobillid")) || (srcBillIdStr = String.valueOf(srcPoBillId)).isEmpty() || null == (order = (DynamicObject)poBillId_orderMap.get(srcBillIdStr))) continue;
            Object settleOrg = order.get("settleorg");
            Object srcSettleOrg = obj.get("settleorg");
            if (null == settleOrg || null == srcSettleOrg || !settleOrg.toString().equals(srcSettleOrg.toString())) continue;
            writeBackDynamicObjects.add(obj);
        }
        log.info("###writeBackDynamicObjects:" + writeBackDynamicObjects);
        return writeBackDynamicObjects;
    }
}

