/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;

public class SaloutUtil {
    private static Log log = LogFactory.getLog(SaloutUtil.class);

    private SaloutUtil() {
    }

    @Deprecated
    public static void updateCfmStatusByPks(Object[] pks, String entityKey) {
        DynamicObject[] bills = SaloutUtil.getBillInfo(pks, entityKey);
        if (bills.length == 0) {
            return;
        }
        SaloutUtil.updateCfmStatus(bills);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])bills);
    }

    @Deprecated
    public static void writeOrderSumoutstockqty(List<Object> targetIdList) {
        BigDecimal qty;
        QFilter prodfilter = new QFilter("id", "in", targetIdList);
        String selectors = "id,number,replenishtype,materialentry.qty,materialentry.pobillid,materialentry.poentryid";
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"scp_salreturn", (String)selectors, (QFilter[])new QFilter[]{prodfilter});
        DynamicObjectCollection entryCols = null;
        DynamicObject entry = null;
        HashSet<String> orderIdSet = new HashSet<String>();
        HashMap<String, BigDecimal> orderentryid_qtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject dyn : objs) {
            if (null == dyn.get("replenishtype") || !"1".equals(dyn.getString("replenishtype"))) continue;
            entryCols = dyn.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < entryCols.size(); ++i) {
                entry = (DynamicObject)entryCols.get(i);
                String orderId = entry.getString("pobillid");
                String orderEntryId = entry.getString("poentryid");
                orderIdSet.add(orderId);
                qty = entry.getBigDecimal("qty");
                if (null == orderentryid_qtyMap.get(orderEntryId)) {
                    orderentryid_qtyMap.put(orderEntryId, qty);
                    continue;
                }
                BigDecimal oldQty = (BigDecimal)orderentryid_qtyMap.get(orderEntryId);
                orderentryid_qtyMap.put(orderEntryId, oldQty.add(qty));
            }
        }
        prodfilter = new QFilter("materialentry.pobillid", "in", orderIdSet);
        selectors = "id,number,materialentry.sumoutstockqty,materialentry.qty,materialentry.pobillid,materialentry.poentryid";
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pur_order", (String)selectors, (QFilter[])new QFilter[]{prodfilter});
        HashSet<Long> orderId = new HashSet<Long>(1024);
        HashSet salouIdSet = new HashSet(1024);
        HashSet<String> salouHasPoidSet = new HashSet<String>(1024);
        for (DynamicObject temp : orders) {
            orderId.add(temp.getLong("id"));
        }
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"scp_order", (Long[])orderId.toArray(new Long[0]), (OperateOption)OperateOption.create());
        bfRowList.forEach(bfRow -> salouIdSet.add(bfRow.getId().getBillId()));
        DynamicObjectCollection saloutCollection = QueryServiceHelper.query((String)"scp_saloutstock", (String)"id,materialentry.pobillid,materialentry.poentryid poentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", salouIdSet)});
        for (DynamicObject saloutdDynamic : saloutCollection) {
            salouHasPoidSet.add(saloutdDynamic.getString("poentryid"));
        }
        BigDecimal sumoutstockqty = BigDecimal.ZERO;
        qty = BigDecimal.ZERO;
        String orderentryID = null;
        for (DynamicObject dyn : orders) {
            entryCols = dyn.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < entryCols.size(); ++i) {
                entry = (DynamicObject)entryCols.get(i);
                sumoutstockqty = entry.getBigDecimal("sumoutstockqty");
                qty = entry.getBigDecimal("qty");
                orderentryID = entry.getString("poentryid");
                if (!salouHasPoidSet.contains(orderentryID) || null == orderentryID || null == orderentryid_qtyMap.get(orderentryID) || (sumoutstockqty = sumoutstockqty.add((BigDecimal)orderentryid_qtyMap.get(orderentryID))).compareTo(BigDecimal.ZERO) < 0 || sumoutstockqty.compareTo(qty) > 0) continue;
                entry.set("sumoutstockqty", (Object)sumoutstockqty);
            }
        }
        if (orders.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
        }
    }

    public static Set<String> getPoBillIds(DynamicObject[] dynamicObjects) {
        HashSet<String> poBillIdSet = new HashSet<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : dynamicObjectCollection) {
                String poBillId = entryRow.getString("pobillid");
                if (poBillId == null || poBillId.trim().isEmpty()) continue;
                poBillIdSet.add(poBillId);
            }
        }
        return poBillIdSet;
    }

    public static Set<String> getPoEntryIds(DynamicObject[] dynamicObjects) {
        HashSet<String> poEntryIdSet = new HashSet<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : dynamicObjectCollection) {
                String poEntryId = entryRow.getString("poentryid");
                if (poEntryId == null || poEntryId.trim().isEmpty()) continue;
                poEntryIdSet.add(poEntryId);
            }
        }
        return poEntryIdSet;
    }

    public static Map<String, Object> getPoEntryIdQtyMap(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> poEntryId_QtyMap = new HashMap<String, Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
            if (materialEntry.size() == 0) continue;
            for (DynamicObject entryRow : materialEntry) {
                String poEntryId = entryRow.getString("poentryid");
                BigDecimal qty = entryRow.getBigDecimal("qty");
                if (null == poEntryId || poEntryId.length() <= 0) continue;
                if (null != poEntryId_QtyMap.get(poEntryId)) {
                    BigDecimal qty1 = new BigDecimal(String.valueOf(poEntryId_QtyMap.get(poEntryId)));
                    poEntryId_QtyMap.put(poEntryId, qty.add(qty1));
                    continue;
                }
                poEntryId_QtyMap.put(poEntryId, qty);
            }
        }
        return poEntryId_QtyMap;
    }

    public static Map<String, BigDecimal> getPoEntryIdQtyMap(List<DynamicObject> dynamicObjects) {
        HashMap<String, BigDecimal> poEntryId_QtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject bill : dynamicObjects) {
            String poEntryId = bill.getString("poentryid");
            BigDecimal qty = bill.getBigDecimal("qty");
            if (null == poEntryId || poEntryId.isEmpty()) continue;
            poEntryId_QtyMap.merge(poEntryId, qty, (a, b) -> b.add((BigDecimal)a));
        }
        return poEntryId_QtyMap;
    }

    public static void updateCfmStatus(DynamicObject[] bills) {
        for (int i = 0; i < bills.length; ++i) {
            boolean isPartRecipt = false;
            boolean isAllRecipt = false;
            boolean isPartInstock = false;
            boolean isAllInstock = false;
            BigDecimal total_sumInstockQty = BigDecimal.ZERO;
            BigDecimal total_sumReciptQty = BigDecimal.ZERO;
            BigDecimal total_qty = BigDecimal.ZERO;
            DynamicObjectCollection entrys = bills[i].getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)entry);
                if (amountLineTypeControlCriterion) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty"));
                BigDecimal sumInstockQty = CommonUtil.getBigDecimalPro((Object)entry.get("suminstockqty"));
                BigDecimal sumReciptQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumreceiptqty"));
                total_qty = total_qty.add(qty);
                boolean isRowPartRecipt = false;
                boolean isRowAllRecipt = false;
                boolean isRowPartInstock = false;
                boolean isRowAllInstock = false;
                total_sumReciptQty = total_sumReciptQty.add(sumReciptQty);
                if (sumReciptQty.compareTo(BigDecimal.ZERO) > 0 && sumReciptQty.compareTo(qty) < 0) {
                    isRowPartRecipt = true;
                    isRowAllRecipt = false;
                } else if (sumReciptQty.compareTo(BigDecimal.ZERO) == 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = false;
                } else if (sumReciptQty.compareTo(qty) >= 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = true;
                }
                if (isAllRecipt && sumReciptQty.compareTo(BigDecimal.ZERO) == 0) {
                    isPartRecipt = true;
                    isAllRecipt = false;
                } else if (sumReciptQty.compareTo(BigDecimal.ZERO) != 0 && !isPartRecipt) {
                    if (qty.compareTo(sumReciptQty) > 0) {
                        isPartRecipt = true;
                        isAllRecipt = false;
                    } else if (!isPartRecipt && qty.compareTo(sumReciptQty) <= 0) {
                        isAllRecipt = true;
                        isPartRecipt = false;
                    }
                }
                total_sumInstockQty = total_sumInstockQty.add(sumInstockQty);
                if (sumInstockQty.compareTo(BigDecimal.ZERO) > 0 && sumInstockQty.compareTo(qty) < 0) {
                    isRowPartInstock = true;
                    isRowAllInstock = false;
                } else if (sumInstockQty.compareTo(BigDecimal.ZERO) == 0) {
                    isRowPartInstock = false;
                    isRowAllInstock = false;
                } else if (sumInstockQty.compareTo(qty) >= 0) {
                    isRowPartInstock = false;
                    isRowAllInstock = true;
                }
                if (isAllInstock && sumInstockQty.compareTo(BigDecimal.ZERO) == 0) {
                    isPartInstock = true;
                    isAllInstock = false;
                } else if (sumInstockQty.compareTo(BigDecimal.ZERO) != 0 && !isPartInstock) {
                    if (qty.compareTo(sumInstockQty) > 0) {
                        isPartInstock = true;
                        isAllInstock = false;
                    } else if (!isPartInstock && qty.compareTo(sumInstockQty) <= 0) {
                        isPartInstock = false;
                        isAllInstock = true;
                    }
                }
                SaloutUtil.setRowLogisticsStatus(isRowPartRecipt, isRowAllRecipt, isRowPartInstock, isRowAllInstock, bills[i], entry);
            }
            if (total_sumReciptQty.compareTo(BigDecimal.ZERO) == 0) {
                isAllRecipt = false;
                isPartRecipt = false;
            } else if (total_qty.compareTo(total_sumReciptQty) > 0) {
                isPartRecipt = true;
                isAllRecipt = false;
            }
            if (total_sumInstockQty.compareTo(BigDecimal.ZERO) == 0) {
                isPartInstock = false;
                isAllInstock = false;
            } else if (total_qty.compareTo(total_sumInstockQty) > 0) {
                isPartInstock = true;
                isAllInstock = false;
            }
            SaloutUtil.setLogisticsStatus(isPartRecipt, isAllRecipt, isPartInstock, isAllInstock, bills[i]);
        }
        SaloutUtil.excuteOrderStatusByAmount(bills);
    }

    private static void excuteOrderStatusByAmount(DynamicObject[] orders) {
        for (int i = 0; i < orders.length; ++i) {
            DynamicObject order = orders[i];
            DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
            DynamicObjectType entrysDynamicObjectType = entrys.getDynamicObjectType();
            Boolean isAllAmountControlCriterion = true;
            boolean isPartRecipt = false;
            for (DynamicObject row : entrys) {
                boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)row);
                if (!amountLineTypeControlCriterion) {
                    isAllAmountControlCriterion = false;
                    continue;
                }
                String poentryid = row.getString("poentryid");
                log.info("currenyentry={},{}", (Object)row, (Object)poentryid);
                boolean isRowPartRecipt = false;
                boolean isRowAllRecipt = false;
                BigDecimal taxAmount = CommonUtil.getBigDecimalPro((Object)row.get("taxamount"));
                BigDecimal sumAcceptTaxAmount = BigDecimal.ZERO;
                if (entrysDynamicObjectType.getProperty("sumaccepttaxamount") != null) {
                    sumAcceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumaccepttaxamount"));
                }
                if (sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) > 0 && sumAcceptTaxAmount.compareTo(taxAmount) < 0) {
                    isRowPartRecipt = true;
                    isRowAllRecipt = false;
                    isPartRecipt = true;
                } else if (sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = false;
                } else if (sumAcceptTaxAmount.compareTo(taxAmount) >= 0) {
                    isRowPartRecipt = false;
                    isRowAllRecipt = true;
                }
                SaloutUtil.setRowLogisticsStatus(isRowPartRecipt, isRowAllRecipt, false, false, orders[i], row);
            }
            if (!isAllAmountControlCriterion.booleanValue()) continue;
            SaloutUtil.setAmountLogisticsStatus(order, isPartRecipt);
        }
    }

    private static void setAmountLogisticsStatus(DynamicObject order, boolean isPartRecipt) {
        boolean isAllRecipt = false;
        DynamicObjectCollection entrys = order.getDynamicObjectCollection("materialentry");
        DynamicObjectType entrysDynamicObjectType = entrys.getDynamicObjectType();
        BigDecimal total_taxAmount = BigDecimal.ZERO;
        BigDecimal total_sumApacceptTaxAmount = BigDecimal.ZERO;
        BigDecimal total_sumAcceptTaxAmount = BigDecimal.ZERO;
        for (DynamicObject row : entrys) {
            boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)row);
            if (!amountLineTypeControlCriterion) continue;
            if (entrysDynamicObjectType.getProperty("taxamount") != null) {
                total_taxAmount = total_taxAmount.add(row.getBigDecimal("taxamount"));
            }
            if (entrysDynamicObjectType.getProperty("sumapaccepttaxamount") != null) {
                BigDecimal sumApacceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumapaccepttaxamount"));
                total_sumApacceptTaxAmount = total_sumApacceptTaxAmount.add(sumApacceptTaxAmount);
            }
            if (entrysDynamicObjectType.getProperty("sumaccepttaxamount") == null) continue;
            BigDecimal sumAcceptTaxAmount = CommonUtil.getBigDecimalPro((Object)row.get("sumaccepttaxamount"));
            total_sumAcceptTaxAmount = total_sumAcceptTaxAmount.add(sumAcceptTaxAmount);
        }
        if (total_sumAcceptTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
            isAllRecipt = false;
            isPartRecipt = false;
        } else if (isPartRecipt || total_taxAmount.compareTo(total_sumAcceptTaxAmount) > 0) {
            isAllRecipt = false;
            isPartRecipt = true;
        } else {
            isAllRecipt = true;
            isPartRecipt = false;
        }
        SaloutUtil.setLogisticsStatus(isPartRecipt, isAllRecipt, false, false, order);
    }

    public static DynamicObject[] getBillInfo(Object[] pks, String entityKey) {
        HashMap param = new HashMap(1);
        HashMap<String, Object[]> idMap = new HashMap<String, Object[]>(1);
        idMap.put("in", pks);
        param.put("id", idMap);
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus").append(",materialentry.id,materialentry.qty").append(",materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.rowlogstatus");
        return ORMUtil.load((String)entityKey, (String)selectSb.toString(), param);
    }

    public static void updateCfmStatusByEntry(DynamicObject billObj, DynamicObject entry) {
        SaloutUtil.updateCfmStatus(new DynamicObject[]{billObj});
    }

    private static boolean setLogisticsStatus(boolean isPartRecipt, boolean isAllRecipt, boolean isPartInstock, boolean isAllInstock, DynamicObject billObj) {
        boolean isContinue = false;
        if (isAllInstock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.ALLINSTOCK.getVal());
        } else if (isPartInstock) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.PARTINSTOCK.getVal());
        } else if (isAllRecipt) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.ALLRECIPT.getVal());
        } else if (isPartRecipt) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
        } else if (billObj.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal())) {
            billObj.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
        } else if (billObj.getDataEntityType().getName().equals("scp_saloutstock")) {
            billObj.set("logstatus", (Object)"C");
        } else {
            billObj.set("logstatus", (Object)"");
        }
        return isContinue;
    }

    private static boolean setRowLogisticsStatus(boolean isPartRecipt, boolean isAllRecipt, boolean isPartInstock, boolean isAllInstock, DynamicObject bill, DynamicObject row) {
        boolean isContinue = false;
        if (isAllInstock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLINSTOCK.getVal());
        } else if (isPartInstock) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.PARTINSTOCK.getVal());
        } else if (isAllRecipt) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLRECIPT.getVal());
        } else if (isPartRecipt) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
        } else if (bill.getString("cfmstatus").equals(ConfirmStatusEnum.CONFIRM.getVal())) {
            row.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
        } else if (bill.getDataEntityType().getName().equals("scp_saloutstock")) {
            row.set("rowlogstatus", (Object)"C");
        } else {
            row.set("rowlogstatus", (Object)"");
        }
        return isContinue;
    }

    @Deprecated
    public static DynamicObjectCollection querySrcBillInfo(List<Object> poEntryIdList) {
        DynamicObjectCollection dynaCols = null;
        String selectFields = "id,materialentry.id entryId,materialentry.pobillid pobillid,materialentry.poentryid poentryid";
        HashMap paramMap = new HashMap();
        HashMap<String, List<Object>> idMap = new HashMap<String, List<Object>>();
        idMap.put("in", poEntryIdList);
        paramMap.put("materialentry.poentryid", idMap);
        dynaCols = ORMUtil.queryDynamicObjectCollection((String)"pur_order", (String)selectFields, paramMap);
        return dynaCols;
    }

    @Deprecated
    public static DynamicObject getSrcBillEntry(DynamicObjectCollection srcBillObjs, Object srcBillEntryId) {
        DynamicObject entry = null;
        for (DynamicObject srcBill : srcBillObjs) {
            String poEntryId = srcBill.getString("poentryid");
            if (!srcBillEntryId.equals(poEntryId)) continue;
            return srcBill;
        }
        return entry;
    }

    public static boolean updateSrcEntryIdBySaloutEntryId(List<Long> entryIdList, Map<String, String> entryId_srcEntryIdMap) {
        QFilter filter = new QFilter("materialentry.id", "in", entryIdList);
        String selectFields = "id,billno,materialentry.id,materialentry.srcentryid";
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"scp_saloutstock", (String)selectFields, (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        for (Map.Entry data : dataMap.entrySet()) {
            boolean isUpdate = false;
            DynamicObject salOut = (DynamicObject)data.getValue();
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String srcEntryId = entryId_srcEntryIdMap.get(col.getPkValue().toString());
                if (null == srcEntryId) continue;
                col.set("srcentryid", (Object)srcEntryId);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            updateDataList.add(salOut);
        }
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("SaloutUtil updateBillSrcEntryId finished!" + Arrays.toString(objs));
        return true;
    }

    public static boolean updateSrcEntryIdByPoentryId(List<Object> poEntryIdList, Map<String, String> poEntryId_srcEntryIdMap) {
        QFilter filter = new QFilter("materialentry.poentryid", "in", poEntryIdList);
        String selectFields = "id,billno,materialentry.id,materialentry.poentryid,materialentry.srcentryid";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectFields, (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        for (DynamicObject salOut : datas) {
            boolean isUpdate = false;
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String srcEntryId = poEntryId_srcEntryIdMap.get(col.getString("poentryid"));
                if (null == srcEntryId) continue;
                col.set("srcentryid", (Object)srcEntryId);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            updateDataList.add(salOut);
        }
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("SaloutUtil updateSrcEntryIdByPoentryId finished!" + Arrays.toString(objs));
        return true;
    }

    public static void updateReciptQtyOrInstockQty(List<Object> poEntryIdList, Map<String, BigDecimal> poEntryId_qtyMap, String pro, String operation) {
        QFilter filter = null;
        if (!poEntryId_qtyMap.isEmpty() && poEntryId_qtyMap.get("saloutentryid") != null) {
            poEntryId_qtyMap.remove("saloutentryid");
            ArrayList<Long> poEntryIds = new ArrayList<Long>(poEntryId_qtyMap.size());
            for (String poEntryId : poEntryId_qtyMap.keySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)poEntryId)) continue;
                poEntryIds.add(Long.valueOf(poEntryId));
            }
            filter = new QFilter("materialentry.id", "in", poEntryIds);
        } else if (poEntryId_qtyMap.get("poentryid") != null) {
            poEntryId_qtyMap.remove("poentryid");
            filter = new QFilter("materialentry.poentryid", "in", poEntryId_qtyMap.keySet());
        }
        if (filter == null) {
            return;
        }
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus").append(",materialentry.id,materialentry.poentryid,materialentry.srcentryid,materialentry.qty,materialentry.basicqty").append(",materialentry.sumreceiptqty,materialentry.sumreceiptbaseqty,materialentry.suminstockqty,materialentry.suminstockbaseqty,materialentry.rejectqty, materialentry.entrystatus,materialentry.rowlogstatus");
        String orderBy = "billdate asc";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBy);
        HashMap<String, BigDecimal> newPoEntryId_qtyMap = new HashMap<String, BigDecimal>();
        newPoEntryId_qtyMap.putAll(poEntryId_qtyMap);
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            boolean isUpdate = false;
            DynamicObject salOut = datas[i];
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                String entryId = col.getString("id");
                BigDecimal writeQty = (BigDecimal)newPoEntryId_qtyMap.get(entryId);
                if (writeQty == null) {
                    writeQty = (BigDecimal)newPoEntryId_qtyMap.get(poEntryId);
                }
                BigDecimal sumQty = CommonUtil.getBigDecimalPro((Object)col.get(pro));
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)col.get("qty"));
                if (writeQty == null || writeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal restWriteQty = BigDecimal.ZERO;
                boolean isAutoClose = false;
                if ("audit".equals(operation)) {
                    if (sumQty.compareTo(qty) < 0 && sumQty.add(writeQty).compareTo(qty) < 0) {
                        col.set(pro, (Object)sumQty.add(writeQty));
                    } else {
                        if (sumQty.compareTo(qty) >= 0 || sumQty.add(writeQty).compareTo(qty) < 0) continue;
                        col.set(pro, (Object)qty);
                        restWriteQty = sumQty.add(writeQty).subtract(qty);
                    }
                } else if ("delete".equals(operation)) {
                    BigDecimal sumReceiptQty = col.getBigDecimal("sumreceiptqty");
                    BigDecimal sumInstockQty = col.getBigDecimal("suminstockqty");
                    BigDecimal rejectQty = col.getBigDecimal("rejectqty");
                    BigDecimal sendQty = col.getBigDecimal("qty");
                    BigDecimal maxQty = sumReceiptQty.compareTo(sumInstockQty) > 0 ? sumReceiptQty : sumInstockQty;
                    if ((maxQty = maxQty.add(rejectQty)).compareTo(sendQty) >= 0) {
                        isAutoClose = true;
                    }
                    if (sumQty.subtract(writeQty).compareTo(BigDecimal.ZERO) > 0) {
                        col.set(pro, (Object)sumQty.subtract(writeQty));
                    } else {
                        if (sumQty.subtract(writeQty).compareTo(BigDecimal.ZERO) > 0) continue;
                        col.set(pro, (Object)BigDecimal.ZERO);
                        restWriteQty = sumQty.subtract(writeQty).abs();
                    }
                }
                newPoEntryId_qtyMap.put(poEntryId, restWriteQty);
                isUpdate = true;
                SaloutUtil.updateSaloutEntryStatus(col, operation, isAutoClose, false);
            }
            if (!isUpdate) continue;
            updateDataList.add(salOut);
        }
        SaloutUtil.updateCfmStatus(updateDataList.toArray(new DynamicObject[0]));
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("SaloutUtil updateReciptQtyOrInstockQty finished!" + Arrays.toString(objs));
    }

    private static void updateSaloutEntryStatus(DynamicObject col, String operation, boolean isAutoClose, boolean amountLineTypeControlCriterion) {
        BigDecimal taxamount;
        BigDecimal sumAcceptTaxAmount;
        if (null == col) {
            return;
        }
        BigDecimal sumReceiptQty = col.getBigDecimal("sumreceiptqty");
        BigDecimal sumInstockQty = col.getBigDecimal("suminstockqty");
        BigDecimal rejectQty = col.getBigDecimal("rejectqty");
        BigDecimal qty = col.getBigDecimal("qty");
        BigDecimal maxQty = sumReceiptQty.compareTo(sumInstockQty) > 0 ? sumReceiptQty : sumInstockQty;
        if ((maxQty = maxQty.add(rejectQty)).compareTo(qty) >= 0 && "audit".equals(operation)) {
            col.set("entrystatus", (Object)"B");
            log.info("SaloutUtil updateSaloutEntryStatus set RowStatus close!" + col.getPkValue());
        }
        if (amountLineTypeControlCriterion && (sumAcceptTaxAmount = col.getBigDecimal("sumaccepttaxamount")).compareTo(taxamount = col.getBigDecimal("taxamount")) >= 0 && "audit".equals(operation)) {
            col.set("entrystatus", (Object)"B");
            log.info("SaloutUtil updateSaloutEntryStatus set RowStatus close!" + col.getPkValue());
        }
        if (isAutoClose && "B".equals(col.getString("entrystatus")) && "delete".equals(operation)) {
            col.set("entrystatus", (Object)"A");
            log.info("SaloutUtil updateSaloutEntryStatus set RowStatus normal!" + col.getPkValue());
        }
    }

    public static void updateReciptQtyOrInstockQtyEx(CheckWriteDataEntity writeData, String pro, String operation) {
        Map<String, Map<String, BigDecimal>> writeDataMap = writeData.getWriteDataMap();
        if (writeDataMap.size() == 0) {
            log.info("###writeDataMap isEmpty!");
            return;
        }
        boolean dirPushFlag = false;
        List saloutBillEntryIdList = null;
        if (writeData.getSaloutBillEntryIdList() != null && !writeData.getSaloutBillEntryIdList().isEmpty()) {
            saloutBillEntryIdList = writeData.getSaloutBillEntryIdList().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        QFilter filter = null;
        if (saloutBillEntryIdList != null && !saloutBillEntryIdList.isEmpty()) {
            filter = new QFilter("materialentry.id", "in", saloutBillEntryIdList);
        } else {
            dirPushFlag = true;
            filter = new QFilter("materialentry.poentryid", "in", writeData.getPoEntryIdList());
        }
        QFilter filterstatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        String selectSb = "id,billno,cfmstatus,billstatus,logstatus,materialentry.id,materialentry.material,materialentry.unit,materialentry.basicunit,materialentry.poentryid,materialentry.srcentryid,materialentry.qty,materialentry.basicqty,materialentry.sumreceiptqty,materialentry.sumreceiptbaseqty,materialentry.suminstockqty,materialentry.suminstockbaseqty,materialentry.rejectqty, materialentry.entrystatus,materialentry.rowlogstatus,materialentry.warehouse";
        String orderBy = "billdate asc";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectSb, (QFilter[])new QFilter[]{filter, filterstatus}, (String)orderBy);
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        Map<String, String> writePropertyMap = writeData.getWritePropertyMap("pur_saloutstock");
        String writeQtyProperty = writePropertyMap.get("qty");
        String writeBasicQtyProperty = writePropertyMap.get("basicqty");
        DynamicProperty qtyProperty = null;
        DynamicProperty basicQtyProperty = null;
        DynamicObjectType rowDynamicObjectType = null;
        DynamicObject material = null;
        DynamicObject unit = null;
        DynamicObject basicUnit = null;
        for (int i = 0; i < datas.length; ++i) {
            ArrayList<String> srcEntryIdList = new ArrayList<String>(1);
            DynamicObject salOut = datas[i];
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            rowDynamicObjectType = cols.getDynamicObjectType();
            qtyProperty = rowDynamicObjectType.getProperty(writeQtyProperty);
            basicQtyProperty = rowDynamicObjectType.getProperty(writeBasicQtyProperty);
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                material = col.getDynamicObject("material");
                unit = col.getDynamicObject("unit");
                basicUnit = col.getDynamicObject("basicunit");
                Map<String, BigDecimal> srcEntryId_qtyMap = writeData.getWriteDataMap(poEntryId);
                if (!SaloutUtil.verifyStockQty(srcEntryId_qtyMap)) {
                    for (Map.Entry<String, Map<String, BigDecimal>> entry : writeDataMap.entrySet()) {
                        Map<String, BigDecimal> stepAvailableMap;
                        if (!entry.getKey().contains(poEntryId) || !SaloutUtil.verifyStockQty(stepAvailableMap = entry.getValue())) continue;
                        srcEntryId_qtyMap = stepAvailableMap;
                        break;
                    }
                }
                if (srcEntryId_qtyMap == null || srcEntryId_qtyMap.isEmpty()) continue;
                String srcEntryId = null;
                BigDecimal writeBasicQty = null;
                BigDecimal basicQty = CommonUtil.getBigDecimalPro((Object)col.get("basicqty"));
                for (Map.Entry<String, BigDecimal> qtyMapEntry : srcEntryId_qtyMap.entrySet()) {
                    srcEntryId = qtyMapEntry.getKey();
                    if (dirPushFlag) {
                        BigDecimal tryStockQty = qtyMapEntry.getValue();
                        if (tryStockQty != null) {
                            if (tryStockQty.compareTo(basicQty) == 0) {
                                writeBasicQty = qtyMapEntry.getValue();
                                break;
                            }
                            writeBasicQty = qtyMapEntry.getValue();
                            continue;
                        }
                    } else {
                        writeBasicQty = writeData.getSaloutWriteBackMapOneVal(col.getString("id"));
                    }
                    if (null != writeBasicQty && writeBasicQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                }
                BigDecimal sumQty = CommonUtil.getBigDecimalPro((Object)col.get(writeQtyProperty));
                BigDecimal sumBasicQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)sumQty, (DynamicObject)basicUnit);
                if (null == writeBasicQty || null != writeBasicQty && writeBasicQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal restWriteQty = BigDecimal.ZERO;
                boolean isAutoClose = false;
                if ("audit".equals(operation)) {
                    boolean isBuildRelation = true;
                    BigDecimal realWriteQty = BigDecimal.ZERO;
                    if (sumBasicQty.compareTo(basicQty) < 0 && sumBasicQty.add(writeBasicQty).compareTo(basicQty) < 0) {
                        BigDecimal stepBasicQty = sumBasicQty.add(writeBasicQty);
                        basicQtyProperty.setValue((Object)col, (Object)stepBasicQty);
                        qtyProperty.setValue((Object)col, (Object)CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)stepBasicQty, (DynamicObject)unit));
                        realWriteQty = writeBasicQty;
                    } else if (sumBasicQty.compareTo(basicQty) < 0 && sumBasicQty.add(writeBasicQty).compareTo(basicQty) >= 0) {
                        basicQtyProperty.setValue((Object)col, (Object)basicQty);
                        qtyProperty.setValue((Object)col, (Object)CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)basicQty, (DynamicObject)unit));
                        restWriteQty = sumBasicQty.add(writeBasicQty).subtract(basicQty);
                        realWriteQty = writeBasicQty.subtract(restWriteQty);
                    } else {
                        isBuildRelation = false;
                        continue;
                    }
                    if (isBuildRelation) {
                        DynamicObject writeRelation = CheckRelationUtil.createRelationObj(poEntryId, srcEntryId, col.getPkValue().toString(), realWriteQty);
                        CheckRelationUtil.setRelationData(salOut, writeRelation, writeData);
                        checkRelationList.add(writeRelation);
                    }
                } else if ("delete".equals(operation)) {
                    BigDecimal sumReceiptQty = col.getBigDecimal("sumreceiptqty");
                    BigDecimal sumInstockQty = col.getBigDecimal("suminstockqty");
                    BigDecimal rejectQty = col.getBigDecimal("rejectqty");
                    BigDecimal sendQty = col.getBigDecimal("qty");
                    BigDecimal maxQty = sumReceiptQty.compareTo(sumInstockQty) > 0 ? sumReceiptQty : sumInstockQty;
                    if ((maxQty = maxQty.add(rejectQty)).compareTo(sendQty) >= 0) {
                        isAutoClose = true;
                    }
                    if (sumBasicQty.subtract(writeBasicQty).compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal stepBasicQty = sumBasicQty.subtract(writeBasicQty);
                        basicQtyProperty.setValue((Object)col, (Object)stepBasicQty);
                        qtyProperty.setValue((Object)col, (Object)CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)stepBasicQty, (DynamicObject)unit));
                    } else {
                        if (sumBasicQty.subtract(writeBasicQty).compareTo(BigDecimal.ZERO) > 0) continue;
                        basicQtyProperty.setValue((Object)col, (Object)BigDecimal.ZERO);
                        qtyProperty.setValue((Object)col, (Object)BigDecimal.ZERO);
                        restWriteQty = sumBasicQty.subtract(writeBasicQty).abs();
                    }
                }
                srcEntryId_qtyMap.put(srcEntryId, restWriteQty);
                srcEntryIdList.add(srcEntryId);
                SaloutUtil.updateSaloutEntryStatus(col, operation, isAutoClose, false);
            }
            if (srcEntryIdList.isEmpty()) continue;
            updateDataList.add(salOut);
        }
        SaloutUtil.updateCfmStatus(updateDataList.toArray(new DynamicObject[0]));
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("###SaloutUtil updateReciptQtyOrInstockQty finished!" + Arrays.toString(objs));
        if (checkRelationList.size() > 0) {
            Object[] relationObjs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###SaloutUtil updateReciptQtyOrInstockQty saveRelations!" + Arrays.toString(relationObjs));
        }
    }

    private static boolean verifyStockQty(Map<String, BigDecimal> srcEntryId_qtyMap) {
        boolean anyAvailableMap;
        boolean verifyFlag = Boolean.FALSE;
        if (srcEntryId_qtyMap != null && !srcEntryId_qtyMap.isEmpty() && (anyAvailableMap = srcEntryId_qtyMap.entrySet().stream().anyMatch(row -> ((BigDecimal)row.getValue()).compareTo(BigDecimal.ZERO) > 0))) {
            verifyFlag = Boolean.TRUE;
        }
        return verifyFlag;
    }

    public static void updateReceiptTaxAmount(CheckWriteDataEntity writeData, String pro, String operation) {
        Map<String, Map<String, BigDecimal>> writeDataMap = writeData.getWriteDataMap();
        if (writeDataMap.size() == 0) {
            log.info("###writeDataMap isEmpty!");
            return;
        }
        boolean dirPushFlag = false;
        List saloutBillEntryIdList = null;
        if (writeData.getSaloutBillEntryIdList() != null && !writeData.getSaloutBillEntryIdList().isEmpty()) {
            saloutBillEntryIdList = writeData.getSaloutBillEntryIdList().stream().map(Long::parseLong).collect(Collectors.toList());
        }
        QFilter filter = null;
        if (saloutBillEntryIdList != null && !saloutBillEntryIdList.isEmpty()) {
            filter = new QFilter("materialentry.id", "in", saloutBillEntryIdList);
        } else {
            dirPushFlag = true;
            filter = new QFilter("materialentry.poentryid", "in", writeDataMap.keySet());
        }
        if (filter == null) {
            return;
        }
        QFilter filterstatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus").append(",materialentry.id,materialentry.poentryid,materialentry.srcentryid,materialentry.qty").append(",materialentry.taxamount,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.rejectqty").append(",materialentry.sumaccepttaxamount, materialentry.entrystatus,materialentry.rowlogstatus,materialentry.linetype");
        String orderBy = "billdate asc";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_accept_apply", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter, filterstatus}, (String)orderBy);
        log.info("###SaloutUtil updateReceiptTaxAmount starter!");
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            ArrayList<String> srcEntryIdList = new ArrayList<String>(1);
            DynamicObject salOut = datas[i];
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                Map<String, BigDecimal> srcEntryId_qtyMap = writeData.getWriteDataMap(poEntryId);
                if (null == srcEntryId_qtyMap) continue;
                String srcEntryId = null;
                BigDecimal writeAmount = null;
                for (Map.Entry<String, BigDecimal> qtyMapEntry : srcEntryId_qtyMap.entrySet()) {
                    srcEntryId = qtyMapEntry.getKey();
                    writeAmount = dirPushFlag ? qtyMapEntry.getValue() : writeData.getSaloutWriteBackMapOneVal(col.getString("id"));
                    if (null != writeAmount && writeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                }
                BigDecimal sumAcceptTaxAmount = CommonUtil.getBigDecimalPro((Object)col.get(pro));
                BigDecimal taxamount = col.getBigDecimal("taxamount");
                if (null == writeAmount || null != writeAmount && writeAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal restWriteAmount = BigDecimal.ZERO;
                boolean isAutoClose = false;
                if ("audit".equals(operation)) {
                    boolean isBuildRelation = true;
                    BigDecimal realWriteQty = BigDecimal.ZERO;
                    if (sumAcceptTaxAmount.compareTo(taxamount) < 0 && sumAcceptTaxAmount.add(writeAmount).compareTo(taxamount) < 0) {
                        col.set(pro, (Object)sumAcceptTaxAmount.add(writeAmount));
                        realWriteQty = writeAmount;
                    } else if (sumAcceptTaxAmount.compareTo(taxamount) < 0 && sumAcceptTaxAmount.add(writeAmount).compareTo(taxamount) >= 0) {
                        col.set(pro, (Object)taxamount);
                        restWriteAmount = sumAcceptTaxAmount.add(writeAmount).subtract(taxamount);
                        realWriteQty = writeAmount.subtract(restWriteAmount);
                    } else {
                        isBuildRelation = false;
                        continue;
                    }
                    if (isBuildRelation) {
                        DynamicObject writeRelation = CheckRelationUtil.createRelationObj(poEntryId, srcEntryId, col.getPkValue().toString(), realWriteQty);
                        CheckRelationUtil.setRelationData(salOut, writeRelation, writeData);
                        checkRelationList.add(writeRelation);
                    }
                } else if ("delete".equals(operation)) {
                    if (sumAcceptTaxAmount.compareTo(taxamount) >= 0) {
                        isAutoClose = true;
                    }
                    if (sumAcceptTaxAmount.subtract(writeAmount).compareTo(BigDecimal.ZERO) > 0) {
                        col.set(pro, (Object)sumAcceptTaxAmount.subtract(writeAmount));
                    } else {
                        if (sumAcceptTaxAmount.subtract(writeAmount).compareTo(BigDecimal.ZERO) > 0) continue;
                        col.set(pro, (Object)BigDecimal.ZERO);
                        restWriteAmount = sumAcceptTaxAmount.subtract(writeAmount).abs();
                    }
                }
                srcEntryId_qtyMap.put(srcEntryId, restWriteAmount);
                srcEntryIdList.add(srcEntryId);
                SaloutUtil.updateSaloutEntryStatus(col, operation, isAutoClose, true);
            }
            if (srcEntryIdList.isEmpty()) continue;
            updateDataList.add(salOut);
        }
        SaloutUtil.updateCfmStatus(updateDataList.toArray(new DynamicObject[0]));
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("###SaloutUtil updateReceiptTaxAmount finished!" + Arrays.toString(objs));
        if (checkRelationList.size() > 0) {
            Object[] relationObjs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###SaloutUtil updateReceiptTaxAmount saveRelations!" + Arrays.toString(relationObjs));
        }
    }

    private static void setSumreceiptqty(String pro, DynamicObject col, BigDecimal qty, boolean addFlag) {
        if ("suminstockqty".equals(pro)) {
            BigDecimal sumreceiptqty = CommonUtil.getBigDecimalPro((Object)col.get("sumreceiptqty"));
            sumreceiptqty = addFlag ? sumreceiptqty.add(qty) : sumreceiptqty.subtract(qty);
            col.set("sumreceiptqty", (Object)sumreceiptqty);
        }
    }

    public static void updateReciptQtyOrInstockQty(CheckWriteDataEntity writeData, String pro, String operation) {
        Map<String, Map<String, BigDecimal>> writeDataMap = writeData.getWriteDataMap();
        if (writeDataMap.size() == 0) {
            log.info("###writeDataMap isEmpty!");
            return;
        }
        QFilter filter = new QFilter("materialentry.poentryid", "in", writeDataMap.keySet());
        QFilter filterstatus = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus").append(",materialentry.id,materialentry.poentryid,materialentry.srcentryid,materialentry.qty,materialentry.basicqty").append(",materialentry.material,materialentry.unit,materialentry.basicunit").append(",materialentry.sumreceiptqty,materialentry.sumreceiptbaseqty,materialentry.suminstockqty,materialentry.suminstockbaseqty,materialentry.rejectqty, materialentry.entrystatus,materialentry.rowlogstatus");
        String orderBy = "billdate asc";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter, filterstatus}, (String)orderBy);
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            boolean isUpdate = false;
            DynamicObject salOut = datas[i];
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                DynamicObject materialObj = col.getDynamicObject("material");
                DynamicObject unitObj = col.getDynamicObject("unit");
                DynamicObject basicUnitObj = col.getDynamicObject("basicunit");
                String poEntryId = col.getString("poentryid");
                Map<String, BigDecimal> srcEntryId_qtyMap = writeData.getWriteDataMap(poEntryId);
                if (null == srcEntryId_qtyMap) continue;
                String srcEntryId = null;
                BigDecimal writeQty = null;
                for (Map.Entry<String, BigDecimal> qtyMapEntry : srcEntryId_qtyMap.entrySet()) {
                    srcEntryId = qtyMapEntry.getKey();
                    writeQty = qtyMapEntry.getValue();
                    if (writeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                }
                BigDecimal sumQty = CommonUtil.getBigDecimalPro((Object)col.get(pro));
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)col.get("qty"));
                if (null == writeQty || null != writeQty && writeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal restWriteQty = BigDecimal.ZERO;
                boolean isAutoClose = false;
                if ("audit".equals(operation)) {
                    boolean isBuildRelation = true;
                    BigDecimal realWriteQty = BigDecimal.ZERO;
                    if (sumQty.compareTo(qty) < 0 && sumQty.add(writeQty).compareTo(qty) < 0) {
                        col.set(pro, (Object)sumQty.add(writeQty));
                        SaloutUtil.setBaseQty(pro, col, materialObj, unitObj, basicUnitObj);
                        realWriteQty = writeQty;
                    } else if (sumQty.compareTo(qty) < 0 && sumQty.add(writeQty).compareTo(qty) >= 0) {
                        col.set(pro, (Object)qty);
                        SaloutUtil.setBaseQty(pro, col, materialObj, unitObj, basicUnitObj);
                        restWriteQty = sumQty.add(writeQty).subtract(qty);
                        realWriteQty = writeQty.subtract(restWriteQty);
                    } else {
                        isBuildRelation = false;
                        continue;
                    }
                    if (isBuildRelation) {
                        DynamicObject writeRelation = CheckRelationUtil.createRelationObj(poEntryId, srcEntryId, col.getPkValue().toString(), realWriteQty);
                        CheckRelationUtil.setRelationData(salOut, writeRelation, writeData);
                        checkRelationList.add(writeRelation);
                    }
                } else if ("delete".equals(operation)) {
                    BigDecimal sumReceiptQty = col.getBigDecimal("sumreceiptqty");
                    BigDecimal sumInstockQty = col.getBigDecimal("suminstockqty");
                    BigDecimal rejectQty = col.getBigDecimal("rejectqty");
                    BigDecimal sendQty = col.getBigDecimal("qty");
                    BigDecimal maxQty = sumReceiptQty.compareTo(sumInstockQty) > 0 ? sumReceiptQty : sumInstockQty;
                    if ((maxQty = maxQty.add(rejectQty)).compareTo(sendQty) >= 0) {
                        isAutoClose = true;
                    }
                    if (sumQty.subtract(writeQty).compareTo(BigDecimal.ZERO) > 0) {
                        col.set(pro, (Object)sumQty.subtract(writeQty));
                        SaloutUtil.setBaseQty(pro, col, materialObj, unitObj, basicUnitObj);
                    } else {
                        if (sumQty.subtract(writeQty).compareTo(BigDecimal.ZERO) > 0) continue;
                        col.set(pro, (Object)BigDecimal.ZERO);
                        SaloutUtil.setBaseQty(pro, col, materialObj, unitObj, basicUnitObj);
                        restWriteQty = sumQty.subtract(writeQty).abs();
                    }
                }
                srcEntryId_qtyMap.put(srcEntryId, restWriteQty);
                isUpdate = true;
                SaloutUtil.updateSaloutEntryStatus(col, operation, isAutoClose, false);
            }
            if (!isUpdate) continue;
            updateDataList.add(salOut);
        }
        SaloutUtil.updateCfmStatus(updateDataList.toArray(new DynamicObject[0]));
        Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])updateDataList.toArray(new DynamicObject[0]));
        log.info("###SaloutUtil updateReciptQtyOrInstockQty finished!" + Arrays.toString(objs));
        if (checkRelationList.size() > 0) {
            Object[] relationObjs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###SaloutUtil updateReciptQtyOrInstockQty saveRelations!" + Arrays.toString(relationObjs));
        }
    }

    private static void setBaseQty(String pro, DynamicObject col, DynamicObject materialObj, DynamicObject unitObj, DynamicObject basicUnitObj) {
        if ("sumreceiptbaseqty".equals(pro)) {
            BigDecimal sumreceiptbaseqty = col.getBigDecimal(pro);
            BigDecimal sumreceiptqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)sumreceiptbaseqty, (DynamicObject)unitObj);
            col.set("sumreceiptqty", (Object)sumreceiptqty);
        } else if ("sumreceiptqty".equals(pro)) {
            BigDecimal sumreceiptqty = col.getBigDecimal(pro);
            BigDecimal sumreceiptbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumreceiptqty, (DynamicObject)basicUnitObj);
            col.set("sumreceiptbaseqty", (Object)sumreceiptbaseqty);
        } else if ("suminstockbaseqty".equals(pro)) {
            BigDecimal suminstockbaseqty = col.getBigDecimal(pro);
            BigDecimal suminstockqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)suminstockbaseqty, (DynamicObject)unitObj);
            col.set("suminstockqty", (Object)suminstockqty);
        } else if ("suminstockqty".equals(pro)) {
            BigDecimal suminstockqty = col.getBigDecimal(pro);
            BigDecimal suminstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockqty, (DynamicObject)basicUnitObj);
            col.set("suminstockbaseqty", (Object)suminstockbaseqty);
        }
    }
}

