/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;

public class CheckRelationUtil {
    private static Log log = LogFactory.getLog(CheckRelationUtil.class);
    private static String[] REL_SELECTS = new String[]{"poentryid", "srcentryid", "tarentryid", "qty"};
    private static String[] SAL_SELECTS = new String[]{"billid", "billno", "entryid", "salqty"};
    private static String[] SEND_SAL_SELECTS = new String[]{"sendbillid", "sendbillno", "sendbilldate", "sendentryid", "sendqty", "sendtaxamount", "sendsrcentryid"};

    public static DynamicObject createRelationObj(String poEntryId, String srcEntryId, String tarEntryId, BigDecimal qty) {
        DynamicObject checkRelation = ORMUtil.newDynamicObject((String)"pur_checkrelation");
        checkRelation.set("poentryid", (Object)poEntryId);
        checkRelation.set("srcentryid", (Object)srcEntryId);
        checkRelation.set("tarentryid", (Object)tarEntryId);
        checkRelation.set("qty", (Object)qty);
        checkRelation.set("createdate", (Object)new Date());
        return checkRelation;
    }

    public static void setRelationData(DynamicObject tarObj, DynamicObject relationObj, CheckWriteDataEntity writeData) {
        relationObj.set("srcentitykey", (Object)writeData.getSrcEntityKey());
        relationObj.set("tarentitykey", (Object)writeData.getTarEntityKey());
        Object srcEntryId = relationObj.get("srcentryid");
        if (null != srcEntryId) {
            relationObj.set("srcid", (Object)writeData.getSrcBillId(srcEntryId.toString()));
        }
        relationObj.set("tarid", tarObj.getPkValue());
    }

    public static void createCheckRelation(List<DynamicObject> returnDataList, List<DynamicObject> tarDataList, String retEntityKey) {
        HashMap<String, DynamicObject> poEntryId_tarEntry = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : tarDataList) {
            DynamicObjectCollection cols = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                poEntryId_tarEntry.put(poEntryId, col);
            }
        }
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        for (DynamicObject data : returnDataList) {
            DynamicObjectCollection cols = data.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                DynamicObject tarEntry = (DynamicObject)poEntryId_tarEntry.get(poEntryId);
                if (tarEntry == null) continue;
                BigDecimal qty = col.getBigDecimal("qty");
                DynamicObject relationObj = CheckRelationUtil.createRelationObj(poEntryId, col.getPkValue().toString(), tarEntry.getPkValue().toString(), qty);
                relationObj.set("srcentitykey", (Object)retEntityKey);
                relationObj.set("tarentitykey", (Object)"scp_salreturn");
                relationObj.set("srcid", data.getPkValue());
                Object parent = tarEntry.getParent();
                if (null != parent && parent instanceof DynamicObject) {
                    relationObj.set("tarid", ((DynamicObject)parent).getPkValue());
                }
                checkRelationList.add(relationObj);
            }
        }
        if (checkRelationList.size() > 0) {
            Object[] objectArray = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###return saveRelations!" + Arrays.toString(objectArray));
        }
    }

    public static void createCheckRelation(List<DynamicObject> objs, Map<String, Map<String, Object>> srcEntryId_entryMap, String entityKey, String entryKey) {
        log.info("###start createCheckRelation");
        HashMap<String, String> poEntryId_salEntryIdMap = new HashMap<String, String>(srcEntryId_entryMap.size());
        HashMap<String, String> poEntryId_salIdMap = new HashMap<String, String>(srcEntryId_entryMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : srcEntryId_entryMap.entrySet()) {
            Object poEntryId = entry.getValue().get("poentryid");
            Object salOutEntryIdObj = entry.getValue().get("saloutentryid");
            if (null == poEntryId || poEntryId.toString().trim().length() == 0 || null == salOutEntryIdObj || salOutEntryIdObj.toString().trim().length() == 0) continue;
            poEntryId_salEntryIdMap.put(poEntryId.toString(), salOutEntryIdObj.toString());
            Object salOutIdObj = entry.getValue().get("saloutid");
            if (null == salOutIdObj || salOutIdObj.toString().trim().length() == 0) continue;
            poEntryId_salIdMap.put(poEntryId.toString(), salOutIdObj.toString());
        }
        log.info("###createCheckRelation poEntryId_salIdMap:" + poEntryId_salIdMap);
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(entryKey);
            for (DynamicObject col : cols) {
                String srcEntryId = col.getString("srcentryid");
                Map<String, Object> billEntryMap = srcEntryId_entryMap.get(srcEntryId);
                if (null == billEntryMap) continue;
                String poEntryId = col.getString("poentryid");
                Object salOutEntryIdObj = billEntryMap.get("saloutentryid");
                if ((null == salOutEntryIdObj || salOutEntryIdObj.toString().trim().length() == 0) && null == (salOutEntryIdObj = poEntryId_salEntryIdMap.get(poEntryId))) continue;
                BigDecimal qty = col.getBigDecimal("qty");
                DynamicObject relationObj = CheckRelationUtil.createRelationObj(poEntryId, col.getPkValue().toString(), salOutEntryIdObj.toString(), qty);
                relationObj.set("srcentitykey", (Object)entityKey);
                relationObj.set("tarentitykey", (Object)"pur_saloutstock");
                relationObj.set("srcid", obj.getPkValue());
                Object saloutId = billEntryMap.get("saloutid");
                if (null != saloutId && saloutId.toString().trim().length() != 0) {
                    relationObj.set("tarid", saloutId);
                } else {
                    relationObj.set("tarid", poEntryId_salIdMap.get(poEntryId));
                }
                checkRelationList.add(relationObj);
            }
        }
        if (checkRelationList.size() > 0) {
            Object[] objectArray = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###" + entityKey + " saveRelations contains!" + Arrays.toString(objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getRelationData(List<String> srcEntryIdList) {
        DynamicObjectCollection relationdatacol = null;
        DataSet saloutDataSet = null;
        DataSet salRetrunDataSet = null;
        DataSet unionData = null;
        try {
            ORM orm = ORM.create();
            QFilter filter = new QFilter("srcentryid", "in", srcEntryIdList);
            StringBuilder selectSb = new StringBuilder();
            selectSb.append("id,poentryid,srcentryid,tarentryid,qty");
            DataSet relationData = orm.queryDataSet("checkRelationUtil", "pur_checkrelation", selectSb.toString(), new QFilter[]{filter});
            DynamicObjectCollection relationDatas = orm.toPlainDynamicObjectCollection(relationData.copy());
            if (relationDatas.size() == 0) {
                log.info("###checkRelation \u6ca1\u6709\u53d6\u5230\u5173\u8054\u6570\u636e." + srcEntryIdList);
                DynamicObjectCollection dynamicObjectCollection = null;
                return dynamicObjectCollection;
            }
            List entryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])relationDatas.toArray((Object[])new DynamicObject[0])), (String)"tarentryid");
            if (CollectionUtils.isEmpty((Collection)entryIdList)) {
                DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(relationData);
                return dynamicObjectCollection;
            }
            List orderListLong = entryIdList.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter salOutFilter = new QFilter("materialentry.id", "in", orderListLong);
            StringBuilder selectSaloutSb = new StringBuilder();
            selectSaloutSb.append("id billid,billno,materialentry.id entryid,materialentry.qty salqty");
            saloutDataSet = orm.queryDataSet("checkRelationUtil", "pur_saloutstock", selectSaloutSb.toString(), new QFilter[]{salOutFilter});
            salRetrunDataSet = orm.queryDataSet("checkRelationUtil", "pur_salreturn", selectSaloutSb.toString(), new QFilter[]{salOutFilter});
            unionData = saloutDataSet.union(salRetrunDataSet);
            JoinDataSet joinSet = relationData.join(unionData, JoinType.LEFT);
            joinSet.on("tarentryid", "entryid");
            joinSet.select(REL_SELECTS, SAL_SELECTS);
            relationData = joinSet.finish();
            relationdatacol = orm.toPlainDynamicObjectCollection(relationData);
        }
        finally {
            if (null != saloutDataSet) {
                saloutDataSet.close();
            }
            if (null != salRetrunDataSet) {
                salRetrunDataSet.close();
            }
            if (null != unionData) {
                unionData.close();
            }
        }
        return relationdatacol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getOrderCheckRelationData(List<String> srcEntryIdList) {
        DynamicObjectCollection col = null;
        ORM orm = ORM.create();
        DataSet saloutDataSet = null;
        DataSet relationDatanew = null;
        DataSet relationData = null;
        DataSet salRetrunDataSet = null;
        DataSet resultDataSet = null;
        try {
            QFilter filter = new QFilter("srcentryid", "in", srcEntryIdList);
            StringBuilder selectSb = new StringBuilder();
            selectSb.append("id,poentryid,srcentryid,tarentryid,qty");
            relationData = QueryServiceHelper.queryDataSet((String)"checkRelationUtil", (String)"pur_checkrelation", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter}, (String)"");
            relationDatanew = relationData.copy();
            ArrayList<Long> entryIdList = new ArrayList<Long>(16);
            while (relationData.hasNext()) {
                entryIdList.add(relationData.next().getLong("tarentryid"));
            }
            QFilter salOutFilter = new QFilter("materialentry.id", "in", entryIdList);
            StringBuilder selectSaloutSb = new StringBuilder();
            selectSaloutSb.append("id sendbillid,billno sendbillno,billstatus sendbillstatus,billdate sendbilldate,").append("curr.id sendcurr,org.id sendorg,").append("purorg.id sendpurorg,").append("materialentry").append(".id sendentryid,").append(1).append("*abs(").append("materialentry").append(".qty) sendqty").append(',').append(1).append("*abs(").append("materialentry").append(".taxamount) sendtaxamount").append(',').append("materialentry").append(".pobillid sendpobillid,").append("materialentry").append(".poentryid sendpoentryid,").append("materialentry").append(".srcentryid sendsrcentryid,").append("materialentry").append(".srcbillid sendsrcbillid");
            saloutDataSet = QueryServiceHelper.queryDataSet((String)"checkRelationUtil", (String)"pur_saloutstock", (String)selectSaloutSb.toString(), (QFilter[])new QFilter[]{salOutFilter}, (String)"");
            salRetrunDataSet = QueryServiceHelper.queryDataSet((String)"checkRelationUtil", (String)"pur_salreturn", (String)selectSaloutSb.toString(), (QFilter[])new QFilter[]{salOutFilter}, (String)"");
            DataSet unionData = saloutDataSet.union(salRetrunDataSet);
            JoinDataSet joinSet = relationDatanew.join(unionData, JoinType.LEFT);
            joinSet.on("tarentryid", "sendentryid");
            joinSet.select(REL_SELECTS, SEND_SAL_SELECTS);
            resultDataSet = joinSet.finish();
            col = orm.toPlainDynamicObjectCollection(resultDataSet);
        }
        finally {
            if (saloutDataSet != null) {
                saloutDataSet.close();
            }
            if (relationDatanew != null) {
                relationDatanew.close();
            }
            if (relationData != null) {
                relationData.close();
            }
            if (salRetrunDataSet != null) {
                salRetrunDataSet.close();
            }
            if (resultDataSet != null) {
                resultDataSet.close();
            }
        }
        return col;
    }

    public static DynamicObjectCollection getCheckRelation(List<String> srcIdList) {
        QFilter filter = new QFilter("srcid", "in", srcIdList);
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,srcid,srcentryid");
        DataSet relationData = ORMUtil.queryDataSet((String)"getCheckRelation", (String)"pur_checkrelation", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection relationDatas = ORM.create().toPlainDynamicObjectCollection(relationData.copy());
        if (relationDatas.size() == 0) {
            log.info("###getCheckRelation \u6ca1\u6709\u53d6\u5230\u5173\u8054\u6570\u636e." + srcIdList);
            return null;
        }
        return relationDatas;
    }
}

