/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.check;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.PurTypeUtil;
import kd.scm.common.util.check.AbstractCheckImpl;

public class HandCheckImpl
extends AbstractCheckImpl {
    private Set<String> extendFields = null;
    private Map<String, Set<String>> extendFieldsMap = null;
    private Map<String, Set<String>> extendFieldGroups = null;
    private Set<String> removeFieldGroups = null;
    private static final Log log = LogFactory.getLog(HandCheckImpl.class);
    private static final String[] ENTRY_NUMBER_FIELDS = new String[]{"qty", "tax", "dctamount", "amount", "taxamount", "sumcheckqty", "sumcheckamt", "unmatchqty"};
    protected String jointsystemtype = null;
    private static final String ISINSTOCK = "2";
    private static final String ISNOTINSTOCK = "1";
    private List<String> checkFieldGroups = Stream.of("settleorg", "supplier", "curr", "checkperiod", "taxtype", "controlcriterion").collect(Collectors.toList());

    public static String[] getEntryNumberFields() {
        return ENTRY_NUMBER_FIELDS;
    }

    public HandCheckImpl() {
    }

    public HandCheckImpl(Set<String> extendFields, Map<String, Set<String>> extendFieldsMap) {
        this.extendFields = extendFields;
        this.extendFieldsMap = extendFieldsMap;
    }

    public HandCheckImpl(Set<String> extendFields, Map<String, Set<String>> extendFieldsMap, Map<String, Set<String>> extendGroups, Set<String> removeGroups) {
        this.extendFields = extendFields;
        this.extendFieldsMap = extendFieldsMap;
        this.extendFieldGroups = extendGroups;
        this.removeFieldGroups = removeGroups;
    }

    @Override
    public Map<String, Object> getData(String entityName, Map<String, Map<String, Object>> param) {
        return this.getData(entityName, param, SystemJointChannelHelper.getDefaultJointChannelId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getData(String entityName, Map<String, Map<String, Object>> param, String jointChannelData) {
        log.info("###checkImpl start getData");
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        DataSet dataSet = null;
        DataSet detailDataSet = null;
        try {
            String entryKey = this.getEntryKey(entityName);
            DynamicObject jointCacheData = null;
            if (jointChannelData != null) {
                jointCacheData = SystemJointChannelHelper.getJointChannelData((String)jointChannelData);
            }
            String jointSystemTypeParam = null;
            if (jointCacheData != null) {
                this.jointsystemtype = jointSystemTypeParam = jointCacheData.getString("jointchanneltype.jointsystemtype");
            }
            String selectFields = this.getSelectFields(param, entityName, entryKey, false);
            Object[] checkTypeInstockIds = this.getLineTypeOrPurTypeIds(ISINSTOCK, this.jointsystemtype);
            Object[] checkTypeReceiptIds = this.getLineTypeOrPurTypeIds(ISNOTINSTOCK, this.jointsystemtype);
            Map<String, Map<String, Object>> customPram = this.wrapParam(entityName, entryKey, param, checkTypeInstockIds, checkTypeReceiptIds);
            dataSet = ORMUtil.queryDataSet((String)entityName, (String)selectFields, customPram, null);
            detailDataSet = this.getUnionData(entityName, param, checkTypeInstockIds, checkTypeReceiptIds);
            if (detailDataSet != null) {
                dataSet = dataSet.union(detailDataSet);
            }
            detailDataSet = dataSet.copy();
            String orderBys = this.getOrderBys();
            if (orderBys != null) {
                detailDataSet = detailDataSet.orderBy(orderBys.split(","));
            }
            String[] checkGroupBys = this.getCheckGroups();
            DynamicObjectCollection dynamicObjects = orm.toPlainDynamicObjectCollection(detailDataSet);
            for (DynamicObject detail : dynamicObjects) {
                detail.set("groupkey", (Object)this.getGroupKey(detail, checkGroupBys));
            }
            objectMap.put("detail", dynamicObjects);
            DataSet checkDataSet = dataSet.copy();
            GroupbyDataSet checkbyDataSet = checkDataSet.groupBy(checkGroupBys);
            for (String pro : ENTRY_NUMBER_FIELDS) {
                checkbyDataSet.sum(pro);
            }
            DataSet checkSumDataSet = checkbyDataSet.finish();
            DynamicObjectCollection sum = orm.toPlainDynamicObjectCollection(checkSumDataSet);
            for (DynamicObject sumCol : sum) {
                String purSumGroupKey = this.getGroupKey(sumCol, checkGroupBys);
                sumCol.set("groupkey", (Object)purSumGroupKey);
            }
            objectMap.put("sum", sum);
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            if (null != detailDataSet) {
                detailDataSet.close();
            }
        }
        log.info("###checkImpl end getData");
        return objectMap;
    }

    private String getGroupKey(DynamicObject obj, String[] groupBys) {
        StringBuilder sb = new StringBuilder();
        for (String group : groupBys) {
            if ("groupkey".equals(group)) continue;
            if (obj.get(group) instanceof DynamicObject) {
                sb.append(((DynamicObject)obj.get(group)).getPkValue()).append('-');
                continue;
            }
            sb.append(obj.get(group)).append('-');
        }
        return sb.toString();
    }

    public String getSelectFields(Map<String, Map<String, Object>> param, String entityKey, String entryKey, boolean isNegative) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append(this.getSelectFields(entityKey, entryKey, isNegative));
        StringBuilder dateBuilder = new StringBuilder();
        Map<String, Object> billDateMap = param.get("billdate");
        for (Map.Entry<String, Object> billDate : billDateMap.entrySet()) {
            dateBuilder.append(DateUtil.date2str((Date)((Date)billDate.getValue()), (String)"yyyy-MM-dd")).append(':');
        }
        selectFieldSb.append(",'").append((CharSequence)dateBuilder).append("' as checkperiod");
        return selectFieldSb.toString();
    }

    @Override
    public String getSelectFields(String entityKey, String entryKey, boolean isNegative) {
        StringBuilder selectFieldSb = new StringBuilder();
        if (this.isSalKey(entityKey)) {
            selectFieldSb.append(this.getSalSelectFields(entryKey));
        } else if (this.isPurKey(entityKey)) {
            selectFieldSb.append(this.getPurSelectFields(entityKey, entryKey));
        }
        this.getCustomSearchSelects(entityKey, entryKey, selectFieldSb);
        if (selectFieldSb.length() == 0) {
            log.info("###checkImpl getSelectFields \u4e0d\u652f\u6301\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8fdb\u884c\u5bf9\u8d26\u67e5\u8be2!\u5355\u636e\u6807\u8bc6:" + entityKey);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8fdb\u884c\u5bf9\u8d26\u67e5\u8be2\uff01\u5355\u636e\u6807\u8bc6\uff1a", (String)"HandCheckImpl_0", (String)"scm-common", (Object[])new Object[0]) + entityKey);
        }
        int number = 1;
        if (isNegative) {
            number = -1;
        }
        this.wrapNumberFields(selectFieldSb, entryKey, number);
        selectFieldSb.append(",'").append(entityKey).append("' as srcbilltype");
        log.info("###checkImpl getSelectFields entityKey:" + entityKey);
        log.info("###checkImpl getSelectFields:" + selectFieldSb);
        return selectFieldSb.toString();
    }

    protected Map<String, Map<String, Object>> wrapParam(String entityKey, String entryKey, Map<String, Map<String, Object>> paramMap, Object[] checkTypeInstockIds, Object[] checkTypeReceiptIds) {
        HashMap<String, String> isCenterSettleMap;
        HashMap<String, Map<String, Object>> customParam = new HashMap<String, Map<String, Object>>();
        customParam.putAll(paramMap);
        Object[] checkTypeIds = null;
        boolean isFilterPurType = false;
        if ("scp_instock".equals(entityKey) || "pur_instock".equals(entityKey)) {
            isFilterPurType = true;
            checkTypeIds = checkTypeInstockIds;
            isCenterSettleMap = new HashMap<String, String>(1);
            isCenterSettleMap.put("!=", ISNOTINSTOCK);
            customParam.put("iscentersettle", isCenterSettleMap);
        } else if ("scp_receipt".equals(entityKey) || "pur_receipt".equals(entityKey)) {
            isFilterPurType = true;
            checkTypeIds = checkTypeReceiptIds;
        } else if ("scp_return".equals(entityKey) || "pur_return".equals(entityKey)) {
            isCenterSettleMap = new HashMap(1);
            isCenterSettleMap.put("!=", ISNOTINSTOCK);
            customParam.put("iscentersettle", isCenterSettleMap);
            isFilterPurType = true;
            checkTypeIds = checkTypeInstockIds;
        }
        HashMap<String, Object> checkTypeMap = new HashMap<String, Object>(1);
        if (null != checkTypeIds && checkTypeIds.length > 0) {
            checkTypeMap.put("in", checkTypeIds);
        } else if (isFilterPurType) {
            checkTypeMap.put("in", new ArrayList());
        }
        customParam.put(entryKey + "." + this.getLineTypeOrPurType(this.jointsystemtype), checkTypeMap);
        log.info("###checkImpl purType param:" + (checkTypeIds == null ? "0" : CommonUtil.objs2str((Object[])checkTypeIds)));
        if (this.isSalKey(entityKey)) {
            customParam.remove("billdate");
        }
        return customParam;
    }

    private String getLineTypeOrPurType(String jointsystemtype) {
        if ("self".equals(jointsystemtype)) {
            return "linetype";
        }
        return "purtype";
    }

    private Object[] getLineTypeOrPurTypeIds(String checkType, String jointsystemtype) {
        Object[] purTypes = null;
        List purTypeIdList = null;
        if ("self".equals(jointsystemtype)) {
            boolean isStorage = false;
            if (ISINSTOCK.equals(checkType)) {
                isStorage = true;
            }
            purTypeIdList = LineTypeUtil.getLineTypeByStorage((Boolean)isStorage);
        } else {
            purTypeIdList = PurTypeUtil.getPurTypeByCheckType((String)checkType);
        }
        if (purTypeIdList != null && purTypeIdList.size() > 0) {
            purTypes = purTypeIdList.toArray(new Object[0]);
        }
        return purTypes;
    }

    protected Map<String, Map<String, Object>> wrapParam(String entityKey, String entryKey, Map<String, Map<String, Object>> paramMap, boolean isreturn, Object[] checkTypeInstockIds, Object[] checkTypeReceiptIds) {
        Map<String, Map<String, Object>> customParam = this.wrapParam(entityKey, entryKey, paramMap, checkTypeInstockIds, checkTypeReceiptIds);
        if ("scp_receipt".equals(entityKey) || "pur_receipt".equals(entityKey)) {
            if (isreturn) {
                HashMap<String, String> isReturnMap = new HashMap<String, String>(1);
                isReturnMap.put("=", ISNOTINSTOCK);
                customParam.put("isreturn", isReturnMap);
            } else {
                HashMap<String, String> isReturnMap = new HashMap<String, String>(1);
                isReturnMap.put("!=", ISNOTINSTOCK);
                customParam.put("isreturn", isReturnMap);
            }
        }
        return customParam;
    }

    protected void wrapNumberFields(StringBuilder selectFieldSb, String entryKey, int number) {
        int i;
        String[] numberFields = new String[]{};
        for (i = 0; i < ENTRY_NUMBER_FIELDS.length; ++i) {
            if ("qty".equals(ENTRY_NUMBER_FIELDS[i])) {
                selectFieldSb.append(',').append(number).append("*abs(").append(entryKey).append('.').append(ENTRY_NUMBER_FIELDS[i]).append('-').append(entryKey).append(".sumcheckqty").append(") ").append(ENTRY_NUMBER_FIELDS[i]);
                continue;
            }
            if ("taxamount".equals(ENTRY_NUMBER_FIELDS[i])) {
                selectFieldSb.append(',').append(number).append("*abs(").append(entryKey).append('.').append(ENTRY_NUMBER_FIELDS[i]).append('-').append(entryKey).append(".sumcheckamt").append(") ").append(ENTRY_NUMBER_FIELDS[i]);
                continue;
            }
            selectFieldSb.append(',').append(number).append("*abs(").append(entryKey).append('.').append(ENTRY_NUMBER_FIELDS[i]).append(") ").append(ENTRY_NUMBER_FIELDS[i]);
        }
        for (i = 0; i < numberFields.length; ++i) {
            selectFieldSb.append(',').append(number).append("*abs(").append(numberFields[i]).append(')');
        }
    }

    protected boolean isSalKey(String entityKey) {
        return entityKey.equals("scp_salreturn") || entityKey.equals("scp_saloutstock") || entityKey.equals("pur_saloutstock") || entityKey.equals("pur_salreturn");
    }

    protected boolean isPurKey(String entityKey) {
        return entityKey.equals("pur_return") || entityKey.equals("pur_instock") || entityKey.equals("scp_instock") || entityKey.equals("scp_return") || entityKey.equals("pur_receipt") || entityKey.equals("scp_receipt");
    }

    protected String getSalSelectFields(String entryKey) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append("id billid,billno,billstatus,billdate,biztype,paycond.id paycond,settletype.id settletype,").append("taxtype,cfmstatus,cfmdate,curr.id curr,curr.amtprecision amtprecision,curr.priceprecision priceprecision,supplier.id supplier,org.id invorg,purorg.id purorg,").append("businesstype.id businesstype_in,").append(entryKey).append(".id entryid,").append(entryKey).append(".material.id material,").append(entryKey).append(".materialdesc materialdesc,").append(entryKey).append(".material.name materialnameold,").append(entryKey).append(".materialnametext materialname,").append(entryKey).append(".linetype.id linetype,").append(entryKey).append(".linetype.controlcriterion controlcriterion,").append(entryKey).append(".price price,").append(entryKey).append(".taxprice taxprice,").append(entryKey).append(".discounttype discounttype,").append(entryKey).append(".dctrate dctrate,").append(entryKey).append(".taxrate taxrate,").append(entryKey).append(".taxrateid taxrateid,").append(entryKey).append(".entrystatus entrystatus,").append(entryKey).append(".actprice actprice,").append(entryKey).append(".acttaxprice acttaxprice,").append(entryKey).append(".unit.id unit,").append(entryKey).append(".pobillno pobillno,").append(entryKey).append(".pcbillno pcbillno,").append(entryKey).append(".pobillid pobillid,").append(entryKey).append(".poentryid poentryid,").append(entryKey).append(".pcbillid pcbillid,").append(entryKey).append(".pcentryid pcentryid,").append(entryKey).append(".entrysettleorg.id settleorg,").append(entryKey).append(".project.id project,").append(entryKey).append(".goods goods,").append(entryKey).append(".ispresent ispresent,").append(entryKey).append(".srcentryid srcentryid,").append(entryKey).append(".srcbillid srcbillid");
        return selectFieldSb.toString();
    }

    protected boolean isReceiptEntity(String entityKey) {
        return entityKey.equals("pur_receipt") || entityKey.equals("scp_receipt");
    }

    protected String getPurSelectFields(String entityKey, String entryKey) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append("id billid,billno,billstatus,billdate,biztype,paycond.id paycond,cfm.id cfm,").append("settletype.id settletype,taxtype,cfmstatus,cfmdate,curr.id curr,curr.amtprecision amtprecision,curr.priceprecision priceprecision,org.id invorg,").append("businesstype.id businesstype_in,").append("purorg.id purorg,loccurr,exchrate,").append(entryKey).append(".id entryid,").append(entryKey).append(".material.id material,").append(entryKey).append(".material.name materialnameold,").append(entryKey).append(".materialnametext materialname,").append(entryKey).append(".materialdesc materialdesc,").append(entryKey).append(".price price,").append(entryKey).append(".linetype.id linetype,").append(entryKey).append(".linetype.controlcriterion controlcriterion,").append(entryKey).append(".taxprice taxprice,").append(entryKey).append(".discounttype discounttype,").append(entryKey).append(".dctrate dctrate,").append(entryKey).append(".taxrate taxrate,").append(entryKey).append(".taxrateid taxrateid,").append(entryKey).append(".entrystatus entrystatus,").append(entryKey).append(".entrysettleorg.id settleorg,").append(entryKey).append(".actprice actprice,").append(entryKey).append(".acttaxprice acttaxprice,").append(entryKey).append(".settlesup.id supplier,").append(entryKey).append(".unit.id unit,").append(entryKey).append(".pobillno pobillno,").append(entryKey).append(".pcbillno pcbillno,").append(entryKey).append(".pobillid pobillid,").append(entryKey).append(".poentryid poentryid,").append(entryKey).append(".pcbillid pcbillid,").append(entryKey).append(".pcentryid pcentryid,").append(entryKey).append(".ispresent ispresent,").append(entryKey).append(".goods goods,").append(entryKey).append(".srcentryid srcentryid,").append(entryKey).append(".srcbillid srcbillid,").append(entryKey).append(".project.id project,").append(entryKey).append(".entrypurorg entrypurorg,").append("null as groupkey");
        if (this.isReceiptEntity(entityKey)) {
            selectFieldSb.append(",inputamount");
        } else {
            selectFieldSb.append(",null as inputamount");
        }
        if ("pur_instock".equals(entityKey) || "scp_instock".equals(entityKey)) {
            selectFieldSb.append(",businessdirect");
        } else {
            selectFieldSb.append(",null as businessdirect");
        }
        this.setExtendFields(entityKey, selectFieldSb);
        return selectFieldSb.toString();
    }

    private void setExtendFields(String entityKey, StringBuilder sb) {
        if (this.extendFields != null && !this.extendFields.isEmpty()) {
            MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityKey);
            if (this.extendFieldsMap != null && this.extendFieldsMap.containsKey(entityKey)) {
                Set<String> allowFields = this.extendFieldsMap.get(entityKey);
                this.extendFields.forEach(arg_0 -> this.lambda$setExtendFields$0(allowFields, sb, (DynamicObjectType)objectType, arg_0));
            } else {
                this.extendFields.forEach(arg_0 -> this.lambda$setExtendFields$1(sb, (DynamicObjectType)objectType, arg_0));
            }
        }
    }

    private String checkField(String field, DynamicObjectType objectType) {
        BillEntityType billEntityType;
        Map entityTypeMap;
        EntityType entityType;
        String newField = field.trim();
        int headDivideIndex = newField.indexOf(".");
        int aliasDivideIndex = newField.indexOf(" ");
        String fieldPrefixKey = null;
        String fieldSuffixKey = null;
        if (headDivideIndex > 0) {
            fieldPrefixKey = newField.substring(0, headDivideIndex).toLowerCase();
            if (aliasDivideIndex > 0) {
                fieldSuffixKey = newField.substring(headDivideIndex + 1, aliasDivideIndex).toLowerCase();
            }
        } else if (aliasDivideIndex > 0) {
            fieldPrefixKey = newField.substring(0, aliasDivideIndex).toLowerCase();
        }
        if (StringUtils.isNotEmpty(fieldPrefixKey) && (StringUtils.isNotEmpty(fieldSuffixKey) ? (entityType = (EntityType)(entityTypeMap = (billEntityType = (BillEntityType)objectType).getAllEntities()).get(fieldPrefixKey)) != null && entityType.getProperty(fieldSuffixKey) != null : objectType.getProperty(fieldPrefixKey) != null)) {
            return field;
        }
        if (aliasDivideIndex > 0) {
            return " null " + newField.substring(newField.lastIndexOf(" ") + 1);
        }
        return headDivideIndex > 0 ? " null " + newField.substring(headDivideIndex + 1) : " null " + field;
    }

    @Override
    public List<String> getUnionKey(String entityKey, boolean isReturn) {
        ArrayList<String> unitKeyList = new ArrayList<String>();
        if (isReturn) {
            if (entityKey.equals("pur_instock")) {
                unitKeyList.add("pur_return");
                unitKeyList.add("pur_receipt");
            } else if (entityKey.equals("scp_saloutstock")) {
                unitKeyList.add("scp_salreturn");
            } else if (entityKey.equals("scp_instock")) {
                unitKeyList.add("scp_return");
                unitKeyList.add("scp_receipt");
            } else if (entityKey.equals("pur_saloutstock")) {
                unitKeyList.add("pur_salreturn");
            }
        } else if (entityKey.equals("scp_instock")) {
            unitKeyList.add("scp_receipt");
        } else if (entityKey.equals("pur_instock")) {
            unitKeyList.add("pur_receipt");
        }
        return unitKeyList;
    }

    public DataSet getUnionData(String entityKey, Map<String, Map<String, Object>> param, Object[] checkTypeInstockIds, Object[] checkTypeReceiptIds) {
        DataSet detailDataSet = null;
        Map<String, Map<String, Object>> customPram = null;
        try {
            DataSet unionDataSet;
            String selectFields;
            String entryKey;
            List<String> unionEntityKeyList = this.getUnionKey(entityKey, true);
            log.info("###checkImpl unionKeyList is return:" + unionEntityKeyList);
            for (String unionEntityKey : unionEntityKeyList) {
                entryKey = this.getEntryKey(unionEntityKey);
                selectFields = this.getSelectFields(param, unionEntityKey, entryKey, true);
                customPram = this.wrapParam(unionEntityKey, entryKey, param, true, checkTypeInstockIds, checkTypeReceiptIds);
                log.info("###checkImpl param:" + customPram);
                unionDataSet = ORMUtil.queryDataSet((String)unionEntityKey, (String)selectFields, customPram, null);
                if (null == detailDataSet) {
                    detailDataSet = unionDataSet;
                    continue;
                }
                detailDataSet = detailDataSet.union(unionDataSet);
            }
            unionEntityKeyList = this.getUnionKey(entityKey, false);
            log.info("###checkImpl unionKeyList is not return:" + unionEntityKeyList);
            for (String unionEntityKey : unionEntityKeyList) {
                entryKey = this.getEntryKey(unionEntityKey);
                selectFields = this.getSelectFields(param, unionEntityKey, entryKey, false);
                customPram = this.wrapParam(unionEntityKey, entryKey, param, false, checkTypeInstockIds, checkTypeReceiptIds);
                log.info("###checkImpl param:" + customPram);
                unionDataSet = ORMUtil.queryDataSet((String)unionEntityKey, (String)selectFields, customPram, null);
                if (null == detailDataSet) {
                    detailDataSet = unionDataSet;
                    continue;
                }
                detailDataSet = detailDataSet.union(unionDataSet);
            }
        }
        catch (Exception e) {
            log.error("checkImpl getUnionData exception:" + e.getMessage());
        }
        return detailDataSet;
    }

    @Override
    public DataSet getUnionData(String entityKey, Map<String, Map<String, Object>> param) {
        Object[] checkTypeInstockIds = this.getLineTypeOrPurTypeIds(ISINSTOCK, this.jointsystemtype);
        Object[] checkTypeReceiptIds = this.getLineTypeOrPurTypeIds(ISNOTINSTOCK, this.jointsystemtype);
        DataSet unionData = this.getUnionData(entityKey, param, checkTypeInstockIds, checkTypeReceiptIds);
        return unionData;
    }

    protected String getEntryKey(String entityKey) {
        return "materialentry";
    }

    public String getOrderBys() {
        StringBuilder sb = new StringBuilder();
        sb.append("billdate").append(" DESC,").append("billno").append(" DESC");
        return sb.toString();
    }

    public String[] getCheckGroups() {
        ArrayList<String> checkGroupsList = new ArrayList<String>();
        checkGroupsList.add("groupkey");
        checkGroupsList.addAll(this.checkFieldGroups);
        if (!CollectionUtils.isEmpty(this.extendFieldGroups)) {
            for (Map.Entry entry : this.extendFieldGroups.entrySet()) {
                String entityKey = (String)entry.getKey();
                Set allowFields = (Set)entry.getValue();
                MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityKey);
                for (String field : allowFields) {
                    String checkFieldGroup = this.checkFieldGroup(field, (DynamicObjectType)objectType);
                    if (!StringUtils.isNotBlank((CharSequence)checkFieldGroup)) continue;
                    checkGroupsList.add(checkFieldGroup);
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.removeFieldGroups)) {
            for (String string : this.removeFieldGroups) {
                if (!checkGroupsList.contains(string)) continue;
                checkGroupsList.remove(string);
            }
        }
        return checkGroupsList.toArray(new String[0]);
    }

    private String checkFieldGroup(String field, DynamicObjectType objectType) {
        BillEntityType billEntityType;
        Map entityTypeMap;
        EntityType entityType;
        String newField = field.trim();
        String[] splitAlias = newField.split(" ");
        String fieldPrefixKey = null;
        String fieldSuffixKey = null;
        String alaisField = null;
        if (splitAlias.length > 1) {
            String fieldStr = splitAlias[0];
            alaisField = splitAlias[1];
            String[] splitField = fieldStr.split("\\.");
            if (splitField.length > 1) {
                fieldPrefixKey = splitField[0];
                fieldSuffixKey = splitField[1];
            } else {
                fieldPrefixKey = splitField[0];
            }
        } else {
            String[] splitField = newField.split("\\.");
            if (splitField.length > 1) {
                fieldPrefixKey = splitField[0];
                fieldSuffixKey = splitField[1];
            } else {
                fieldPrefixKey = splitField[0];
            }
            alaisField = field;
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldPrefixKey) && (StringUtils.isNotEmpty((CharSequence)fieldSuffixKey) ? (entityType = (EntityType)(entityTypeMap = (billEntityType = (BillEntityType)objectType).getAllEntities()).get(fieldPrefixKey)) != null && entityType.getProperty(fieldSuffixKey) != null : objectType.getProperty(fieldPrefixKey) != null)) {
            return alaisField;
        }
        return null;
    }

    private /* synthetic */ void lambda$setExtendFields$1(StringBuilder sb, DynamicObjectType objectType, String t) {
        sb.append(",").append(this.checkField(t, objectType));
    }

    private /* synthetic */ void lambda$setExtendFields$0(Set allowFields, StringBuilder sb, DynamicObjectType objectType, String t) {
        if (allowFields.contains(t)) {
            sb.append(",").append(this.checkField(t, objectType));
        }
    }
}

