/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.check.CheckRelationUtil;

public class OrderCheckUtil {
    private static Log log = LogFactory.getLog(OrderCheckUtil.class);
    private static String[] SELECTS = new String[]{"billid", "billno", "billstatus", "billdate", "supplier", "settleorg", "material", "unit", "goods", "qty", "entrysettleorg", "entryrcvorg", "price", "taxprice", "taxrate", "taxrateid", "tax", "dctrate", "dctamount", "amount", "taxamount", "pobillid", "poentryid", "linetype", "materialnametext", "materialnameold"};
    private static StringBuilder ORDER_SELECTORS = new StringBuilder().append("id billid,billno,billstatus,billdate,supplier.id supplier,settleorg.id settleorg ,materialentry.material.id material,").append(" materialentry.unit.id unit,materialentry.goods.id goods,materialentry.qty qty,materialentry.entrysettleorg.id entrysettleorg,materialentry.entryrcvorg.id entryrcvorg,").append(" materialentry.price price ,materialentry.taxprice taxprice ,materialentry.taxrate taxrate,materialentry.taxrateid.id taxrateid,materialentry.tax tax,materialentry.dctrate dctrate,").append(" materialentry.dctamount dctamount,materialentry.amount amount,materialentry.taxamount taxamount,materialentry.pobillid pobillid,materialentry.poentryid poentryid,materialentry.linetype linetype,").append(" materialentry.material.name materialnameold,materialentry.materialnametext materialnametext ");
    private static String[] PUR_SELECTS = new String[]{"rcvbillid", "rcvbillno", "rcvbilldate", "rcventryid", "rcvqty", "rcvtaxamount", "rcvsrcentryid", "srcbilltype"};
    private static final int SIZE = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateOrderCheckentry(String entityKey, Map<String, Map<String, Object>> param) {
        log.info("###updateOrderCheckEntry \u5f00\u59cb\u6267\u884c entityKey:" + entityKey);
        log.info("###updateOrderCheckEntry loadOrder params:" + param);
        QFilter[] filters = ORMUtil.map2QFilter(param);
        param.clear();
        ArrayList<String> billNoList = new ArrayList<String>();
        try (DataSet dataset = null;){
            dataset = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)entityKey, (String)"id,billno", (QFilter[])filters, (String)"");
            while (dataset.hasNext()) {
                billNoList.add(dataset.next().getString("billno"));
                if (billNoList.size() <= 10000) continue;
                OrderCheckUtil.updateOrderCheckentry(entityKey, param, billNoList);
                billNoList.clear();
            }
            if (billNoList.size() > 0) {
                OrderCheckUtil.updateOrderCheckentry(entityKey, param, billNoList);
                billNoList.clear();
            }
        }
    }

    private static void updateOrderCheckentry(String entityKey, Map<String, Map<String, Object>> param, List<String> billNoList) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityKey, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)entityKey, (String)"entryentity", (boolean)false);
        QFilter filter = new QFilter("billno", "in", billNoList);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{filter});
        log.info("###updateOrderCheckEntry loadOrder billNoList:" + CommonUtil.list2str(billNoList));
        Map<String, Object> data = OrderCheckUtil.getData("pur_order", param, billNoList);
        if (data.isEmpty()) {
            return;
        }
        Object purDetail = data.get("purdetail");
        if (null != purDetail && purDetail instanceof DynamicObjectCollection) {
            DynamicObjectCollection purDetailCols = (DynamicObjectCollection)purDetail;
            OrderCheckUtil.rebuildCheckData(objs, purDetailCols);
            List srcEntryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])purDetailCols.toArray((Object[])new DynamicObject[0])), (String)"rcventryid");
            DynamicObjectCollection salDetailCols = CheckRelationUtil.getOrderCheckRelationData(srcEntryIdList);
            if (null != salDetailCols) {
                OrderCheckUtil.matchSendData(objs, salDetailCols);
            }
            OrderCheckUtil.dealCheckData(objs);
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])objs);
        }
    }

    private static void rebuildCheckData(DynamicObject[] objs, DynamicObjectCollection purDetailCols) {
        GroupDataInfo purDetailGroup = new GroupDataInfo(purDetailCols, "billid");
        Map<String, List<DynamicObject>> billId_colsMap = purDetailGroup.getGroupData();
        DynamicObject checkdata = null;
        for (int i = 0; i < objs.length; ++i) {
            checkdata = objs[i];
            DynamicObjectCollection checkEntrys = checkdata.getDynamicObjectCollection("entryentity");
            List<DynamicObject> cols = billId_colsMap.get(objs[i].getPkValue().toString());
            if (null == cols) continue;
            checkEntrys.clear();
            for (DynamicObject col : cols) {
                BigDecimal qty = col.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject entry = OrderCheckUtil.createCheckEntry(checkEntrys.getDynamicObjectType(), col);
                String poEntryId = col.getString("rcventryid");
                entry.set("sumrcvqty", (Object)purDetailGroup.getQty("rcventryid", poEntryId, "rcvqty"));
                entry.set("sumrcvamt", (Object)purDetailGroup.getTaxAmount("rcventryid", poEntryId, "rcvtaxamount"));
                checkEntrys.add((Object)entry);
            }
            objs[i].set("entryentity", (Object)checkEntrys);
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)objs[i], (String)"entryentity");
        }
    }

    private static DynamicObject createCheckEntry(DynamicObjectType type, DynamicObject col) {
        DynamicObject entry = ORMUtil.newDynamicObject((DynamicObjectType)type);
        entry.set("material", col.get("material"));
        entry.set("unit", col.get("unit"));
        entry.set("goods", col.get("goods"));
        Object entrySettleOrg = col.get("entrysettleorg");
        if (null == entrySettleOrg) {
            entry.set("entrysettleorg", col.get("settleorg"));
        } else {
            entry.set("entrysettleorg", entrySettleOrg);
        }
        Object entryRcvOrg = col.get("entryrcvorg");
        if (null == entryRcvOrg) {
            entry.set("entryrcvorg", col.get("rcvorg"));
        } else {
            entry.set("entryrcvorg", entryRcvOrg);
        }
        if (StringUtils.isEmpty((CharSequence)col.getString("materialnametext"))) {
            entry.set("materialnametext", (Object)col.getString("materialnameold"));
        } else {
            entry.set("materialnametext", (Object)col.getString("materialnametext"));
        }
        entry.set("sumorderqty", col.get("qty"));
        entry.set("sumorderamt", col.get("taxamount"));
        entry.set("price", (Object)col.getBigDecimal("price").setScale(6, RoundingMode.UP));
        entry.set("taxprice", (Object)col.getBigDecimal("taxprice").setScale(6, RoundingMode.UP));
        entry.set("dctrate", col.get("dctrate"));
        entry.set("dctamount", col.get("dctamount"));
        entry.set("taxrate", col.get("taxrate"));
        entry.set("linetype", col.get("linetype"));
        boolean hasTaxRateId = entry.getDataEntityType().getProperties().containsKey((Object)"taxrateid");
        if (hasTaxRateId) {
            entry.set("taxrateid", col.get("taxrateid"));
        }
        entry.set("tax", col.get("tax"));
        entry.set("amount", col.get("amount"));
        entry.set("rcvno", col.get("rcvbillno"));
        entry.set("rcvdate", col.get("rcvbilldate"));
        entry.set("rcvqty", col.get("rcvqty"));
        entry.set("rcvamt", col.get("rcvtaxamount"));
        String pobillid = col.getString("pobillid");
        String poentryid = col.getString("poentryid");
        String srcbillid = col.getString("rcvbillid");
        String srcentryid = col.getString("rcventryid");
        entry.set("pobillid", col.get("pobillid"));
        entry.set("poentryid", col.get("poentryid"));
        if (srcbillid == null || srcentryid == null || srcbillid.trim().equals("0") || srcentryid.trim().equals("0")) {
            entry.set("srcbillid", (Object)pobillid);
            entry.set("srcentryid", (Object)poentryid);
            entry.set("matchkey", (Object)poentryid);
        } else {
            entry.set("srcbillid", (Object)srcbillid);
            entry.set("srcentryid", (Object)srcentryid);
            entry.set("matchkey", (Object)srcentryid);
        }
        entry.set("srcbilltype", col.get("srcbilltype"));
        return entry;
    }

    private static void matchSendData(DynamicObject[] objs, DynamicObjectCollection cols) {
        GroupDataInfo groupData = new GroupDataInfo(cols, "srcentryid");
        for (int i = 0; i < objs.length; ++i) {
            DynamicObjectCollection checkEntrys = objs[i].getDynamicObjectCollection("entryentity");
            for (DynamicObject checkEntry : checkEntrys) {
                String matchkey = checkEntry.getString("matchkey");
                BigDecimal qty = checkEntry.getBigDecimal("rcvqty");
                BigDecimal writeQty = groupData.getQty(matchkey, "qty");
                BigDecimal sumsendqty = groupData.getSendQty(matchkey, "sendqty");
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    writeQty = writeQty.multiply(new BigDecimal("-1"));
                }
                checkEntry.set("sumsendqty", (Object)sumsendqty);
                checkEntry.set("sendqty", (Object)sumsendqty);
                OrderCheckUtil.setTaxAmount(checkEntry, qty, sumsendqty);
                String sendBillNo = groupData.getBillNo(matchkey, "sendbillno");
                if (sendBillNo.length() > 255) {
                    sendBillNo = sendBillNo.substring(0, 100);
                }
                checkEntry.set("sendno", (Object)sendBillNo);
                checkEntry.set("senddate", (Object)groupData.getBillDate(matchkey, "sendbilldate"));
            }
        }
    }

    private static void setTaxAmount(DynamicObject detail, BigDecimal qty, BigDecimal writeQty) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (writeQty.compareTo(qty) == 0) {
            taxAmount = detail.getBigDecimal("rcvamt");
        } else {
            DynamicObject curr;
            int amtPrecision = 6;
            int pricePrecision = 6;
            Object parent = detail.getParent();
            if (null != parent && parent instanceof DynamicObject && null != (curr = ((DynamicObject)parent).getDynamicObject("curr"))) {
                amtPrecision = curr.getInt("amtprecision");
                pricePrecision = curr.getInt("priceprecision");
            }
            BigDecimal taxPrice = detail.getBigDecimal("taxprice");
            taxPrice = taxPrice.setScale(pricePrecision, RoundingMode.HALF_UP);
            BigDecimal dcRate = detail.getBigDecimal("dctrate");
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent((BigDecimal)writeQty, (BigDecimal)taxPrice, (BigDecimal)dcRate, (int)amtPrecision);
        }
        detail.set("sumsendamt", (Object)taxAmount);
        detail.set("sendamt", (Object)taxAmount);
    }

    private static void dealCheckData(DynamicObject[] objs) {
        String unDiffType = ParamUtil.getParam((String)"eae607fb000143ac", (String)"undifftype");
        String billstatus = null;
        String billId = null;
        DynamicObject order = null;
        HashMap<String, ArrayList> sendNoMap = new HashMap<String, ArrayList>(1024);
        for (int i = 0; i < objs.length; ++i) {
            BigDecimal diffHeadAmt;
            order = objs[i];
            billstatus = order.getString("billstatus");
            billId = order.getString("id");
            boolean isAllUnDiff = true;
            BigDecimal sumHeadRcvamt = BigDecimal.ZERO;
            BigDecimal sumHeadSendamt = BigDecimal.ZERO;
            BigDecimal sumHeadRcvamtContainReturn = BigDecimal.ZERO;
            BigDecimal sumHeadSendamtContainReturn = BigDecimal.ZERO;
            BigDecimal sumHeadOrderamt = order.getBigDecimal("sumtaxamount");
            DynamicObjectCollection checkEntrys = order.getDynamicObjectCollection("entryentity");
            HashMap<String, String> exitDataMap = new HashMap<String, String>(1024);
            Map<String, BigDecimal> sumDataMap = GroupDataInfo.sumDataEx(checkEntrys, "poentryid", "sumrcvqty", "sendqty", "sumrcvamt", "sumsendamt");
            for (DynamicObject checkEntry : checkEntrys) {
                String poEntryId = checkEntry.getString("poentryid");
                if ("0".equalsIgnoreCase(poEntryId)) {
                    poEntryId = checkEntry.getString("srcentryid");
                }
                BigDecimal sumRcvqty = sumDataMap.get(poEntryId + "_sumrcvqty");
                BigDecimal sumSendqty = sumDataMap.get(poEntryId + "_sendqty");
                BigDecimal diffSumQty = sumRcvqty.subtract(sumSendqty);
                checkEntry.set("sumdiffqty", (Object)diffSumQty);
                BigDecimal sumRcvamt = sumDataMap.get(poEntryId + "_sumrcvamt");
                BigDecimal sumSendamt = sumDataMap.get(poEntryId + "_sumsendamt");
                BigDecimal sumDiffamt = sumRcvamt.subtract(sumSendamt);
                checkEntry.set("sumdiffamt", (Object)sumDiffamt);
                BigDecimal rcvTaxamount = checkEntry.getBigDecimal("rcvamt");
                BigDecimal sendTaxamount = checkEntry.getBigDecimal("sendamt");
                rcvTaxamount = null == rcvTaxamount ? BigDecimal.ZERO : rcvTaxamount;
                sendTaxamount = null == sendTaxamount ? BigDecimal.ZERO : sendTaxamount;
                BigDecimal diffTaxamount = BigDecimal.ZERO;
                if (rcvTaxamount.compareTo(BigDecimal.ZERO) < 0) {
                    rcvTaxamount = rcvTaxamount.multiply(new BigDecimal("-1"));
                    diffTaxamount = rcvTaxamount.subtract(sendTaxamount);
                    sendTaxamount = sendTaxamount.multiply(new BigDecimal("-1"));
                    rcvTaxamount = rcvTaxamount.multiply(new BigDecimal("-1"));
                } else {
                    diffTaxamount = rcvTaxamount.subtract(sendTaxamount);
                }
                checkEntry.set("diffamt", (Object)diffTaxamount);
                if (rcvTaxamount.compareTo(BigDecimal.ZERO) > 0) {
                    sumHeadRcvamt = sumHeadRcvamt.add(rcvTaxamount);
                }
                if (sendTaxamount.compareTo(BigDecimal.ZERO) > 0) {
                    sumHeadSendamt = sumHeadSendamt.add(sendTaxamount);
                }
                String sendNoStr = checkEntry.getString("sendNo");
                ArrayList sendNoList = (ArrayList)sendNoMap.get(billId);
                sendNoList = null == sendNoList ? new ArrayList(checkEntrys.size()) : sendNoList;
                sendNoList.add(sendNoStr);
                sendNoMap.put(billId, sendNoList);
                if (!exitDataMap.containsKey(poEntryId + "_" + sendNoStr)) {
                    sumHeadSendamtContainReturn = sumHeadSendamtContainReturn.add(sendTaxamount);
                    exitDataMap.put(poEntryId + "_" + sendNoStr, "1");
                }
                sumHeadRcvamtContainReturn = sumHeadRcvamtContainReturn.add(rcvTaxamount);
                BigDecimal sumorderqty = checkEntry.getBigDecimal("sumorderqty");
                BigDecimal rcvqty = checkEntry.getBigDecimal("rcvqty");
                BigDecimal sendqty = checkEntry.getBigDecimal("sendqty");
                BigDecimal bigDecimal = rcvqty = null == rcvqty ? BigDecimal.ZERO : rcvqty;
                if (rcvqty.compareTo(BigDecimal.ZERO) < 0) {
                    rcvqty = rcvqty.multiply(new BigDecimal("-1"));
                }
                BigDecimal diffQty = rcvqty.subtract(sendqty);
                checkEntry.set("diffqty", (Object)diffQty);
                if (rcvqty.compareTo(sendqty) <= 0 && "D".equals(billstatus)) {
                    checkEntry.set("status", (Object)"C");
                } else if (sumorderqty.compareTo(BigDecimal.ZERO) == 0 && rcvqty.compareTo(BigDecimal.ZERO) == 0 && sendqty.compareTo(BigDecimal.ZERO) == 0) {
                    checkEntry.set("status", (Object)"C");
                } else if (rcvqty.compareTo(BigDecimal.ZERO) == 0 || sendqty.compareTo(BigDecimal.ZERO) == 0) {
                    checkEntry.set("status", (Object)"B");
                    isAllUnDiff = false;
                    continue;
                }
                if (!"D".equals(billstatus)) {
                    if (0 == sumorderqty.compareTo(sumRcvqty) && rcvqty.compareTo(sendqty) <= 0) {
                        checkEntry.set("status", (Object)"C");
                    } else {
                        checkEntry.set("status", (Object)"B");
                        isAllUnDiff = false;
                    }
                }
                if (diffSumQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                isAllUnDiff = false;
            }
            if (!isAllUnDiff) {
                diffHeadAmt = sumHeadRcvamtContainReturn.subtract(sumHeadSendamtContainReturn);
                BigDecimal bigDecimal = diffHeadAmt = null == diffHeadAmt ? BigDecimal.ZERO : diffHeadAmt;
                if (diffHeadAmt.compareTo(BigDecimal.ZERO) != 0) {
                    objs[i].set("checkstatus", (Object)"B");
                    if ("D".equals(billstatus)) {
                        if (OrderCheckUtil.exitUncloseSendOrde((ArrayList)sendNoMap.get(objs[i].getString("id")))) {
                            objs[i].set("checkstatus", (Object)"B");
                        } else {
                            objs[i].set("checkstatus", (Object)"C");
                        }
                    }
                }
                if (diffHeadAmt.compareTo(BigDecimal.ZERO) == 0) {
                    objs[i].set("checkstatus", (Object)"C");
                    if (sumHeadOrderamt.compareTo(sumHeadRcvamt) != 0) {
                        objs[i].set("checkstatus", (Object)"B");
                    }
                }
                objs[i].set("sumsettleamount", (Object)sumHeadRcvamtContainReturn);
                objs[i].set("sumsaloutamount", (Object)sumHeadSendamtContainReturn);
                objs[i].set("sumdiffamount", (Object)diffHeadAmt);
                continue;
            }
            objs[i].set("checkstatus", (Object)"C");
            if ("2".equals(unDiffType)) {
                diffHeadAmt = sumHeadRcvamtContainReturn.subtract(sumHeadSendamtContainReturn);
                objs[i].set("sumsettleamount", (Object)sumHeadRcvamtContainReturn);
                objs[i].set("sumsaloutamount", (Object)sumHeadSendamtContainReturn);
                objs[i].set("sumdiffamount", (Object)diffHeadAmt);
                if (!"D".equals(billstatus) || !OrderCheckUtil.exitUncloseSendOrde((ArrayList)sendNoMap.get(objs[i].getString("id")))) continue;
                objs[i].set("checkstatus", (Object)"B");
                continue;
            }
            diffHeadAmt = sumHeadRcvamtContainReturn.subtract(sumHeadSendamtContainReturn);
            objs[i].set("sumsettleamount", (Object)sumHeadRcvamtContainReturn);
            objs[i].set("sumsaloutamount", (Object)sumHeadSendamtContainReturn);
            objs[i].set("sumdiffamount", (Object)diffHeadAmt);
            if (sumHeadRcvamt.compareTo(BigDecimal.ZERO) == 0 && sumHeadSendamt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (!"D".equals(billstatus)) {
                if (sumHeadOrderamt.subtract(sumHeadSendamtContainReturn).compareTo(BigDecimal.ZERO) == 0 && sumHeadOrderamt.subtract(sumHeadRcvamtContainReturn).compareTo(BigDecimal.ZERO) == 0) {
                    if (sumHeadRcvamtContainReturn.compareTo(sumHeadSendamtContainReturn) == 0) {
                        objs[i].set("checkstatus", (Object)"C");
                        continue;
                    }
                    objs[i].set("checkstatus", (Object)"B");
                    continue;
                }
                objs[i].set("checkstatus", (Object)"B");
                continue;
            }
            if (OrderCheckUtil.exitUncloseSendOrde((ArrayList)sendNoMap.get(objs[i].getString("id")))) {
                objs[i].set("checkstatus", (Object)"B");
                continue;
            }
            objs[i].set("checkstatus", (Object)"C");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getData(String entityName, Map<String, Map<String, Object>> param, List<String> billNoList) {
        log.info("###orderCheckUtil start getData");
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        ORM orm = ORM.create();
        DataSet dataSet = null;
        DataSet detailDataSet = null;
        DataSet purDataSet = null;
        DataSet dataSetnew = null;
        JoinDataSet purJoinDataSet = null;
        try {
            QFilter filter = new QFilter("billno", "in", billNoList);
            dataSet = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)entityName, (String)ORDER_SELECTORS.toString(), (QFilter[])new QFilter[]{filter}, (String)"");
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSetnew = dataSet.copy();
                ArrayList<String> srcEntryIdList = new ArrayList<String>(16);
                while (dataSetnew.hasNext()) {
                    String poentryid = dataSetnew.next().getString("poentryid");
                    if (poentryid == null || poentryid.isEmpty() || "0".equalsIgnoreCase(poentryid)) continue;
                    srcEntryIdList.add(poentryid);
                }
                detailDataSet = OrderCheckUtil.getUnionData(srcEntryIdList, "pur_order", param, billNoList);
                purJoinDataSet = dataSet.join(detailDataSet, JoinType.LEFT);
                purJoinDataSet.on("poentryid", "rcvpoentryid");
                purJoinDataSet.select(SELECTS, PUR_SELECTS);
                purDataSet = purJoinDataSet.finish();
                DynamicObjectCollection dynamicObjects = null;
                if (null != purDataSet) {
                    dynamicObjects = orm.toPlainDynamicObjectCollection(purDataSet);
                    objectMap.put("purdetail", dynamicObjects);
                }
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            if (null != dataSetnew) {
                dataSetnew.close();
            }
            if (null != detailDataSet) {
                detailDataSet.close();
            }
        }
        log.info("###orderCheckUtil end getData");
        return objectMap;
    }

    public static DataSet getDataSet(String entityName, Map<String, Map<String, Object>> param, List<String> billNoList) {
        DataSet dataSet = null;
        try {
            String entryKey = OrderCheckUtil.getEntryKey(entityName);
            String selectFields = OrderCheckUtil.getSelectFields(entityName, entryKey, false);
            Map<String, Map<String, Object>> customPram = OrderCheckUtil.wrapParam(entityName, param, billNoList);
            dataSet = ORMUtil.queryDataSet((String)entityName, (String)selectFields, customPram, null);
        }
        catch (Exception e) {
            log.error("getDateSet exception:" + e.getMessage());
        }
        return dataSet;
    }

    public static String getSelectFields(String entityKey, String entryKey, boolean isNegative) {
        StringBuilder selectFieldSb = new StringBuilder();
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityKey, (boolean)true);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)entityKey, (String)entryKey, (boolean)true);
        selectFieldSb.append(selectFields).append(",id billid");
        if (selectFieldSb.length() == 0) {
            log.info("###orderCheck getSelectFields \u4e0d\u652f\u6301\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8fdb\u884c\u5bf9\u8d26\u67e5\u8be2!\u5355\u636e\u6807\u8bc6:" + entityKey);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8fdb\u884c\u5bf9\u8d26\u67e5\u8be2\uff01\u5355\u636e\u6807\u8bc6\uff1a", (String)"OrderCheckUtil_0", (String)"scm-common", (Object[])new Object[0]) + entityKey);
        }
        log.info("###orderCheck getSelectFields entityKey:" + entityKey);
        log.info("###orderCheck getSelectFields:" + selectFieldSb);
        return selectFieldSb.toString();
    }

    protected static Map<String, Map<String, Object>> wrapParam(String entityKey, Map<String, Map<String, Object>> paramMap, List<String> billNoList) {
        HashMap<String, Map<String, Object>> customParam = new HashMap<String, Map<String, Object>>();
        customParam.putAll(paramMap);
        if (null != billNoList && "pur_order".equals(entityKey)) {
            HashMap<String, List<String>> billNoMap = new HashMap<String, List<String>>(1);
            billNoMap.put("in", billNoList);
            customParam.put("billno", billNoMap);
        }
        return customParam;
    }

    protected static Map<String, Map<String, Object>> wrapParam(String entityKey, Map<String, Map<String, Object>> paramMap, boolean isreturn, List<String> billNoList) {
        Map<String, Map<String, Object>> customParam = OrderCheckUtil.wrapParam(entityKey, paramMap, billNoList);
        if ("scp_receipt".equals(entityKey) || "pur_receipt".equals(entityKey)) {
            HashMap<String, String> isReturnMap;
            if (isreturn) {
                isReturnMap = new HashMap<String, String>(1);
                isReturnMap.put("=", "1");
                customParam.put("isreturn", isReturnMap);
            } else {
                isReturnMap = new HashMap(1);
                isReturnMap.put("!=", "1");
                customParam.put("isreturn", isReturnMap);
            }
        }
        HashMap<String, QFilter> srcEntryIdMap = new HashMap<String, QFilter>(1);
        String proKey = OrderCheckUtil.getEntryKey(entityKey) + "." + "srcentryid";
        srcEntryIdMap.put("qfilter", new QFilter(proKey, "is not null", null).and(proKey, "!=", (Object)" "));
        customParam.put("srcentryid", srcEntryIdMap);
        return customParam;
    }

    protected static String getJoinSelectFields(String entityKey, String entryKey, boolean isNagetive) {
        StringBuilder selectFieldSb = new StringBuilder();
        int number = 1;
        if (isNagetive) {
            number = -1;
        }
        if ("pur_saloutstock".equals(entityKey) || "pur_salreturn".equals(entityKey)) {
            selectFieldSb.append("id sendbillid,billno sendbillno,billstatus sendbillstatus,billdate sendbilldate,").append("curr.id sendcurr,org.id sendorg,").append("purorg.id sendpurorg,").append(entryKey).append(".id sendentryid,").append(number).append("*abs(").append(entryKey).append(".qty) sendqty").append(',').append(number).append("*abs(").append(entryKey).append(".taxamount) sendtaxamount").append(',').append(entryKey).append(".pobillid sendpobillid,").append(entryKey).append(".poentryid sendpoentryid,").append(entryKey).append(".srcentryid sendsrcentryid,").append(entryKey).append(".srcbillid sendsrcbillid");
        } else {
            selectFieldSb.append("id rcvbillid,billno rcvbillno,billstatus rcvbillstatus,billdate rcvbilldate,").append("curr.id rcvcurr,org.id rcvorg,").append("purorg.id rcvpurorg,").append(entryKey).append(".id rcventryid,").append(number).append("*abs(").append(entryKey).append(".qty) rcvqty").append(',').append(number).append("*abs(").append(entryKey).append(".taxamount) rcvtaxamount").append(',').append(entryKey).append(".pobillid rcvpobillid,").append(entryKey).append(".poentryid rcvpoentryid,").append(entryKey).append(".srcentryid rcvsrcentryid,").append(entryKey).append(".srcbillid rcvsrcbillid");
        }
        selectFieldSb.append(",'").append(entityKey).append("' as srcbilltype");
        return selectFieldSb.toString();
    }

    public static List<String> getUnionKey(String entityKey, boolean isReturn) {
        ArrayList<String> unitKeyList = new ArrayList<String>();
        if (isReturn) {
            if (entityKey.equals("pur_order")) {
                unitKeyList.add("pur_receipt");
            } else if (entityKey.equals("scp_order")) {
                unitKeyList.add("pur_salreturn");
            }
        } else if (entityKey.equals("scp_order")) {
            unitKeyList.add("pur_saloutstock");
        } else if (entityKey.equals("pur_order")) {
            unitKeyList.add("pur_receipt");
        }
        return unitKeyList;
    }

    public static DataSet getUnionData(DynamicObjectCollection detailCols, String entityKey, Map<String, Map<String, Object>> param, List<String> billNoList) {
        List srcEntryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])detailCols.toArray((Object[])new DynamicObject[0])), (String)"poentryid");
        return OrderCheckUtil.getUnionData(srcEntryIdList, entityKey, param, billNoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSet getUnionData(List<String> srcEntryIdList, String entityKey, Map<String, Map<String, Object>> param, List<String> billNoList) {
        HashMap<String, List<String>> srcEntryIdMap = new HashMap<String, List<String>>(1);
        srcEntryIdMap.put("in", srcEntryIdList);
        DataSet detailDataSet = null;
        Map<String, Map<String, Object>> customPram = null;
        DataSet unionDataSet = null;
        try {
            boolean[] isReturnOrNot = new boolean[]{true, false};
            List<String> writeOffEntityKeyList = Arrays.asList("pur_return", "pur_receipt", "pur_instock", "pur_receipt_return", "scp_instock", "scp_receipt", "scp_return", "scp_return_receipt");
            for (boolean isReturn : isReturnOrNot) {
                log.info("###orderCheck unionKeyList is return:" + isReturn);
                List<String> unionEntityKeyList = OrderCheckUtil.getUnionKey(entityKey, isReturn);
                log.info("###orderCheck unionKeyList:" + unionEntityKeyList);
                for (String unionEntityKey : unionEntityKeyList) {
                    String entryKey = OrderCheckUtil.getEntryKey(unionEntityKey);
                    String selectFields = OrderCheckUtil.getJoinSelectFields(unionEntityKey, entryKey, isReturn);
                    param.putIfAbsent(entryKey + "." + "poentryid", srcEntryIdMap);
                    customPram = OrderCheckUtil.wrapParam(unionEntityKey, param, isReturn, billNoList);
                    if (writeOffEntityKeyList.contains(unionEntityKey)) {
                        HashMap<String, String> isNotWriteOffMap = new HashMap<String, String>(1);
                        isNotWriteOffMap.put("!=", "1");
                        customPram.put("writeoffflag", isNotWriteOffMap);
                    }
                    log.info("###orderCheck param:" + customPram);
                    unionDataSet = ORMUtil.queryDataSet((String)unionEntityKey, (String)selectFields, customPram, null);
                    detailDataSet = null == detailDataSet ? unionDataSet : detailDataSet.union(unionDataSet);
                    param.remove(entryKey + "." + "poentryid");
                }
            }
        }
        catch (Exception exception) {
        }
        return detailDataSet;
    }

    protected static String getEntryKey(String entityKey) {
        String entryKey = "materialentry";
        if ("pur_ordercheck".equals(entityKey)) {
            entryKey = "entryentity";
        }
        return entryKey;
    }

    public static String[] getCheckGroups() {
        return new String[]{"pobillno"};
    }

    public static void fixOrderCheckDataByCheck() {
        String checkSelectFields = "id,billno,materialentry.poentryid,materialentry.pobillid,materialentry.pobillno";
        QFilter checkFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] checkObjs = BusinessDataServiceHelper.load((String)"pur_check", (String)checkSelectFields, (QFilter[])new QFilter[]{checkFilter});
        if (checkObjs.length == 0) {
            return;
        }
        List poBillNoList = DynamicObjectUtil.getProVal2List((DynamicObject[])checkObjs, (String)"materialentry", (String)"pobillno");
        OrderCheckUtil.updateOrderCheckDataByPoBillNo(poBillNoList, "audit");
    }

    public static void updateOrderCheckDataByPoBillNo(List<String> poBillNoList, String operate) {
        QFilter orderCheckFilter = null;
        String checkStatus = "B";
        if ("audit".equals(operate)) {
            orderCheckFilter = new QFilter("checkstatus", "!=", (Object)"D");
            checkStatus = "D";
        } else if ("delete".equals(operate)) {
            orderCheckFilter = new QFilter("checkstatus", "=", (Object)"D");
        } else {
            return;
        }
        orderCheckFilter.and("billno", "in", poBillNoList);
        String orderCheckSelectFields = "id,billno,checkstatus";
        DynamicObject[] orderCheckObjs = BusinessDataServiceHelper.load((String)"pur_ordercheck", (String)orderCheckSelectFields, (QFilter[])new QFilter[]{orderCheckFilter});
        if (orderCheckObjs.length == 0) {
            return;
        }
        for (DynamicObject orderCheckObj : orderCheckObjs) {
            orderCheckObj.set("checkstatus", (Object)checkStatus);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderCheckObjs);
    }

    protected static boolean exitUncloseSendOrde(ArrayList<String> sendNoList) {
        boolean ret = false;
        if (null == sendNoList) {
            return ret;
        }
        QFilter filter = new QFilter("billno", "in", sendNoList).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"));
        ret = QueryServiceHelper.exists((String)"pur_saloutstock", (QFilter[])new QFilter[]{filter});
        return ret;
    }

    public static class GroupDataInfo {
        private Map<String, List<DynamicObject>> groupData = new HashMap<String, List<DynamicObject>>();
        private DynamicObjectCollection cols;
        private String gourpKey;
        private Map<String, BigDecimal> qtyMap;
        private Map<String, BigDecimal> sendQtyMap;
        private Map<String, BigDecimal> taxAmountMap;

        public GroupDataInfo() {
        }

        public GroupDataInfo(DynamicObjectCollection cols, String groupKey) {
            this.gourpKey = groupKey;
            this.cols = cols;
            this.initData();
        }

        public Map<String, List<DynamicObject>> getGroupData() {
            return this.groupData;
        }

        private void initData() {
            if (null == this.cols) {
                return;
            }
            for (DynamicObject col : this.cols) {
                String srcEntryId = col.getString(this.gourpKey);
                if (null == srcEntryId) continue;
                List<DynamicObject> rows = this.groupData.get(srcEntryId);
                if (null == rows) {
                    rows = new ArrayList<DynamicObject>();
                    rows.add(col);
                } else {
                    rows.add(col);
                }
                this.groupData.put(srcEntryId, rows);
            }
        }

        public BigDecimal getQty(String groupKey, String group, String sumPro) {
            BigDecimal qty;
            if (null == this.qtyMap) {
                this.qtyMap = this.sumData(this.cols, groupKey, sumPro);
            }
            if ((qty = this.qtyMap.get(group)) == null) {
                qty = BigDecimal.ZERO;
            }
            return qty;
        }

        public BigDecimal getQty(String group, String sumPro) {
            return this.getQty(this.gourpKey, group, sumPro);
        }

        public BigDecimal getSendQty(String groupKey, String group, String sumPro) {
            BigDecimal qty;
            if (null == this.sendQtyMap) {
                this.sendQtyMap = this.sumData(this.cols, groupKey, sumPro);
            }
            if ((qty = this.sendQtyMap.get(group)) == null) {
                qty = BigDecimal.ZERO;
            }
            return qty;
        }

        public BigDecimal getSendQty(String group, String sumPro) {
            return this.getSendQty(this.gourpKey, group, sumPro);
        }

        public BigDecimal getTaxAmount(String groupKey, String group, String sumPro) {
            BigDecimal taxAmount;
            if (null == this.taxAmountMap) {
                this.taxAmountMap = this.sumData(this.cols, groupKey, sumPro);
            }
            if ((taxAmount = this.taxAmountMap.get(group)) == null) {
                taxAmount = BigDecimal.ZERO;
            }
            return taxAmount;
        }

        public BigDecimal getTaxAmount(String group, String sumPro) {
            return this.getTaxAmount(this.gourpKey, group, sumPro);
        }

        public Map<String, BigDecimal> sumData(DynamicObjectCollection cols, String groupPro, String sumPro) {
            HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>();
            for (DynamicObject col : cols) {
                String groupProVal = col.getString(groupPro);
                Object sumProVal = col.get(sumPro);
                BigDecimal data = (BigDecimal)sumMap.get(groupProVal);
                if (null == data) {
                    data = BigDecimal.ZERO;
                    data = CommonUtil.getBigDecimalPro((Object)sumProVal);
                } else {
                    data = data.add(CommonUtil.getBigDecimalPro((Object)sumProVal));
                }
                sumMap.put(groupProVal, data);
            }
            return sumMap;
        }

        public static Map<String, BigDecimal> sumDataEx(DynamicObjectCollection cols, String groupProName, String ... sumPro) {
            HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>(1024);
            HashMap<String, String> exitDataMap = new HashMap<String, String>(1024);
            for (String pro : sumPro) {
                for (DynamicObject col : cols) {
                    String groupProVal = col.getString(groupProName);
                    if ("0".equalsIgnoreCase(groupProVal)) {
                        groupProVal = col.getString("srcentryid");
                    }
                    Object sumProVal = col.get(pro);
                    BigDecimal data = (BigDecimal)sumMap.get(groupProVal + "_" + pro);
                    String sendNoStr = col.getString("sendno");
                    if ("sendqty".equals(pro) || "sumsendamt".equals(pro)) {
                        if (exitDataMap.containsKey(pro + "_" + groupProVal + "_" + sendNoStr)) continue;
                        exitDataMap.put(pro + "_" + groupProVal + "_" + sendNoStr, "1");
                    }
                    if (null == data) {
                        data = BigDecimal.ZERO;
                        data = CommonUtil.getBigDecimalPro((Object)sumProVal);
                    } else {
                        data = data.add(CommonUtil.getBigDecimalPro((Object)sumProVal));
                    }
                    sumMap.put(groupProVal + "_" + pro, data);
                }
            }
            return sumMap;
        }

        public String getBillNo(String group, String billNoPro) {
            List<DynamicObject> cols = this.groupData.get(group);
            if (null == cols) {
                return "";
            }
            HashSet<Object> billnoSet = new HashSet<Object>(cols.size());
            StringBuilder billNoSb = new StringBuilder();
            for (DynamicObject col : cols) {
                if (billnoSet.contains(col.get(billNoPro))) continue;
                if (billNoSb.length() > 0) {
                    billNoSb.append(',').append(col.get(billNoPro));
                } else {
                    billNoSb.append(col.get(billNoPro));
                }
                billnoSet.add(col.get(billNoPro));
            }
            return billNoSb.toString();
        }

        public String getBillNoAndQty(String group, String billNoPro, String srcQtyPro) {
            List<DynamicObject> cols = this.groupData.get(group);
            if (null == cols) {
                return "";
            }
            StringBuilder billNoSb = new StringBuilder();
            for (DynamicObject col : cols) {
                BigDecimal qty;
                BigDecimal srcQty = col.getBigDecimal(srcQtyPro);
                if (null == srcQty) {
                    srcQty = BigDecimal.ZERO;
                }
                if (null == (qty = col.getBigDecimal("qty"))) {
                    qty = BigDecimal.ZERO;
                }
                if (billNoSb.length() > 0) {
                    billNoSb.append(',').append(qty.stripTrailingZeros().toPlainString()).append('/').append(srcQty.stripTrailingZeros().toPlainString()).append(' ').append(col.get(billNoPro));
                    continue;
                }
                billNoSb.append(qty.stripTrailingZeros().toPlainString()).append('/').append(srcQty.stripTrailingZeros().toPlainString()).append(' ').append(col.get(billNoPro));
            }
            return billNoSb.toString();
        }

        public Date getBillDate(String group, String datePro) {
            List<DynamicObject> cols = this.groupData.get(group);
            if (null == cols) {
                return null;
            }
            Date date = null;
            for (DynamicObject col : cols) {
                date = col.getDate(datePro);
                if (null == date) continue;
                return date;
            }
            return date;
        }
    }
}

