/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.check.OrderCheckUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;

public class ThirdOrderCheckUtil {
    private static final Log log = LogFactory.getLog(OrderCheckUtil.class);
    private static final String[] SELECTS = new String[]{"billno", "billdate", "supplier", "entrysettleorg", "org", "material", "unit", "goods", "srcentryid", "reqperson", "person", "businesstype", "pobillno", "rcvpersonid", "goodsname", "linetype", "entryreqorg", "entryrcvorg", "purtype", "taxamount", "taxprice", "pobillid", "poentryid", "childorderid", "thirdorderid", "curr", "invoicestate", "desttype"};
    private static final String[] PUR_SELECTS = new String[]{"rcvbillno", "rcvbilldate", "rcvqty", "rcvtaxamount", "rcvpoentryid"};
    private static final String CHECKTYPE_RECEIVE = "1";
    private static final String CHECKTYPE_INWARE = "2";

    public static List<String> getProVal2List(DynamicObjectCollection dyoCol, String proName) {
        ArrayList ProValList = new ArrayList();
        for (DynamicObject dynamicObject : dyoCol) {
            ProValList.add(String.valueOf(dynamicObject.get(proName)));
        }
        return ProValList.isEmpty() ? Collections.emptyList() : ProValList;
    }

    public static void createThirdCheckOrder(String paybillno, boolean recheck) throws Exception {
        QFilter dfilter = new QFilter("paymentbillno", "=", (Object)paybillno);
        QFilter stateFilter = new QFilter("thirdorder.invoicestate", "=", (Object)PurEcInvoiceEnum.PREREQUEST.getVal());
        QFilter nullilter = new QFilter("thirdorder", "=", (Object)0);
        stateFilter.or(nullilter);
        DeleteServiceHelper.delete((String)"pur_thirdcheckorder", (QFilter[])new QFilter[]{dfilter, stateFilter});
        log.info("###updateThirdOrderCheckEntry \u5f00\u59cb\u6267\u884c entityKey:pur_thirddata");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pur_thirddata", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"pur_thirddata", (String)"entryentity", (boolean)false);
        selectFields = selectFields + ",id,entryentity.id";
        log.info("###updateThirdOrderCheckEntry loadOrder paybillno:" + paybillno);
        DynamicObjectCollection orderCol = QueryServiceHelper.query((String)"pur_thirdcheckorder", (String)"id,childbillno", (QFilter[])new QFilter[]{dfilter});
        List<String> oldchildBillNoList = ThirdOrderCheckUtil.getProVal2List(orderCol, "childbillno");
        QFilter filter = new QFilter("number", "=", (Object)paybillno);
        QFilter oldfilter = new QFilter("entryentity.childorder", "not in", oldchildBillNoList);
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pur_thirddata", (String)selectFields, (QFilter[])new QFilter[]{filter, oldfilter});
        if (dyoCol.isEmpty()) {
            return;
        }
        String source = ((DynamicObject)dyoCol.get(0)).getString("source");
        List<String> childBillNoList = ThirdOrderCheckUtil.getProVal2List(dyoCol, "entryentity.childorder");
        DynamicObjectCollection purDetailCols = ThirdOrderCheckUtil.getData(childBillNoList, source);
        DynamicObjectCollection col = ThirdOrderCheckUtil.rebuildCheckData(dyoCol, purDetailCols);
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])col.toArray((Object[])new DynamicObject[0])));
        if (!dyoCol.isEmpty()) {
            DynamicObject thirdOrderDyn = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)dyoCol.get(0)).getString("id"), (String)"pur_thirddata");
            DynamicObjectCollection thirdOrderEntryCol = thirdOrderDyn.getDynamicObjectCollection("entryentity");
            thirdOrderEntryCol.forEach(thirdOrderEntry -> dyoCol.forEach(dyo -> {
                if (dyo.getString("entryentity.id").equals(thirdOrderEntry.getString("id"))) {
                    thirdOrderEntry.set("checkstatus", (Object)CHECKTYPE_RECEIVE);
                }
            }));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{thirdOrderDyn});
        }
        log.info("###orderCheck \u5bf9\u8d26\u6570\u636e\u51c6\u5907\u5b8c\u6210");
    }

    private static DynamicObjectCollection rebuildCheckData(DynamicObjectCollection dyoCol, DynamicObjectCollection purDetailCols) {
        OrderCheckUtil.GroupDataInfo purDetailGroup = null;
        Map<Object, Object> childId_colsMap = new HashMap();
        if (purDetailCols != null && purDetailCols.size() > 0) {
            purDetailGroup = new OrderCheckUtil.GroupDataInfo(purDetailCols, "childorderid");
            childId_colsMap = purDetailGroup.getGroupData();
        }
        DynamicObject checkDyo = null;
        DynamicObjectCollection checkCol = new DynamicObjectCollection();
        DynamicObjectCollection checkEntrys = null;
        DynamicObject purdetail = null;
        BigDecimal sumtaxamount = BigDecimal.ZERO;
        BigDecimal sumsettleamount = BigDecimal.ZERO;
        BigDecimal sumsaloutamount = BigDecimal.ZERO;
        BigDecimal sumdiffamount = BigDecimal.ZERO;
        BigDecimal returnamount = BigDecimal.ZERO;
        String childid = null;
        List cols = null;
        for (int i = 0; i < dyoCol.size(); ++i) {
            childid = ((DynamicObject)dyoCol.get(i)).getString("entryentity.childorder");
            cols = (List)childId_colsMap.get(childid);
            checkDyo = ORMUtil.newDynamicObject((String)"pur_thirdcheckorder");
            checkDyo.set("paymentbillno", ((DynamicObject)dyoCol.get(i)).get("number"));
            sumtaxamount = new BigDecimal(((DynamicObject)dyoCol.get(i)).get("entryentity.orderamount").toString());
            if (purDetailGroup != null) {
                sumsettleamount = purDetailGroup.getTaxAmount("childorderid", childid, "rcvtaxamount");
                checkDyo.set("purbillno", (Object)purDetailGroup.getBillNo(childid, "billno"));
            }
            sumsaloutamount = new BigDecimal(((DynamicObject)dyoCol.get(i)).get("entryentity.unpayamount").toString());
            returnamount = new BigDecimal(((DynamicObject)dyoCol.get(i)).get("entryentity.returnamount").toString());
            sumsaloutamount = sumsaloutamount.subtract(returnamount);
            sumdiffamount = sumsaloutamount.subtract(sumsettleamount);
            checkDyo.set("sumtaxamount", (Object)sumtaxamount);
            checkDyo.set("sumsettleamount", (Object)sumsettleamount);
            checkDyo.set("sumsaloutamount", (Object)sumsaloutamount);
            checkDyo.set("sumdiffamount", (Object)sumdiffamount);
            if (sumdiffamount.compareTo(BigDecimal.ZERO) == 0) {
                checkDyo.set("checkstatus", (Object)"B");
            } else {
                checkDyo.set("checkstatus", (Object)"A");
            }
            checkEntrys = checkDyo.getDynamicObjectCollection("entryentity");
            checkEntrys.clear();
            if (cols != null && cols.size() > 0) {
                for (DynamicObject col : cols) {
                    DynamicObject entry = ThirdOrderCheckUtil.createCheckEntry(checkEntrys.getDynamicObjectType(), col);
                    checkEntrys.add((Object)entry);
                }
                purdetail = (DynamicObject)cols.get(0);
                checkDyo.set("supplier", purdetail.get("supplier"));
                checkDyo.set("purorg", purdetail.get("org"));
                checkDyo.set("curr", purdetail.get("curr"));
                checkDyo.set("invoicestate", purdetail.get("invoicestate"));
                checkDyo.set("thirdorder", purdetail.get("thirdorderid"));
                checkDyo.set("org", (Object)purdetail.getString("entrysettleorg"));
                checkDyo.set("reqperson", purdetail.get("reqperson"));
                checkDyo.set("person", purdetail.get("person"));
                checkDyo.set("businesstype", purdetail.get("businesstype"));
                checkDyo.set("deporg", purdetail.get("entryreqorg"));
                checkDyo.set("rcvorg", purdetail.get("entryrcvorg"));
                checkDyo.set("malbillno", purdetail.get("pobillno"));
                checkDyo.set("receipt", purdetail.get("rcvpersonid"));
            }
            checkDyo.set("billdate", (Object)((DynamicObject)dyoCol.get(i)).getDate("entryentity.billdate"));
            checkDyo.set("billno", (Object)((DynamicObject)dyoCol.get(i)).getString("entryentity.parentorder"));
            checkDyo.set("childbillno", (Object)childid);
            checkDyo.set("entryentity", (Object)checkEntrys);
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)checkDyo, (String)"entryentity");
            checkCol.add((Object)checkDyo);
        }
        return checkCol;
    }

    private static DynamicObject createCheckEntry(DynamicObjectType type, DynamicObject col) {
        DynamicObject entry = ORMUtil.newDynamicObject((DynamicObjectType)type);
        entry.set("material", col.get("material"));
        entry.set("unit", col.get("unit"));
        entry.set("rcvno", col.get("rcvbillno"));
        entry.set("rcvdate", col.get("rcvbilldate"));
        entry.set("rcvqty", col.get("rcvqty"));
        entry.set("rcvamount", col.get("rcvtaxamount"));
        entry.set("taxprice", col.get("taxprice"));
        entry.set("goods", col.get("goods"));
        entry.set("linetype", col.get("linetype"));
        entry.set("purtype", col.get("purtype"));
        return entry;
    }

    public static DataSet getOrderDataSet(List<Long> malorderEntryIdList) {
        HashSet malorderEntryIdSet = new HashSet(malorderEntryIdList.size() * 2);
        malorderEntryIdList.forEach(id -> malorderEntryIdSet.add(String.valueOf(id)));
        QFilter childfilter = new QFilter("materialentry.srcentryid", "in", malorderEntryIdSet);
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(" reqperson,person,businesstype,");
        selectFields.append(" billno,billdate,supplier,org,settleorg,jdorderid,materialentry.id,materialentry.poentryid poentryid,srctype,");
        selectFields.append(" materialentry.material material,materialentry.unit unit,materialentry.qty qty,materialentry.taxamount taxamount,materialentry.taxprice taxprice,");
        selectFields.append(" materialentry.entrysettleorg entrysettleorg,materialentry.goods goods,materialentry.pobillid pobillid,materialentry.srcentryid srcentryid,");
        selectFields.append(" materialentry.goods.name goodsname,materialentry.linetype linetype,materialentry.linetype.storage storage,materialentry.entryreqorg entryreqorg,materialentry.entryrcvorg entryrcvorg,");
        selectFields.append(" materialentry.pobillno pobillno,materialentry.rcvpersonid rcvpersonid,");
        selectFields.append("materialentry.jdorder.id thirdorderid,materialentry.jdorder.number childorderid,materialentry.jdorder.invoicestate invoicestate,curr,");
        selectFields.append("materialentry.purtype purtype,materialentry.purtype.desttype desttype,materialentry.purtype.checktype checktype ");
        String orderBys = " materialentry.jdorder.number,billdate";
        return QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)"pur_order", (String)selectFields.toString(), (QFilter[])new QFilter[]{childfilter}, (String)orderBys);
    }

    public static Map<String, DynamicObjectCollection> spiltByCheckType(DynamicObjectCollection purOrders) {
        HashMap<String, DynamicObjectCollection> res = new HashMap<String, DynamicObjectCollection>(16);
        DynamicObjectCollection receivecol = new DynamicObjectCollection();
        DynamicObjectCollection instockcol = new DynamicObjectCollection();
        String connectErp = ApiConfigUtil.getConnectErp();
        if (connectErp.equals("0")) {
            for (DynamicObject purOrder : purOrders) {
                boolean storage = purOrder.getBoolean("storage");
                if (storage) {
                    instockcol.add((Object)purOrder);
                    continue;
                }
                receivecol.add((Object)purOrder);
            }
        } else {
            for (DynamicObject purOrder : purOrders) {
                String checktype = purOrder.getString("checktype");
                if (!Objects.nonNull(checktype)) continue;
                if (checktype.equals(CHECKTYPE_RECEIVE)) {
                    receivecol.add((Object)purOrder);
                    continue;
                }
                instockcol.add((Object)purOrder);
            }
        }
        res.put(CHECKTYPE_RECEIVE, receivecol);
        res.put(CHECKTYPE_INWARE, instockcol);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getData(List<String> childBillNoList, String source) throws Exception {
        log.info("OrderCheckUtil start getData");
        DataSet dataSet = null;
        DynamicObjectCollection dynamicObjects = null;
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        ORM orm = ORM.create();
        DataSet detailDataSet = null;
        DataSet purDataSet = null;
        JoinDataSet purJoinDataSet = null;
        try {
            List<Long> malorderEntryIdList = ThirdOrderCheckUtil.queryMalorderEntryIdList(childBillNoList, source);
            dataSet = ThirdOrderCheckUtil.getOrderDataSet(malorderEntryIdList);
            if (dataSet == null) {
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
                return dynamicObjectCollection;
            }
            detailDataSet = dataSet.copy();
            DynamicObjectCollection detailCols = orm.toPlainDynamicObjectCollection(detailDataSet);
            if (detailCols.size() > 0) {
                DataSet instockDataSet = null;
                DataSet receiveDataSet = null;
                DataSet unionDataSet = null;
                Map<String, DynamicObjectCollection> detailColsMap = ThirdOrderCheckUtil.spiltByCheckType(detailCols);
                DynamicObjectCollection receivecol = detailColsMap.get(CHECKTYPE_RECEIVE);
                DynamicObjectCollection inwarecol = detailColsMap.get(CHECKTYPE_INWARE);
                if (receivecol.size() > 0 && (receiveDataSet = ThirdOrderCheckUtil.getUnionData(receivecol, "pur_order", params)) != null) {
                    unionDataSet = receiveDataSet.copy();
                }
                if (inwarecol.size() > 0 && (instockDataSet = ThirdOrderCheckUtil.getUnionInstockData(inwarecol)) != null) {
                    unionDataSet = instockDataSet.copy();
                }
                if (instockDataSet != null && receiveDataSet != null) {
                    unionDataSet = receiveDataSet.union(instockDataSet);
                }
                purJoinDataSet = dataSet.join(unionDataSet, JoinType.LEFT);
                purJoinDataSet.on("poentryid", "rcvpoentryid");
                purJoinDataSet.select(SELECTS, PUR_SELECTS);
                purDataSet = purJoinDataSet.finish();
            }
            if (null != purDataSet) {
                dynamicObjects = orm.toPlainDynamicObjectCollection(purDataSet);
                if (MalOrderParamUtil.getDefaultMalVersion()) {
                    ThirdOrderCheckUtil.completePurOrderDetailCol(dynamicObjects);
                }
                ThirdOrderCheckUtil.getPurOrderDetailCol(dynamicObjects);
            }
        }
        finally {
            if (null != dataSet) {
                dataSet.close();
            }
            if (null != detailDataSet) {
                detailDataSet.close();
            }
        }
        log.info("OrderCheckUtil end getData");
        return dynamicObjects;
    }

    public static List<Long> queryMalorderEntryIdList(List<String> childBillNoList, String source) {
        ArrayList<Long> result = new ArrayList<Long>();
        ArrayList ecOrderPks = new ArrayList();
        if (childBillNoList.isEmpty()) {
            return result;
        }
        if (!MalOrderParamUtil.getDefaultMalVersion() && EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source)) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ThirdOrderCheckUtil", (String)"mal_order", (String)"entryentity.id", (QFilter[])new QFilter[]{new QFilter("entryentity.jdorder.number", "in", childBillNoList)}, null);){
                ds.forEach(row -> result.add(row.getLong("entryentity.id")));
            }
            return result;
        }
        String ecsource = ThirdOrderCheckUtil.getEcSource(source);
        if (StringUtils.isEmpty((CharSequence)ecsource)) {
            return result;
        }
        try (DataSet ecDs = QueryServiceHelper.queryDataSet((String)"ThirdOrderCheckUtil", (String)ecsource, (String)"id", (QFilter[])new QFilter[]{new QFilter("pbd_jdorder".endsWith(ecsource) ? "number" : "orderid", "in", childBillNoList)}, null);){
            ecDs.forEach(row -> ecOrderPks.add(row.getLong("id")));
        }
        if (!ecOrderPks.isEmpty()) {
            QFilter ecOrderPkfilter = new QFilter("entryentity.order", "in", ecOrderPks);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ThirdOrderCheckUtil", (String)"mal_order", (String)"entryentity.id", (QFilter[])new QFilter[]{ecOrderPkfilter}, null);){
                ds.forEach(row -> result.add(row.getLong("entryentity.id")));
            }
        }
        return result;
    }

    public static String getEcSource(String source) {
        return MalNewOrderUtils.getPlatformId((String)source);
    }

    public static void completePurOrderDetailCol(DynamicObjectCollection detailCols) {
        List<String> srcentryidList = ThirdOrderCheckUtil.getProVal2List(detailCols, "srcentryid");
        ArrayList malOrderEntryidList = new ArrayList();
        srcentryidList.forEach(id -> malOrderEntryidList.add(Long.valueOf(id)));
        String selectField = "id,platform,ecsource,entryentity.order,entryentity.id";
        DynamicObjectCollection malorderCol = QueryServiceHelper.query((String)"mal_order", (String)selectField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malOrderEntryidList)});
        ArrayList ecOrderIDs = new ArrayList();
        malorderCol.forEach(malorderDyn -> ecOrderIDs.add(malorderDyn.getLong("entryentity.order")));
        String ecsource = ((DynamicObject)malorderCol.get(0)).getString("ecsource");
        String ecSelectFields = "pbd_jdorder".equals(ecsource) ? "id,jdorderid porderid,number orderid,invoicestate" : "id,porderid,orderid,invoicestate";
        DynamicObjectCollection ecorderDyns = QueryServiceHelper.query((String)ecsource, (String)ecSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", ecOrderIDs)});
        HashMap malorderIdEcorderDynMap = new HashMap();
        malorderCol.forEach(malorder -> ecorderDyns.forEach(ecorder -> {
            if (StringUtils.equals((CharSequence)malorder.getString("entryentity.order"), (CharSequence)ecorder.getString("id"))) {
                malorderIdEcorderDynMap.put(malorder.getString("entryentity.id"), ecorder);
            }
        }));
        detailCols.forEach(purorderEntry -> {
            DynamicObject ecorderDyn = (DynamicObject)malorderIdEcorderDynMap.get(purorderEntry.getString("srcentryid"));
            if (ecorderDyn != null) {
                purorderEntry.set("thirdorderid", (Object)ecorderDyn.getString("id"));
                purorderEntry.set("childorderid", (Object)ecorderDyn.getString("orderid"));
                purorderEntry.set("invoicestate", (Object)ecorderDyn.getString("invoicestate"));
            }
        });
    }

    public static void getPurOrderDetailCol(DynamicObjectCollection detailCols) {
        List<String> srcentryidList = ThirdOrderCheckUtil.getProVal2List(detailCols, "srcentryid");
        ArrayList malOrderEntryidList = new ArrayList();
        srcentryidList.forEach(id -> malOrderEntryidList.add(Long.valueOf(id)));
        String selectField = "id,entryentity.id,person,receipt,billno";
        DynamicObjectCollection malorderCol = QueryServiceHelper.query((String)"mal_order", (String)selectField, (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", malOrderEntryidList)});
        detailCols.forEach(purorderEntry -> malorderCol.forEach(malorderDyn -> {
            if (StringUtils.equals((CharSequence)purorderEntry.getString("srcentryid"), (CharSequence)malorderDyn.getString("entryentity.id"))) {
                purorderEntry.set("person", (Object)malorderDyn.getString("person"));
                purorderEntry.set("rcvpersonid", (Object)malorderDyn.getString("receipt"));
                purorderEntry.set("pobillno", (Object)malorderDyn.getString("billno"));
            }
        }));
    }

    public static void updateInvoiceState(List<String> ecChildOrderIds, String source) {
        QFilter childOrderFilter;
        if (ecChildOrderIds == null || ecChildOrderIds.isEmpty() || StringUtils.isEmpty((CharSequence)source)) {
            return;
        }
        HashMap<String, String> ecChildOrderInvstateMap = new HashMap<String, String>();
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            childOrderFilter = new QFilter("number", "in", ecChildOrderIds);
            DynamicObjectCollection ecorderDyns = QueryServiceHelper.query((String)"pbd_jdorder", (String)"id,number,invoicestate", (QFilter[])new QFilter[]{childOrderFilter});
            for (DynamicObject ecorderDyn : ecorderDyns) {
                ecChildOrderInvstateMap.put(ecorderDyn.getString("number"), ecorderDyn.getString("invoicestate"));
            }
        } else {
            String ecsource = ThirdOrderCheckUtil.getEcSource(source);
            if (StringUtils.isNotEmpty((CharSequence)ecsource)) {
                QFilter childOrderFilter2 = new QFilter("orderid", "in", ecChildOrderIds);
                DynamicObjectCollection ecorderDyns = QueryServiceHelper.query((String)ecsource, (String)"id,porderid,orderid,invoicestate", (QFilter[])new QFilter[]{childOrderFilter2});
                for (DynamicObject ecorderDyn : ecorderDyns) {
                    ecChildOrderInvstateMap.put(ecorderDyn.getString("orderid"), ecorderDyn.getString("invoicestate"));
                }
            }
        }
        if (!ecChildOrderInvstateMap.isEmpty()) {
            DynamicObject[] thirdCheckOrderDyns;
            childOrderFilter = new QFilter("childbillno", "in", ecChildOrderInvstateMap.keySet());
            for (DynamicObject thirdCheckOrderDyn : thirdCheckOrderDyns = BusinessDataServiceHelper.load((String)"pur_thirdcheckorder", (String)"childbillno,invoicestate", (QFilter[])new QFilter[]{childOrderFilter})) {
                String invoicestate = (String)ecChildOrderInvstateMap.get(thirdCheckOrderDyn.getString("childbillno"));
                if (!StringUtils.isNotEmpty((CharSequence)invoicestate)) continue;
                thirdCheckOrderDyn.set("invoicestate", (Object)invoicestate);
            }
            SaveServiceHelper.save((DynamicObject[])thirdCheckOrderDyns);
        }
    }

    public static DataSet getUnionData(DynamicObjectCollection detailCols, String entityKey, Map<String, Map<String, Object>> param) {
        List srcEntryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])detailCols.toArray((Object[])new DynamicObject[0])), (String)"poentryid");
        DataSet detailDataSet = null;
        try {
            String entryKey = "materialentry";
            String selectFields = ThirdOrderCheckUtil.getJoinSelectFields("pur_receipt", entryKey, false);
            String proKey = "materialentry.poentryid";
            QFilter filter = new QFilter(proKey, "is not null", null).and(proKey, "!=", (Object)" ").and(proKey, "in", (Object)srcEntryIdList);
            detailDataSet = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)"pur_receipt", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        }
        catch (Exception e) {
            log.error("getUnionData exception:" + e.getMessage());
        }
        return detailDataSet;
    }

    public static DataSet getUnionInstockData(DynamicObjectCollection detailCols) {
        List srcEntryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])detailCols.toArray((Object[])new DynamicObject[0])), (String)"poentryid");
        DataSet detailDataSet = null;
        DataSet instockDataSet = null;
        try {
            String entryKey = "materialentry";
            String selectFields = ThirdOrderCheckUtil.getInStockSelectFields(entryKey);
            String proKey = "materialentry.poentryid";
            QFilter filter = new QFilter(proKey, "is not null", null).and(proKey, "!=", (Object)" ").and(proKey, "in", (Object)srcEntryIdList);
            detailDataSet = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)"pur_instock", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
            String selectReturnFields = ThirdOrderCheckUtil.getReturnSelectFields(entryKey);
            instockDataSet = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)"pur_return", (String)selectReturnFields, (QFilter[])new QFilter[]{filter}, null);
            detailDataSet = detailDataSet.union(instockDataSet);
        }
        catch (Exception e) {
            log.error("getUnionData exception:" + e.getMessage());
        }
        return detailDataSet;
    }

    protected static String getJoinSelectFields(String entityKey, String entryKey, boolean isNagetive) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append("id rcvbillid,billno rcvbillno,billdate rcvbilldate,").append(entryKey).append(".id rcventryid,").append(" (case when isReturn = '1'  ").append(" then  -1 * (").append(entryKey).append(".qty)").append(" else  ").append(entryKey).append(".qty").append(" end ) rcvqty,").append(" (case when isReturn = '1'  ").append(" then  -1 * (").append(entryKey).append(".taxamount)").append(" else  ").append(entryKey).append(".taxamount").append(" end ) rcvtaxamount,").append(entryKey).append(".pobillid rcvpobillid,").append(entryKey).append(".poentryid rcvpoentryid,").append(entryKey).append(".srcentryid rcvsrcentryid,").append(entryKey).append(".srcbillid rcvsrcbillid");
        return selectFieldSb.toString();
    }

    protected static String getInStockSelectFields(String entryKey) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append("id rcvbillid,billno rcvbillno,billdate rcvbilldate,").append(entryKey).append(".id rcventryid,").append(" abs(").append(entryKey).append(".qty) rcvqty,").append(" abs(").append(entryKey).append(".taxamount) rcvtaxamount,").append(entryKey).append(".pobillid rcvpobillid,").append(entryKey).append(".poentryid rcvpoentryid,").append(entryKey).append(".srcentryid rcvsrcentryid,").append(entryKey).append(".srcbillid rcvsrcbillid");
        return selectFieldSb.toString();
    }

    protected static String getReturnSelectFields(String entryKey) {
        StringBuilder selectFieldSb = new StringBuilder();
        selectFieldSb.append("id rcvbillid,billno rcvbillno,billdate rcvbilldate,").append(entryKey).append(".id rcventryid,").append(" -1 * abs(").append(entryKey).append(".qty) rcvqty,").append(" -1 * abs(").append(entryKey).append(".taxamount) rcvtaxamount,").append(entryKey).append(".pobillid rcvpobillid,").append(entryKey).append(".poentryid rcvpoentryid,").append(entryKey).append(".srcentryid rcvsrcentryid,").append(entryKey).append(".srcbillid rcvsrcbillid");
        return selectFieldSb.toString();
    }
}

