/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.enums.DiscountTypeEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CurrencyUtils;
import kd.scm.common.util.cal.CalculateUtils;

public final class PurInvoiceDeductionCalHelper {
    public static void calDeduction(IDataModel model, Set<String> deductBills) {
        DynamicObject invoiceObj = model.getDataEntity(true);
        DynamicObjectCollection entrydys = invoiceObj.getDynamicObjectCollection("entryentity1");
        ArrayList<DynamicObject> deductEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> inOrRecAllEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> inOrRecDeductEntrys = new ArrayList<DynamicObject>(8);
        PurInvoiceDeductionCalHelper.separateEntriesByType(entrydys, deductBills, deductEntrys, inOrRecAllEntrys, inOrRecDeductEntrys);
        BigDecimal inOrRecActTotalAmount = inOrRecAllEntrys.stream().map(e -> e.getBigDecimal("actchecktaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal deductActTotalAmount = deductEntrys.stream().map(e -> e.getBigDecimal("actchecktaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.setValue("insumtaxamount", (Object)inOrRecActTotalAmount);
        model.setValue("deductsumtaxamount", (Object)deductActTotalAmount);
        Map<String, BigDecimal> calDeductionTaxAmount = PurInvoiceDeductionCalHelper.calDeductionTaxAmount(invoiceObj, deductEntrys, inOrRecDeductEntrys);
        String taxType = invoiceObj.getString("taxtype");
        Map<String, Map<String, Object>> calAfterDeductionTaxAmount = PurInvoiceDeductionCalHelper.calAfterDeductionTaxAmount(invoiceObj, inOrRecDeductEntrys, calDeductionTaxAmount, taxType);
        int amtPrecision = CurrencyUtils.getAmtPrecision((DynamicObject)invoiceObj);
        for (int index = 0; index < entrydys.size(); ++index) {
            DynamicObject entrydy = (DynamicObject)entrydys.get(index);
            String srcentryid = entrydy.getString("srcentryid1");
            BigDecimal deductionAmount = calDeductionTaxAmount.getOrDefault(srcentryid, BigDecimal.ZERO);
            Map<String, Object> afterDeductionParam = calAfterDeductionTaxAmount.get(srcentryid);
            if (deductionAmount.signum() != 0 && !CollectionUtils.isEmpty(afterDeductionParam)) {
                Object afterdeductdiscounttype = afterDeductionParam.getOrDefault("afterdeductdiscounttype", DiscountTypeEnum.NULL.getVal());
                model.setValue("afterdeductdiscounttype", afterdeductdiscounttype, index);
                Object afterdeductdctrate = afterDeductionParam.getOrDefault("afterdeductdctrate", BigDecimal.ZERO);
                model.setValue("afterdeductdctrate", afterdeductdctrate, index);
                Object afterdeductdctamount = afterDeductionParam.getOrDefault("afterdeductdctamount", BigDecimal.ZERO);
                model.setValue("afterdeductdctamount", afterdeductdctamount, index);
                Object afterdeducttax = afterDeductionParam.getOrDefault("afterdeducttax", BigDecimal.ZERO);
                model.setValue("afterdeducttax", afterdeducttax, index);
                Object afterdeductamount = afterDeductionParam.getOrDefault("afterdeductamount", BigDecimal.ZERO);
                model.setValue("afterdeductamount", afterdeductamount, index);
                Object afterdeducttaxamount = afterDeductionParam.getOrDefault("afterdeducttaxamount", BigDecimal.ZERO);
                model.setValue("afterdeducttaxamount", afterdeducttaxamount, index);
            }
            model.setValue("deductamount", (Object)deductionAmount, index);
        }
    }

    public static void calDeduction(DynamicObject invoiceObj, Set<String> deductBills) {
        DynamicObjectCollection entrydys = invoiceObj.getDynamicObjectCollection("entryentity1");
        ArrayList<DynamicObject> deductEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> inOrRecAllEntrys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> inOrRecDeductEntrys = new ArrayList<DynamicObject>(8);
        PurInvoiceDeductionCalHelper.separateEntriesByType(entrydys, deductBills, deductEntrys, inOrRecAllEntrys, inOrRecDeductEntrys);
        BigDecimal inOrRecActTotalAmount = inOrRecAllEntrys.stream().map(e -> e.getBigDecimal("actchecktaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal deductActTotalAmount = deductEntrys.stream().map(e -> e.getBigDecimal("actchecktaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        invoiceObj.set("insumtaxamount", (Object)inOrRecActTotalAmount);
        invoiceObj.set("deductsumtaxamount", (Object)deductActTotalAmount);
        Map<String, BigDecimal> calDeductionTaxAmount = PurInvoiceDeductionCalHelper.calDeductionTaxAmount(invoiceObj, deductEntrys, inOrRecDeductEntrys);
        String taxType = invoiceObj.getString("taxtype");
        Map<String, Map<String, Object>> calAfterDeductionTaxAmount = PurInvoiceDeductionCalHelper.calAfterDeductionTaxAmount(invoiceObj, inOrRecDeductEntrys, calDeductionTaxAmount, taxType);
        int amtPrecision = CurrencyUtils.getAmtPrecision((DynamicObject)invoiceObj);
        entrydys.forEach(entrydy -> {
            String srcentryid = entrydy.getString("srcentryid1");
            BigDecimal deductionAmount = calDeductionTaxAmount.getOrDefault(srcentryid, BigDecimal.ZERO);
            Map afterDeductionParam = (Map)calAfterDeductionTaxAmount.get(srcentryid);
            if (deductionAmount.signum() != 0 && !CollectionUtils.isEmpty((Map)afterDeductionParam)) {
                String afterdeductdiscounttype = afterDeductionParam.getOrDefault("afterdeductdiscounttype", DiscountTypeEnum.NULL.getVal());
                entrydy.set("afterdeductdiscounttype", (Object)afterdeductdiscounttype);
                BigDecimal afterdeductdctrate = afterDeductionParam.getOrDefault("afterdeductdctrate", BigDecimal.ZERO);
                entrydy.set("afterdeductdctrate", (Object)afterdeductdctrate);
                BigDecimal afterdeductdctamount = afterDeductionParam.getOrDefault("afterdeductdctamount", BigDecimal.ZERO);
                entrydy.set("afterdeductdctamount", (Object)afterdeductdctamount);
                BigDecimal afterdeducttax = afterDeductionParam.getOrDefault("afterdeducttax", BigDecimal.ZERO);
                entrydy.set("afterdeducttax", (Object)afterdeducttax);
                BigDecimal afterdeductamount = afterDeductionParam.getOrDefault("afterdeductamount", BigDecimal.ZERO);
                entrydy.set("afterdeductamount", (Object)afterdeductamount);
                BigDecimal afterdeducttaxamount = afterDeductionParam.getOrDefault("afterdeducttaxamount", BigDecimal.ZERO);
                entrydy.set("afterdeducttaxamount", (Object)afterdeducttaxamount);
            }
            entrydy.set("deductamount", (Object)deductionAmount);
        });
    }

    private static Map<String, Map<String, Object>> calAfterDeductionTaxAmount(DynamicObject invoiceObj, List<DynamicObject> inOrRecEntrys, Map<String, BigDecimal> calDeductionTaxAmount, String taxType) {
        HashMap<String, Map<String, Object>> calAfterDeduction = new HashMap<String, Map<String, Object>>(8);
        int amtPrecision = CurrencyUtils.getAmtPrecision((DynamicObject)invoiceObj);
        int amtScale = PurInvoiceDeductionCalHelper.getScale(amtPrecision);
        int pricePrecision = CurrencyUtils.getPircePrecision((DynamicObject)invoiceObj);
        int priceScale = PurInvoiceDeductionCalHelper.getScale(pricePrecision);
        for (DynamicObject entrydy : inOrRecEntrys) {
            HashMap<String, Object> afterDeductionTaxAmount = new HashMap<String, Object>(8);
            String srcentryid = entrydy.getString("srcentryid1");
            BigDecimal deductionAmount = calDeductionTaxAmount.getOrDefault(srcentryid, BigDecimal.ZERO);
            String discounttype = entrydy.getString("discounttype1");
            BigDecimal qty = entrydy.getBigDecimal("qty1");
            BigDecimal actchecktaxamount = entrydy.getBigDecimal("actchecktaxamount");
            BigDecimal actcheckamount = entrydy.getBigDecimal("actcheckamount");
            BigDecimal actchecktaxprice = entrydy.getBigDecimal("actchecktaxprice");
            BigDecimal actcheckprice = entrydy.getBigDecimal("actcheckprice");
            BigDecimal taxRate = entrydy.getBigDecimal("taxrate1");
            BigDecimal discountRate = entrydy.getBigDecimal("dctrate1");
            boolean inputamount = invoiceObj.getBoolean("inputamount");
            String afterdeductdiscounttype = StringUtils.isNotBlank((String)discounttype) ? discounttype : DiscountTypeEnum.DISRATE.getVal();
            afterDeductionTaxAmount.put("afterdeductdiscounttype", afterdeductdiscounttype);
            if (inputamount) {
                actchecktaxprice = CalculateUtils.calTaxPriceNoScale((String)discounttype, (BigDecimal)actchecktaxamount, (BigDecimal)qty, (BigDecimal)discountRate, (int)priceScale);
                actcheckprice = CalculateUtils.calPriceNoScale((String)discounttype, (BigDecimal)actcheckamount, (BigDecimal)qty, (BigDecimal)discountRate, (int)priceScale);
            }
            BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercentNoScale((String)discounttype, (BigDecimal)discountRate, (BigDecimal)qty, (BigDecimal)actchecktaxprice, (String)taxType, (BigDecimal)taxRate, (int)amtScale);
            discountAmount = discountAmount.setScale(amtPrecision, 4);
            BigDecimal afterdeductdctamount = discountAmount.subtract(deductionAmount);
            afterDeductionTaxAmount.put("afterdeductdctamount", afterdeductdctamount);
            Boolean containTax = PurInvoiceDeductionCalHelper.isContainTax(taxType);
            if (containTax.booleanValue()) {
                BigDecimal afterdeducttaxamount = actchecktaxamount.add(deductionAmount);
                afterDeductionTaxAmount.put("afterdeducttaxamount", afterdeducttaxamount);
                BigDecimal afterdeducttax = BigDecimal.ZERO;
                afterdeducttax = TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) ? CalculateUtils.calTaxWhenPriceExludeTax((BigDecimal)afterdeducttaxamount, (BigDecimal)taxRate, (int)amtScale) : CalculateUtils.calTax((BigDecimal)afterdeducttaxamount, (BigDecimal)taxRate, (int)amtScale);
                afterdeducttax = afterdeducttax.setScale(amtPrecision, 4);
                afterDeductionTaxAmount.put("afterdeducttax", afterdeducttax);
                BigDecimal afterdeductamount = afterdeducttaxamount.subtract(afterdeducttax);
                afterDeductionTaxAmount.put("afterdeductamount", afterdeductamount);
                BigDecimal afterdeductdctrate = CalculateUtils.calDiscountByPercent((String)afterdeductdiscounttype, (BigDecimal)afterdeductdctamount, (BigDecimal)qty, (BigDecimal)actchecktaxprice, (int)priceScale);
                afterDeductionTaxAmount.put("afterdeductdctrate", afterdeductdctrate);
            } else {
                BigDecimal afterdeductdctrate = CalculateUtils.calDiscountByPercentByExTax((String)afterdeductdiscounttype, (BigDecimal)afterdeductdctamount, (BigDecimal)qty, (BigDecimal)actchecktaxprice, (BigDecimal)taxRate, (int)priceScale);
                afterDeductionTaxAmount.put("afterdeductdctrate", afterdeductdctrate);
                BigDecimal afterdeductamount = CalculateUtils.calTaxAmountByDiscountPercent((String)afterdeductdiscounttype, (BigDecimal)qty, (BigDecimal)actcheckprice, (BigDecimal)afterdeductdctrate, (int)amtScale);
                afterdeductamount = afterdeductamount.setScale(amtPrecision, 4);
                afterDeductionTaxAmount.put("afterdeductamount", afterdeductamount);
                BigDecimal afterdeducttax = CalculateUtils.calTaxNoScale((BigDecimal)afterdeductamount, (BigDecimal)taxRate, (int)amtScale);
                afterdeducttax = afterdeducttax.setScale(amtPrecision, 4);
                afterDeductionTaxAmount.put("afterdeducttax", afterdeducttax);
                BigDecimal afterdeducttaxamount = afterdeductamount.add(afterdeducttax);
                afterDeductionTaxAmount.put("afterdeducttaxamount", afterdeducttaxamount);
            }
            calAfterDeduction.put(srcentryid, afterDeductionTaxAmount);
        }
        return calAfterDeduction;
    }

    public static Map<String, BigDecimal> calDeductionTaxAmount(DynamicObject invoiceObj, List<DynamicObject> deductEntrys, List<DynamicObject> inOrRecEntrys) {
        HashMap<String, BigDecimal> deductTaxAmountBySrcEntryid = new HashMap<String, BigDecimal>(8);
        int amtPrecision = CurrencyUtils.getAmtPrecision((DynamicObject)invoiceObj);
        int amtScale = PurInvoiceDeductionCalHelper.getScale(amtPrecision);
        if (!deductEntrys.isEmpty()) {
            BigDecimal noPoNoMaterialDeductTaxAmount = BigDecimal.ZERO;
            HashMap<String, BigDecimal> mapdeductByPoEntryid = new HashMap<String, BigDecimal>(8);
            HashMap<Long, BigDecimal> mapdeductByMaterialId = new HashMap<Long, BigDecimal>(8);
            Map<String, List<DynamicObject>> poEntryIdMap = inOrRecEntrys.stream().filter(entry -> StringUtils.isNotEmpty((String)entry.getString("poentryid1"))).collect(Collectors.groupingBy(entry -> entry.getString("poentryid1")));
            Map<Long, List<DynamicObject>> materialIdMap = inOrRecEntrys.stream().filter(entry -> PurCheckMappingUtils.getMaterialId(entry, "1") != 0L).collect(Collectors.groupingBy(entry -> PurCheckMappingUtils.getMaterialId(entry, "1")));
            for (DynamicObject dynamicObject : deductEntrys) {
                BigDecimal bigDecimal = dynamicObject.getBigDecimal("actchecktaxamount");
                String string = dynamicObject.getString("poentryid1");
                long materialId = PurCheckMappingUtils.getMaterialId(dynamicObject, "1");
                if (StringUtils.isNotEmpty((String)string) && poEntryIdMap.get(string) != null) {
                    mapdeductByPoEntryid.put(string, mapdeductByPoEntryid.computeIfAbsent(string, k -> BigDecimal.ZERO).add(bigDecimal));
                    continue;
                }
                if (materialId != 0L && materialIdMap.get(materialId) != null) {
                    mapdeductByMaterialId.put(materialId, mapdeductByMaterialId.computeIfAbsent(materialId, k -> BigDecimal.ZERO).add(bigDecimal));
                    continue;
                }
                noPoNoMaterialDeductTaxAmount = noPoNoMaterialDeductTaxAmount.add(bigDecimal);
            }
            HashMap<String, BigDecimal> inTaxAmountByPoentryidMap = new HashMap<String, BigDecimal>(8);
            for (Map.Entry entry2 : mapdeductByPoEntryid.entrySet()) {
                String string = (String)entry2.getKey();
                BigDecimal deductTaxAmountTotal = (BigDecimal)entry2.getValue();
                List<DynamicObject> poentryidEntrys = poEntryIdMap.get(string);
                PurInvoiceDeductionCalHelper.calDeduteTaxAmountBySrcEntryId(inTaxAmountByPoentryidMap, deductTaxAmountTotal, poentryidEntrys, amtScale, amtPrecision);
            }
            HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>(8);
            for (Map.Entry entry3 : mapdeductByMaterialId.entrySet()) {
                Long materialId = (Long)entry3.getKey();
                BigDecimal deductTaxAmountTotal = (BigDecimal)entry3.getValue();
                List<DynamicObject> materialIdEntrys = materialIdMap.get(materialId);
                PurInvoiceDeductionCalHelper.calDeduteTaxAmountBySrcEntryId(hashMap, deductTaxAmountTotal, materialIdEntrys, amtScale, amtPrecision);
            }
            HashMap<String, BigDecimal> hashMap2 = new HashMap<String, BigDecimal>(8);
            PurInvoiceDeductionCalHelper.calDeduteTaxAmountBySrcEntryId(hashMap2, noPoNoMaterialDeductTaxAmount, inOrRecEntrys, amtScale, amtPrecision);
            PurInvoiceDeductionCalHelper.mergeAndSumMaps(inTaxAmountByPoentryidMap, hashMap, hashMap2, deductTaxAmountBySrcEntryid);
        } else {
            for (DynamicObject entrydy : inOrRecEntrys) {
                String srcentryid = entrydy.getString("srcentryid1");
                deductTaxAmountBySrcEntryid.put(srcentryid, BigDecimal.ZERO);
            }
        }
        return deductTaxAmountBySrcEntryid;
    }

    private static void calDeduteTaxAmountBySrcEntryId(Map<String, BigDecimal> inTaxAmountByMaterialIdMap, BigDecimal deductTaxAmountTotal, List<DynamicObject> materialIdEntrys, int amtScale, int amtPrecision) {
        BigDecimal totalAmountByPo = materialIdEntrys.stream().map(e -> e.getBigDecimal("actchecktaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        int maxIndexByPoentryid = materialIdEntrys.size() - 1;
        HashMap<String, BigDecimal> taxAmountByMaterialIdMap = new HashMap<String, BigDecimal>(8);
        for (int i = 0; i < materialIdEntrys.size(); ++i) {
            DynamicObject entrydy = materialIdEntrys.get(i);
            String srcentryid = entrydy.getString("srcentryid1");
            BigDecimal deductTaxAmount = BigDecimal.ZERO;
            BigDecimal actchecktaxamount = entrydy.getBigDecimal("actchecktaxamount");
            if (i == maxIndexByPoentryid) {
                Collection values = taxAmountByMaterialIdMap.values();
                BigDecimal sum = values.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                deductTaxAmount = deductTaxAmountTotal.subtract(sum);
            } else if (totalAmountByPo.signum() != 0) {
                deductTaxAmount = deductTaxAmountTotal.multiply(actchecktaxamount.divide(totalAmountByPo, amtScale, 4));
                deductTaxAmount = deductTaxAmount.setScale(amtPrecision, 4);
            }
            taxAmountByMaterialIdMap.put(srcentryid, taxAmountByMaterialIdMap.computeIfAbsent(srcentryid, k -> BigDecimal.ZERO).add(deductTaxAmount));
        }
        BinaryOperator sumOperator = (a, b) -> a.add((BigDecimal)b);
        taxAmountByMaterialIdMap.forEach((key, value) -> inTaxAmountByMaterialIdMap.merge((String)key, (BigDecimal)value, sumOperator));
    }

    private static void mergeAndSumMaps(Map<String, BigDecimal> inTaxAmountByPoentryidMap, Map<String, BigDecimal> inTaxAmountByMaterialIdMap, Map<String, BigDecimal> inTaxAmountByAllMap, Map<String, BigDecimal> deductTaxAmountBySrcEntryid) {
        BinaryOperator sumOperator = (a, b) -> a.add((BigDecimal)b);
        inTaxAmountByPoentryidMap.forEach((key, value) -> deductTaxAmountBySrcEntryid.merge((String)key, (BigDecimal)value, sumOperator));
        inTaxAmountByMaterialIdMap.forEach((key, value) -> deductTaxAmountBySrcEntryid.merge((String)key, (BigDecimal)value, sumOperator));
        inTaxAmountByAllMap.forEach((key, value) -> deductTaxAmountBySrcEntryid.merge((String)key, (BigDecimal)value, sumOperator));
    }

    private static void separateEntriesByType(DynamicObjectCollection entrydys, Set<String> deductBills, List<DynamicObject> deductEntrys, List<DynamicObject> inOrRecAllEntrys, List<DynamicObject> inOrRecEntrys) {
        entrydys.forEach(entrydy -> {
            String srcbilltype = entrydy.getString("srcbilltype1");
            if (deductBills.contains(srcbilltype)) {
                deductEntrys.add((DynamicObject)entrydy);
            } else {
                BigDecimal actchecktaxamount = entrydy.getBigDecimal("actchecktaxamount");
                if (actchecktaxamount.signum() > 0) {
                    inOrRecEntrys.add((DynamicObject)entrydy);
                }
                inOrRecAllEntrys.add((DynamicObject)entrydy);
            }
        });
    }

    private static boolean isContainTax(String taxType) {
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    private static int getScale(int scale) {
        return scale + 2;
    }
}

