/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sccore.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.util.ParamUtil;

public final class OrderAvailableStockQtyHelper {
    private static final Log log = LogFactory.getLog(OrderAvailableStockQtyHelper.class);

    public static Collection<String> assmibleMustProperties() {
        HashSet<String> properties = new HashSet<String>(128);
        properties.add("material");
        properties.add("basicunit");
        properties.add("unit");
        properties.add("billno");
        properties.add("basicqty");
        properties.add("qty");
        properties.add("iscontrolqty");
        properties.add("saloutbaseqtyup");
        properties.add("relateoutstockbaseqty");
        properties.add("sumoutstockbaseqty");
        properties.add("schedulebaseqty");
        properties.add("sumreceiptbaseqty");
        properties.add("suminstockbaseqty");
        properties.add("sumrejqty");
        properties.add("sumrefundbaseqty");
        properties.add("jointdatachannelid");
        properties.add("poentryid");
        properties.add("businesstype");
        return properties;
    }

    public static List<DynamicObject> queryOrderData(QFilter qFilter, String entityFields, String orderBysParam, Map<String, String> customParamMap) {
        ORM orm = ORM.create();
        if (orderBysParam == null || orderBysParam.trim().isEmpty()) {
            orderBysParam = "id";
        }
        ArrayList<DynamicObject> jointBills = new ArrayList<DynamicObject>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)OrderAvailableStockQtyHelper.class.getName(), (String)"pur_order", (String)("materialentry.id orderentryid," + entityFields), (QFilter[])new QFilter[]{qFilter}, (String)orderBysParam);){
            jointBills.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        }
        return jointBills;
    }

    public static Map<Long, BigDecimal> assembleOrderAvailableBasicCustomQty(List<DynamicObject> orders, Map<String, String> customParamMap) {
        HashMap<Long, BigDecimal> orderAvailableBasicQtyMap = new HashMap<Long, BigDecimal>(1024);
        HashMap<String, BigDecimal> erpOrderQtyMap = new HashMap<String, BigDecimal>(1024);
        Boolean callErpStockQty = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"availablestockqty");
        if (callErpStockQty.booleanValue()) {
            erpOrderQtyMap.putAll(OrderAvailableStockQtyHelper.assembleErpStockBasicQty(orders, customParamMap));
        }
        String valueProperty = customParamMap.getOrDefault("valueproperty", "relateoutstockbaseqty");
        Map<Long, BigDecimal> orderBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderBasicQty(orders, customParamMap);
        for (DynamicObject order : orders) {
            Long entryId = order.getLong("orderentryid");
            BigDecimal orderAvailableBasicQty = orderBasicQtyMap.getOrDefault(entryId, BigDecimal.ZERO);
            String poentryid = order.getString("poentryid");
            BigDecimal erpBasicQty = erpOrderQtyMap.getOrDefault(poentryid, BigDecimal.ZERO);
            BigDecimal maxAvailableBasicQty = BigDecimal.ZERO;
            BigDecimal valuePropertyBasicQty = order.getBigDecimal(valueProperty);
            maxAvailableBasicQty = valuePropertyBasicQty.compareTo(erpBasicQty) >= 0 ? valuePropertyBasicQty : erpBasicQty;
            orderAvailableBasicQtyMap.put(entryId, orderAvailableBasicQty.subtract(maxAvailableBasicQty));
        }
        return orderAvailableBasicQtyMap;
    }

    public static Map<String, BigDecimal> assembleOrderAvailableBasicQty(List<DynamicObject> orders) {
        HashMap<String, BigDecimal> orderAvailableBasicQtyMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, BigDecimal> erpOrderQtyMap = new HashMap<String, BigDecimal>(1024);
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        Boolean callErpStockQty = ParamUtil.getBooleanParam((String)"eae607fb000143ac", (String)"availablestockqty");
        if (callErpStockQty.booleanValue()) {
            erpOrderQtyMap.putAll(OrderAvailableStockQtyHelper.assembleErpStockBasicQty(orders, customParamMap));
        }
        Map<Long, BigDecimal> orderBasicQtyMap = OrderAvailableStockQtyHelper.assembleOrderBasicQty(orders, customParamMap);
        for (DynamicObject order : orders) {
            String poentryid;
            BigDecimal erpBasicQty;
            Long entryId = order.getLong("orderentryid");
            BigDecimal orderAvailableBasicQty = orderBasicQtyMap.getOrDefault(entryId, BigDecimal.ZERO);
            BigDecimal maxAvailableBasicQty = orderAvailableBasicQty.compareTo(erpBasicQty = erpOrderQtyMap.getOrDefault(poentryid = order.getString("poentryid"), BigDecimal.ZERO)) >= 0 ? orderAvailableBasicQty.subtract(erpBasicQty) : BigDecimal.ZERO;
            orderAvailableBasicQtyMap.put(poentryid, maxAvailableBasicQty);
        }
        return orderAvailableBasicQtyMap;
    }

    public static Map<Long, BigDecimal> assembleOrderBasicQty(List<DynamicObject> orders, Map<String, String> customParamMap) {
        HashMap<Long, BigDecimal> orderBasicQtyMap = new HashMap<Long, BigDecimal>(1024);
        String valueScene = customParamMap.get("getvaluescene");
        for (DynamicObject order : orders) {
            boolean iscontrolqty = order.getBoolean("iscontrolqty");
            BigDecimal basicqty = order.getBigDecimal("basicqty");
            if (iscontrolqty && "validator".equals(valueScene)) {
                basicqty = order.getBigDecimal("saloutbaseqtyup");
            }
            BigDecimal sumrefundbaseqty = order.getBigDecimal("sumrefundbaseqty");
            BigDecimal sumrejqty = order.getBigDecimal("sumrejqty");
            BigDecimal orderAvailableBasicQty = basicqty.add(sumrefundbaseqty).add(sumrejqty);
            Long entryId = order.getLong("orderentryid");
            orderBasicQtyMap.put(entryId, orderAvailableBasicQty);
        }
        return orderBasicQtyMap;
    }

    private static Map<String, BigDecimal> assembleErpStockBasicQty(List<DynamicObject> orders, Map<String, String> customParamMap) {
        Map<String, Map<String, BigDecimal>> messageMap = OrderAvailableStockQtyHelper.getErpStockBasicQty("manualqueryorderavailableqty", orders, customParamMap);
        HashMap<String, BigDecimal> erpOrderQtyMap = new HashMap<String, BigDecimal>(1024);
        if (!messageMap.isEmpty()) {
            for (Map.Entry<String, Map<String, BigDecimal>> entry : messageMap.entrySet()) {
                BigDecimal receiveBaseQtySum;
                String entryKey = entry.getKey();
                Map<String, BigDecimal> entryValue = entry.getValue();
                BigDecimal inBaseQtySum = entryValue.get("inBaseQtySum");
                BigDecimal maxErpStockBasicQty = inBaseQtySum.compareTo(receiveBaseQtySum = entryValue.get("receiveBaseQtySum")) >= 0 ? inBaseQtySum : receiveBaseQtySum;
                erpOrderQtyMap.put(entryKey, maxErpStockBasicQty);
            }
        }
        return erpOrderQtyMap;
    }

    public static Map<String, Map<String, BigDecimal>> getErpStockBasicQty(String executeSceneNumber, List<DynamicObject> executeBills, Map<String, String> customParamMap) {
        HashMap messageMap;
        HashMap<String, Map<String, BigDecimal>> stockQtyMap;
        block8: {
            stockQtyMap = new HashMap<String, Map<String, BigDecimal>>(1024);
            messageMap = new HashMap(1024);
            String keyField = customParamMap.getOrDefault("keyField", "id");
            String jointChannelField = customParamMap.getOrDefault("jointChannelField", "jointdatachannelid");
            try {
                MultiDataHandleResult dataHandleResult = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)executeSceneNumber, executeBills, (String)keyField, (String)jointChannelField, customParamMap);
                String messageJsonString = dataHandleResult.getMessage();
                messageMap.putAll((Map)SerializationUtils.fromJsonString((String)messageJsonString, Map.class));
                if (log.isInfoEnabled()) {
                    log.info("PurAvailableStockBasicQtyHelper#getErpStockBasicQty#messageMap:{}", (Object)SerializationUtils.toJsonString(messageMap));
                }
            }
            catch (RuntimeException runtimeException) {
                if (!log.isWarnEnabled()) break block8;
                log.warn(String.valueOf(runtimeException.getMessage()));
            }
        }
        if (!messageMap.isEmpty()) {
            HashMap<String, BigDecimal> stepBasicQty = null;
            for (Map.Entry entry : messageMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                Map entryValue = (Map)entry.getValue();
                String receiveBaseQtySumString = (String)entryValue.get("receiveBaseQtySum");
                String inBaseQtySumString = (String)entryValue.get("inBaseQtySum");
                BigDecimal receiveBaseQtySum = BigDecimal.ZERO;
                BigDecimal inBaseQtySum = BigDecimal.ZERO;
                if (receiveBaseQtySumString != null) {
                    receiveBaseQtySum = new BigDecimal(receiveBaseQtySumString);
                }
                if (inBaseQtySumString != null) {
                    inBaseQtySum = new BigDecimal(inBaseQtySumString);
                }
                stepBasicQty = new HashMap<String, BigDecimal>(2);
                stepBasicQty.put("receiveBaseQtySum", receiveBaseQtySum);
                stepBasicQty.put("inBaseQtySum", inBaseQtySum);
                stockQtyMap.put(entryKey, stepBasicQty);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("PurAvailableStockBasicQtyHelper#getErpStockBasicQty#stockQtyMap:{}", (Object)SerializationUtils.toJsonString(stockQtyMap));
        }
        return stockQtyMap;
    }

    public static String getTargetWriteBasicQtyProperty(String targetEntity) {
        switch (targetEntity) {
            case "pur_deliveryschedule": 
            case "scp_scheduledelivery": {
                return "schedulebaseqty";
            }
        }
        return "relateoutstockbaseqty";
    }
}

