/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sccore.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.scm.sccore.business.OrderAvailableStockQtyHelper;

public final class SalOutStockAvailableBasicQtyHelper {
    private static final Log log = LogFactory.getLog(SalOutStockAvailableBasicQtyHelper.class);

    public static Map<String, Map<String, BigDecimal>> assmibleSalOutStockAvailableBasicQty(List<DynamicObject> salOutStocks, Map<String, String> customParamMap) {
        return OrderAvailableStockQtyHelper.getErpStockBasicQty("manualquerystockavailableqty", salOutStocks, customParamMap);
    }

    public static List<DynamicObject> getJointSalOutStockData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1024);
        ArrayList allRows = new ArrayList(1024);
        for (DynamicObject bill : dynamicObjects) {
            allRows.addAll(bill.getDynamicObjectCollection("materialentry"));
        }
        final Iterator allRowsIterator = allRows.iterator();
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("entryid", (DataType)DataType.LongType), new Field("jointdatachannelid", (DataType)DataType.StringType), new Field("poentryid", (DataType)DataType.StringType), new Field("businesstype", (DataType)DataType.AnyType)});
        DataSet dataSet = Algo.create((String)"SalOutStockAvailableBasicQtyHelperAlgo").createDataSet((Iterator)new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return allRowsIterator.hasNext();
            }

            @Override
            public Object[] next() {
                DynamicObject row = (DynamicObject)allRowsIterator.next();
                DynamicObject bill = (DynamicObject)row.getParent();
                Long id = bill.getLong("id");
                DynamicObject businesstype = bill.getDynamicObject("businesstype");
                String billNo = bill.getString("id");
                Long entryid = row.getLong("id");
                String jointdatachannelid = row.getString("jointdatachannelid");
                String poentryid = row.getString("poentryid");
                return new Object[]{id, billNo, entryid, jointdatachannelid, poentryid, businesstype};
            }
        }, rowMeta);
        ORM orm = ORM.create();
        dynamicObjectList.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        return dynamicObjectList;
    }
}

