/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sccore.multijoint.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.sccore.multijoint.plugin.AbstractOrderLogisticsStatusStdPlugin;

public abstract class AbstractOrderLogisticsStatusForCosmicStdPlugin
extends AbstractOrderLogisticsStatusStdPlugin {
    @Override
    public List<DynamicObject> getRefDynamicObjects(List<DynamicObject> originalData) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
        HashSet<String> linkValues = new HashSet<String>(1024);
        for (DynamicObject data : originalData) {
            String poEntryId = data.getString("poentryid");
            if (poEntryId == null || poEntryId.isEmpty() || "0".equalsIgnoreCase(poEntryId)) continue;
            linkValues.add(poEntryId);
        }
        if (!linkValues.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.getSceneEntityNumber(), (String)"logstatus,materialentry.pobillid pobillid", (QFilter[])new QFilter[]{new QFilter(this.getLinkProperty(), "in", linkValues).and(new QFilter(this.getValueProperty(), "in", (Object)this.getValueOptions()))}, (String)"id");){
                DataSet groupDataSet = dataSet.groupBy(new String[]{"pobillid", "logstatus"}).finish();
                dynamicObjects.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(groupDataSet));
                groupDataSet.close();
            }
        }
        return dynamicObjects;
    }

    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> orderList) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = null;
        HashSet<Long> logisticsIds = new HashSet<Long>(1024);
        for (DynamicObject bill : orderList) {
            logisticsIds.add(Long.parseLong(bill.getString("pobillid")));
        }
        if (!logisticsIds.isEmpty()) {
            cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
            HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
            logisticsMap.put("status", this.getValueOptions().stream().findFirst());
            logisticsMap.put("ids", new ArrayList(logisticsIds));
            cosmicStdParamArgs.setCloudId("scmc");
            cosmicStdParamArgs.setAppId("pm");
            cosmicStdParamArgs.setServiceName("PmSupColService");
            cosmicStdParamArgs.setMethodName("upLogisticsStatus");
            cosmicStdParamArgs.setParamMap(logisticsMap);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#cosmicStdParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)cosmicStdParamArgs));
        }
        return cosmicStdParamArgs;
    }
}

