/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sccore.multijoint.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractLinkEntityCustomParamPlugin;
import kd.scm.common.util.BussinessTypeUtils;

public final class OrderAutoConfirmStatusForCosmicStdByOmPlugin
extends AbstractLinkEntityCustomParamPlugin {
    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        List queryDynamicObjects = this.queryDynamicObjects(pkIds);
        List<DynamicObject> dys = queryDynamicObjects.stream().filter(dy -> BussinessTypeUtils.isPmOmBussinessType(dy.getString("businesstype"))).collect(Collectors.toList());
        return dys;
    }

    protected Collection<String> getProperty() {
        HashSet<String> propertys = new HashSet<String>(1);
        propertys.add("materialentry.poentryid poentryid");
        propertys.add("businesstype.number businesstype");
        return propertys;
    }

    protected Set<String> getGroupKeys() {
        HashSet<String> groupKey = new HashSet<String>(1);
        groupKey.add("poentryid");
        groupKey.add("businesstype");
        return groupKey;
    }

    public void initValuePropertyAndOptionVar(Map<String, String> customConfigMap) {
        super.initValuePropertyAndOptionVar(customConfigMap);
        this.setValueProperty("cfmstatus");
        this.addValueOption("E");
    }

    public List<DynamicObject> getRefDynamicObjects(List<DynamicObject> originalData) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
        HashSet<String> linkValues = new HashSet<String>(1024);
        for (DynamicObject data : originalData) {
            String poEntryId = data.getString("poentryid");
            if (poEntryId == null || poEntryId.isEmpty() || "0".equalsIgnoreCase(poEntryId)) continue;
            linkValues.add(poEntryId);
        }
        if (this.getLinkProperty() == null) {
            this.setLinkProperty("materialentry.poentryid");
        }
        if (!linkValues.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.getSceneEntityNumber(), (String)"cfmstatus,materialentry.pobillid pobillid", (QFilter[])new QFilter[]{new QFilter(this.getLinkProperty(), "in", linkValues).and(new QFilter(this.getValueProperty(), "in", (Object)this.getValueOptions()))}, (String)"id");){
                DataSet groupDataSet = dataSet.groupBy(new String[]{"pobillid", "cfmstatus"}).finish();
                dynamicObjects.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(groupDataSet));
                groupDataSet.close();
            }
        }
        return dynamicObjects;
    }

    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> orderList) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = null;
        HashSet<Long> confirmIds = new HashSet<Long>(1024);
        for (DynamicObject bill : orderList) {
            confirmIds.add(Long.parseLong(bill.getString("pobillid")));
        }
        if (!confirmIds.isEmpty()) {
            cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
            HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
            logisticsMap.put("entity", "pm_om_purorderbill");
            logisticsMap.put("confirmstatus", ConfirmStatusEnum.ALERT.getVal());
            logisticsMap.put("ids", new ArrayList(confirmIds));
            cosmicStdParamArgs.setCloudId("scmc");
            cosmicStdParamArgs.setAppId("pm");
            cosmicStdParamArgs.setServiceName("OmPurOrderOpmService");
            cosmicStdParamArgs.setMethodName("writeBackStatus");
            cosmicStdParamArgs.setParamMap(logisticsMap);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#cosmicStdParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)cosmicStdParamArgs));
        }
        return cosmicStdParamArgs;
    }
}

