/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.sccore.multijoint.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.sccore.multijoint.plugin.AbstractOrderLogisticsStatusForCosmicStdPlugin;

public final class OrderLogisticsStatusForCosmicStdByOmPlugin
extends AbstractOrderLogisticsStatusForCosmicStdPlugin {
    private String uniqueValueOption;

    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        List queryDynamicObjects = this.queryDynamicObjects(pkIds);
        List<DynamicObject> dys = queryDynamicObjects.stream().filter(dy -> BussinessTypeUtils.isPmOmBussinessType(dy.getString("businesstype"))).collect(Collectors.toList());
        return dys;
    }

    @Override
    protected Collection<String> getProperty() {
        HashSet<String> propertys = new HashSet<String>(1);
        propertys.add("materialentry.poentryid poentryid");
        propertys.add("businesstype.number businesstype");
        return propertys;
    }

    @Override
    protected Set<String> getGroupKeys() {
        HashSet<String> groupKey = new HashSet<String>(1);
        groupKey.add("poentryid");
        groupKey.add("businesstype");
        return groupKey;
    }

    @Override
    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> orderList) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = null;
        HashSet<Long> logisticsIds = new HashSet<Long>(1024);
        for (DynamicObject bill : orderList) {
            logisticsIds.add(Long.parseLong(bill.getString("pobillid")));
        }
        Set valueOptions = this.getValueOptions();
        if (valueOptions.size() == 1) {
            this.uniqueValueOption = (String)valueOptions.stream().findFirst().get();
        }
        if (!logisticsIds.isEmpty() && this.uniqueValueOption != null) {
            cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
            HashMap<String, Object> logisticsMap = new HashMap<String, Object>(2);
            logisticsMap.put("logisticsstatus", this.uniqueValueOption);
            logisticsMap.put("ids", new ArrayList(logisticsIds));
            logisticsMap.put("entity", "pm_om_purorderbill");
            cosmicStdParamArgs.setCloudId("scmc");
            cosmicStdParamArgs.setAppId("pm");
            cosmicStdParamArgs.setServiceName("OmPurOrderOpmService");
            cosmicStdParamArgs.setMethodName("writeBackStatus");
            cosmicStdParamArgs.setParamMap(logisticsMap);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#cosmicStdParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)cosmicStdParamArgs));
        }
        return cosmicStdParamArgs;
    }
}

