/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.fulltext.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.PropertyValue;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;

@Deprecated
public class PbdMalElasticSearchUtils {
    private static Log log = LogFactory.getLog(PbdMalElasticSearchUtils.class);
    private static final String GOODS_STATUS = "pbd_mallgoods_status";
    private static final String GOODS_PRICE = "pbd_mallgoods_price";
    private static final String GOODS = "pbd_mallgoods";
    private static final String SELF_GOODS = "pmm_prodmanage";
    private static final String PBD_GOODS = "pbd_goods";
    private static final String GOODS_PROPERTIES = "id,name,number,group.id,group.name,group.number,group.longnumber,brandid.id,brandid.number,brandid.name,model,source,mainpic";
    private static final String SELF_GOODS__PROPERTIES = "id,name,number,category.id,category.name,category.number,category.longnumber,brand.id,brand.number,brand.name,model,centralpurtype,taxprice,source,mallstatus,thumbnail,supplier.id,supplier.name";

    public static boolean MalGoodsBatchSync(String entityName, List<Long> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return false;
        }
        boolean flag = true;
        List splitList = Lists.partition(pkIds, (int)200);
        try {
            FullTextUpdater fullTextUpdater = FullTextFactory.getFullTextUpdater((String)"pur");
            for (List splitIds : splitList) {
                BatchValue[] batchValue = null;
                Map goods = null;
                Map<String, DynamicObject> goodsPrice = null;
                Map<String, DynamicObject> goodsStatus = null;
                switch (entityName) {
                    case "pbd_mallgoods": {
                        goods = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS, GOODS_PROPERTIES, new QFilter("id", "in", (Object)splitIds), true);
                        goodsPrice = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_PRICE, "mallgoods,price", new QFilter("mallgoods", "in", (Object)splitIds), false);
                        goodsStatus = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_STATUS, "mallgoods,mallstatus", new QFilter("mallgoods", "in", (Object)splitIds), false);
                        batchValue = PbdMalElasticSearchUtils.buildBatchValue(goods, goodsPrice, goodsStatus, false);
                        break;
                    }
                    case "pbd_mallgoods_price": {
                        goodsPrice = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_PRICE, "mallgoods,price", new QFilter("id", "in", (Object)splitIds), false);
                        List<Long> priceGoodsIds = PbdMalElasticSearchUtils.getMalGoodsIds(goodsPrice);
                        goods = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS, GOODS_PROPERTIES, new QFilter("id", "in", priceGoodsIds), true);
                        goodsStatus = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_STATUS, "mallgoods,mallstatus", new QFilter("mallgoods", "in", priceGoodsIds), false);
                        batchValue = PbdMalElasticSearchUtils.buildBatchValue(goods, goodsPrice, goodsStatus, false);
                        break;
                    }
                    case "pbd_mallgoods_status": {
                        goodsStatus = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_STATUS, "mallgoods,mallstatus", new QFilter("id", "in", (Object)splitIds), false);
                        List<Long> statusGoodsIds = PbdMalElasticSearchUtils.getMalGoodsIds(goodsStatus);
                        goods = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS, GOODS_PROPERTIES, new QFilter("id", "in", statusGoodsIds), true);
                        goodsPrice = PbdMalElasticSearchUtils.getDynamicObjectMap(GOODS_PRICE, "mallgoods,price", new QFilter("mallgoods", "in", statusGoodsIds), false);
                        batchValue = PbdMalElasticSearchUtils.buildBatchValue(goods, goodsPrice, goodsStatus, false);
                        break;
                    }
                    case "pmm_prodmanage": 
                    case "pbd_goods": {
                        QFilter filter = new QFilter("id", "in", (Object)splitIds).and(new QFilter("source", "=", (Object)"1"));
                        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)SELF_GOODS, (String)SELF_GOODS__PROPERTIES, (QFilter[])new QFilter[]{filter});
                        goods = DynamicObjectUtil.colsToMap((DynamicObjectCollection)dyoCol, (String)"id");
                        batchValue = PbdMalElasticSearchUtils.buildBatchValue(goods, null, null, true);
                        break;
                    }
                }
                if (null != batchValue) {
                    fullTextUpdater.update(StringUtils.equals((CharSequence)SELF_GOODS, (CharSequence)entityName) || StringUtils.equals((CharSequence)PBD_GOODS, (CharSequence)entityName) ? PBD_GOODS : GOODS, batchValue);
                    continue;
                }
                log.info("@@@kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils.MalGoodsBatchSync.batchValue\u4e3a\u7a7a");
                flag = false;
            }
        }
        catch (Exception e) {
            log.info("@@@kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils.MalGoodsBatchSync\u66f4\u65b0\u5f02\u5e38\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            flag = false;
        }
        return flag;
    }

    private static List<Long> getMalGoodsIds(Map<String, DynamicObject> map) {
        ArrayList<Long> resList = new ArrayList<Long>(map.size());
        for (Map.Entry<String, DynamicObject> entry : map.entrySet()) {
            DynamicObject dyo = entry.getValue();
            resList.add(dyo.getLong("mallgoods"));
        }
        return resList;
    }

    private static Map<String, DynamicObject> getDynamicObjectMap(String entityName, String selectors, QFilter filter, boolean isGoodsPk) {
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)entityName, (String)selectors, (QFilter[])new QFilter[]{filter});
        return DynamicObjectUtil.colsToMap((DynamicObjectCollection)dyoCol, (String)(isGoodsPk ? "id" : "mallgoods"));
    }

    public static boolean MalGoodsIncrSyn(String entityName, long pkId) {
        ArrayList<Long> pkIds = new ArrayList<Long>(4);
        pkIds.add(pkId);
        return PbdMalElasticSearchUtils.MalGoodsBatchSync(entityName, pkIds);
    }

    private static BatchValue[] buildBatchValue(Map<String, DynamicObject> goods, Map<String, DynamicObject> goodsPrice, Map<String, DynamicObject> goodsStatus, boolean isSelf) {
        ArrayList<BatchValue> batchValues = new ArrayList<BatchValue>();
        for (Map.Entry<String, DynamicObject> entry : goods.entrySet()) {
            DynamicObject dyo = entry.getValue();
            String id = entry.getKey();
            try {
                PropertyValue[] propertyValueArray = new PropertyValue[20];
                propertyValueArray[0] = new PropertyValue(new MatchProperty("id", FTDataType.STRING), (Object)id);
                propertyValueArray[1] = new PropertyValue(new MatchProperty("name_zh_cn", FTDataType.STRING), (Object)dyo.getString("name"));
                propertyValueArray[2] = new PropertyValue(new MatchProperty("name_py", FTDataType.STRING), (Object)PinYinUtil.getMergePinyin((String)dyo.getString("name")));
                propertyValueArray[3] = new PropertyValue(new MatchProperty("number", FTDataType.STRING), (Object)dyo.getString("number"));
                propertyValueArray[4] = new PropertyValue(new MatchProperty("classid", FTDataType.STRING), (Object)(isSelf ? dyo.getString("category.id") : dyo.getString("group.id")));
                propertyValueArray[5] = new PropertyValue(new MatchProperty("classname", FTDataType.STRING), (Object)(isSelf ? dyo.getString("category.name") : dyo.getString("group.name")));
                propertyValueArray[6] = new PropertyValue(new MatchProperty("classnumber", FTDataType.STRING), (Object)(isSelf ? dyo.getString("category.number") : dyo.getString("group.number")));
                propertyValueArray[7] = new PropertyValue(new MatchProperty("classlongnumber", FTDataType.STRING), (Object)(isSelf ? dyo.getString("category.longnumber") : dyo.getString("group.longnumber")));
                propertyValueArray[8] = new PropertyValue(new MatchProperty("brandid", FTDataType.STRING), (Object)(isSelf ? dyo.getString("brand.id") : dyo.getString("brandid.id")));
                propertyValueArray[9] = new PropertyValue(new MatchProperty("brandnumber", FTDataType.STRING), (Object)(isSelf ? dyo.getString("brand.number") : dyo.getString("brandid.number")));
                propertyValueArray[10] = new PropertyValue(new MatchProperty("brandname", FTDataType.STRING), (Object)(isSelf ? dyo.getString("brand.name") : dyo.getString("brandid.name")));
                propertyValueArray[11] = new PropertyValue(new MatchProperty("model", FTDataType.STRING), (Object)dyo.getString("model"));
                propertyValueArray[12] = new PropertyValue(new MatchProperty("centralpurtype", FTDataType.STRING), (Object)(isSelf ? dyo.getString("centralpurtype") : "1"));
                propertyValueArray[13] = new PropertyValue(new MatchProperty("price", FTDataType.FLOAT), (Object)(isSelf ? (Number)Float.valueOf(CommonUtil.getBigDecimalPro((Object)dyo.getBigDecimal("taxprice")).floatValue()) : (Number)(goodsPrice.get(id) != null ? CommonUtil.getBigDecimalPro((Object)goodsPrice.get(id).getBigDecimal("price")) : Float.valueOf(0.0f))));
                propertyValueArray[14] = new PropertyValue(new MatchProperty("source", FTDataType.STRING), (Object)dyo.getString("source"));
                propertyValueArray[15] = new PropertyValue(new MatchProperty("mallstatus", FTDataType.STRING), (Object)(isSelf ? (null != dyo ? dyo.getString("mallstatus") : "") : (goodsStatus.get(id) != null ? goodsStatus.get(id).getString("mallstatus") : "")));
                propertyValueArray[16] = new PropertyValue(new MatchProperty("mainpic", FTDataType.STRING), (Object)(isSelf ? dyo.getString("thumbnail") : dyo.getString("mainpic")));
                propertyValueArray[17] = new PropertyValue(new MatchProperty("supplierid", FTDataType.STRING), (Object)(isSelf ? dyo.getString("supplier.id") : ""));
                propertyValueArray[18] = new PropertyValue(new MatchProperty("suppliername", FTDataType.STRING), (Object)(isSelf ? dyo.getString("supplier.name") : ""));
                propertyValueArray[19] = new PropertyValue(new MatchProperty("suppliername_py", FTDataType.STRING), (Object)(isSelf ? PinYinUtil.getMergePinyin((String)dyo.getString("supplier.name")) : ""));
                PropertyValue[] propertyValue = propertyValueArray;
                batchValues.add(new BatchValue((Object)id, propertyValue));
            }
            catch (Exception e) {
                log.info("@@@kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        return batchValues.toArray(new BatchValue[0]);
    }
}

