/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.domain.LadderPriceInfo;

public class PmmPurOrgEntrysetEdit
extends AbstractBillPlugIn
implements TreeNodeClickListener,
SearchEnterListener,
BeforeF7SelectListener {
    private static final String BTNNEW = "btnnew";
    private static final String BTNEDIT = "btnedit";
    private static final String BTNDEL = "btndel";
    private static final String ENTRY_ALL = "entryentity1";
    private static final String ENTRY_PART = "entryentity";
    private static final String CACHE_SELECTNODEID = "treeNodeId";
    private static final String CACHE_SELECTPARENTNODEID = "treeParentNodeId";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "toprotocolentry": {
                this.doToProtocolEntry(args);
                break;
            }
            case "copyentrytoorg": {
                this.doCopyEntryToOrg(args);
                break;
            }
            case "newentry": {
                this.doNewentry(args);
                break;
            }
            case "setladderprice": {
                this.setLadderPrice(args);
                break;
            }
        }
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_PART);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_PART);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("entrypricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"PmmOrgScopeSettingEdit_5", (String)"scm-malcore-common", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = row.getBigDecimal("minorderqty");
        if (minorderqty.compareTo(BigDecimal.ZERO) == 0) {
            minorderqty = BigDecimal.ZERO;
        }
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), dataEntity.getDynamicObject("curr").getLong("id"));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal("taxprice");
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, dataEntity.getDynamicObject("curr").getLong("id")));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object lock = customParams.get("lock");
        if (!Boolean.parseBoolean(String.valueOf(lock))) {
            detailParamMap.put("status", "0");
        } else {
            detailParamMap.put("status", "1");
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void doNewentry(BeforeDoOperationEventArgs args) {
        String nodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u4e70\u65b9\u6848\u3002", (String)"PmmPurOrgEntrysetEdit_10", (String)"scm-malcore-common", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
    }

    private void doCopyEntryToOrg(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_PART);
        int[] selectRows = grid.getSelectRows();
        if (entrys.size() == 0 || selectRows.length == 0) {
            String msg = ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u6761\u6570\u636e\u3002", (String)"PmmPurOrgEntrysetEdit_4", (String)"scm-malcore-common", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        String caption = ResManager.loadKDString((String)"\u590d\u5236\u6e05\u5355\u5230\u5176\u4ed6\u7ec4\u7ec7", (String)"PmmPurOrgEntrysetEdit_5", (String)"scm-malcore-common", (Object[])new Object[0]);
        this.showCusPlanForm("new", 0L, caption, "copyentrytoorg");
    }

    private void doToProtocolEntry(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryCol;
        Map<String, List<Map<String, Object>>> allDataMap = this.getAllData();
        String treeNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        List<Map<String, Object>> partData = this.getPartData(treeNodeId, entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART));
        if (partData.size() > 0) {
            allDataMap.put(treeNodeId, partData);
        } else {
            allDataMap.remove(treeNodeId);
        }
        if (allDataMap.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u91c7\u4e70\u65b9\u6848\u548c\u534f\u8bae\u6e05\u5355\u3002", (String)"PmmPurOrgEntrysetEdit_7", (String)"scm-malcore-common", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            Object msg;
            HashMap<String, String> msgMap = new HashMap<String, String>(1024);
            for (Map.Entry<String, List<Map<String, Object>>> entry : allDataMap.entrySet()) {
                List<Map<String, Object>> values = entry.getValue();
                int seq = 1;
                msg = new StringBuilder();
                for (Map<String, Object> map : values) {
                    String index = "";
                    if (map.containsKey("entrypricetype1")) {
                        index = "1";
                    }
                    String entrypricetype = String.valueOf(map.get("entrypricetype" + index));
                    List subentryentity = (List)map.get("subentryentity");
                    if ("B".equals(entrypricetype) && subentryentity.size() == 0) {
                        ((StringBuilder)msg).append(seq).append(",");
                    }
                    ++seq;
                }
                if (((StringBuilder)msg).length() <= 0) continue;
                msgMap.put(entry.getKey(), ((StringBuilder)msg).substring(0, ((StringBuilder)msg).length() - 1));
            }
            if (msgMap.size() > 0) {
                HashSet<Long> purPlanIds = new HashSet<Long>(1024);
                for (String purPlanId : allDataMap.keySet()) {
                    purPlanIds.add(Long.parseLong(purPlanId));
                }
                QFilter qFilter = new QFilter("id", "in", purPlanIds);
                DynamicObjectCollection pmm_purchaseplan = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,name", (QFilter[])qFilter.toArray());
                HashMap<String, DynamicObject> purPlanMap = new HashMap<String, DynamicObject>(1024);
                for (DynamicObject info : pmm_purchaseplan) {
                    purPlanMap.put(info.getString("id"), info);
                }
                msg = new StringBuilder();
                for (Map.Entry entry : msgMap.entrySet()) {
                    DynamicObject purPlan = (DynamicObject)purPlanMap.get(entry.getKey());
                    String errMsg = ResManager.loadKDString((String)"\u5728{0}\u4e2d\u7b2c{1}\u884c\u5206\u5f55\u6ca1\u6709\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"PmmOrgScopeSettingEdit_6", (String)"scm-malcore-common", (Object[])new Object[]{purPlan.getString("name"), entry.getValue()});
                    ((StringBuilder)msg).append(errMsg).append("\n");
                }
                if (msgMap.size() == 1) {
                    this.getView().showErrorNotification(((StringBuilder)msg).toString());
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25", (String)"PmmOrgScopeSettingEdit_7", (String)"scm-malcore-common", (Object[])new Object[0]), ((StringBuilder)msg).toString(), MessageTypes.Default);
                }
                args.setCancel(true);
                return;
            }
        }
        List<Map<String, Object>> allEntryDataList = this.getAllEntryDataList();
        HashMap<String, List<Map<String, Object>>> returnData = new HashMap<String, List<Map<String, Object>>>(8);
        returnData.put("returnEntrys", allEntryDataList);
        this.getView().returnDataToParent(returnData);
        this.getPageCache().put("confirmDelete", "1");
        this.getView().close();
    }

    private List<Map<String, Object>> getAllEntryDataList() {
        DynamicObjectCollection entryCol;
        Map<String, List<Map<String, Object>>> allDataMap = this.getAllData();
        String treeNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        List<Map<String, Object>> partData = this.getPartData(treeNodeId, entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART));
        if (partData.size() > 0) {
            allDataMap.put(treeNodeId, partData);
        } else {
            allDataMap.remove(treeNodeId);
        }
        LinkedHashMap purPlan_OrgMap = new LinkedHashMap(1024);
        ArrayList<Object> purPlanIdList = new ArrayList<Object>(1024);
        if (allDataMap.size() > 0) {
            HashSet<Long> purPlanIds = new HashSet<Long>(1024);
            for (String string : allDataMap.keySet()) {
                purPlanIds.add(Long.parseLong(string));
            }
            Iterator<Map.Entry<String, List<Map<String, Object>>>> qFilter = new QFilter("id", "in", purPlanIds);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,entryentity.org", (QFilter[])qFilter.toArray(), (String)"createtime asc");
            for (DynamicObject row : dynamicObjectCollection) {
                String id = row.getString("id");
                List<Long> orgIds = new ArrayList<Long>(1024);
                if (null != purPlan_OrgMap.get(id)) {
                    orgIds = (List)purPlan_OrgMap.get(id);
                }
                orgIds.add(row.getLong("entryentity.org"));
                purPlan_OrgMap.put(id, orgIds);
                if (purPlanIdList.contains(id)) continue;
                purPlanIdList.add(id);
            }
        }
        ArrayList<Map<String, Object>> allEntryDataList = new ArrayList<Map<String, Object>>(1024);
        for (Map.Entry<String, List<Map<String, Object>>> entry : allDataMap.entrySet()) {
            String purPlanId = entry.getKey();
            List<Map<String, Object>> paramMaps = entry.getValue();
            for (Map<String, Object> paramMap : paramMaps) {
                List list = (List)purPlan_OrgMap.get(purPlanId);
                if (null == list) continue;
                for (Long orgId : list) {
                    HashMap<String, Object> newParamMap = new HashMap<String, Object>(1024);
                    newParamMap.putAll(paramMap);
                    newParamMap.put("purorg", orgId);
                    allEntryDataList.add(newParamMap);
                }
            }
        }
        for (Map map : allEntryDataList) {
            if (map.containsKey("materialname")) {
                map.put("entrygroup", map.get("materialname") + "_" + map.get("material_id"));
            } else {
                map.put("entrygroup", map.get("materialname1") + "_" + map.get("material1_id"));
            }
            if (!map.containsKey("purplanid")) continue;
            map.put("purplanid1", map.get("purplanid"));
        }
        Map<Object, List<Map>> materialnameMap = allEntryDataList.stream().collect(Collectors.groupingBy(o -> o.get("entrygroup")));
        allEntryDataList.clear();
        for (Map.Entry<Object, List<Map>> map : materialnameMap.entrySet()) {
            List<Map> values = map.getValue();
            ArrayList<Map> newValues = new ArrayList<Map>(1024);
            for (String string : purPlanIdList) {
                for (Map valueMap : values) {
                    if (!string.equals(valueMap.get("purplanid1"))) continue;
                    newValues.add(valueMap);
                }
            }
            allEntryDataList.addAll(newValues);
        }
        return allEntryDataList;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String confirmDelete = this.getPageCache().get("confirmDelete");
        if (StringUtils.isEmpty((CharSequence)confirmDelete)) {
            this.doCancel(e);
        }
    }

    private void doCancel(BeforeClosedEvent e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object lock = customParams.get("lock");
        if (Boolean.parseBoolean(String.valueOf(lock))) {
            return;
        }
        List<Map<String, Object>> allEntryDataList = this.getAllEntryDataList();
        HashMap<String, List<Map<String, Object>>> returnData = new HashMap<String, List<Map<String, Object>>>(8);
        returnData.put("returnEntrys", allEntryDataList);
        this.getView().returnDataToParent(returnData);
    }

    private void initData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Map entrypros = (Map)customParams.get("entrypros");
        Object curr = customParams.get("curr");
        this.getModel().setValue("curr", (Object)Long.parseLong(String.valueOf(curr)));
        Object loccurr = customParams.get("loccurr");
        this.getModel().setValue("loccurr", (Object)Long.parseLong(String.valueOf(loccurr)));
        Object orgId = customParams.get("orgId");
        this.getModel().setValue("org", (Object)Long.parseLong(String.valueOf(orgId)));
        this.initTreeData(0L);
        this.allotCurDynamicData(entrypros, this.getPageCache().get(CACHE_SELECTNODEID));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewBtnStatus();
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrypricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrypricetype", "ladderprice"});
        }
    }

    private void setViewBtnStatus() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object lock = customParams.get("lock");
        if (Boolean.parseBoolean(String.valueOf(lock))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNNEW, BTNEDIT, BTNDEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{"copyentrytoorg", "newentry", "deleteentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"toprotocolentry"});
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRY_PART});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNNEW, BTNEDIT, BTNDEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{"copyentrytoorg", "newentry", "deleteentry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"toprotocolentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{ENTRY_PART});
            String parentNodeId = this.getPageCache().get(CACHE_SELECTPARENTNODEID);
            if (!StringUtils.isEmpty((CharSequence)parentNodeId) && !"0".equals(parentNodeId)) {
                this.setEntryBtnStatus(true);
            } else {
                this.setEntryBtnStatus(false);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        Object parentNodeId = evt.getParentNodeId();
        if ("0".equals(parentNodeId)) {
            this.allotDynamicData(this.getPageCache().get(CACHE_SELECTNODEID), String.valueOf(nodeId));
            this.getPageCache().put(CACHE_SELECTNODEID, String.valueOf(nodeId));
            this.getPageCache().put(CACHE_SELECTPARENTNODEID, String.valueOf(parentNodeId));
        }
        if ("0".equals(nodeId)) {
            return;
        }
        if (!"0".equals(parentNodeId)) {
            String[] strs = String.valueOf(nodeId).split("_");
            this.allotDynamicData(this.getPageCache().get(CACHE_SELECTNODEID), strs[0]);
            this.getPageCache().put(CACHE_SELECTNODEID, strs[0]);
            this.getPageCache().put(CACHE_SELECTPARENTNODEID, String.valueOf(parentNodeId));
        }
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.focusNode(new TreeNode("0", evt.getNodeId().toString(), ""));
        this.getView().updateView();
    }

    private void setEntryBtnStatus(boolean isEnable) {
        if (isEnable) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"copyentrytoorg", "newentry", "deleteentry"});
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRY_PART});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"copyentrytoorg", "newentry", "deleteentry"});
            this.getView().setEnable(Boolean.TRUE, new String[]{ENTRY_PART});
        }
    }

    private void allotDynamicData(String srcTreeNodeId, String tarTreeNodeId) {
        Map<String, List<Map<String, Object>>> allDataMap = this.getAllData();
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        List<Map<String, Object>> partData = this.getPartData(srcTreeNodeId, entryCol);
        if (partData.size() > 0) {
            allDataMap.put(srcTreeNodeId, partData);
        }
        this.allotCurDynamicData(allDataMap, tarTreeNodeId);
    }

    private void allotDynamicEntryData(String entryEntityKey, List<Map<String, Object>> dataMap, String index) {
        this.getModel().deleteEntryData(entryEntityKey);
        if (dataMap == null || dataMap.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String entryEntity = entryEntityKey;
        if (StringUtils.isEmpty((CharSequence)index)) {
            entryEntity = entryEntityKey + "1";
        }
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entryEntity).getDynamicObjectType());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        HashMap<Integer, Object> seq_subrowsMap = new HashMap<Integer, Object>(1024);
        for (Map<String, Object> map : dataMap) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String newEntrykey;
                if (StringUtils.isEmpty((CharSequence)index) && entry.getKey().contains("purplanid") || entry.getKey().contains("_id") || "id".equals(entry.getKey()) || "seq".equals(entry.getKey()) || "subentryentity".equals(entry.getKey()) || !propertiesentity.contains((newEntrykey = entry.getKey().replace("1", "")) + "1")) continue;
                if (newEntrykey.contains("priceeffectdate") || newEntrykey.contains("priceinvaliddate")) {
                    if (entry.getValue() instanceof Date) {
                        vs.set(newEntrykey + index, entry.getValue(), rowCount);
                        continue;
                    }
                    if (null == entry.getValue()) continue;
                    vs.set(newEntrykey + index, (Object)DateUtil.string2date((String)String.valueOf(entry.getValue()), (String)"yyyy-MM-dd HH:mm:ss"), rowCount);
                    continue;
                }
                vs.set(newEntrykey + index, entry.getValue(), rowCount);
            }
            if (null != map.get("subentryentity")) {
                seq_subrowsMap.put(rowCount, map.get("subentryentity"));
            }
            vs.set("seq", (Object)(rowCount + 1), rowCount);
            ++rowCount;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntityKey, vs);
        model.endInit();
        this.getView().updateView(entryEntityKey);
        IDataModel entryOperate = this.getModel();
        for (Map.Entry entry : seq_subrowsMap.entrySet()) {
            List subRows = (List)entry.getValue();
            entryOperate.setEntryCurrentRowIndex(entryEntityKey, ((Integer)entry.getKey()).intValue());
            entryOperate.deleteEntryData("subentryentity" + index);
            for (Object subRow : subRows) {
                Map subRowMap = (Map)subRow;
                entryOperate.setEntryCurrentRowIndex(entryEntityKey, ((Integer)entry.getKey()).intValue());
                String subDataIndex = "";
                if (!subRowMap.containsKey("qtyfrom")) {
                    subDataIndex = "1";
                }
                int subIndex = entryOperate.createNewEntryRow("subentryentity" + index);
                this.getModel().setValue("subkey" + index, subRowMap.get("qtyfrom" + subDataIndex), subIndex, ((Integer)entry.getKey()).intValue());
                this.getModel().setValue("qtyfrom" + index, subRowMap.get("qtyfrom" + subDataIndex), subIndex, ((Integer)entry.getKey()).intValue());
                this.getModel().setValue("qtyto" + index, subRowMap.get("qtyto" + subDataIndex), subIndex, ((Integer)entry.getKey()).intValue());
                this.getModel().setValue("ladprice" + index, subRowMap.get("ladprice" + subDataIndex), subIndex, ((Integer)entry.getKey()).intValue());
            }
        }
        if (entryEntityKey.equals(ENTRY_PART)) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
            for (DynamicObject row : dynamicObjectCollection) {
                if (null == row.getDynamicObject("material")) continue;
                this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, new String[]{"materialname", "materialgroup"});
            }
        }
    }

    private List<Map<String, Object>> getPartData(String srcTreeNodeId, DynamicObjectCollection entryCol) {
        ArrayList<Map<String, Object>> rowsPros = new ArrayList<Map<String, Object>>();
        if (entryCol.size() > 0) {
            for (DynamicObject row : entryCol) {
                if (StringUtils.isEmpty((CharSequence)row.getString("materialname"))) continue;
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentryentity");
                ArrayList<Map> subRows = new ArrayList<Map>(1024);
                if ("B".equals(row.getString("entrypricetype")) && subEntry.size() > 1) {
                    for (DynamicObject subRow : subEntry) {
                        Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                        subRows.add(subRowMap);
                    }
                }
                objectMap.put("subentryentity", subRows);
                objectMap.put("purplanid", srcTreeNodeId);
                rowsPros.add(objectMap);
            }
        }
        return rowsPros;
    }

    private Map<String, List<Map<String, Object>>> getAllData() {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ALL);
        HashMap<String, List<Map<String, Object>>> purPlan_rowProsMap = new HashMap<String, List<Map<String, Object>>>(1024);
        if (entryCol.size() > 0) {
            for (DynamicObject row : entryCol) {
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentryentity1");
                ArrayList<Map> subRows = new ArrayList<Map>(1024);
                if ("B".equals(row.getString("entrypricetype1")) && subEntry.size() > 1) {
                    for (DynamicObject subRow : subEntry) {
                        Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                        subRows.add(subRowMap);
                    }
                }
                objectMap.put("subentryentity", subRows);
                String purPlanId = row.getString("purplanid1");
                List rowsPros = new ArrayList<Map>();
                if (null != purPlan_rowProsMap.get(purPlanId)) {
                    rowsPros = (List)purPlan_rowProsMap.get(purPlanId);
                }
                rowsPros.add(objectMap);
                purPlan_rowProsMap.put(purPlanId, rowsPros);
            }
        }
        return purPlan_rowProsMap;
    }

    private void initTreeData(Long focusPurPlanId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object protocol = customParams.get("protocolId");
        QFilter qFilter = new QFilter("protocol", "=", (Object)Long.parseLong(String.valueOf(protocol)));
        DynamicObjectCollection purchaseplans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,name,entryentity.org.id,entryentity.org.name", (QFilter[])qFilter.toArray(), (String)"createtime asc");
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmPurOrgEntrysetEdit_1", (String)"scm-malcore-common", (Object[])new Object[0]));
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        if (purchaseplans == null || purchaseplans.size() <= 0) {
            this.getPageCache().remove(CACHE_SELECTNODEID);
            this.getPageCache().remove(CACHE_SELECTPARENTNODEID);
            return;
        }
        Map<Long, List<DynamicObject>> purPlanId_OrgsMap = this.getPurPlanAndorgsMap(purchaseplans);
        String focusName = "";
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(1024);
        for (Map.Entry<Long, List<DynamicObject>> map : purPlanId_OrgsMap.entrySet()) {
            Long purPlanId = map.getKey();
            List<DynamicObject> orgs = map.getValue();
            TreeNode node = new TreeNode("0", purPlanId.toString(), orgs.get(0).getString("name"));
            treeNodes.add(node);
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject row : orgs) {
                stringBuilder.setLength(0);
                stringBuilder.append(purPlanId).append('_').append(row.getString("entryentity.org.id"));
                node = new TreeNode(purPlanId.toString(), stringBuilder.toString(), row.getString("entryentity.org.name"));
                treeNodes.add(node);
            }
            if (!purPlanId.equals(focusPurPlanId)) continue;
            focusName = orgs.get(0).getString("name");
        }
        treeView.focusNode(new TreeNode("0", ((TreeNode)treeNodes.get(0)).getId(), ((TreeNode)treeNodes.get(0)).getText()));
        treeView.addNodes(treeNodes);
        treeView.expand("0");
        TreeView treeView1 = (TreeView)this.getControl("treeview");
        if (focusPurPlanId.equals(0L)) {
            treeView1.focusNode(new TreeNode("0", ((TreeNode)treeNodes.get(0)).getId(), ((TreeNode)treeNodes.get(0)).getText()));
            this.getPageCache().put(CACHE_SELECTNODEID, ((TreeNode)treeNodes.get(0)).getId());
        } else {
            treeView1.focusNode(new TreeNode("0", focusPurPlanId.toString(), focusName));
            this.getPageCache().put(CACHE_SELECTNODEID, focusPurPlanId.toString());
        }
        this.getView().updateView();
    }

    private Map<Long, List<DynamicObject>> getPurPlanAndorgsMap(DynamicObjectCollection purchaseplans) {
        LinkedHashMap<Long, List<DynamicObject>> purPlanId_OrgsMap = new LinkedHashMap<Long, List<DynamicObject>>(1024);
        for (DynamicObject row : purchaseplans) {
            Long purPlanId = row.getLong("id");
            List<Object> orgs = new ArrayList<DynamicObject>(1024);
            if (null != purPlanId_OrgsMap.get(purPlanId)) {
                orgs = (List)purPlanId_OrgsMap.get(purPlanId);
            }
            orgs.add(row);
            purPlanId_OrgsMap.put(purPlanId, orgs);
        }
        return purPlanId_OrgsMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnnew = (Button)this.getView().getControl(BTNNEW);
        btnnew.addClickListener((ClickListener)this);
        Button btnedit = (Button)this.getView().getControl(BTNEDIT);
        btnedit.addClickListener((ClickListener)this);
        Button btndel = (Button)this.getView().getControl(BTNDEL);
        btndel.addClickListener((ClickListener)this);
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String treeNodeId;
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        String caption = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u91c7\u4e70\u65b9\u6848", (String)"PmmPurOrgEntrysetEdit_0", (String)"scm-malcore-common", (Object[])new Object[0]);
        if (BTNNEW.equalsIgnoreCase(srcCtrl.getKey())) {
            this.showCusPlanForm("new", 0L, caption, BTNNEW);
        }
        if (BTNEDIT.equalsIgnoreCase(srcCtrl.getKey()) && !StringUtils.isEmpty((CharSequence)(treeNodeId = this.getPageCache().get(CACHE_SELECTNODEID)))) {
            this.showCusPlanForm("edit", Long.parseLong(treeNodeId), caption, BTNEDIT);
        }
        if (BTNDEL.equalsIgnoreCase(srcCtrl.getKey())) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
            if (entrys.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91c7\u4e70\u65b9\u6848\u548c\u91c7\u4e70\u7ec4\u7ec7\u88ab\u534f\u8bae\u6e05\u5355\u5f15\u7528\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"PmmPurOrgEntrysetEdit_8", (String)"scm-malcore-common", (Object[])new Object[0]));
                return;
            }
            String treeNodeId2 = this.getPageCache().get(CACHE_SELECTNODEID);
            if (!StringUtils.isEmpty((CharSequence)treeNodeId2)) {
                QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(treeNodeId2));
                DynamicObjectCollection pmmPurPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"name", (QFilter[])qFilter.toArray());
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTNDEL, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u91c7\u8d2d\u65b9\u6848\u201c{0}\u201d", (String)"PmmPurOrgEntrysetEdit_2", (String)"scm-malcore-common", (Object[])new Object[]{((DynamicObject)pmmPurPlans.get(0)).getString("name")});
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    private Set<Long> getConflictOrgIds(String closeCallBackName) {
        String nodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        HashSet<Long> idSet = new HashSet<Long>(1024);
        for (DynamicObject row : entrys) {
            DynamicObject srcMaterial = row.getDynamicObject("material");
            if (null == srcMaterial) continue;
            idSet.add(srcMaterial.getLong("id"));
        }
        ArrayList<Long> purPlanIds = new ArrayList<Long>(1024);
        DynamicObjectCollection allEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ALL);
        for (DynamicObject row : allEntrys) {
            DynamicObject srcMaterial = row.getDynamicObject("material1");
            String purplanid = row.getString("purplanid1");
            if (null == srcMaterial || !idSet.contains(srcMaterial.getLong("id"))) continue;
            purPlanIds.add(Long.parseLong(purplanid));
        }
        if (closeCallBackName.equals("copyentrytoorg")) {
            purPlanIds.add(Long.parseLong(nodeId));
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object protocol = customParams.get("protocolId");
        QFilter qFilter = new QFilter("protocol", "=", (Object)Long.parseLong(String.valueOf(protocol)));
        DynamicObjectCollection purchaseplans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,name,entryentity.org.id,entryentity.org.name", (QFilter[])qFilter.toArray(), (String)"createtime asc");
        HashMap purChasePlanMap = new HashMap(1024);
        for (DynamicObject row : purchaseplans) {
            Long purPlanId = row.getLong("id");
            Long orgId = row.getLong("entryentity.org.id");
            List<Long> orgIds = new ArrayList<Long>(1024);
            if (null != purChasePlanMap.get(purPlanId)) {
                orgIds = (List)purChasePlanMap.get(purPlanId);
            }
            orgIds.add(orgId);
            purChasePlanMap.put(purPlanId, orgIds);
        }
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        for (Map.Entry map : purChasePlanMap.entrySet()) {
            List purPlanOrgIds = (List)map.getValue();
            if (!purPlanIds.contains(map.getKey()) || null == orgIds || (Long)map.getKey() == Long.parseLong(nodeId)) continue;
            orgIds.addAll(purPlanOrgIds);
        }
        if (closeCallBackName.equals("copyentrytoorg") && null != purChasePlanMap.get(Long.parseLong(nodeId))) {
            orgIds.addAll((Collection)purChasePlanMap.get(Long.parseLong(nodeId)));
        }
        return orgIds;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals(BTNDEL) && e.getResult() == MessageBoxResult.Yes) {
            this.deleteData();
        }
        if (callBackId.equals("deletePartSeq") && e.getResult() == MessageBoxResult.Yes) {
            this.deleteEntryBySeq();
        }
    }

    private void deleteData() {
        String treeNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        if (!StringUtils.isEmpty((CharSequence)treeNodeId)) {
            Map<String, List<Map<String, Object>>> allData = this.getAllData();
            allData.remove(treeNodeId);
            this.getModel().deleteEntryData(ENTRY_PART);
            this.deletePurPlanById(treeNodeId);
            this.initTreeData(0L);
            this.allotCurDynamicData(allData, this.getPageCache().get(CACHE_SELECTNODEID));
        }
    }

    private void deletePurPlanById(String treeNodeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(treeNodeId));
        DeleteServiceHelper.delete((String)"pmm_purchaseplan", (QFilter[])qFilter.toArray());
    }

    private void showCusPlanForm(String btnnew, long purPlanId, String caption, String closeCallBackName) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmm_cuspurplan");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put("planid", purPlanId);
        detailParamMap.put("protocolId", customParams.get("protocolId"));
        detailParamMap.put("operate", btnnew);
        if (!"new".equals(closeCallBackName)) {
            Set<Long> conflictOrgIds = this.getConflictOrgIds(closeCallBackName);
            detailParamMap.put("orgs", SerializationUtils.toJsonString(conflictOrgIds));
        }
        showParameter.setCaption(caption);
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackName));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "btnnew": 
            case "btnedit": {
                this.doCloseCallBackNew(e);
                break;
            }
            case "copyentrytoorg": {
                this.doCloseCallBackCopyEntryToOrg(e);
                break;
            }
            case "setladderprice": {
                this.doSetladderprice(e);
                break;
            }
        }
    }

    private void doSetladderprice(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)returnData;
            List entryList = (List)returnDataMap.get("entry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("subentryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_PART);
            int[] selectRows = grid.getSelectRows();
            int rowIndex = selectRows[0];
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
                this.getPageCache().remove("row");
            }
            int index = 0;
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("qty", rowIndex));
            for (LadderPriceInfo info : entryList) {
                vs.set("qtyfrom", (Object)info.getQtyfrom(), index);
                vs.set("qtyto", (Object)info.getQtyto(), index);
                vs.set("ladprice", (Object)info.getLadprice(), index);
                if (qty.compareTo(info.getQtyfrom()) >= 0 && (qty.compareTo(info.getQtyto()) < 0 || info.getQtyto().compareTo(BigDecimal.ZERO) == 0)) {
                    price = info.getLadprice();
                }
                ++index;
            }
            if (price.compareTo(BigDecimal.ZERO) == 0 && entryList.size() > 0) {
                entryList = entryList.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
                price = ((LadderPriceInfo)entryList.get(0)).getLadprice();
            }
            model.beginInit();
            model.batchCreateNewEntryRow("subentryentity", vs);
            model.endInit();
            this.getView().updateView("subentryentity");
            this.getModel().setValue("taxprice", (Object)price, rowIndex);
        }
    }

    private void doCloseCallBackNew(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)e.getReturnData();
            String purPlanId = String.valueOf(returnDataMap.get("purPlanId"));
            this.allotDynamicData(this.getPageCache().get(CACHE_SELECTNODEID), purPlanId);
            this.initTreeData(Long.parseLong(purPlanId));
        }
    }

    private void doCloseCallBackCopyEntryToOrg(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)e.getReturnData();
            String purPlanId = String.valueOf(returnDataMap.get("purPlanId"));
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_PART);
            int[] selectRows = grid.getSelectRows();
            DynamicObjectCollection selectEntryCol = new DynamicObjectCollection();
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
            for (int index : selectRows) {
                DynamicObject row = (DynamicObject)entryCol.get(index);
                if (StringUtils.isEmpty((CharSequence)row.getString("materialname"))) continue;
                selectEntryCol.add(entryCol.get(index));
            }
            List<Map<String, Object>> selectPartData = this.getPartData(purPlanId, selectEntryCol);
            String srcTreeNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
            Map<String, List<Map<String, Object>>> allDataMap = this.getAllData();
            List<Map<String, Object>> partData = this.getPartData(srcTreeNodeId, entryCol);
            if (partData.size() > 0) {
                allDataMap.put(srcTreeNodeId, partData);
            }
            if (selectPartData.size() > 0) {
                allDataMap.put(purPlanId, selectPartData);
            }
            this.allotCurDynamicData(allDataMap, purPlanId);
            this.initTreeData(Long.parseLong(purPlanId));
        }
    }

    private void allotCurDynamicData(Map<String, List<Map<String, Object>>> allDataMap, String purPlanId) {
        ArrayList<Map<String, Object>> allData = new ArrayList<Map<String, Object>>(1024);
        for (Map.Entry<String, List<Map<String, Object>>> map : allDataMap.entrySet()) {
            allData.addAll((Collection<Map<String, Object>>)map.getValue());
        }
        this.allotDynamicEntryData(ENTRY_ALL, allData, "1");
        this.allotDynamicEntryData(ENTRY_PART, allDataMap.get(purPlanId), "");
    }

    public void search(SearchEnterEvent evt) {
        List<Object> treeNodes;
        String name = evt.getText();
        String searchText = evt.getText();
        String srcTreeNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = this.queryNodeByName(name);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.queryNodeByName(name);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            String msg = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"PmmPurOrgEntrysetEdit_6", (String)"scm-malcore-common", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        } else {
            TreeView treeView = (TreeView)this.getControl("treeview");
            TreeNode node = null;
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                node = treeNodes.get(indexCache);
                treeView.showNode(node.getParentid());
                treeView.focusNode(node);
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                node = treeNodes.get(0);
                treeView.showNode(node.getParentid());
                treeView.focusNode(node);
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
                this.getPageCache().put(CACHE_SELECTNODEID, node.getId());
            }
            if ("0".equals(node.getParentid())) {
                this.getPageCache().put(CACHE_SELECTNODEID, node.getId());
                this.setEntryBtnStatus(false);
            } else {
                this.getPageCache().put(CACHE_SELECTNODEID, node.getParentid());
                this.setEntryBtnStatus(true);
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
        Map<String, List<Map<String, Object>>> allDataMap = this.getAllData();
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        List<Map<String, Object>> partData = this.getPartData(srcTreeNodeId, entryCol);
        if (partData.size() > 0) {
            allDataMap.put(srcTreeNodeId, partData);
        }
        this.allotCurDynamicData(allDataMap, this.getPageCache().get(CACHE_SELECTNODEID));
    }

    private List<TreeNode> queryNodeByName(String name) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object protocol = customParams.get("protocolId");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(1024);
        QFilter qFilter = new QFilter("protocol.id", "=", (Object)Long.parseLong(String.valueOf(protocol)));
        QFilter nameQFilter = new QFilter("name", "like", (Object)("%" + name + "%"));
        nameQFilter.or(new QFilter("entryentity.org.name", "like", (Object)("%" + name + "%")));
        qFilter.and(nameQFilter);
        DynamicObjectCollection pmmPurchasePlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,name,entryentity.org.id,entryentity.org.name", (QFilter[])qFilter.toArray(), (String)"createtime asc");
        if (pmmPurchasePlans.size() > 0) {
            Map<Long, List<DynamicObject>> purPlanAndorgsMap = this.getPurPlanAndorgsMap(pmmPurchasePlans);
            String nodeId = "";
            String nodeName = "";
            List<Object> rows = new ArrayList(1024);
            ArrayList<String> purPlanIds = new ArrayList<String>(1024);
            for (Map.Entry<Long, List<DynamicObject>> map : purPlanAndorgsMap.entrySet()) {
                rows = map.getValue();
                String purPlanId = ((DynamicObject)rows.get(0)).getString("id");
                if (((DynamicObject)rows.get(0)).getString("name").contains(name) && !purPlanIds.contains(purPlanId)) {
                    nodeName = ((DynamicObject)rows.get(0)).getString("name");
                    purPlanIds.add(purPlanId);
                    treeNodes.add(new TreeNode("0", purPlanId, nodeName));
                }
                for (DynamicObject dynamicObject : rows) {
                    if (!dynamicObject.getString("entryentity.org.name").contains(name)) continue;
                    nodeId = purPlanId + "_" + dynamicObject.getString("entryentity.org.id");
                    nodeName = dynamicObject.getString("entryentity.org.name");
                    treeNodes.add(new TreeNode(purPlanId, nodeId, nodeName));
                }
            }
        }
        return treeNodes;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if ("material".equals(name)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Object protocol = customParams.get("protocolId");
            QFilter qFilter = new QFilter("protocol", "=", (Object)Long.parseLong(String.valueOf(protocol)));
            DynamicObjectCollection purchaseplans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,name,entryentity.org.id,entryentity.org.name", (QFilter[])qFilter.toArray(), (String)"createtime asc");
            HashMap<Long, void> purChasePlanMap = new HashMap<Long, void>(1024);
            for (DynamicObject row : purchaseplans) {
                void var13_13;
                Long purPlanId = row.getLong("id");
                Long orgId = row.getLong("entryentity.org.id");
                ArrayList arrayList = new ArrayList(1024);
                if (null != purChasePlanMap.get(purPlanId)) {
                    List list = (List)purChasePlanMap.get(purPlanId);
                }
                var13_13.add(orgId);
                purChasePlanMap.put(purPlanId, var13_13);
            }
            String nodeId = this.getPageCache().get(CACHE_SELECTNODEID);
            List curOrgIds = (List)purChasePlanMap.get(Long.parseLong(nodeId));
            ArrayList purPlanIds = new ArrayList(1024);
            block1: for (Map.Entry entry : purChasePlanMap.entrySet()) {
                List orgIds = (List)entry.getValue();
                if (null == curOrgIds || Long.parseLong(nodeId) == (Long)entry.getKey()) continue;
                for (Long orgId : curOrgIds) {
                    if (!orgIds.contains(orgId)) continue;
                    purPlanIds.add(entry.getKey());
                    continue block1;
                }
            }
            DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
            HashSet<Long> hashSet = new HashSet<Long>(1024);
            for (DynamicObject row : entrys) {
                DynamicObject srcMaterial = row.getDynamicObject("material");
                if (null == srcMaterial) continue;
                hashSet.add(srcMaterial.getLong("id"));
            }
            if (purPlanIds.size() > 0) {
                DynamicObjectCollection allEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ALL);
                for (DynamicObject row : allEntrys) {
                    DynamicObject srcMaterial = row.getDynamicObject("material1");
                    String purplanid = row.getString("purplanid1");
                    if (null == srcMaterial || !purPlanIds.contains(Long.parseLong(purplanid))) continue;
                    hashSet.add(srcMaterial.getLong("id"));
                }
            }
            if (hashSet.size() > 0) {
                ListShowParameter fs = (ListShowParameter)e.getFormShowParameter();
                fs.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", hashSet));
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (e.getEntryProp().getName().equals(ENTRY_ALL)) {
            return;
        }
        if (null == this.getPageCache().get("deletePartSeq")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deletePartSeq", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u6e05\u7a7a\uff0c\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"PmmPurOrgEntrysetEdit_9", (String)"scm-malcore-common", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            e.setCancel(true);
            int[] rowIndexs = e.getRowIndexs();
            this.getPageCache().put("deletePartSeq", SerializationUtils.toJsonString((Object)rowIndexs));
        }
    }

    private void deleteEntryBySeq() {
        String deleteseq = this.getPageCache().get("deletePartSeq");
        List rowIndexs = SerializationUtils.fromJsonStringToList((String)deleteseq, String.class);
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        HashSet<String> materialNameSet = new HashSet<String>(1024);
        ArrayList<Integer> seqPartList = new ArrayList<Integer>(1024);
        if (entrys.size() > 0) {
            for (String index : rowIndexs) {
                seqPartList.add(Integer.parseInt(index));
                DynamicObject row = (DynamicObject)entrys.get(Integer.parseInt(index));
                if (StringUtils.isEmpty((CharSequence)row.getString("materialname"))) continue;
                materialNameSet.add(row.getString("materialname"));
            }
        }
        DynamicObjectCollection allEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ALL);
        String curNodeId = this.getPageCache().get(CACHE_SELECTNODEID);
        ArrayList<Integer> seqList = new ArrayList<Integer>(1024);
        for (DynamicObject row : allEntrys) {
            if (!row.getString("purplanid1").equals(curNodeId) || !materialNameSet.contains(row.getString("materialname1"))) continue;
            seqList.add(row.getInt("seq") - 1);
        }
        this.getPageCache().remove("deleteSeq");
        if (seqList.size() > 0) {
            this.getPageCache().put("deleteSeq", SerializationUtils.toJsonString(seqList));
        }
        this.getModel().deleteEntryRows(ENTRY_PART, seqPartList.stream().mapToInt(Integer::intValue).toArray());
        this.getPageCache().remove("deletePartSeq");
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String deleteSeq;
        List seqList;
        super.afterDeleteRow(e);
        if (e.getEntryProp().getName().equals(ENTRY_ALL)) {
            return;
        }
        if (null != this.getPageCache().get("deleteSeq") && (seqList = SerializationUtils.fromJsonStringToList((String)(deleteSeq = this.getPageCache().get("deleteSeq")), Integer.class)).size() > 0) {
            this.getModel().deleteEntryRows(ENTRY_ALL, seqList.stream().mapToInt(Integer::intValue).toArray());
        }
    }
}

