/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.util.prodinfochange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.malcore.util.prodinfochange.domain.PropertyInfoVO;
import kd.scm.malcore.util.prodinfochange.enums.ProdInfoChangeTypeEnum;
import kd.scm.malcore.util.prodinfochange.factory.MalProdInfoChangeFactory;
import kd.scm.malcore.util.prodinfochange.handle.CommonFieldChangeHandle;
import kd.scm.malcore.util.prodinfochange.handle.Impl.ProdAttributeEntryChangeHandleImpl;

public class MalProdInfoChangeUtil {
    private static Log log = LogFactory.getLog(MalProdInfoChangeUtil.class);
    private static final List<String> exceptFields = new ArrayList<String>(Arrays.asList("seq", "id", "masterid", "createtime", "modifytime", "auditdate", "number", "lastupdatetime", "uploaddate", "downloaddate", "catlongnumber", "adjustdate", "uploaddate"));

    public static Map<String, Object> pushProdChgBill(DynamicObject newDataEntity, String billName, String origin) {
        log.info("\u5546\u54c1\u4fe1\u606f\u5f00\u59cb\u8fdb\u884c\u53d8\u66f4");
        Map<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("billid", 0);
        resultMap.put("message", "");
        LinkedHashMap<String, PropertyInfoVO> newValueMap = new LinkedHashMap<String, PropertyInfoVO>();
        LinkedHashMap<String, PropertyInfoVO> oldValueMap = new LinkedHashMap<String, PropertyInfoVO>();
        DynamicObject targetDynamicObject = ORMUtil.newDynamicObject((String)billName);
        long prodId = newDataEntity.getLong("id");
        log.info("\u53d8\u66f4\u5546\u54c1id" + prodId);
        DynamicObject oldDataEntity = QueryRecordUtil.queryRecordSet((String)"pmm_prodmanage", (String)"id", (String)"id", (Object)prodId, null, null, null, null, null, null, null, (String)"loadBill", null);
        if (oldDataEntity == null) {
            return resultMap;
        }
        DynamicObjectCollection tgtChangeEntry = targetDynamicObject.getDynamicObjectCollection("entryentity");
        tgtChangeEntry.clear();
        MalProdInfoChangeUtil.readPropValue(oldDataEntity, oldValueMap);
        MalProdInfoChangeUtil.readPropValue(newDataEntity, newValueMap);
        log.info("\u5f00\u59cb\u5dee\u5f02\u6bd4\u8f83\uff0c\u5e76\u65b0\u589e\u5206\u5f55");
        MalProdInfoChangeUtil.compareAndCreateEntry(newValueMap, oldValueMap, targetDynamicObject);
        MalProdInfoChangeUtil.entrySeqDeal(targetDynamicObject);
        MalProdInfoChangeUtil.setDefault(origin, newDataEntity, targetDynamicObject);
        String validMsg = MalProdInfoChangeUtil.checkValid(targetDynamicObject);
        if (StringUtils.isNotBlank((CharSequence)validMsg)) {
            resultMap.put("succed", false);
            resultMap.put("message", validMsg);
            return resultMap;
        }
        resultMap = MalProdInfoChangeUtil.saveDynamicObject(billName, targetDynamicObject);
        log.info("\u4fdd\u5b58\u4fe1\u606f\u6210\u529f" + targetDynamicObject.getPkValue());
        resultMap.put("billid", targetDynamicObject.getPkValue());
        return resultMap;
    }

    private static void readPropValue(DynamicObject dataEntity, Map<String, PropertyInfoVO> valueMap) {
        IDataEntityType dType = dataEntity.getDataEntityType();
        for (IDataEntityProperty property : dType.getProperties()) {
            String propName = property.getName();
            if (exceptFields.contains(propName)) continue;
            CommonFieldChangeHandle fieldChangeHandle = MalProdInfoChangeFactory.getFieldChangeHandleByProperty(property);
            PropertyInfoVO propertyInfoVO = fieldChangeHandle.initPropertyInfoVO(dataEntity, property);
            fieldChangeHandle.getFieldInfo(valueMap, dataEntity, property, propertyInfoVO);
        }
    }

    private static void compareAndCreateEntry(Map<String, PropertyInfoVO> newValueMap, Map<String, PropertyInfoVO> oldValueMap, DynamicObject targetDynamicObject) {
        for (Map.Entry<String, PropertyInfoVO> entryMap : oldValueMap.entrySet()) {
            boolean isEqual;
            PropertyInfoVO oldPropertyInfoVO = entryMap.getValue();
            PropertyInfoVO newPropertyInfoVO = newValueMap.get(entryMap.getKey());
            if (oldPropertyInfoVO == null || newPropertyInfoVO == null) continue;
            if (Objects.isNull(oldPropertyInfoVO.getPropValue()) && Objects.isNull(newPropertyInfoVO.getPropValue()) || Objects.isNull(oldPropertyInfoVO.getPropDisplayName()) || Objects.isNull(newPropertyInfoVO.getPropDisplayName())) {
                newValueMap.remove(entryMap.getKey());
                continue;
            }
            String infoType = oldPropertyInfoVO.getInfoType();
            CommonFieldChangeHandle fieldChangeHandle = MalProdInfoChangeFactory.getFieldChangeHandleByInfoType(infoType);
            if (ProdInfoChangeTypeEnum.ENTRY.getVal().equals(oldPropertyInfoVO.getInfoType()) && "prodattributeentry".equals(oldPropertyInfoVO.getPropName())) {
                fieldChangeHandle = new ProdAttributeEntryChangeHandleImpl();
            }
            if (isEqual = fieldChangeHandle.propValueCompare(oldPropertyInfoVO, newPropertyInfoVO)) {
                newValueMap.remove(entryMap.getKey());
                continue;
            }
            fieldChangeHandle.insertValueToDyn(oldPropertyInfoVO, newPropertyInfoVO, targetDynamicObject);
        }
    }

    private static void entrySeqDeal(DynamicObject targetDynamicObject) {
        DynamicObjectCollection entryEntity = targetDynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            String fieldName = entry.getString("fieldname");
            if ("taxrateid".equals(fieldName) || "taxrate".equals(fieldName)) {
                entry.set("seq", (Object)(entryEntity.size() + 1));
            }
            if (!"content_tag".equals(fieldName) && !"specification_tag".equals(fieldName)) continue;
            entry.set("seq", (Object)(entryEntity.size() + 2));
        }
    }

    private static void setDefault(String origin, DynamicObject newDataEntity, DynamicObject tgtDataEntity) {
        Date currDate = TimeServiceHelper.now();
        tgtDataEntity.set("org_id", (Object)MalProdInfoChangeUtil.setOrgValue(origin, newDataEntity));
        tgtDataEntity.set("billdate", (Object)currDate);
        tgtDataEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
        tgtDataEntity.set("cfmstatus", null);
        tgtDataEntity.set("creator", (Object)RequestContext.get().getCurrUserId());
        tgtDataEntity.set("createtime", (Object)currDate);
        tgtDataEntity.set("origin", (Object)origin);
        tgtDataEntity.set("prod_id", (Object)newDataEntity.getLong("id"));
        tgtDataEntity.set("supplier", (Object)newDataEntity.getLong("supplier_id"));
    }

    private static Long setOrgValue(String origin, DynamicObject newDataEntity) {
        long createOrg = newDataEntity.getLong("createorg.id");
        if ("2".equals(origin)) {
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_prodchange_manage", (String)"47156aff000000ac");
            List permissionOrgs = hasPermOrgResult.getHasPermOrgs();
            if (hasPermOrgResult.hasAllOrgPerm() || permissionOrgs.contains(createOrg)) {
                return createOrg;
            }
            if (permissionOrgs.contains(RequestContext.get().getOrgId())) {
                return RequestContext.get().getOrgId();
            }
            return (Long)permissionOrgs.get(0);
        }
        return createOrg;
    }

    private static String checkValid(DynamicObject prodChgDyn) {
        if (!MalProdInfoChangeUtil.hasChangeField(prodChgDyn)) {
            return ResManager.loadKDString((String)"\u5546\u54c1\u672a\u53d1\u751f\u53d8\u66f4\u3002", (String)"MalProdInfoChangeUtil_3", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        if (MalProdInfoChangeUtil.checkChangeFieldInfluenceMalOrder(prodChgDyn) && QueryServiceHelper.exists((String)"mal_order", (QFilter[])new QFilter("entryentity.goods", "=", (Object)prodChgDyn.getLong("prod_id")).toArray())) {
            return ResManager.loadKDString((String)"\u5546\u54c1\u5df2\u5173\u8054\u8ba2\u5355\uff0c\u90e8\u5206\u4fe1\u606f\u4e0d\u80fd\u4fee\u6539\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u53d1\u8d77\u3002", (String)"MalProdInfoChangeUtil_4", (String)"scm-ent-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private static Map<String, Object> saveDynamicObject(String metaData, DynamicObject billObj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        try {
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)metaData, (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)option);
            resultMap.put("succed", saveResult.isSuccess());
            if (!saveResult.isSuccess()) {
                StringBuilder errMsg = new StringBuilder();
                for (int i = 0; i < saveResult.getAllErrorOrValidateInfo().size(); ++i) {
                    errMsg.append(((IOperateInfo)saveResult.getAllErrorOrValidateInfo().get(i)).getMessage()).append('\t');
                }
                resultMap.put("message", errMsg + "\n" + ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u9879\u662f\u5426\u90fd\u5df2\u7ecf\u5f55\u5165\u3002", (String)"MalProdInfoChangeUtil_0", (String)"scm-common", (Object[])new Object[0]));
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"MalProdInfoChangeUtil_1", (String)"scm-common", (Object[])new Object[0]) + errMsg);
            }
            resultMap.put("message", saveResult.getMessage());
            return resultMap;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"@@\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"MalProdInfoChangeUtil_2", (String)"scm-common", (Object[])new Object[0]) + e.getMessage());
        }
    }

    public static boolean hasChangeField(DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (!entryEntity.isEmpty()) {
            return true;
        }
        List<String> pictureList = Arrays.asList("thumbnail", "picture1", "picture2", "picture3", "picture4");
        for (String picture : pictureList) {
            if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString(picture)) && !StringUtils.isNotBlank((CharSequence)dynamicObject.getString("old" + picture))) continue;
            return true;
        }
        return false;
    }

    public static boolean checkChangeFieldInfluenceMalOrder(DynamicObject prodChgDyn) {
        HashSet<String> invalidChangeField = new HashSet<String>(Arrays.asList("name", "model", "brand", "taxrateid", "content_tag", "specification_tag", "prodattribute", "prodattributevalue", "packinglist", "guarantee"));
        DynamicObjectCollection entryEntity = prodChgDyn.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            String fieldName = entry.getString("fieldname");
            if (!invalidChangeField.contains(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAttributeChangeInfluenceSPU(DynamicObject prodChgDyn) {
        DynamicObjectCollection entryEntity = prodChgDyn.getDynamicObjectCollection("entryentity");
        if (entryEntity.isEmpty()) {
            return false;
        }
        HashSet<Long> attributeChangeEntryIds = new HashSet<Long>(entryEntity.size());
        HashSet<Long> attributeValueChangeEntryIds = new HashSet<Long>(entryEntity.size());
        HashSet<Long> changeEntryIds = new HashSet<Long>(entryEntity.size());
        HashSet<String> addAttributes = new HashSet<String>(entryEntity.size());
        HashSet<String> addAttributeValues = new HashSet<String>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            if ("prodattributeentry".equals(entry.getString("entryname")) && "prodattribute".equals(entry.getString("fieldname"))) {
                if (StringUtils.isNotBlank((CharSequence)entry.getString("oldvalue"))) {
                    attributeChangeEntryIds.add(Long.parseLong(entry.getString("srcbillentryid")));
                    changeEntryIds.add(Long.parseLong(entry.getString("srcbillentryid")));
                }
                if (StringUtils.isNotBlank((CharSequence)entry.getString("newvalue"))) {
                    addAttributes.add(entry.getString("srcdata"));
                }
            }
            if (!"prodattributeentry".equals(entry.getString("entryname")) || !"prodattributevalue".equals(entry.getString("fieldname"))) continue;
            if (StringUtils.isNotBlank((CharSequence)entry.getString("oldvalue"))) {
                attributeValueChangeEntryIds.add(Long.parseLong(entry.getString("srcbillentryid")));
                changeEntryIds.add(Long.parseLong(entry.getString("srcbillentryid")));
            }
            if (!StringUtils.isNotBlank((CharSequence)entry.getString("newvalue"))) continue;
            addAttributeValues.add(entry.getString("srcdata"));
        }
        QFilter qFilter = new QFilter("prodattributeentry.id", "in", changeEntryIds);
        DynamicObjectCollection prodAttributes = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"prodattributeentry.id prodattributeentry,prodattributeentry.prodattribute prodattribute,prodattributeentry.prodattributevalue prodattributevalue", (QFilter[])qFilter.toArray());
        HashSet<String> deleteProdAttribute = new HashSet<String>(prodAttributes.size());
        HashSet<String> deleteProdAttributeValue = new HashSet<String>(prodAttributes.size());
        for (DynamicObject dynamicObject : prodAttributes) {
            if (attributeChangeEntryIds.contains(dynamicObject.getLong("prodattributeentry"))) {
                deleteProdAttribute.add(dynamicObject.getString("prodattribute"));
            }
            if (!attributeValueChangeEntryIds.contains(dynamicObject.getLong("prodattributeentry"))) continue;
            deleteProdAttributeValue.add(dynamicObject.getString("prodattributevalue"));
        }
        for (String string : addAttributes) {
            deleteProdAttribute.remove(string);
        }
        for (String string : addAttributeValues) {
            deleteProdAttributeValue.remove(string);
        }
        if (addAttributes.size() > 0) {
            HashSet<Long> attrIds = new HashSet<Long>(6);
            for (String key : addAttributes) {
                attrIds.add(Long.parseLong(key));
            }
            QFilter qFilter2 = new QFilter("id", "in", attrIds);
            qFilter2.and(new QFilter("attributetype", "=", (Object)"1"));
            boolean exists = QueryServiceHelper.exists((String)"pmm_prodattribute", (QFilter[])qFilter2.toArray());
            if (exists) {
                return true;
            }
        }
        if (attributeChangeEntryIds.isEmpty()) {
            return false;
        }
        long goodsId = prodChgDyn.getLong("prod_id");
        String spuNumber = prodChgDyn.getString("prod.spunumber");
        QFilter qFilterSpu = new QFilter("spuskumapentry.goods", "=", (Object)goodsId);
        qFilterSpu.and("number", "=", (Object)spuNumber);
        DynamicObjectCollection spus = QueryServiceHelper.query((String)"pmm_spu", (String)"baseattributeentry.prodattribute prodattribute,spuskumapentry.spuatrdetailentry.saleprodattributevalueid saleprodattributevalueid", (QFilter[])qFilterSpu.toArray());
        for (DynamicObject spu : spus) {
            if (deleteProdAttribute.contains(spu.getString("prodattribute"))) {
                return true;
            }
            if (!deleteProdAttributeValue.contains(spu.getString("saleprodattributevalueid"))) continue;
            return true;
        }
        return false;
    }
}

