/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.util.prodinfochange.factory;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.CollectionProperty;
import kd.bos.dataentity.metadata.clr.ComplexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PictureProp;
import kd.scm.malcore.util.prodinfochange.enums.ProdInfoChangeTypeEnum;
import kd.scm.malcore.util.prodinfochange.handle.CommonFieldChangeHandle;
import kd.scm.malcore.util.prodinfochange.handle.Impl.BaseDataPropChangeHandleImpl;
import kd.scm.malcore.util.prodinfochange.handle.Impl.DecimalPropChangeHandleImpl;
import kd.scm.malcore.util.prodinfochange.handle.Impl.EntryPropChangeHandleImpl;
import kd.scm.malcore.util.prodinfochange.handle.Impl.PicturePropChangeHandleImpl;
import kd.scm.malcore.util.prodinfochange.handle.Impl.ProdAttributeEntryChangeHandleImpl;

public class MalProdInfoChangeFactory {
    private static final String PRODATTRIBUTEENTRY = "prodattributeentry";

    public static CommonFieldChangeHandle getFieldChangeHandleByProperty(IDataEntityProperty property) {
        CommonFieldChangeHandle commonFieldChangeHandle = new CommonFieldChangeHandle();
        if (property instanceof CollectionProperty || property instanceof EntryProp) {
            commonFieldChangeHandle = new EntryPropChangeHandleImpl();
            if (PRODATTRIBUTEENTRY.equals(property.getName())) {
                commonFieldChangeHandle = new ProdAttributeEntryChangeHandleImpl();
            }
        } else if (property instanceof PictureProp) {
            commonFieldChangeHandle = new PicturePropChangeHandleImpl();
        } else if (property instanceof ComplexProperty || property instanceof BasedataProp) {
            commonFieldChangeHandle = new BaseDataPropChangeHandleImpl();
        } else if (property instanceof DecimalProp) {
            commonFieldChangeHandle = new DecimalPropChangeHandleImpl();
        }
        return commonFieldChangeHandle;
    }

    public static CommonFieldChangeHandle getFieldChangeHandleByInfoType(String infoType) {
        CommonFieldChangeHandle commonFieldChangeHandle = new CommonFieldChangeHandle();
        ProdInfoChangeTypeEnum prodInfoChangeTypeEnum = ProdInfoChangeTypeEnum.fromVal(infoType);
        switch (prodInfoChangeTypeEnum) {
            case BASEDATA: {
                commonFieldChangeHandle = new BaseDataPropChangeHandleImpl();
                break;
            }
            case PICTURE: {
                commonFieldChangeHandle = new PicturePropChangeHandleImpl();
                break;
            }
            case ENTRY: {
                commonFieldChangeHandle = new EntryPropChangeHandleImpl();
                break;
            }
            case NUM: {
                commonFieldChangeHandle = new DecimalPropChangeHandleImpl();
            }
        }
        return commonFieldChangeHandle;
    }
}

