/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.malcore.util.prodinfochange.handle.Impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.EntryProp;
import kd.scm.malcore.util.prodinfochange.domain.PropertyInfoVO;
import kd.scm.malcore.util.prodinfochange.enums.ProdInfoChangeTypeEnum;
import kd.scm.malcore.util.prodinfochange.handle.Impl.EntryPropChangeHandleImpl;

public class ProdAttributeEntryChangeHandleImpl
extends EntryPropChangeHandleImpl {
    private static String PRODATTRIBUTE = "prodattribute";
    private static String PRODATTRIBUTENAME = "prodattributename";
    private static String PRODATTRIBUTEVALUE = "prodattributevalue";
    private static String PRODATTRIBUTE_ID = "prodattribute_id";
    private static String PRODATTRIBUTEVALUE_ID = "prodattributevalue_id";
    private static String ATTRIBUTEADD = "attributeadd";
    private static String ATTRIBUTEDELETE = "attributedelete";
    private static String ATTRIBUTEUPDATE = "attributeupdate";

    @Override
    public void getFieldInfo(Map<String, PropertyInfoVO> valueMap, DynamicObject dataEntity, IDataEntityProperty property, PropertyInfoVO propertyInfoVO) {
        propertyInfoVO.setInfoType(ProdInfoChangeTypeEnum.ENTRY.getVal());
        propertyInfoVO.setPropValue(dataEntity.get(property));
        valueMap.put(propertyInfoVO.getKey(), propertyInfoVO);
    }

    @Override
    public boolean propValueCompare(PropertyInfoVO oldPropertyInfoVO, PropertyInfoVO newPropertyInfoVO) {
        DynamicObjectCollection oldPropValue = (DynamicObjectCollection)oldPropertyInfoVO.getPropValue();
        DynamicObjectCollection newPropValue = (DynamicObjectCollection)newPropertyInfoVO.getPropValue();
        if (Objects.isNull(oldPropValue) && Objects.isNull(newPropValue)) {
            return true;
        }
        if (Objects.isNull(oldPropValue) || Objects.isNull(newPropValue)) {
            return false;
        }
        if (oldPropValue.size() != newPropValue.size()) {
            return false;
        }
        Map<String, String> oldEntryMap = oldPropValue.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString(PRODATTRIBUTE_ID), dynamicObject -> dynamicObject.getString(PRODATTRIBUTEVALUE_ID)));
        Map<String, Integer> oldEntrySeqMap = oldPropValue.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString(PRODATTRIBUTE_ID), dynamicObject -> dynamicObject.getInt("seq")));
        for (DynamicObject newEntry : newPropValue) {
            String id = newEntry.getString(PRODATTRIBUTE_ID);
            String oldEntry = oldEntryMap.get(id);
            if (oldEntry == null) {
                return false;
            }
            if (!oldEntry.equals(newEntry.getString(PRODATTRIBUTEVALUE_ID))) {
                return false;
            }
            if (oldEntrySeqMap.get(id).intValue() == newEntry.getInt("seq")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void insertValueToDyn(PropertyInfoVO oldPropertyInfoVO, PropertyInfoVO newPropertyInfoVO, DynamicObject targetDynamicObject) {
        DynamicObjectCollection oldPropValue = (DynamicObjectCollection)oldPropertyInfoVO.getPropValue();
        DynamicObjectCollection newPropValue = (DynamicObjectCollection)newPropertyInfoVO.getPropValue();
        if (oldPropValue == null) {
            this.attributeAdd((List<DynamicObject>)newPropValue, targetDynamicObject);
        } else if (newPropValue == null) {
            this.attributeDelete((List<DynamicObject>)oldPropValue, targetDynamicObject);
        } else {
            this.entryCompareAndInsert(oldPropValue, newPropValue, targetDynamicObject);
        }
    }

    private void entryInsert(DynamicObject targetDynamicObject, DynamicObject oldEntryDyn, DynamicObject newEntryDyn, String fieldName) {
        DynamicObject dynamicObject = oldEntryDyn != null ? oldEntryDyn : newEntryDyn;
        EntryProp entryProp = (EntryProp)targetDynamicObject.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject tempRow = new DynamicObject((DynamicObjectType)entryType);
        tempRow.set("chgfield", (Object)((IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)fieldName)).getDisplayName().toString());
        if (newEntryDyn != null) {
            tempRow.set("newvalue", newEntryDyn.getDynamicObject(fieldName).get("name"));
            tempRow.set("entryseq", (Object)newEntryDyn.getString("seq"));
            tempRow.set("seq", (Object)newEntryDyn.getInt("seq"));
            tempRow.set("srcdata", (Object)newEntryDyn.getString(fieldName + "_id"));
        }
        if (oldEntryDyn != null) {
            tempRow.set("oldvalue", oldEntryDyn.getDynamicObject(fieldName).get("name"));
            tempRow.set("srcbillentryid", (Object)oldEntryDyn.getString("id"));
        }
        tempRow.set("fieldname", (Object)fieldName);
        tempRow.set("infotype", (Object)ProdInfoChangeTypeEnum.BASEDATA.getVal());
        tempRow.set("entryname", (Object)"prodattributeentry");
        DynamicObjectCollection tgtChangeEntry = targetDynamicObject.getDynamicObjectCollection("entryentity");
        tgtChangeEntry.add((Object)tempRow);
    }

    private void entrySeqChangeInsert(DynamicObject oldEntryDyn, DynamicObject newEntryDyn, DynamicObject targetDynamicObject) {
        EntryProp entryProp = (EntryProp)targetDynamicObject.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObject tempRow = new DynamicObject((DynamicObjectType)entryType);
        tempRow.set("chgfield", (Object)((IDataEntityProperty)newEntryDyn.getDataEntityType().getProperties().get((Object)"seq")).getDisplayName().toString());
        tempRow.set("oldvalue", (Object)oldEntryDyn.getInt("seq"));
        tempRow.set("srcbillentryid", (Object)oldEntryDyn.getString("id"));
        tempRow.set("newvalue", (Object)newEntryDyn.getInt("seq"));
        tempRow.set("entryseq", (Object)newEntryDyn.getString("seq"));
        tempRow.set("seq", (Object)newEntryDyn.getInt("seq"));
        tempRow.set("srcdata", (Object)newEntryDyn.getString(PRODATTRIBUTE_ID));
        tempRow.set("fieldname", (Object)"seq");
        tempRow.set("infotype", (Object)ProdInfoChangeTypeEnum.CHAR.getVal());
        tempRow.set("entryname", (Object)"prodattributeentry");
        DynamicObjectCollection tgtChangeEntry = targetDynamicObject.getDynamicObjectCollection("entryentity");
        tgtChangeEntry.add((Object)tempRow);
    }

    private void entryCompareAndInsert(DynamicObjectCollection oldPropValue, DynamicObjectCollection newPropValue, DynamicObject targetDynamicObject) {
        Map<String, DynamicObject> oldEntryMap = oldPropValue.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString(PRODATTRIBUTE_ID), dynamicObject -> dynamicObject));
        Map<String, DynamicObject> newEntryMap = newPropValue.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString(PRODATTRIBUTE_ID), Collectors.collectingAndThen(Collectors.toList(), list -> (DynamicObject)list.get(0))));
        Iterator<Map.Entry<String, DynamicObject>> iterator = oldEntryMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int newAttrSeq;
            int oldAttrSeq;
            long newAttValueId;
            Map.Entry<String, DynamicObject> key = iterator.next();
            if (!newEntryMap.containsKey(key.getKey())) continue;
            DynamicObject oldEntry = key.getValue();
            DynamicObject newEntry = newEntryMap.get(key.getKey());
            long oldAttValueId = oldEntry.getLong(PRODATTRIBUTEVALUE_ID);
            if (oldAttValueId != (newAttValueId = newEntry.getLong(PRODATTRIBUTEVALUE_ID))) {
                this.entryInsert(targetDynamicObject, oldEntry, newEntry, PRODATTRIBUTEVALUE);
                String attributeAddText = targetDynamicObject.getString(ATTRIBUTEUPDATE);
                attributeAddText = this.attributeTextDeal(attributeAddText, newEntry);
                targetDynamicObject.set(ATTRIBUTEUPDATE, (Object)attributeAddText);
            }
            if ((oldAttrSeq = oldEntry.getInt("seq")) != (newAttrSeq = newEntry.getInt("seq"))) {
                this.entrySeqChangeInsert(oldEntry, newEntry, targetDynamicObject);
                this.attrSeqChangeTextAdd(newEntry, targetDynamicObject);
            }
            iterator.remove();
            newEntryMap.remove(key.getKey());
        }
        this.attributeAdd(new ArrayList<DynamicObject>(newEntryMap.values()), targetDynamicObject);
        this.attributeDelete(new ArrayList<DynamicObject>(oldEntryMap.values()), targetDynamicObject);
    }

    private void attributeAdd(List<DynamicObject> newPropValue, DynamicObject targetDynamicObject) {
        for (DynamicObject dynamicObject : newPropValue) {
            String attributeAddText = targetDynamicObject.getString(ATTRIBUTEADD);
            attributeAddText = this.attributeTextDeal(attributeAddText, dynamicObject);
            targetDynamicObject.set(ATTRIBUTEADD, (Object)attributeAddText);
            this.entryInsert(targetDynamicObject, null, dynamicObject, PRODATTRIBUTE);
            this.entryInsert(targetDynamicObject, null, dynamicObject, PRODATTRIBUTEVALUE);
        }
    }

    private void attributeDelete(List<DynamicObject> oldPropValue, DynamicObject targetDynamicObject) {
        for (DynamicObject dynamicObject : oldPropValue) {
            String attributeDeleteText = targetDynamicObject.getString(ATTRIBUTEDELETE);
            attributeDeleteText = this.attributeTextDeal(attributeDeleteText, dynamicObject);
            targetDynamicObject.set(ATTRIBUTEDELETE, (Object)attributeDeleteText);
            this.entryInsert(targetDynamicObject, dynamicObject, null, PRODATTRIBUTE);
            this.entryInsert(targetDynamicObject, dynamicObject, null, PRODATTRIBUTEVALUE);
        }
    }

    private String attributeTextDeal(String oldText, DynamicObject dynamicObject) {
        String attributeName = "";
        String attributeValueName = "";
        if (dynamicObject.getDynamicObject(PRODATTRIBUTE) != null && dynamicObject.getDynamicObject(PRODATTRIBUTE).getDynamicObject(PRODATTRIBUTENAME) != null) {
            attributeName = dynamicObject.getDynamicObject(PRODATTRIBUTE).getDynamicObject(PRODATTRIBUTENAME).getString("name");
        }
        if (dynamicObject.getDynamicObject(PRODATTRIBUTEVALUE) != null) {
            attributeValueName = dynamicObject.getDynamicObject(PRODATTRIBUTEVALUE).getString("name");
        }
        return this.attributeTextAdd(oldText, attributeName, attributeValueName);
    }

    private String attributeTextAdd(String oldText, String attributeName, String attributeValueName) {
        if (StringUtils.isNotBlank((CharSequence)oldText)) {
            oldText = oldText + "\u3001";
        }
        oldText = oldText + attributeName + "\u3010" + attributeValueName + "\u3011";
        return oldText;
    }

    private void attrSeqChangeTextAdd(DynamicObject newEntry, DynamicObject targetDynamicObject) {
        String attributeAddText = targetDynamicObject.getString(ATTRIBUTEUPDATE);
        String attributeName = "";
        int newAttrSeq = newEntry.getInt("seq");
        if (newEntry.getDynamicObject(PRODATTRIBUTE) != null && newEntry.getDynamicObject(PRODATTRIBUTE).getDynamicObject(PRODATTRIBUTENAME) != null) {
            attributeName = newEntry.getDynamicObject(PRODATTRIBUTE).getDynamicObject(PRODATTRIBUTENAME).getString("name");
        }
        if (StringUtils.isNotBlank((CharSequence)attributeAddText)) {
            attributeAddText = attributeAddText + "\u3001";
        }
        attributeAddText = attributeAddText + attributeName + ResManager.loadKDString((String)"\u3010\u5e8f\u53f7", (String)"ProdAttributeEntryChangeHandleImpl_0", (String)"scm-malcore-common", (Object[])new Object[0]) + newAttrSeq + "\u3011";
        targetDynamicObject.set(ATTRIBUTEUPDATE, (Object)attributeAddText);
    }

    @Override
    public void changeEffectUpdateProd(DynamicObject chgDyn, DynamicObject prod) {
        String entryId;
        DynamicObjectCollection entryEntity = chgDyn.getDynamicObjectCollection("entryentity");
        LinkedHashMap<String, Map> oldEntryChangeMap = new LinkedHashMap<String, Map>(entryEntity.size());
        LinkedHashMap<String, Map> newEntryChangeMap = new LinkedHashMap<String, Map>(entryEntity.size());
        LinkedHashMap<String, Integer> entrySeqChangeMap = new LinkedHashMap<String, Integer>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            Map valueMap;
            if (!"prodattributeentry".equals(entry.getString("entryname"))) continue;
            if ("seq".equals(entry.getString("fieldname"))) {
                String entryId2 = entry.getString("srcbillentryid");
                entrySeqChangeMap.put(entryId2, Integer.valueOf(entry.getString("newvalue")));
                continue;
            }
            String oldValue = entry.getString("oldvalue");
            entryId = entry.getString("srcbillentryid");
            String baseDataId = entry.getString("srcdata");
            String entrySeq = entry.getString("entryseq");
            String fieldName = entry.getString("fieldname");
            if (StringUtils.isBlank((CharSequence)oldValue)) {
                valueMap = newEntryChangeMap.computeIfAbsent(entrySeq, s -> new HashMap(8));
                valueMap.put(fieldName, baseDataId);
                continue;
            }
            valueMap = oldEntryChangeMap.computeIfAbsent(entryId, s -> new HashMap(8));
            valueMap.put(fieldName, baseDataId);
        }
        DynamicObjectCollection prodAttributeEntry = prod.getDynamicObjectCollection("prodattributeentry");
        Iterator iterator = prodAttributeEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            entryId = entry.getString("id");
            if (oldEntryChangeMap.containsKey(entryId)) {
                Map valueMap = (Map)oldEntryChangeMap.get(entryId);
                for (Map.Entry valueEntry : valueMap.entrySet()) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)valueEntry.getValue()))) {
                        iterator.remove();
                        break;
                    }
                    entry.set((String)valueEntry.getKey(), (Object)Long.valueOf((String)valueEntry.getValue()));
                }
            }
            if (!entrySeqChangeMap.containsKey(entryId)) continue;
            Integer newSeq = (Integer)entrySeqChangeMap.get(entryId);
            entry.set("seq", (Object)newSeq);
        }
        for (Map.Entry valueEntry : newEntryChangeMap.entrySet()) {
            DynamicObject newEntry = prodAttributeEntry.addNew();
            newEntry.set("seq", (Object)Integer.valueOf((String)valueEntry.getKey()));
            for (Map.Entry newValueEntry : ((Map)valueEntry.getValue()).entrySet()) {
                newEntry.set((String)newValueEntry.getKey(), (Object)Long.valueOf((String)newValueEntry.getValue()));
            }
        }
    }
}

