/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.unit.multisystemjoint;

import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointException;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.api.IMultiPushDataHandler;
import kd.scm.common.helper.multisystemjoint.param.engine.AbstractMultiPushHandler;
import kd.scm.common.helper.multisystemjoint.param.engine.MultiCosmicPushHandler;
import kd.scm.common.helper.multisystemjoint.param.engine.MultiIscCosmicPushHandler;

public final class MultiDestructivePushHandler
extends AbstractMultiPushHandler
implements IMultiPushDataHandler {
    private SecureRandom rand;
    private final MultiCosmicPushHandler delegateHandler;
    private final MultiIscCosmicPushHandler delegateIscHandler;

    public MultiDestructivePushHandler() {
        block2: {
            try {
                this.rand = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Throwable)e);
            }
        }
        this.delegateHandler = new MultiCosmicPushHandler();
        this.delegateIscHandler = new MultiIscCosmicPushHandler();
    }

    public void callIdempotentCheck(ScMultiParamArgs multiParamArgs) {
        super.callIdempotentCheck(multiParamArgs);
    }

    protected void doExecute(MultiDataHandleResult multiDataHandleResult, ScMultiParamArgs scMultiParamArgs) {
        int nextInt = this.rand.nextInt(256);
        if (nextInt < 60) {
            throw new Error("\u7834\u574f\u6027\u6d4b\u8bd5\u8bf7\u6c42\u5f02\u6784\u7cfb\u7edf\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684");
        }
        if (nextInt >= 124 && nextInt < 164) {
            try {
                throw new UnknownHostException("\u7834\u574f\u6027\u6d4b\u8bd5\u8bf7\u6c42\u5f02\u6784\u7cfb\u7edf\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684");
            }
            catch (UnknownHostException e) {
                throw new MultiSystemJointException(String.valueOf(e.getMessage()), (Throwable)e);
            }
        }
        if (nextInt >= 165 && nextInt < 255) {
            try {
                throw new NoRouteToHostException("\u7834\u574f\u6027\u6d4b\u8bd5\u8bf7\u6c42\u5f02\u6784\u7cfb\u7edf\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684");
            }
            catch (NoRouteToHostException e) {
                throw new MultiSystemJointException(String.valueOf(e.getMessage()), (Throwable)e);
            }
        }
        this.delegateHandler.executePush(multiDataHandleResult, scMultiParamArgs);
        this.delegateIscHandler.executePush(multiDataHandleResult, scMultiParamArgs);
    }
}

