/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.unit.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;

public class UnitTestUtil {
    private static Log log = LogFactory.getLog(UnitTestUtil.class);

    private static IFormView getViewByAppId(String appId, IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        String pageId = UnitTestUtil.getPageIdByAppId(appId, view.getPageId(), params, junit);
        junit.loadData(pageId);
        return junit.getView(pageId);
    }

    public static String invokeActionForAppId(String appId, String currentPageId, String params, AbstractJUnitTestPlugIn junit) {
        return UnitTestUtil.checkInfo("" + DispatchServiceHelper.invokeBOSService((String)appId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{currentPageId, params}));
    }

    public static String getPageIdByAppId(String appId, IFormView view, String params, AbstractJUnitTestPlugIn junit) {
        return UnitTestUtil.getPageIdByAppId(appId, view.getPageId(), params, junit);
    }

    public static String getPageIdByAppId(String appId, String params, AbstractJUnitTestPlugIn junit) {
        return UnitTestUtil.getPageIdByAppId(appId, junit.getView().getPageId(), params, junit);
    }

    public static String getPageIdByAppId(String appId, String currentPageId, String params, AbstractJUnitTestPlugIn junit) {
        Pattern p;
        Matcher m;
        String pageId = "";
        String callBackArg = UnitTestUtil.invokeActionForAppId(appId, currentPageId, params, junit);
        log.info(callBackArg);
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String pageIdStr;
                if (!(result.get(j) instanceof Map) || (pageIdStr = (String)(map = (Map)result.get(j)).get("pageId")) == null) continue;
                pageId = pageIdStr;
            }
        }
        if (StringUtils.isBlank((CharSequence)pageId) && (m = (p = Pattern.compile(",\"pageId\":\"(.+?)\"")).matcher(callBackArg)).find()) {
            pageId = m.group(1);
        }
        return pageId;
    }

    public static String getPageIdByAppIdTypeShowForm(String appId, String currentPageId, String params, AbstractJUnitTestPlugIn junit) {
        Pattern p;
        Matcher m;
        String pageId = "";
        String callBackArg = UnitTestUtil.invokeActionForAppId(appId, currentPageId, params, junit);
        log.info(callBackArg);
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            Object type = ((Map)results.get(i)).get("a");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String pageIdStr;
                if (!(result.get(j) instanceof Map) || (pageIdStr = (String)(map = (Map)result.get(j)).get("pageId")) == null || !"showForm".equals(type.toString())) continue;
                pageId = pageIdStr;
            }
        }
        if (StringUtils.isBlank((CharSequence)pageId) && (m = (p = Pattern.compile(",\"pageId\":\"(.+?)\"")).matcher(callBackArg)).find()) {
            pageId = m.group(1);
        }
        return pageId;
    }

    private static String checkInfo(String info) {
        if (info.contains("error") && !info.contains("errorcode_001")) {
            throw new RuntimeException(info);
        }
        return info;
    }

    public static void release(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"\",\"methodName\":\"release\",\"args\":[{}],\"postData\":[]}]", junit);
    }

    public static void close(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_close\",\"close\"],\"postData\":[{},[]]}]", junit);
    }

    public static void editSubmit(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"barsubmit\",\"submit\"],\"postData\":[{},[]]}]", junit);
    }

    public static void editAudit(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"baraudit\",\"audit\"],\"postData\":[{},[]]}]", junit);
    }

    public static void editUnAudit(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"barunaudit\",\"unaudit\"],\"postData\":[{},[]]}]", junit);
    }

    public static void editUnSubmit(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"barunsubmit\",\"unsubmit\"],\"postData\":[{},[]]}]", junit);
    }

    public static void editDelete(String appId, String pageId, AbstractJUnitTestPlugIn junit) {
        UnitTestUtil.invokeActionForAppId(appId, pageId, "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bardelete\",\"delete\"],\"postData\":[{},[]]}]", junit);
    }
}

