/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.parent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.cal.MultCurrencyCalImpl;

public class AbstractMultCurrencyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private MultCurrencyCalImpl currCal = new MultCurrencyCalImpl();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit quotecurr = (BasedataEdit)this.getView().getControl("quotecurr");
        if (quotecurr != null) {
            quotecurr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection details = this.getModel().getDataEntity().getDynamicObjectCollection(this.getEntryEntity());
        if (details != null && details.size() > 0) {
            for (int i = 0; i < details.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)details.get(i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.currCal.isNeedChange()) {
            this.currCal.needChange(false);
            String key = e.getProperty().getName();
            IDataModel model = this.getModel();
            ChangeData[] changeSet = e.getChangeSet();
            block10: for (int i = 0; i < changeSet.length; ++i) {
                ChangeData changeData = changeSet[i];
                Object newValue = changeData.getNewValue();
                Object oldValue = changeData.getOldValue();
                DynamicObject dataEntity = changeData.getDataEntity();
                int rowIndex = changeData.getRowIndex();
                if (newValue == null || newValue.equals(oldValue)) continue;
                switch (key) {
                    case "price": {
                        if (!(newValue instanceof BigDecimal)) continue block10;
                        BigDecimal taxRate = dataEntity.getBigDecimal(this.currCal.getTAXRATE());
                        this.currCal.calEntryTaxPriceByPrice(model, rowIndex, (BigDecimal)newValue, taxRate);
                        continue block10;
                    }
                    case "taxprice": {
                        if (!(newValue instanceof BigDecimal)) continue block10;
                        BigDecimal taxRate = dataEntity.getBigDecimal(this.currCal.getTAXRATE());
                        this.currCal.calEntryPriceByTaxPrice(this.getModel(), rowIndex, (BigDecimal)newValue, taxRate);
                        continue block10;
                    }
                    case "taxrate": {
                        String taxType = this.getModel().getDataEntity().getString("taxtype" + this.getPreTag());
                        if (!(newValue instanceof BigDecimal)) continue block10;
                        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                            BigDecimal taxPrice = dataEntity.getBigDecimal(this.currCal.getTAXPRICE());
                            this.currCal.calEntryPriceByTaxPrice(this.getModel(), rowIndex, taxPrice, (BigDecimal)newValue);
                            continue block10;
                        }
                        BigDecimal price = dataEntity.getBigDecimal(this.currCal.getPRICE());
                        this.currCal.calEntryTaxPriceByPrice(model, rowIndex, price, (BigDecimal)newValue);
                        continue block10;
                    }
                }
            }
            this.currCal.needChange(true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("quotecurr".equals(name)) {
            DynamicObject curr = this.getModel().getDataEntity().getDynamicObject("curr" + this.getPreTag());
            DynamicObject exchtype = this.getModel().getDataEntity().getDynamicObject("exchtype" + this.getPreTag());
            if (exchtype != null && curr != null) {
                QFilter qFilter = new QFilter("exctable", "=", (Object)exchtype.getLong("id"));
                qFilter.and(new QFilter("orgcur", "=", (Object)curr.getLong("id")).or("cur", "=", (Object)curr.getLong("id")));
                qFilter.and("enable", "=", (Object)"1");
                Date rateDate = this.getModel().getDataEntity().getDate("ratedate" + this.getPreTag());
                if (rateDate != null) {
                    qFilter.and("effectdate", "<=", (Object)rateDate);
                } else {
                    qFilter.and("effectdate", "<=", (Object)TimeServiceHelper.now());
                }
                ArrayList<Long> currs = new ArrayList<Long>();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_exrate_tree", (String)"orgcur,cur", (QFilter[])new QFilter[]{qFilter}, null);){
                    if (dataSet != null) {
                        dataSet.forEach(info -> {
                            currs.add(info.getLong("orgcur"));
                            currs.add(info.getLong("cur"));
                        });
                    }
                }
                currs.add(curr.getLong("id"));
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", currs));
            } else {
                return;
            }
        }
    }

    protected String getPreTag() {
        return "";
    }

    protected String getEntryEntity() {
        return "detail_entryentity";
    }

    protected long getTargetCurr() {
        return this.getModel().getDataEntity().getLong("curr" + this.getPreTag() + "_id");
    }
}

