/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.apiconnector.api.AbstractApiMeta;
import kd.scm.common.helper.apiconnector.api.ApiMetaManager;
import kd.scm.common.helper.apiconnector.api.ApiParam;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.helper.apiconnector.api.GroupApiMeta;
import kd.scm.common.helper.apiconnector.api.IscApiMeta;
import kd.scm.common.helper.apiconnector.api.util.JsonHandler;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.helper.apiconnector.api.util.StringUtil;

public class ApiAccessor {
    private static final Log logger = LogFactory.getLog(ApiAccessor.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"APIACCESSOR", (int)3, (int)9);

    public static Map<String, Object> invokeTrigger(String number, Map<String, Object> params) {
        logger.info("\u672c\u6b21\u8c03\u7528\u7684\u542f\u52a8\u65b9\u6848\u662f\uff1a" + number + "--\u53c2\u6570\u662f\uff1a" + params);
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{number, params, null});
    }

    public static Map<String, Object> invokeExecutionState(String exeNumber) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"getExecutionState", (Object[])new Object[]{exeNumber});
    }

    public static Long invokeServiceFlow(String number) {
        return (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{number});
    }

    public static Long invokeServiceFlow(String number, List<Object> inputs) {
        return (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{number, inputs});
    }

    public static Map<String, Object> getServiceFlowState(Long instanceId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{instanceId});
    }

    public static boolean retryServiceFlow(Long instanceId) {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"retry", (Object[])new Object[]{instanceId});
    }

    public static Map<String, Object> invokeGroup(String groupNumber, Map<String, Object> params) {
        AbstractApiMeta meta = ApiMetaManager.getByNumber(groupNumber, "pbd_extsys_apiset");
        return ApiAccessor.invokeGroup(meta, params);
    }

    public static Map<String, Object> invokeGroup(AbstractApiMeta meta, Map<String, Object> params) {
        GroupApiMeta groupMeta = (GroupApiMeta)meta;
        return groupMeta.invokeApi((AbstractApiMeta)groupMeta, (Map)params);
    }

    public static Object invoke(String apiNumber, Object[] args) {
        AbstractApiMeta schema = ApiMetaManager.getByNumber(apiNumber, "pbd_extsys_api");
        return ApiAccessor.invoke(schema, args);
    }

    public static Object invoke(String apiNumber, Map<String, Object> params) {
        AbstractApiMeta schema = ApiMetaManager.getByNumber(apiNumber, "pbd_extsys_api");
        return ApiAccessor.invoke(schema, params);
    }

    public static <T> ApiResult<T> invoke(String apiNumber, Class<T> responseType, Object paramObj) {
        JSONObject paramMap = JSONObject.parseObject((String)JSONObject.toJSONString((Object)paramObj));
        Object res = ApiAccessor.invoke(apiNumber, (Map<String, Object>)paramMap);
        JSONObject resJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)res));
        ApiResult<Object> apiResult = new ApiResult<Object>();
        apiResult.setResultMessage(resJson.getString("resultMessage"));
        apiResult.setSuccess(resJson.getBoolean("success"));
        apiResult.setResultCode(resJson.getString("resultCode"));
        Object result = JSON.toJavaObject((JSON)resJson.getJSONObject("result"), responseType);
        apiResult.setResult(result);
        return apiResult;
    }

    public static Object invoke(AbstractApiMeta schema, Object[] args) {
        Map<String, Object> params = ApiAccessor.prepareParams(schema, args);
        return ApiAccessor.invoke(schema, params);
    }

    public static Object invoke(AbstractApiMeta schema, Map<String, Object> params) {
        ApiAccessor.setDefaultValue(schema.getInputs(), params);
        DynamicObject log = ApiAccessor.invokeBegin(schema, params);
        Object result = null;
        try {
            result = schema.invokeApi(schema, params);
            ApiAccessor.invokeEnd(log, result);
            return result;
        }
        catch (Throwable e) {
            ApiAccessor.invokeEnd(log, e);
            logger.error(e);
            IscApiMeta meta = (IscApiMeta)schema;
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"ApiAccessor_3", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)meta.getType()).getName(), e.getMessage()));
        }
    }

    private static void setDefaultValue(ApiParam schema, Map<String, Object> params) {
        int j = schema.fieldCount();
        for (int i = 0; i < j; ++i) {
            ApiParam.Field f = schema.getField(i);
            Object value = params.get(f.getName());
            if (value == null) {
                value = f.getDefaultValue();
                params.put(f.getName(), value);
            }
            if (f.getSchema() == null) continue;
            ApiAccessor.setDefaultValue(f, value);
        }
    }

    private static void setDefaultValue(ApiParam.Field f, Object value) {
        if (value instanceof Map) {
            ApiAccessor.setDefaultValue(f.getSchema(), (Map)value);
        } else if (value instanceof Collection) {
            ApiAccessor.setDefaultValue(f, (Collection)value);
        }
    }

    private static void setDefaultValue(ApiParam.Field f, Collection<?> items) {
        for (Object item : items) {
            if (!(item instanceof Map)) continue;
            ApiAccessor.setDefaultValue(f.getSchema(), (Map)item);
        }
    }

    private static Map<String, Object> prepareParams(AbstractApiMeta schema, Object[] args) {
        ApiParam inputs = schema.getInputs();
        ApiAccessor.checkArgs(inputs, args);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            String key = inputs.getField(i).getName();
            params.put(key, args[i]);
        }
        return params;
    }

    private static void checkArgs(ApiParam inputs, Object[] args) {
        if (inputs.fieldCount() != args.length) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u63d0\u4f9b\u7684\u53c2\u6570\u4e2a\u6570\u4e0e\u5b9a\u4e49\u4e0d\u7b26\uff0c\u8981\u6c42", (String)"ApiAccessor_0", (String)"scm-common-helper", (Object[])new Object[0]) + inputs.fieldCount() + ResManager.loadKDString((String)"\u4e2a\uff0c\u5b9e\u9645\u63d0\u4f9b", (String)"ApiAccessor_1", (String)"scm-common-helper", (Object[])new Object[0]) + args.length + ResManager.loadKDString((String)"\u4e2a\uff01", (String)"ApiAccessor_2", (String)"scm-common-helper", (Object[])new Object[0]));
        }
    }

    private static DynamicObject invokeBegin(AbstractApiMeta api, Object params) {
        if (api instanceof IscApiMeta && ((IscApiMeta)api).isRecordLog()) {
            String apiType = ((IscApiMeta)api).getType();
            long apiId = api.getId();
            return ApiAccessor.loggerBegin(apiType, apiId, params);
        }
        return null;
    }

    public static DynamicObject loggerBegin(String apiType, long apiId, Object params) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"pbd_apilog");
        log.set("systype", (Object)apiType);
        log.set("extsysapi_id", (Object)apiId);
        log.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        log.set("status", (Object)"R");
        String s = JsonHandler.toString(params, true);
        log.set("params", (Object)StringUtil.trim(s, 1500));
        log.set("params_tag", (Object)s);
        return log;
    }

    private static void invokeEnd(DynamicObject log, Object result) {
        if (log == null) {
            return;
        }
        ApiAccessor.loggerEnd(log, result);
    }

    public static void loggerEnd(DynamicObject log, Object result) {
        threadPool.execute(() -> {
            boolean failed = result instanceof Throwable;
            String s = failed ? StringUtil.toString((Throwable)result) : Parser.toString(result);
            log.set("result", (Object)StringUtil.trim(s, 1500));
            log.set("result_tag", (Object)s);
            log.set("end_time", (Object)new Timestamp(System.currentTimeMillis()));
            log.set("status", (Object)(failed ? "F" : "S"));
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationServiceHelper.executeOperate((String)"save", (String)"pbd_apilog", (DynamicObject[])new DynamicObject[]{log}, (OperateOption)option);
        });
    }

    public static void enableEcApiGroupMember(String ecType) {
        DynamicObject[] dyos;
        if (StringUtils.isBlank((CharSequence)ecType)) {
            return;
        }
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()).and(new QFilter("enable", "=", (Object)"1"));
        for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"pbd_extsys_apiset", (String)"entryentity.systype,entryentity.valid,status", (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection entryCol = dyo.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyo : entryCol) {
                if (!ecType.equals(entryDyo.getString("systype"))) continue;
                entryDyo.set("valid", (Object)"1");
            }
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"pbd_extsys_apiset", (DynamicObject[])dyos, null);
    }

    static ApiParam getOutputSchema(DynamicObject cfg) {
        DynamicObjectCollection c = cfg.getDynamicObjectCollection("outputs");
        ArrayList<ApiParam.Field> fields = new ArrayList<ApiParam.Field>(c.size());
        for (DynamicObject p : c) {
            String name = p.getString("output_field");
            String dataType = p.getString("output_data_type");
            String title = p.getString("output_description");
            boolean is_array = p.getBoolean("output_is_array");
            fields.add(new ApiParam.Field(name, dataType, title, is_array, false, null));
        }
        ApiParam inputs = new ApiParam(fields);
        return inputs;
    }

    static ApiParam getInputSchema(DynamicObject cfg) {
        DynamicObjectCollection c = cfg.getDynamicObjectCollection("inputs");
        ArrayList<ApiParam.Field> fields = new ArrayList<ApiParam.Field>(c.size());
        for (DynamicObject p : c) {
            String name = p.getString("input_field");
            String dataType = p.getString("input_data_type");
            boolean is_array = p.getBoolean("input_is_array");
            String title = p.getString("input_description");
            boolean required = p.getBoolean("required");
            String defaultValue = p.getString("default_value");
            fields.add(new ApiParam.Field(name, dataType, title, is_array, required, defaultValue));
        }
        ApiParam inputs = new ApiParam(fields);
        return inputs;
    }

    public static Object invokeChangeDataSource(String realDataSource, String apiNumber, Map<String, Object> params) {
        AbstractApiMeta schema = ApiMetaManager.getByNumber(apiNumber, "pbd_extsys_api");
        return ApiAccessor.invokeChangeDataSource(realDataSource, schema, params);
    }

    public static Object invokeChangeDataSource(String realDataSource, AbstractApiMeta schema, Map<String, Object> params) {
        ApiAccessor.setDefaultValue(schema.getInputs(), params);
        DynamicObject log = ApiAccessor.invokeBegin(schema, params);
        Object result = null;
        try {
            result = schema.invokeApiChangeDataSource(realDataSource, schema, params);
            ApiAccessor.invokeEnd(log, result);
            return result;
        }
        catch (Throwable e) {
            ApiAccessor.invokeEnd(log, e);
            logger.error(e);
            IscApiMeta meta = (IscApiMeta)schema;
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"ApiAccessor_3", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)meta.getType()).getName(), e.getMessage()));
        }
    }

    public static Object callWebApi(String apiNumber, Map<String, Object> params) {
        AbstractApiMeta schema = ApiMetaManager.getByNumber(apiNumber, "pbd_extsys_api");
        ApiAccessor.setDefaultValue(schema.getInputs(), params);
        DynamicObject log = ApiAccessor.invokeBegin(schema, params);
        Object result = null;
        try {
            result = schema.callWebApi(schema, params);
            ApiAccessor.invokeEnd(log, result);
            return result;
        }
        catch (Throwable e) {
            ApiAccessor.invokeEnd(log, e);
            logger.error(e);
            IscApiMeta meta = (IscApiMeta)schema;
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8c03\u7528{0}\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{1}", (String)"ApiAccessor_3", (String)"scm-common-helper", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)meta.getType()).getName(), e.getMessage()));
        }
    }
}

