/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.apiconnector.api.AbstractApiMeta;
import kd.scm.common.helper.apiconnector.api.GroupApiMeta;
import kd.scm.common.helper.apiconnector.api.IscApiMeta;
import kd.scm.common.helper.apiconnector.api.util.ReadLockFreeMap;

public class ApiMetaManager {
    private static final ReadLockFreeMap<String, Class<?>> clazzCache = new ReadLockFreeMap(8);
    private static final IAppCache metaCache;
    private static Log log;

    public static AbstractApiMeta getById(Long id, String entity) throws Exception {
        return ApiMetaManager.get("id", id, entity);
    }

    public static AbstractApiMeta getByNumber(String number, String entity) {
        return ApiMetaManager.get("number", number, entity);
    }

    private static synchronized AbstractApiMeta get(String field, Object value, String entity) {
        String key = ApiMetaManager.generateCacheKey(value, entity);
        AbstractApiMeta meta = (AbstractApiMeta)metaCache.get(key, clazzCache.get(entity));
        if (null == meta) {
            meta = ApiMetaManager.createObject(field, value, entity);
            ApiMetaManager.putInCache(meta, value, entity);
        }
        return meta;
    }

    private static String generateCacheKey(Object value, String entity) {
        return entity + "_" + value + "_" + RequestContext.get().getAccountId();
    }

    private static AbstractApiMeta createObject(String field, Object value, String entity) {
        DynamicObject cfg = null;
        if ("id".equals(field)) {
            cfg = BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)entity);
        } else {
            QFilter filter = new QFilter("number", "=", value);
            cfg = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])new QFilter[]{filter});
        }
        if (cfg == null) {
            throw new IllegalArgumentException("init config dynamicObject faild, please check whether the entity[" + entity + "] exisits number[" + value + "]");
        }
        log.info("field:" + field + ",value:" + value + ",entity:" + entity);
        return StringUtils.equalsIgnoreCase((CharSequence)"pbd_extsys_api", (CharSequence)entity) ? new IscApiMeta(cfg) : new GroupApiMeta(cfg);
    }

    private static void putInCache(AbstractApiMeta meta, Object value, String entity) {
        String key = ApiMetaManager.generateCacheKey(value, entity);
        if (meta != null) {
            metaCache.put(key, (Object)meta);
        }
    }

    public static void clearAllCache() {
        metaCache.clear();
    }

    public static void clearCacheByKey(Object key, String entity) {
        String cacheKey = ApiMetaManager.generateCacheKey(key, entity);
        metaCache.remove(cacheKey);
    }

    static {
        log = LogFactory.getLog(ApiMetaManager.class);
        metaCache = AppCache.get((String)("scm-" + ApiMetaManager.class.getSimpleName()));
        clazzCache.put("pbd_extsys_api", IscApiMeta.class);
        clazzCache.put("pbd_extsys_apiset", GroupApiMeta.class);
    }
}

