/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;

public class ApiParam
implements Serializable {
    private static final long serialVersionUID = -5708693332835110075L;
    private List<Field> fields = new ArrayList<Field>();
    private Map<String, Integer> mapping = new HashMap<String, Integer>();

    public ApiParam(List<Field> fields) {
        for (Field f : fields) {
            String name = f.name;
            String dataType = f.dataType;
            String title = f.title;
            Object defaultValue = f.defaultValue;
            boolean is_array = f.is_array;
            boolean required = f.required;
            this.add(name, dataType, title, is_array, required, defaultValue);
        }
    }

    public int fieldCount() {
        return this.fields.size();
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(int index) {
        return this.fields.get(index);
    }

    public int findField(String name) {
        Integer index = this.mapping.get(name);
        return index == null ? -1 : index;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Map<String, Integer> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, Integer> mapping) {
        this.mapping = mapping;
    }

    private void add(String name, String dataType, String title, boolean is_array, boolean required, Object defaultValue) {
        int dotIndex = name.indexOf(46);
        if (dotIndex < 0) {
            if (this.mapping.putIfAbsent(name, this.fields.size()) == null) {
                Field field = new Field(name, dataType, title, is_array, required, defaultValue);
                this.fields.add(field);
            }
        } else {
            String key = name.substring(0, dotIndex);
            Integer index = this.mapping.get(key);
            if (index == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u672a\u58f0\u660e\u5b57\u6bb5\uff08", (String)"ApiParam_0", (String)"scm-common-helper", (Object[])new Object[0]) + key + ResManager.loadKDString((String)"\uff09\u7684\u7c7b\u578b\uff0c\u4ece\u4e0a\u4e0b\u6587\u63a8\u65ad\u8be5\u5b57\u6bb5\u5e94\u8be5\u7ed3\u6784\u6216\u5206\u5f55\u7c7b\u578b\u3002", (String)"ApiParam_1", (String)"scm-common-helper", (Object[])new Object[0]));
            }
            Field s = this.fields.get(index);
            if (s.schema != null) {
                s.schema.add(name.substring(dotIndex + 1), dataType, title, is_array, required, defaultValue);
            } else {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5b57\u6bb5\uff08", (String)"ApiParam_2", (String)"scm-common-helper", (Object[])new Object[0]) + s.name + ResManager.loadKDString((String)"\uff09\u662f\uff08", (String)"ApiParam_3", (String)"scm-common-helper", (Object[])new Object[0]) + s.dataType + ResManager.loadKDString((String)"\uff09\u6570\u636e\u7c7b\u578b\uff0c\u4e0d\u80fd\u5305\u542b\u4e0b\u7ea7\u5b57\u6bb5\u3002", (String)"ApiParam_4", (String)"scm-common-helper", (Object[])new Object[0]));
            }
        }
    }

    public String toString() {
        return this.fields.toString();
    }

    private ApiParam() {
    }

    public static class Field
    implements Comparable<Field>,
    Serializable {
        private String name;
        private String dataType;
        private String title;
        private boolean is_array;
        private boolean required;
        private Object defaultValue;
        private ApiParam schema;

        public Field() {
        }

        public Field(String name, String dataType, String title, boolean is_array, boolean required, Object defaultValue) {
            this.name = name;
            this.dataType = dataType;
            this.title = title;
            this.is_array = is_array;
            this.required = required;
            if ("STRUCT".equals(dataType)) {
                this.schema = new ApiParam();
            }
            this.defaultValue = defaultValue;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean isIs_array() {
            return this.is_array;
        }

        public void setIs_array(boolean is_array) {
            this.is_array = is_array;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setSchema(ApiParam schema) {
            this.schema = schema;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isArray() {
            return this.is_array;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public ApiParam getSchema() {
            return this.schema;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Field o) {
            return this.name.compareTo(o.name);
        }
    }
}

