/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.apiconnector.IApiHandleProcessor;
import kd.scm.common.helper.apiconnector.api.AbstractApiMeta;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiMetaManager;
import kd.scm.common.helper.apiconnector.api.ApiParam;
import kd.scm.common.helper.apiconnector.api.IscApiMeta;
import kd.scm.common.helper.apiconnector.api.util.StringUtil;

public class GroupApiMeta
extends AbstractApiMeta {
    private static final long serialVersionUID = 2112021841495034304L;
    private static final Log logger = LogFactory.getLog(GroupApiMeta.class);
    private Map<String, String> groupApiMap;

    public GroupApiMeta() {
    }

    public GroupApiMeta(DynamicObject cfg) {
        super(cfg);
        if (cfg.getDataEntityType().getName().equalsIgnoreCase("pbd_extsys_apiset")) {
            DynamicObjectCollection entryCol = cfg.getDynamicObjectCollection("entryentity");
            int size = entryCol.size() > 0 ? (int)((double)entryCol.size() / 0.75) : 16;
            this.groupApiMap = new LinkedHashMap<String, String>(size);
            for (DynamicObject entry : entryCol) {
                if (!entry.getBoolean("valid")) continue;
                String number = entry.getString("extsysapi.number");
                String handleClass = entry.getString("handleclass");
                this.groupApiMap.putIfAbsent(number, handleClass);
            }
        } else {
            throw new IllegalArgumentException("Illegal Config DynamicObject, GroupApiMeta Construct faild");
        }
    }

    public final Map<String, String> getGroupApiMap() {
        return this.groupApiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> invokeApi(AbstractApiMeta apiMeta, Map<String, Object> params) {
        if (params == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> invokeResult = new HashMap<String, Object>(this.groupApiMap.size());
        GroupApiMeta groupMeta = (GroupApiMeta)apiMeta;
        Map<String, String> groupApiMap = groupMeta.getGroupApiMap();
        logger.info("@@@groupApiMap" + groupApiMap);
        for (Map.Entry<String, String> entry : groupApiMap.entrySet()) {
            String number = entry.getKey();
            AbstractApiMeta meta = ApiMetaManager.getByNumber(number, "pbd_extsys_api");
            if (!(meta instanceof IscApiMeta)) continue;
            IscApiMeta iscMeata = (IscApiMeta)meta;
            logger.info("@@@iscMeata" + iscMeata);
            Object result = null;
            if (!params.containsKey(iscMeata.getType())) continue;
            try {
                Map<String, Object> handledParams;
                IApiHandleProcessor processor = (IApiHandleProcessor)TypesContainer.getOrRegisterSingletonInstance((String)entry.getValue());
                Map<String, Object> map = handledParams = iscMeata.isDebug() ? params : processor.beforeInvoke(params, iscMeata.getType());
                if (!handledParams.isEmpty()) {
                    logger.info("@@@handledParams" + handledParams);
                    Object value = ApiAccessor.invoke((AbstractApiMeta)iscMeata, handledParams);
                    result = processor.afterInvoke(value, iscMeata.getType());
                }
                invokeResult.put(iscMeata.getType(), result);
            }
            catch (Throwable e) {
                try {
                    logger.error("@@@GroupApiMeta.invokeApi" + StringUtil.toString(e));
                    result = e;
                    invokeResult.put(iscMeata.getType(), result);
                }
                catch (Throwable throwable) {
                    invokeResult.put(iscMeata.getType(), result);
                    throw throwable;
                }
            }
        }
        return invokeResult;
    }

    @Override
    public void test(DynamicObject config) {
    }

    @Override
    public ApiParam getInputs() {
        return null;
    }

    @Override
    public ApiParam getOutputs() {
        return null;
    }

    public final IApiHandleProcessor getInvokerByName(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<?> process = Class.forName(className);
        return (IApiHandleProcessor)process.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeApiChangeDataSource(String realDataSource, AbstractApiMeta apiMeta, Map<String, Object> params) {
        if (params == null) {
            return new HashMap();
        }
        HashMap<String, Throwable> invokeResult = new HashMap<String, Throwable>(this.groupApiMap.size());
        GroupApiMeta groupMeta = (GroupApiMeta)apiMeta;
        Map<String, String> groupApiMap = groupMeta.getGroupApiMap();
        logger.info("@@@groupApiMap" + groupApiMap);
        for (Map.Entry<String, String> entry : groupApiMap.entrySet()) {
            String number = entry.getKey();
            AbstractApiMeta meta = ApiMetaManager.getByNumber(number, "pbd_extsys_api");
            if (!(meta instanceof IscApiMeta)) continue;
            IscApiMeta iscMeata = (IscApiMeta)meta;
            logger.info("@@@iscMeata" + iscMeata);
            Object result = null;
            if (!params.containsKey(iscMeata.getType())) continue;
            try {
                IApiHandleProcessor processor = (IApiHandleProcessor)TypesContainer.getOrRegisterSingletonInstance((String)entry.getValue());
                Map<String, Object> handledParams = iscMeata.isDebug() ? params : processor.beforeInvoke(params, iscMeata.getType());
                if (handledParams.isEmpty()) continue;
                logger.info("@@@handledParams" + handledParams);
                Object value = ApiAccessor.invokeChangeDataSource(realDataSource, iscMeata, handledParams);
                result = processor.afterInvoke(value, iscMeata.getType());
            }
            catch (Throwable e) {
                logger.error("@@@GroupApiMeta.invokeApi" + StringUtil.toString(e));
                result = e;
            }
            finally {
                invokeResult.put(iscMeata.getType(), (Throwable)result);
            }
        }
        return invokeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callWebApi(AbstractApiMeta apiMeta, Map<String, Object> params) {
        if (params == null) {
            return new HashMap();
        }
        HashMap<String, Throwable> invokeResult = new HashMap<String, Throwable>(this.groupApiMap.size());
        GroupApiMeta groupMeta = (GroupApiMeta)apiMeta;
        Map<String, String> groupApiMap = groupMeta.getGroupApiMap();
        logger.info("@@@groupApiMap" + groupApiMap);
        for (Map.Entry<String, String> entry : groupApiMap.entrySet()) {
            String number = entry.getKey();
            AbstractApiMeta meta = ApiMetaManager.getByNumber(number, "pbd_extsys_api");
            if (!(meta instanceof IscApiMeta)) continue;
            IscApiMeta iscMeata = (IscApiMeta)meta;
            logger.info("@@@iscMeata" + iscMeata);
            Object result = null;
            if (!params.containsKey(iscMeata.getType())) continue;
            try {
                IApiHandleProcessor processor = (IApiHandleProcessor)TypesContainer.getOrRegisterSingletonInstance((String)entry.getValue());
                Map<String, Object> handledParams = iscMeata.isDebug() ? params : processor.beforeInvoke(params, iscMeata.getType());
                if (handledParams.isEmpty()) continue;
                logger.info("@@@handledParams" + handledParams);
                Object value = ApiAccessor.callWebApi(number, handledParams);
                result = processor.afterInvoke(value, iscMeata.getType());
            }
            catch (Throwable e) {
                logger.error("@@@GroupApiMeta.invokeApi" + StringUtil.toString(e));
                result = e;
            }
            finally {
                invokeResult.put(iscMeata.getType(), (Throwable)result);
            }
        }
        return invokeResult;
    }
}

