/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.AbstractApiMeta;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiParam;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.JsonHandler;
import kd.scm.common.util.ExceptionUtil;

public class IscApiMeta
extends AbstractApiMeta {
    private static final long serialVersionUID = -8591084606201659387L;
    private static final Log log = LogFactory.getLog(IscApiMeta.class);
    private String type;
    private boolean record_log;
    private boolean isDebug;
    private String service;
    private String dataSource;
    private ApiParam inputs;
    private ApiParam outputs;
    private String realDataSource;

    public IscApiMeta() {
    }

    public IscApiMeta(DynamicObject cfg) {
        super(cfg);
        DynamicObject link;
        this.type = cfg.getString("group.systype");
        this.record_log = cfg.getBoolean("record_log");
        this.isDebug = cfg.getBoolean("isdebug");
        this.service = cfg.getString("full_name");
        DynamicObject source = cfg.getDynamicObject("group.syssource");
        if (null != source && null != (link = BusinessDataServiceHelper.loadSingleFromCache((Object)source.getPkValue(), (String)"isc_data_source"))) {
            this.dataSource = link.getString("number");
        }
        this.inputs = ApiAccessor.getInputSchema(cfg);
        this.outputs = ApiAccessor.getOutputSchema(cfg);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRecord_log() {
        return this.record_log;
    }

    public void setRecord_log(boolean record_log) {
        this.record_log = record_log;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setInputs(ApiParam inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(ApiParam outputs) {
        this.outputs = outputs;
    }

    public boolean isRecordLog() {
        return this.record_log;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public ApiParam getInputs() {
        return this.inputs;
    }

    @Override
    public ApiParam getOutputs() {
        return this.outputs;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public String getRealDataSource() {
        return this.realDataSource;
    }

    public void setRealDataSource(String realDataSource) {
        this.realDataSource = realDataSource;
    }

    @Override
    public void test(DynamicObject config) {
    }

    @Override
    public Object invokeApi(AbstractApiMeta apiMeta, Map<String, Object> params) {
        IscApiMeta meta = (IscApiMeta)apiMeta;
        if (meta.isDebug) {
            return this.getMockData(meta.getNumber());
        }
        if (!EcApiUtil.checkEcOpenStatus(meta.getType())) {
            log.warn(EcPlatformEnum.fromVal((String)meta.getType()).getName() + "\u7535\u5546\u6388\u6743\u672a\u5f00\u901a\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5546\u6388\u6743\u672a\u5f00\u901a\u3002", (String)"IscApiMeta_0", (String)"scm-common-helper", (Object[])new Object[0]));
        }
        return DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callService", (Object[])new Object[]{meta.getDataSource(), meta.getService(), params, null});
    }

    @Override
    public Object invokeApiChangeDataSource(String realDataSource, AbstractApiMeta apiMeta, Map<String, Object> params) {
        IscApiMeta meta = (IscApiMeta)apiMeta;
        if (meta.isDebug) {
            return this.getMockData(meta.getNumber());
        }
        return DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callServiceX", (Object[])new Object[]{meta.getDataSource(), realDataSource, meta.getService(), params, null});
    }

    private Object getMockData(String apiNumber) {
        Object res = null;
        String sql = "select fmokejsondata from t_mal_mokedata where FAPINUMBER = '" + apiNumber + "'";
        DBRoute dbRoute = new DBRoute("pur");
        try (DataSet ds = DB.queryDataSet((String)"IscApiMeta.getMockData", (DBRoute)dbRoute, (String)sql, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                String data = row.getString("fmokejsondata");
                res = data.startsWith("[") && data.endsWith("]") ? JsonHandler.parseJson2List(data) : (data.startsWith("{") && data.endsWith("}") ? JsonHandler.parseJson2Map(data) : data);
            }
        }
        catch (Exception e) {
            log.info("IscApiMeta.getMockData failed:" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return res;
    }

    public String toString() {
        return "IscApiMeta [type=" + this.type + ", record_log=" + this.record_log + ", isDebug=" + this.isDebug + ", service=" + this.service + ", dataSource=" + this.dataSource + ", inputs=" + this.inputs + ", outputs=" + this.outputs + "]";
    }

    @Override
    public Object callWebApi(AbstractApiMeta apiMeta, Map<String, Object> params) {
        IscApiMeta meta = (IscApiMeta)apiMeta;
        if (meta.isDebug) {
            return this.getMockData(meta.getNumber());
        }
        return DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscWebApiService", (String)"invoke", (Object[])new Object[]{meta.getService(), params});
    }
}

