/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.parser;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.JDOrderUtil;

public class JdApiParser {
    public static DynamicObject getJdOrderByOrderId(String jdOrderId) {
        return JDOrderUtil.getJdOrder((String)jdOrderId);
    }

    public static Map<String, Object> getChildJdOrderIdMap(String jdOrderId) {
        return JdApiParser.getChildJdOrderIdMap(jdOrderId, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static Map<String, Object> getChildJdOrderIdMap(String jdOrderId, String source) {
        Map<String, Object> res = EcApiUtil.JdChildOrder(jdOrderId, source);
        return JDOrderUtil.parseJdChildOrderIdMap(res);
    }

    public static Map<String, Long> getNumberJdOrderIdMap(Map<String, Object> childJdOrderIdMap, String remittanceCode, DynamicObject jdOrder) {
        return JDOrderUtil.getNumberJdOrderIdMap(childJdOrderIdMap, (String)remittanceCode, (DynamicObject)jdOrder);
    }

    public static Set<String> getJdChildOrderByNumber(Set<String> orderNoSet) {
        QFilter filter = new QFilter("jdorderid", "in", orderNoSet).and(new QFilter("number", "!=", (Object)"jdorderid"));
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pbd_jdorder", (String)"id,number", (QFilter[])new QFilter[]{filter});
        HashSet<String> result = new HashSet<String>(col.size());
        col.forEach(dyo -> result.add(dyo.getString("number")));
        return result;
    }

    public static Set<String> getJdParentOrderByNumber(Set<String> orderItemNoSet) {
        QFilter filter = new QFilter("number", "in", orderItemNoSet);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"pbd_jdorder", (String)"id,number,jdorderid", (QFilter[])new QFilter[]{filter});
        HashSet<String> result = new HashSet<String>(col.size());
        col.forEach(dyo -> result.add(dyo.getString("jdorderid")));
        return result;
    }

    public static void updateJdOrderStatus(String statusKey, Set<String> orderSet, String status) {
        QFilter filter = new QFilter("number", "in", orderSet);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)("number," + statusKey), (QFilter[])new QFilter[]{filter});
        if (null == dyos || dyos.length <= 0) {
            return;
        }
        for (DynamicObject bill : dyos) {
            bill.set(statusKey, (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    public static String getJdApiNumber(String source, String apiNumber) {
        String res = apiNumber;
        if (StringUtils.isNotBlank((CharSequence)apiNumber) && StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_JDPRO.getVal(), (CharSequence)source)) {
            res = apiNumber.replace("_JD_", "_JDPRO_");
        }
        return res;
    }
}

