/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.SaleAttrInfo;
import kd.scm.common.ecapi.entity.SkuGoodsInfo;
import kd.scm.common.ecapi.entity.SnCharacterInfo;
import kd.scm.common.ecapi.entity.SnGoodsInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;

public class EcApiUtil {
    private static final Log logger = LogFactory.getLog(EcApiUtil.class);
    public static final String MDRGOODSCLASS = "mdr_goodsclass";
    public static final String ZJ = "944841720602823680";

    public static boolean confirmJdOrder(String jdOrderId) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("jdOrderId", jdOrderId);
        Object result = ApiAccessor.invoke("SRM_JD_ORDER_confirmOrder", params);
        return result instanceof Map && (Boolean)((Map)result).get("success") != false;
    }

    public static String getJdRemittanceCode(String jdOrderId, BigDecimal amount) {
        return EcApiUtil.getJdRemittanceCode(jdOrderId, amount, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static String getJdRemittanceCode(String jdOrderId, BigDecimal amount, String source) {
        String remittanceCode = "";
        String apiName = JdApiParser.getJdApiNumber(source, "SRM_JD_ORDER_selectRemittanceCode");
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("orderId", jdOrderId);
        params.put("amount", amount);
        Map result = (Map)ApiAccessor.invoke(apiName, params);
        try {
            Object res = EcApiUtil.parseResful(result);
            if (null != res) {
                remittanceCode = (String)((Map)res).get("httpURL");
            }
        }
        catch (KDBizException e) {
            logger.error("\u83b7\u53d6\u4ed8\u6b3e\u8bc6\u522b\u7801\u5931\u8d25\uff1a" + (Object)((Object)e));
        }
        return remittanceCode;
    }

    public static Map<String, Object> JdChildOrder(String orderId) {
        return EcApiUtil.JdChildOrder(orderId, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static Map<String, Object> JdChildOrder(String orderId, String source) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("orderId", orderId);
        Object result = ApiAccessor.invoke(JdApiParser.getJdApiNumber(source, "SRM_JD_ORDER_selectJdOrder"), params);
        return (Map)result;
    }

    public static Map<String, String> getSnOrderStatusMap(String orderId) {
        return (Map)EcGroupApiUtil.getEcOrderStatusMap(orderId, EcPlatformEnum.ECPLATFORM_SUNING.getVal()).get(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
    }

    public static Map<String, String> getCgOrderStatusMap(String orderId) {
        return (Map)EcGroupApiUtil.getEcOrderStatusMap(orderId, EcPlatformEnum.ECPLATFORM_CG.getVal()).get(EcPlatformEnum.ECPLATFORM_CG.getVal());
    }

    public static Map<String, String> batchGetCgOrderStatusMap(Collection<String> orderIds) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("value", orderIds);
        Object result = ApiAccessor.invoke("SRM_CG_ORDER_statusQuery", params);
        return (Map)EcApiUtil.parseResful(result);
    }

    public static List<SnGoodsInfo> getSnSimilarSku(String sku) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("skuId", sku);
        Map data = (Map)ApiAccessor.invoke("SRM_SN_GOODS_getGetproductcluster", params);
        ArrayList<SnGoodsInfo> skustrList = null;
        if (null != data) {
            boolean success = (Boolean)data.get("success");
            if (!success) {
                return skustrList;
            }
            Map skustr = (Map)data.get("result");
            skustrList = new ArrayList<SnGoodsInfo>(skustr.size());
            ArrayList keyList = new ArrayList(skustr.size());
            for (Map.Entry entry : skustr.entrySet()) {
                keyList.add(entry.getKey());
            }
            for (int i = 0; i < skustr.size(); ++i) {
                SnGoodsInfo snGoodsInfo = new SnGoodsInfo();
                ArrayList<SnCharacterInfo> snList = new ArrayList<SnCharacterInfo>(skustr.size());
                List skuLists = (List)skustr.get(keyList.get(i));
                for (int j = 0; j < skuLists.size(); ++j) {
                    snGoodsInfo.setSaleName((String)keyList.get(i));
                    Map snJson = (Map)skuLists.get(j);
                    SnCharacterInfo snCharacterInfo = new SnCharacterInfo();
                    snCharacterInfo.setSkuId(snJson.get("skuId").toString());
                    snCharacterInfo.setCharacterName(snJson.get("characterName").toString());
                    snCharacterInfo.setCharacterValueId(snJson.get("characterValueId").toString());
                    snCharacterInfo.setCharacterValueName(snJson.get("characterValueName").toString());
                    snList.add(snCharacterInfo);
                    snGoodsInfo.setSnCharacterInfo(snList);
                }
                skustrList.add(snGoodsInfo);
            }
        }
        return skustrList;
    }

    public static Object getSnnoReasonToReturn(String sku, BigDecimal price) {
        HashMap<String, Object> snParam = new HashMap<String, Object>(1);
        HashMap<String, BigDecimal> snPrice = new HashMap<String, BigDecimal>(1);
        snPrice.put(sku, price);
        snParam.put("skuPrice", snPrice);
        return ApiAccessor.invoke("SRM_SN_GOODS_getProdextend", snParam);
    }

    public static Object getSnIsJDLogistics(String cityId, String sku) {
        HashMap<String, Object> snPara = new HashMap<String, Object>(1);
        snPara.put("cityId", cityId);
        ArrayList<String> snList = new ArrayList<String>(1);
        snList.add(sku);
        snPara.put("skuIds", snList);
        return ApiAccessor.invoke("SRM_SN_GOODS_getJudgefacproduct", snPara);
    }

    public static String getMalId(String skuId, String source) {
        QFilter filter = new QFilter("number", "=", (Object)skuId).and(new QFilter("source", "=", (Object)source));
        DynamicObject query = QueryServiceHelper.queryOne((String)"pbd_mallgoods", (String)"id", (QFilter[])new QFilter[]{filter});
        return query == null ? "0" : query.getString("id");
    }

    public static Map<String, Long> getMalIds(List<String> skuIds, String source) {
        QFilter filter = new QFilter("number", "in", skuIds).and(new QFilter("source", "=", (Object)source));
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"pbd_mallgoods", (String)"number,id", (QFilter[])new QFilter[]{filter});
        HashMap<String, Long> resMap = new HashMap<String, Long>(dyos.size());
        for (DynamicObject dyo : dyos) {
            resMap.put(dyo.getString("number"), dyo.getLong("id"));
        }
        return resMap;
    }

    public static Map<String, Object> getSnOrderDetail(String orderId) {
        return (Map)EcGroupApiUtil.getEcOrderDetail(orderId, EcPlatformEnum.ECPLATFORM_SUNING.getVal()).get(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
    }

    public static Map<String, Object> getXyOrderDetail(String orderId) {
        return (Map)EcGroupApiUtil.getEcOrderDetail(orderId, EcPlatformEnum.ECPLATFORM_XY.getVal()).get(EcPlatformEnum.ECPLATFORM_XY.getVal());
    }

    public static Map<String, Object> getCgOrderDetail(String orderId) {
        return (Map)EcGroupApiUtil.getEcOrderDetail(orderId, EcPlatformEnum.ECPLATFORM_CG.getVal()).get(EcPlatformEnum.ECPLATFORM_CG.getVal());
    }

    public static Map<String, Object> getXyOrderPackage(String packageId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("packageId", packageId);
        Object result = ApiAccessor.invoke("SRM_XY_ORDER_package", params);
        return (Map)result;
    }

    public static Object parseResful(Object result) {
        Object res = null;
        if (result instanceof Map) {
            Map resMap = (Map)result;
            if (!resMap.containsKey("success")) {
                return resMap;
            }
            boolean success = Parser.toBoolean(resMap.get("success"));
            if (success) {
                res = resMap.get("result");
            } else {
                throw new KDBizException(new ErrorCode(Parser.toString(resMap.get("resultCode")), Parser.toString(resMap.get("resultMessage"))), new Object[0]);
            }
        }
        return res;
    }

    public static Object getJdnoReasonToReturn(String sku, String source) {
        String apiName = JdApiParser.getJdApiNumber(source, "SRM_JD_GOODS_check");
        HashMap<String, Object> jdParam = new HashMap<String, Object>(1);
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(sku);
        jdParam.put("skuIds", list);
        return ApiAccessor.invoke(apiName, jdParam);
    }

    public static Object getJdnoReasonToReturn(String sku) {
        return EcApiUtil.getJdnoReasonToReturn(sku, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static Object getJdMaddress(String maddress, String source) {
        String apiName = JdApiParser.getJdApiNumber(source, "SRM_JD_ADDRESS_getJDAddressFromAddress");
        HashMap<String, Object> jdParam = new HashMap<String, Object>(1);
        jdParam.put("address", maddress);
        Map data = (Map)ApiAccessor.invoke(apiName, jdParam);
        String jdAddrIdStr = data.get("provinceId") + "_" + data.get("cityId") + "_" + data.get("countyId") + "_" + data.get("townId");
        return jdAddrIdStr;
    }

    public static Object getJdMaddress(String maddress) {
        return EcApiUtil.getJdMaddress(maddress, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static Object getJdPromiseTips(String sku, String areaId, String source) {
        String apiName = JdApiParser.getJdApiNumber(source, "SRM_JD_GOODS_getPromiseTips");
        HashMap<String, Object> jdParam = new HashMap<String, Object>(6);
        jdParam.put("skuId", sku);
        jdParam.put("num", 1);
        String[] address = areaId.split("_");
        jdParam.put("province", address[0]);
        jdParam.put("city", address[1]);
        jdParam.put("county", address[2]);
        if (StringUtils.isBlank((CharSequence)address[3]) || address[3].equals("null")) {
            address[3] = "0";
        }
        jdParam.put("town", address[3]);
        return ApiAccessor.invoke(apiName, jdParam);
    }

    public static Object getJdPromiseTips(String sku, String areaId) {
        return EcApiUtil.getJdPromiseTips(sku, areaId, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static List<SkuGoodsInfo> getJdSimilarSku(String sku, String source) {
        String apiName = JdApiParser.getJdApiNumber(source, "SRM_JD_GOODS_getSimilarSku");
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("skuId", sku);
        ArrayList<SkuGoodsInfo> skustrList = new ArrayList<SkuGoodsInfo>(8);
        try {
            List data = (List)ApiAccessor.invoke(apiName, params);
            for (int i = 0; i < data.size(); ++i) {
                Map skujson = (Map)data.get(i);
                SkuGoodsInfo skuGoodsInfo = new SkuGoodsInfo();
                skuGoodsInfo.setDim((Integer)skujson.get("dim"));
                skuGoodsInfo.setSaleName((String)skujson.get("saleName"));
                List skuLists = (List)skujson.get("saleAttrList");
                ArrayList<SaleAttrInfo> saleAttrList = new ArrayList<SaleAttrInfo>(skuLists.size());
                for (int j = 0; j < skuLists.size(); ++j) {
                    SaleAttrInfo saleAttrInfo = new SaleAttrInfo();
                    Map jsonObject = (Map)skuLists.get(j);
                    saleAttrInfo.setSaleValue((String)jsonObject.get("saleValue"));
                    List skuIdsArray = (List)jsonObject.get("skuIds");
                    HashSet<String> setSkuIds = new HashSet<String>(skuIdsArray.size());
                    for (int k = 0; k < skuIdsArray.size(); ++k) {
                        setSkuIds.add(skuIdsArray.get(k).toString());
                    }
                    saleAttrInfo.setSkuIds(setSkuIds);
                    saleAttrList.add(saleAttrInfo);
                    skuGoodsInfo.setSaleAttrList(saleAttrList);
                }
                skustrList.add(skuGoodsInfo);
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u540c\u7c7b\u5546\u54c1\u5931\u8d25" + e);
        }
        return skustrList;
    }

    public static List<SkuGoodsInfo> getJdSimilarSku(String sku) {
        return EcApiUtil.getJdSimilarSku(sku, EcPlatformEnum.ECPLATFORM_JD.getVal());
    }

    public static String getStandard(String source) {
        QFilter filter = new QFilter("platform", "=", (Object)source);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
        if (null != dyo && null != dyo.getDynamicObject("standard")) {
            return dyo.getDynamicObject("standard").getString("id");
        }
        return ZJ;
    }

    public static String getSource(String standard) {
        QFilter filter = new QFilter("standard", "=", (Object)Long.parseLong(standard));
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
        return null != dyo ? dyo.getString("platform") : EcPlatformEnum.ECPLATFORM_SELF.getVal();
    }

    public static String getMalName(String source) {
        return EcPlatformEnum.fromVal((String)source).getName();
    }

    public static DynamicObject getMalPrice(String malId) {
        if (StringUtils.isEmpty((CharSequence)malId)) {
            malId = "0";
        }
        return QueryServiceHelper.queryOne((String)"pbd_mallgoods_price", (String)"nakedprice,price,taxrate,taxprice", (QFilter[])new QFilter[]{new QFilter("mallgoods", "=", (Object)Long.valueOf(malId))});
    }

    public static boolean checkEcOpenStatus(String ecType) {
        QFilter filter = new QFilter("platform", "=", (Object)ecType).and(new QFilter("openstatus", "=", (Object)"2"));
        return QueryServiceHelper.exists((String)"pmm_ecadmit", (QFilter[])new QFilter[]{filter});
    }
}

