/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.scm.common.helper.apiconnector.api.util.StringUtil;

public class JsonHandler {
    public static final int MAX_LEVEL = 64;
    public static final String JSON_PREFIX = "json:";
    public static final Object NULL = new Object();

    public static void escape(String s, StringBuilder sb) {
        if (s == null) {
            sb.append("null");
            return;
        }
        sb.append('\"');
        int j = s.length();
        block8: for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    public static String toString(Object o) {
        return JsonHandler.toString(o, false);
    }

    public static String escapeHTML(Object o) {
        String s = JsonHandler.toString(o);
        if (s.indexOf(60) < 0) {
            return s;
        }
        int i = 0;
        int j = s.indexOf(60);
        StringBuilder sb = new StringBuilder();
        while (j > 0) {
            sb.append(s.substring(i, j));
            sb.append("<\"+\"");
            i = j + 1;
            j = s.indexOf(60, i);
        }
        if (i < s.length()) {
            sb.append(s.substring(i, s.length()));
        }
        return sb.toString();
    }

    public static String toString(Object o, boolean withoutBrackets) {
        String s;
        if (o instanceof String && (s = (String)o).startsWith(JSON_PREFIX)) {
            return s.substring(JSON_PREFIX.length());
        }
        StringBuilder sb = new StringBuilder();
        if (!withoutBrackets) {
            sb.append('(');
        }
        JsonHandler.toString(o, sb, 0);
        if (!withoutBrackets) {
            sb.append(')');
        }
        return sb.toString();
    }

    public static StringBuilder toString(Object o, StringBuilder buffer, int level) {
        if (level >= 64) {
            throw new RuntimeException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o == null || o == NULL) {
            return buffer.append("null");
        }
        if (o instanceof Boolean) {
            return buffer.append(o);
        }
        if (o instanceof Number) {
            return JsonHandler.numberToString(o, buffer);
        }
        if (o instanceof CharSequence) {
            JsonHandler.escape(o.toString(), buffer);
            return buffer;
        }
        if (o instanceof Object[]) {
            return JsonHandler.toString((Object[])o, buffer, level + 1);
        }
        if (o instanceof Collection) {
            return JsonHandler.toString((Collection)((Object)o), buffer, level + 1);
        }
        if (o.getClass().isArray()) {
            return JsonHandler.toString2(o, buffer, level + 1);
        }
        if (o instanceof Throwable) {
            o = JsonHandler.wrap((Throwable)((Object)o));
        }
        if (o instanceof Map) {
            return JsonHandler.toString(o, buffer, level + 1);
        }
        if (o instanceof Date) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof Time) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof java.util.Date) {
            return JsonHandler.dateToString((java.util.Date)((Object)o), buffer);
        }
        if (o instanceof Map.Entry) {
            return JsonHandler.entryToString((Map.Entry)((Object)o), buffer, level);
        }
        JsonHandler.escape(o.toString(), buffer);
        return buffer;
    }

    private static StringBuilder entryToString(Map.Entry<?, ?> p, StringBuilder buffer, int level) {
        buffer.append('{');
        buffer.append("\"key\":");
        JsonHandler.toString(p.getKey(), buffer, level + 1);
        buffer.append(",\"value\":");
        JsonHandler.toString(p.getValue(), buffer, level + 1);
        buffer.append('}');
        return buffer;
    }

    private static StringBuilder dateToString(java.util.Date d, StringBuilder buffer) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return buffer.append('\"').append(df.format(d)).append('\"');
    }

    private static StringBuilder numberToString(Object o, StringBuilder buffer) {
        if (o instanceof Integer || o instanceof Byte || o instanceof Short || o instanceof Double || o instanceof Float) {
            return buffer.append(o).append(' ');
        }
        return buffer.append('\"').append(o).append('\"');
    }

    private static StringBuilder toString(Collection<?> l, StringBuilder buffer, int level) {
        buffer.append('[');
        boolean first = true;
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            JsonHandler.toString(it.next(), buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString2(Object array, StringBuilder buffer, int level) {
        buffer.append('[');
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            Object value = Array.get(array, i);
            JsonHandler.toString(value, buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Object[] a, StringBuilder buffer, int level) {
        buffer.append('[');
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            JsonHandler.toString(a[i], buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Map<?, ?> m, StringBuilder buffer, int level) {
        buffer.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            Object key = entry.getKey();
            JsonHandler.toString(key, buffer, level + 1);
            buffer.append(':');
            JsonHandler.toString(value, buffer, level + 1);
        }
        buffer.append('}');
        return buffer;
    }

    public static boolean isInteger(String name) {
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (JsonHandler.isDigital(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static boolean isLetterOrDigital(char c) {
        return JsonHandler.isLetter(c) || JsonHandler.isDigital(c);
    }

    public static boolean isLetter(char c) {
        return c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigital(char c) {
        return c >= '0' && c <= '9';
    }

    public static Map<String, Object> wrap(Throwable e) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String message = e.getMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        data.put("#message", message);
        data.put("#stack_trace", StringUtil.toString(e));
        return data;
    }

    public static String prettyJson(String result) {
        return JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
    }

    public static List<Map<String, Object>> parseJson2List(String result) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        if (result.startsWith("[") && result.endsWith("]")) {
            JSONArray json = JSONArray.parseArray((String)result);
            for (JSONObject json2 : json) {
                list.add(JsonHandler.parseJson2Map(json2.toString()));
            }
        }
        return list;
    }

    public static Map<String, Object> parseJson2Map(String result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (result.startsWith("{") && result.endsWith("}")) {
            JSONObject json = JSONObject.parseObject((String)result);
            for (Object key : json.keySet()) {
                Object value = json.get(key);
                if (value instanceof JSONArray) {
                    ArrayList list = new ArrayList();
                    for (Object json2 : (JSONArray)value) {
                        if (json2 instanceof String) {
                            list.add(json2);
                            continue;
                        }
                        list.add(JsonHandler.parseJson2Map(json2.toString()));
                    }
                    map.put(key.toString(), list);
                    continue;
                }
                if (value instanceof JSONObject) {
                    map.put(key.toString(), JsonHandler.parseJson2Map(value.toString()));
                    continue;
                }
                map.put(key.toString(), value);
            }
        }
        return map;
    }

    public static Map<String, Object> parseString2Map(String result) {
        return (Map)JSON.parseObject((String)result, Map.class);
    }
}

