/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.util;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Parser {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return Parser.toLong(value.toString().trim());
    }

    private static long toLong(String s) {
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public static int toInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return Parser.toInt(value.toString().trim());
    }

    private static int toInt(String s) {
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        String s = o.toString().trim();
        if (s.length() == 0) {
            return false;
        }
        if ("false".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "off".equalsIgnoreCase(s) || "n".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "failed".equalsIgnoreCase(s) || "\u4e0d\u540c\u610f".equals(s) || "\u62d2\u7edd".equals(s) || "\u9a73\u56de".equals(s) || "\u5426".equals(s) || "undefined".equals(s) || "disable".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "on".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "ok".equalsIgnoreCase(s) || "success".equalsIgnoreCase(s) || "\u540c\u610f".equals(s) || "\u901a\u8fc7".equals(s) || "\u662f".equals(s) || "enable".equals(s)) {
            return true;
        }
        throw new RuntimeException("invalid boolean string '" + s + "'.");
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String s = s0.trim();
        if (s.length() == 0) {
            return null;
        }
        if (Parser.isLong(s)) {
            return new Timestamp(Long.parseLong(s));
        }
        String format = Parser.getDateFormat(s);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            s = Parser.adjustDateString(s, format);
            return new Timestamp(sdf.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static String adjustDateString(String s, String format) {
        int i;
        if (format.endsWith(".SSS") && (i = s.length() - s.lastIndexOf(46) - 1) < 3) {
            s = s + "000".substring(i);
        }
        return s;
    }

    public static String getDateFormat(String s) {
        String format = null;
        if (s.indexOf(84) > 0) {
            format = s.indexOf(46) > 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd'T'HH:mm:ss";
        } else if (s.indexOf(32) > 0) {
            if (s.indexOf(45) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy-MM-dd HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss";
            } else if (s.indexOf(47) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy/MM/dd HH:mm:ss.SSS" : "yyyy/MM/dd HH:mm:ss";
            }
        } else if (s.indexOf(47) > 0) {
            format = "yyyy/MM/dd";
        } else if (s.indexOf(45) > 0) {
            format = "yyyy-MM-dd";
        } else if (s.indexOf(58) > 0) {
            format = s.indexOf(46) > 0 ? "HH:mm:ss.SSS" : "HH:mm:ss";
        }
        if (format != null) {
            return format;
        }
        throw new RuntimeException("illegal datetime format, s='" + s + "'.");
    }

    public static boolean isLong(String d) {
        int j = d.length();
        for (int i = 0; i < j; ++i) {
            char c = d.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String s = value.toString().trim();
        if (s.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (s.indexOf(44) >= 0) {
            s = s.replaceAll(",", "");
        }
        if (s.equals("-")) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(s);
    }

    public static RuntimeException error(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new RuntimeException(e.getMessage(), e);
    }

    public static Exception error2(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new Exception(e.getMessage(), e);
    }
}

