/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.businesstracking;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.businesstracking.SRMLinkBillNodeHelper;
import kd.scm.common.helper.businesstracking.design.BillRelationDesignInfo;
import kd.scm.common.helper.businesstracking.design.BillRelationDesignLinkInfo;
import kd.scm.common.helper.businesstracking.domain.BillBotpRelationParam;
import kd.scm.common.helper.businesstracking.domain.BillLinkRelationParam;
import kd.scm.common.helper.businesstracking.domain.BillRelationParam;

public final class SRMBillRelationSchemeHelper {
    public static LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> assembleBillDesignSchemeData(DynamicObject executebillrelation) {
        LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billRelationSchemeInfoMap = new LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>>(32);
        if (executebillrelation != null) {
            DynamicObjectCollection entryentity = executebillrelation.getDynamicObjectCollection("entryentity");
            boolean isEntryDim = executebillrelation.getBoolean("isentrydim");
            for (DynamicObject row : entryentity) {
                DynamicObject sourceentity = row.getDynamicObject("sourceentity");
                LinkedList<BillRelationDesignLinkInfo> stepDirectInfo = null;
                if (sourceentity == null) continue;
                DynamicObjectCollection targetRows = row.getDynamicObjectCollection("targetentryentity");
                stepDirectInfo = new LinkedList<BillRelationDesignLinkInfo>();
                for (DynamicObject targetRow : targetRows) {
                    DynamicObject targetentity = targetRow.getDynamicObject("targetentity");
                    DynamicObject definelink = targetRow.getDynamicObject("definelink");
                    String executelinkconfig = targetRow.getString("executelinkconfig");
                    if (targetentity == null || executelinkconfig == null || executelinkconfig.trim().isEmpty()) continue;
                    String sourceEntityNumber = sourceentity.getString("number");
                    String targetEntityNumber = targetentity.getString("number");
                    if (definelink == null) continue;
                    BillRelationDesignInfo sourceInfo = null;
                    BillRelationDesignInfo targetInfo = null;
                    String paramTypeClass = definelink.getString("paramtypeclass");
                    Class billRelationParamClass = TypesContainer.getOrRegister((String)paramTypeClass);
                    BillRelationParam billRelationParam = (BillRelationParam)SerializationUtils.fromJsonString((String)executelinkconfig, (Class)billRelationParamClass);
                    if (billRelationParam instanceof BillLinkRelationParam) {
                        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
                        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
                        String originLinkFiledKey = ((BillLinkRelationParam)billRelationParam).getOriginLinkFiledKey();
                        String targetLinkFiledKey = ((BillLinkRelationParam)billRelationParam).getTargetLinkFiledKey();
                        String fullOriginFiledKey = SRMLinkBillNodeHelper.getFullFiledKey(sourceEntityType, originLinkFiledKey);
                        IDataEntityProperty sourceFieldKeyType = SRMLinkBillNodeHelper.getDataEntityProperty(sourceEntityType, sourceEntityNumber, originLinkFiledKey);
                        String fullTargetFiledKey = SRMLinkBillNodeHelper.getFullFiledKey(targetEntityType, targetLinkFiledKey);
                        IDataEntityProperty targetFieldKeyType = SRMLinkBillNodeHelper.getDataEntityProperty(targetEntityType, targetEntityNumber, targetLinkFiledKey);
                        sourceInfo = new BillRelationDesignInfo(sourceEntityNumber, originLinkFiledKey);
                        targetInfo = new BillRelationDesignInfo(targetEntityNumber, targetLinkFiledKey);
                        targetInfo.setExecuteEntityNumber(targetEntityNumber);
                        sourceInfo.setExecuteEntityNumber(sourceEntityNumber);
                        targetInfo.setFullFiledKey(fullTargetFiledKey);
                        targetInfo.setFieldKeyClass(targetFieldKeyType.getClass());
                        sourceInfo.setFullFiledKey(fullOriginFiledKey);
                        sourceInfo.setFieldKeyClass(sourceFieldKeyType.getClass());
                        if (isEntryDim) {
                            targetInfo.setEntryNumber(billRelationParam.getTargetEntry());
                            targetInfo.setEntryDim(true);
                            sourceInfo.setEntryNumber(billRelationParam.getSourceEntry());
                            sourceInfo.setEntryDim(true);
                        }
                    } else if (billRelationParam instanceof BillBotpRelationParam) {
                        sourceInfo = new BillRelationDesignInfo(sourceEntityNumber, "id");
                        targetInfo = new BillRelationDesignInfo(targetEntityNumber, "id");
                        if (isEntryDim) {
                            sourceInfo.setFullFiledKey(billRelationParam.getSourceEntry() + ".id");
                            targetInfo.setFullFiledKey(billRelationParam.getTargetEntry() + ".id");
                            sourceInfo.setEntryDim(true);
                            targetInfo.setEntryDim(true);
                        } else {
                            sourceInfo.setFullFiledKey("id");
                            targetInfo.setFullFiledKey("id");
                        }
                        sourceInfo.setExecuteEntityNumber(((BillBotpRelationParam)billRelationParam).getExecuteSourceEntity());
                        targetInfo.setExecuteEntityNumber(((BillBotpRelationParam)billRelationParam).getExecuteTargetEntity());
                        sourceInfo.setEntryNumber(billRelationParam.getSourceEntry());
                        targetInfo.setEntryNumber(billRelationParam.getTargetEntry());
                    }
                    BillRelationDesignLinkInfo targetDesignNodeInfo = new BillRelationDesignLinkInfo(sourceInfo, targetInfo, definelink.getString("id"));
                    stepDirectInfo.add(targetDesignNodeInfo);
                }
                billRelationSchemeInfoMap.put(sourceentity.getString("number"), stepDirectInfo);
            }
        }
        return billRelationSchemeInfoMap;
    }

    public static Map<String, Collection<String>> assembleEntityGraphMap(DynamicObject executebillrelation) {
        LinkedHashMap<String, Collection<String>> entityGraphMap = new LinkedHashMap<String, Collection<String>>(16);
        if (executebillrelation != null) {
            DynamicObjectCollection entryentity = executebillrelation.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                DynamicObject sourceentity = row.getDynamicObject("sourceentity");
                DynamicObjectCollection targetRows = row.getDynamicObjectCollection("targetentryentity");
                LinkedList<String> refEntity = new LinkedList<String>();
                for (DynamicObject targetRow : targetRows) {
                    DynamicObject targetentity = targetRow.getDynamicObject("targetentity");
                    refEntity.add(targetentity.getString("number"));
                }
                entityGraphMap.putIfAbsent(sourceentity.getString("number"), refEntity);
            }
        }
        return entityGraphMap;
    }

    public static Map<String, Integer> getBillRelationGraphSet(DynamicObject executebillrelation) {
        LinkedHashMap<String, Integer> billrelationgraphset = new LinkedHashMap<String, Integer>();
        DynamicObjectCollection entryentity = executebillrelation.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryentity) {
            Integer seq = row.getInt("seq");
            billrelationgraphset.put(row.getString("sourceentity.id"), seq);
        }
        return billrelationgraphset;
    }

    public static DynamicObject getBillRelationCache(String executebillrelationid) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_executetracking", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)executebillrelationid).and(new QFilter("enable", "=", (Object)"1"))});
    }
}

