/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.datahandle;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.datahandle.IPurDataHandleAction;
import kd.scm.common.helper.datahandle.PurDataHandleContext;
import kd.scm.common.helper.datahandle.PurDataHandleResultManager;
import kd.scm.common.helper.datahandle.TaskStatusEnum;

public abstract class AbstractPurDataHandleAction
implements IPurDataHandleAction {
    private static final Log log = LogFactory.getLog(AbstractPurDataHandleAction.class);
    protected PurDataHandleContext context;
    private Long subTaskId;
    private PurDataHandleResultManager resultManager;
    protected Map<String, Object> resultMap = new HashMap<String, Object>(16);

    @Override
    public void execute() {
        this.updateEntrySubTaskInfo();
        this.doExecute();
    }

    public abstract void doExecute();

    public PurDataHandleContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(PurDataHandleContext context) {
        this.context = context;
    }

    public Long getSubTaskId() {
        return this.subTaskId;
    }

    @Override
    public void setSubTaskId(Long subTaskId) {
        this.subTaskId = subTaskId;
    }

    public PurDataHandleResultManager getResultManager() {
        return this.resultManager;
    }

    @Override
    public void setResultManager(PurDataHandleResultManager resultManager) {
        this.resultManager = resultManager;
    }

    protected void throwException() {
        throw new KDException(new ErrorCode("Excute error", this.resultMap.get("message").toString()), new Object[0]);
    }

    protected void updateEntrySubTaskInfo() {
        log.info("CurTask SupplierId : " + this.context.getInputArgs().getSupId() + "@@CurTask SourceBillId : " + this.context.getInputArgs().getSourceBillId() + "@@runtime context : " + this.context.toString() + "@@Excute Action TraceId : " + RequestContext.get().getTraceId());
        Long resultId = this.context.getInputArgs().getHandleDataResultId();
        QFilter filter = new QFilter("id", "=", (Object)resultId);
        filter.and("entryentity.subtask.id", "=", (Object)this.context.getCurSubTaskId());
        DynamicObject result = BusinessDataServiceHelper.loadSingle((String)"pbd_schandleresult", (String)"id,billno,context,progress,status,entryentity.substarttime,entryentity.subtime,entryentity.substatus,entryentity.detail", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection entry = result.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entry) {
            String substatus = entryRow.getString("substatus");
            if (substatus.equals(TaskStatusEnum.TASK_SUCCESS.getValue()) || substatus.equals("5")) continue;
            entryRow.set("substarttime", (Object)this.context.getCurSubTaskStartTime());
            entryRow.set("substatus", (Object)TaskStatusEnum.TASK_DOING.getValue());
            break;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
    }
}

