/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.multisystemjoint.ISystemJointDataHandleService;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.business.MultiDataChannelHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiSystemJointStrategyMatchHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiChannelHandleService;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiDataHandleChannelServiceTypes;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;

public abstract class AbstractMultiSystemJointDataHandleService
implements ISystemJointDataHandleService {
    protected static final Log log = LogFactory.getLog(AbstractMultiSystemJointDataHandleService.class);

    @Override
    public final MultiDataHandleResult executeDataHandle(String entityNumber, String operateKey, String executeInterface, Map<Long, String> billJointDataMap, MultiCustomParam customParam) {
        return this.executeOperationDataHandle(entityNumber, operateKey, executeInterface, billJointDataMap, customParam);
    }

    @Override
    public final MultiDataHandleResult executeDataHandle(String sourceNumber, List<DynamicObject> dynamicObjects, String keyField, String jointChannelField, MultiCustomParam multiCustomParam) {
        return this.executeSourceDataHandle(sourceNumber, dynamicObjects, keyField, jointChannelField, multiCustomParam);
    }

    protected abstract MultiDataHandleResult executeOperationDataHandle(String var1, String var2, String var3, Map<Long, String> var4, MultiCustomParam var5);

    protected abstract MultiDataHandleResult executeSourceDataHandle(String var1, List<DynamicObject> var2, String var3, String var4, MultiCustomParam var5);

    public final Map<Long, ScDataMultiJointChannelInfo> getMultiChannelInfoJointChannelFiled(String entityNumber, List<DynamicObject> dynamicObjects, String keyField, String jointChannelField) throws MultiSystemJointError {
        Map<Long, String> defaultStrategyMap = MultiSystemJointStrategyMatchHelper.getDefaultStrategy(dynamicObjects, keyField, jointChannelField);
        log.info("defaultStrategyMap:{}", (Object)SerializationUtils.toJsonString(defaultStrategyMap));
        return MultiDataChannelHelper.getMultiChannelInfoJointChannelData(entityNumber, defaultStrategyMap);
    }

    protected final MultiDataHandleResult doExecuteDataHandle(ScDataMultiJointChannelInfo scDataMultiJointChannelInfo, List<DynamicObject> dataExecuteConfig, Long[] currencyIds, MultiCustomParam multiCustomParam) {
        ScMultiChannelHandleService scChannelHandleService = this.initializeService(scDataMultiJointChannelInfo, dataExecuteConfig, multiCustomParam);
        return this.executeChannelService(scChannelHandleService, currencyIds);
    }

    protected final MultiDataHandleResult doExecuteDataHandle(ScDataMultiJointChannelInfo scDataMultiJointChannelInfo, List<DynamicObject> dataExecuteConfigs, List<DynamicObject> dynamicObjects, MultiCustomParam multiCustomParam) {
        ScMultiChannelHandleService scChannelHandleService = this.initializeService(scDataMultiJointChannelInfo, dataExecuteConfigs, multiCustomParam);
        return this.executeChannelService(scChannelHandleService, dynamicObjects);
    }

    protected final Map<Long, ScDataMultiJointChannelInfo> getMultiChannelInfoJointChannelData(String entityNumber, Map<Long, String> billJointDataMap) throws MultiSystemJointError {
        return MultiDataChannelHelper.getMultiChannelInfoJointChannelData(entityNumber, billJointDataMap);
    }

    protected final ScMultiChannelHandleService initializeService(ScDataMultiJointChannelInfo channelNumberInfo, List<DynamicObject> dataExecuteConfig, MultiCustomParam multiCustomParam) {
        ScMultiChannelHandleService scChannelHandleService = (ScMultiChannelHandleService)ScMultiDataHandleChannelServiceTypes.createEntityOperate(channelNumberInfo);
        scChannelHandleService.initialize(channelNumberInfo, dataExecuteConfig, multiCustomParam);
        return scChannelHandleService;
    }

    protected final MultiDataHandleResult executeChannelService(ScMultiChannelHandleService scMultiChannelHandleService, Long[] currencyIds) {
        return scMultiChannelHandleService.execute(currencyIds);
    }

    protected final MultiDataHandleResult executeChannelService(ScMultiChannelHandleService scMultiChannelHandleService, List<DynamicObject> dynamicObjects) {
        return scMultiChannelHandleService.execute(dynamicObjects);
    }
}

