/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;

public final class MultiChannelDispatchHelper {
    private static final Log log = LogFactory.getLog(MultiChannelDispatchHelper.class);

    public static boolean checkMultiJointSystem(Collection<String> verifyEntityNumbers) {
        boolean multiJointFlag = Boolean.FALSE;
        Map channelCacheMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_scdatachannel", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        for (String entityNumber : verifyEntityNumbers) {
            multiJointFlag = QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("materialentry.jointdatachannelid", "in", channelCacheMap.keySet())});
            if (!multiJointFlag) continue;
            break;
        }
        return multiJointFlag;
    }

    public static DynamicObject getBillJointChannelCache(String billEntity, Object[] billIds, String queryStr) {
        HashSet<String> jointDataChannelIds = new HashSet<String>(23);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)billEntity, (String)queryStr, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)}, (String)"id");){
            DataSet groupDataSet = dataSet.groupBy(new String[]{"jointdatachannelid"}).finish();
            while (groupDataSet.hasNext()) {
                Row row = groupDataSet.next();
                String jointdatachannelid = row.getString("jointdatachannelid");
                if (!StringUtils.isNotBlank((String)jointdatachannelid)) continue;
                jointDataChannelIds.add(jointdatachannelid);
            }
            groupDataSet.close();
        }
        return MultiChannelDispatchHelper.getSingleJointChannelId(jointDataChannelIds);
    }

    public static DynamicObject getBillJointChannelCache(String billEntity, Set<Long> billIds, String queryStr) {
        HashSet<String> jointDataChannelIds = new HashSet<String>(23);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)billEntity, (String)queryStr, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"id");){
            DataSet groupDataSet = dataSet.groupBy(new String[]{"jointdatachannelid"}).finish();
            while (groupDataSet.hasNext()) {
                Row row = groupDataSet.next();
                String jointdatachannelid = row.getString("jointdatachannelid");
                if (!StringUtils.isNotBlank((String)jointdatachannelid)) continue;
                jointDataChannelIds.add(jointdatachannelid);
            }
            groupDataSet.close();
        }
        return MultiChannelDispatchHelper.getSingleJointChannelId(jointDataChannelIds);
    }

    public static DynamicObject getBillSingleJointChannelCache(DynamicObject[] dynamicObjects, String entryKey) {
        HashSet<String> jointDataChannelIds = new HashSet<String>(23);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection(entryKey);
            DynamicProperty jointChannelProperty = rows.getDynamicObjectType().getProperty("jointdatachannelid");
            String jointChannelId = "";
            if (jointChannelProperty != null) {
                try {
                    DynamicObject row;
                    Object jointChannelIdValue;
                    if (!rows.isEmpty() && (jointChannelIdValue = jointChannelProperty.getValue((Object)(row = (DynamicObject)rows.get(0)))) != null) {
                        jointChannelId = String.valueOf(jointChannelIdValue);
                    }
                }
                catch (RuntimeException runtimeException) {
                    log.warn(String.valueOf(runtimeException.getMessage()));
                }
                jointDataChannelIds.add(jointChannelId);
                continue;
            }
            jointDataChannelIds.add(jointChannelId);
        }
        return MultiChannelDispatchHelper.getSingleJointChannelId(jointDataChannelIds);
    }

    public static boolean hasDefaultJointChannel(DynamicObject[] dynamicObjects, String systemJointTypeParam) {
        DynamicObject jointChannelData = MultiChannelDispatchHelper.getBillSingleJointChannelCache(dynamicObjects);
        return MultiChannelDispatchHelper.hasDefaultJointChannel(jointChannelData, systemJointTypeParam);
    }

    public static DynamicObject getBillSingleJointChannelCache(DynamicObject[] dynamicObjects) {
        return MultiChannelDispatchHelper.getBillSingleJointChannelCache(dynamicObjects, "materialentry");
    }

    public static boolean hasDefaultJointChannel(DynamicObject jointChannelCache, String systemJointTypeParam) {
        return SystemJointChannelHelper.hasSpecJointType((DynamicObject)jointChannelCache, (String)systemJointTypeParam);
    }

    public static String getJointSystemType(DynamicObject[] dynamicObjects) {
        DynamicObject dynamicObject = MultiChannelDispatchHelper.getBillSingleJointChannelCache(dynamicObjects);
        String jointSystemType = null;
        if (dynamicObject != null) {
            jointSystemType = dynamicObject.getString("jointchanneltype.jointsystemtype");
        }
        return jointSystemType;
    }

    private static DynamicObject getSingleJointChannelId(Set<String> jointDataChannelIds) {
        String singleJointChannelId = "";
        if (!jointDataChannelIds.isEmpty()) {
            if (jointDataChannelIds.size() == 1) {
                singleJointChannelId = (String)jointDataChannelIds.stream().findFirst().get();
            } else {
                throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u4e0e\u5f02\u6784\u7cfb\u7edf\u540c\u6b65\u5355\u636e\u573a\u666f\u4e2d\uff0c\u5355\u6b21\u8f93\u51fa\u540c\u6b65\u8bf7\u6c42\u4e0d\u652f\u6301\u591a\u4e2a\u6e20\u9053\u6570\u636e\u5904\u7406\u3002", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
            }
        }
        DynamicObject jointDataCache = null;
        jointDataCache = singleJointChannelId.trim().isEmpty() ? SystemJointChannelHelper.getDefaultJointChannelData() : SystemJointChannelHelper.getJointChannelData((String)singleJointChannelId);
        return jointDataCache;
    }
}

