/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiCosmicChannelHandleService;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiEASChannelHandleService;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiRemoteCosmicChannelHandleService;
import kd.scm.common.helper.multisystemjoint.jointchannel.ScMultiXkChannelHandleService;
import kd.scm.common.helper.scdatahandle.channel.CosmicChannelService;
import kd.scm.common.helper.scdatahandle.channel.EASChannelService;
import kd.scm.common.helper.scdatahandle.channel.XKChannelService;

public final class MultiChannelTypeFactoryHelper {
    private static final Log log = LogFactory.getLog(MultiChannelTypeFactoryHelper.class);

    public static DynamicObject getStdJointSystemType(String dataSourceConnectType) {
        String channelType = null;
        switch (dataSourceConnectType) {
            case "eas": {
                channelType = "eas";
                break;
            }
            case "k3cloud": 
            case "k3cloud_sdk": {
                channelType = "xkcloud";
                break;
            }
            case "ierp": {
                channelType = "ierp";
                break;
            }
            case "self": {
                channelType = "self";
                break;
            }
        }
        log.info("dataSourceConnectType:{},channelType:{}", (Object)dataSourceConnectType, (Object)channelType);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_datachanneltype", (QFilter[])new QFilter[]{new QFilter("jointsystemtype", "=", (Object)channelType)});
    }

    public static String getChannelTypeFactoryClass(String channelTypeNumber) {
        String channelTypeClass = null;
        DynamicObject datachanneltypecache = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_datachanneltype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)channelTypeNumber)});
        channelTypeClass = datachanneltypecache.getString("channelfactoryclass");
        log.info("channelTypeNumber:{},channelTypeClass:{}", (Object)channelTypeNumber, (Object)channelTypeClass);
        return channelTypeClass;
    }

    public static String getStdJointSystemTypeFactoryClass(String jointsystemtype) {
        String channelTypeClass = null;
        switch (jointsystemtype) {
            case "eas": {
                channelTypeClass = ScMultiEASChannelHandleService.class.getName();
                break;
            }
            case "xkcloud": {
                channelTypeClass = ScMultiXkChannelHandleService.class.getName();
                break;
            }
            case "self": {
                channelTypeClass = ScMultiCosmicChannelHandleService.class.getName();
                break;
            }
            case "ierp": {
                channelTypeClass = ScMultiRemoteCosmicChannelHandleService.class.getName();
                break;
            }
        }
        log.info("jointsystemtype:{},channelTypeClass:{}", (Object)jointsystemtype, (Object)channelTypeClass);
        return channelTypeClass;
    }

    public static String getStdJointSystemTypeChannelClass(String jointsystemtype) {
        String channelClass = null;
        switch (jointsystemtype) {
            case "eas": {
                channelClass = EASChannelService.class.getName();
                break;
            }
            case "xkcloud": {
                channelClass = XKChannelService.class.getName();
                break;
            }
            case "self": {
                channelClass = CosmicChannelService.class.getName();
                break;
            }
        }
        log.info("jointsystemtype:{},channelClass:{}", (Object)jointsystemtype, (Object)channelClass);
        return channelClass;
    }

    public static String getIscConnectType(String channelType) {
        String iscConnectType = null;
        switch (channelType) {
            case "eas": {
                iscConnectType = "eas";
                break;
            }
            case "xkcloud": {
                iscConnectType = "k3cloud";
                break;
            }
            case "self": {
                iscConnectType = "self";
                break;
            }
            case "ierp": {
                iscConnectType = "ierp";
                break;
            }
        }
        log.info("channelType:{},iscConnectType:{}", (Object)channelType, (Object)iscConnectType);
        return iscConnectType;
    }
}

