/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;

public class ScDataMultiJointChannelMetaHelper {
    private static IAppCache getAppCache() {
        return AppCache.get((String)"scdatachannelmeta");
    }

    public static ScDataMultiJointChannelInfo getScDataChannelInfo(String channelNumber) {
        return ScDataMultiJointChannelMetaHelper.getDbScDataChannelInfo(channelNumber);
    }

    public static ScDataMultiJointChannelInfo convertScDataChannelInfoCache(DynamicObject scdatachannelcache) {
        DynamicObject jointchanneltype;
        DynamicProperty isclinktypeproperty;
        DynamicObject iscdatasource;
        DynamicObject isclink;
        String connecterp;
        ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = new ScDataMultiJointChannelInfo();
        scDataMultiJointChannelInfo.setChannelId(scdatachannelcache.getString("id"));
        scDataMultiJointChannelInfo.setChannelNumber(scdatachannelcache.getString("number"));
        String channelclass = scdatachannelcache.getString("channelclass");
        if (channelclass != null) {
            scDataMultiJointChannelInfo.setChannelClass(channelclass);
        }
        if ((connecterp = scdatachannelcache.getString("connecterp")) != null) {
            scDataMultiJointChannelInfo.setConnecterp(connecterp);
        }
        if ((isclink = scdatachannelcache.getDynamicObject("isclink")) != null) {
            scDataMultiJointChannelInfo.setIscLink(isclink.getLong("id"));
            scDataMultiJointChannelInfo.setDatabaseType(isclink.getString("database_type"));
            scDataMultiJointChannelInfo.setIscLinkNumber(isclink.getString("number"));
        }
        if ((iscdatasource = scdatachannelcache.getDynamicObject("iscdatasource")) != null) {
            scDataMultiJointChannelInfo.setIscDataSource(iscdatasource.getLong("id"));
            scDataMultiJointChannelInfo.setIscDataSourceNumber(iscdatasource.getString("number"));
        }
        if ((isclinktypeproperty = (jointchanneltype = scdatachannelcache.getDynamicObject("jointchanneltype")).getDynamicObjectType().getProperty("jointsystemtype")) == null) {
            jointchanneltype = BusinessDataServiceHelper.loadSingleFromCache((Object)jointchanneltype.getString("id"), (String)"pbd_datachanneltype");
        }
        if (jointchanneltype == null) {
            throw new KDException(new ErrorCode("", ""), new Object[0]);
        }
        scDataMultiJointChannelInfo.setChannelTypeId(jointchanneltype.getString("id"));
        scDataMultiJointChannelInfo.setChannelTypeNumber(jointchanneltype.getString("number"));
        scDataMultiJointChannelInfo.setJointSystemType(jointchanneltype.getString("jointsystemtype"));
        scDataMultiJointChannelInfo.setIsDefault(scdatachannelcache.getBoolean("isdefault"));
        return scDataMultiJointChannelInfo;
    }

    public static void putScDataChannelInfoCache(String channelNumber, ScDataMultiJointChannelInfo scDataMultiJointChannelInfo) {
        String makeCacheKey = ScDataMultiJointChannelMetaHelper.getCacheKey(channelNumber);
        ScDataMultiJointChannelMetaHelper.getAppCache().put(makeCacheKey, (Object)SerializationUtils.toJsonString((Object)scDataMultiJointChannelInfo));
    }

    private static String getCacheKey(String channelNumber) {
        return CacheKeyUtil.makeCacheKey("pur", channelNumber);
    }

    private static ScDataMultiJointChannelInfo getDbScDataChannelInfo(String channelNumber) {
        ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = null;
        DynamicObject scdatachannel = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)channelNumber).and(new QFilter("enable", "=", (Object)"1"))});
        if (scdatachannel != null) {
            scDataMultiJointChannelInfo = ScDataMultiJointChannelMetaHelper.convertScDataChannelInfoCache(scdatachannel);
        }
        return scDataMultiJointChannelInfo;
    }
}

