/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.jointchannel;

import kd.bos.dataentity.TypesContainer;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.scm.common.helper.multisystemjoint.business.MultiChannelTypeFactoryHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.jointchannel.IScChannelHandleService;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;

public final class ScMultiDataHandleChannelServiceTypes {
    private static IAppCache getAppCache() {
        return AppCache.get((String)"SCM_PUR_SCMULTIJOINT");
    }

    public static void register(String channelNumber, String className) {
        String makeCacheKey = ScMultiDataHandleChannelServiceTypes.getCacheKey(channelNumber);
        ScMultiDataHandleChannelServiceTypes.getAppCache().put(makeCacheKey, (Object)className);
    }

    public static IScChannelHandleService createEntityOperate(ScDataMultiJointChannelInfo scDataMultiJointChannelInfo) {
        String channelTypeNumber = scDataMultiJointChannelInfo.getChannelTypeNumber();
        String jointSystemType = scDataMultiJointChannelInfo.getJointSystemType();
        String makeCacheKey = ScMultiDataHandleChannelServiceTypes.getCacheKey(channelTypeNumber);
        String channelTypeClass = (String)ScMultiDataHandleChannelServiceTypes.getAppCache().get(makeCacheKey, String.class);
        if (channelTypeClass == null || channelTypeClass.trim().isEmpty()) {
            channelTypeClass = scDataMultiJointChannelInfo.getChannelTypeFactoryClass();
            if (channelTypeClass == null) {
                channelTypeClass = MultiChannelTypeFactoryHelper.getStdJointSystemTypeFactoryClass(jointSystemType);
            }
            ScMultiDataHandleChannelServiceTypes.register(channelTypeNumber, channelTypeClass);
        }
        return (IScChannelHandleService)TypesContainer.createInstance((String)channelTypeClass);
    }

    private static String getCacheKey(String channelNumber) {
        return CacheKeyUtil.makeCacheKey("pur", channelNumber);
    }

    static {
        ScMultiDataHandleChannelServiceTypes.register("eas", MultiChannelTypeFactoryHelper.getStdJointSystemTypeFactoryClass("eas"));
        ScMultiDataHandleChannelServiceTypes.register("xkcloud", MultiChannelTypeFactoryHelper.getStdJointSystemTypeFactoryClass("xkcloud"));
        ScMultiDataHandleChannelServiceTypes.register("self", MultiChannelTypeFactoryHelper.getStdJointSystemTypeFactoryClass("self"));
        ScMultiDataHandleChannelServiceTypes.register("ierp", MultiChannelTypeFactoryHelper.getStdJointSystemTypeFactoryClass("ierp"));
    }
}

