/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.param.engine;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointException;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.api.IMultiPushDataHandler;

public abstract class AbstractMultiPushHandler
implements IMultiPushDataHandler {
    protected static Log log = LogFactory.getLog(AbstractMultiPushHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void executePush(MultiDataHandleResult scDataHandleResult, ScMultiParamArgs multiParamArgs) {
        try {
            this.callIdempotentCheck(multiParamArgs);
            try {
                this.doExecute(scDataHandleResult, multiParamArgs);
            }
            catch (KDException exception) {
                ErrorCode exceptionErrorCode = exception.getErrorCode();
                if (exceptionErrorCode != null && "SYSTEMJOINTEXCEPTION".equals(exceptionErrorCode.getCode())) {
                    throw new MultiSystemJointException(String.valueOf(exceptionErrorCode.getMessage()), exception.getCause());
                }
                throw exception;
            }
            finally {
                scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                log.debug("AbstractMultiPushHandler execute done.");
            }
        }
        finally {
            log.debug("AbstractMultiPushHandler execute done.");
        }
    }

    protected abstract void doExecute(MultiDataHandleResult var1, ScMultiParamArgs var2);
}

