/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.pmapply;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.pmapply.PmApplyStatusUpdate;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;

public abstract class AbstractPmApplyStatusUpdate
implements PmApplyStatusUpdate {
    private Log log = LogFactory.getLog(AbstractPmApplyStatusUpdate.class);
    private String IDS = "ids";
    private String STATUS = "status";
    private String entityKey = null;
    private String entryEntityKey = null;
    private String coreBillKey = null;
    private String operaKey = null;
    private final StringBuilder selectPro = new StringBuilder("id");
    private String targetStatus = null;
    private String doneStatusKey = null;
    private final Set<String> doneStatusList = new LinkedHashSet<String>();
    private String doingStatusKey = null;
    private final Set<String> doingStatusList = new LinkedHashSet<String>();
    private String serviceName = "PmSupColService";
    private String methodName = null;
    private Set<String> pmApplyPkIds = null;
    private DynamicObject[] data = null;

    protected PmApplyStatusUpdate SetEntityKey(String entityKey) {
        this.entityKey = entityKey;
        return this;
    }

    protected PmApplyStatusUpdate SetEntryEntityKey(String entryEntityKey) {
        this.entryEntityKey = entryEntityKey;
        return this;
    }

    protected PmApplyStatusUpdate SetCoreBillKey(String coreBillKey) {
        this.coreBillKey = coreBillKey;
        return this;
    }

    protected PmApplyStatusUpdate SetOperaKey(String operaKey) {
        this.operaKey = operaKey;
        return this;
    }

    protected PmApplyStatusUpdate SetData(DynamicObject[] data) {
        this.data = data;
        return this;
    }

    protected PmApplyStatusUpdate SetPmApplyPkIds(Set<String> pmApplyPkIds) {
        this.pmApplyPkIds = pmApplyPkIds;
        return this;
    }

    protected PmApplyStatusUpdate SetDoingStatusKey(String doingStatusKey) {
        this.doingStatusKey = doingStatusKey;
        return this;
    }

    protected PmApplyStatusUpdate addDoingStatus(Set<String> doingStatusList) {
        this.doingStatusList.addAll(doingStatusList);
        return this;
    }

    protected PmApplyStatusUpdate SetHaveDoneStatusKey(String doneStatusKey) {
        this.doneStatusKey = doneStatusKey;
        return this;
    }

    protected PmApplyStatusUpdate addDoneStatus(Set<String> doneStatusList) {
        this.doneStatusList.addAll(doneStatusList);
        return this;
    }

    protected PmApplyStatusUpdate SetSelectPro(String[] selectPro) {
        if (!this.selectPro.toString().contains(this.doingStatusKey)) {
            this.selectPro.append(',').append(this.doingStatusKey);
        }
        if (!this.selectPro.toString().contains(this.doneStatusKey)) {
            this.selectPro.append(',').append(this.doneStatusKey);
        }
        for (String pro : selectPro) {
            if (this.selectPro.toString().contains(pro)) continue;
            this.selectPro.append(',').append(pro);
        }
        return this;
    }

    protected PmApplyStatusUpdate SetTargetStatus(String status) {
        this.targetStatus = status;
        return this;
    }

    PmApplyStatusUpdate SetMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    PmApplyStatusUpdate SetServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public void execute() {
        this.log.info(this.operaKey);
        this.log.info(this.entityKey);
        if (this.data != null) {
            HashSet<String> pmApplyPkIdsLocal = new HashSet<String>(this.data.length);
            for (DynamicObject bill : this.data) {
                DynamicObjectCollection materialentry = bill.getDynamicObjectCollection(this.entryEntityKey);
                for (DynamicObject row : materialentry) {
                    String srcBillId = row.getString(this.coreBillKey);
                    if (srcBillId == null || srcBillId.isEmpty()) continue;
                    pmApplyPkIdsLocal.add(srcBillId);
                }
            }
            this.SetPmApplyPkIds(pmApplyPkIdsLocal);
        }
        this.log.info(this.pmApplyPkIds.toString());
        ArrayList<String> haveDonePkIds = new ArrayList<String>();
        ArrayList<String> doingPkIds = new ArrayList<String>();
        if ("unaudit".equals(this.operaKey) || "terminate".equals(this.operaKey)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.entityKey, (String)this.selectPro.toString(), (QFilter[])new QFilter[]{new QFilter(this.entryEntityKey + '.' + this.coreBillKey, "in", this.pmApplyPkIds)}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String srcbillid = row.getString(this.coreBillKey);
                    String doneStatus = row.getString(this.doneStatusKey);
                    String doingStatus = row.getString(this.doingStatusKey);
                    if (this.doneStatusList.contains(doneStatus) && !haveDonePkIds.contains(srcbillid)) {
                        haveDonePkIds.add(srcbillid);
                    }
                    if (!this.doingStatusList.contains(doingStatus) || doingPkIds.contains(srcbillid)) continue;
                    doingPkIds.add(srcbillid);
                }
            }
        } else if ("audit".equals(this.operaKey) && "sou_compare".equals(this.entityKey)) {
            this.dealWithInquiry();
        }
        if (!doingPkIds.isEmpty()) {
            this.pmApplyPkIds.removeAll(doingPkIds);
            haveDonePkIds.removeAll(doingPkIds);
            this.log.info(((Object)doingPkIds).toString());
            HashMap<String, Object> paraMap = new HashMap<String, Object>(2);
            paraMap.put(this.IDS, CommonUtil.stringList2objList(doingPkIds));
            paraMap.put(this.STATUS, "A");
            this.executeService(paraMap);
        }
        if (!haveDonePkIds.isEmpty()) {
            this.log.info(((Object)haveDonePkIds).toString());
            this.pmApplyPkIds.removeAll(haveDonePkIds);
            HashMap<String, Object> paraMap = new HashMap<String, Object>(2);
            paraMap.put(this.IDS, CommonUtil.stringList2objList(haveDonePkIds));
            paraMap.put(this.STATUS, "B");
            this.executeService(paraMap);
        }
        if (!this.pmApplyPkIds.isEmpty()) {
            this.log.info(this.pmApplyPkIds.toString());
            HashMap<String, Object> paraMap = new HashMap<String, Object>(2);
            paraMap.put(this.IDS, CommonUtil.stringList2objList(this.pmApplyPkIds));
            paraMap.put(this.STATUS, this.targetStatus);
            this.executeService(paraMap);
        }
    }

    private void dealWithInquiry() {
        HashSet<String> inquiryNoSets = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.entityKey, (String)this.selectPro.toString(), (QFilter[])new QFilter[]{new QFilter(this.entryEntityKey + '.' + this.coreBillKey, "in", this.pmApplyPkIds)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String doneStatus = row.getString(this.doneStatusKey);
                if (!this.doneStatusList.contains(doneStatus)) continue;
                inquiryNoSets.add(row.getString("inquiryno"));
            }
        }
        var3_3 = null;
        try (DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"sou_inquiry", (String)"materialentry.prbillid prbillid,billno,bizstatus", (QFilter[])new QFilter[]{new QFilter("materialentry.prbillid", "in", this.pmApplyPkIds)}, (String)"id");){
            for (Row row : dataSet1) {
                if (inquiryNoSets.contains(row.getString("billno")) || "E".equals(row.getString("bizstatus"))) continue;
                this.pmApplyPkIds.remove(row.getString("prbillid"));
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private void executeService(Map<String, Object> paraMap) {
        try {
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)this.serviceName, (String)this.methodName, (Object[])new Object[]{paraMap});
        }
        catch (Exception e) {
            this.log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
    }
}

