/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.channel;

import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.channel.HandleServicePlugInProxy;
import kd.scm.common.helper.scdatahandle.entity.ScDataServiceInfo;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractServiceDataHandlePlugin;
import kd.scm.common.util.ExceptionUtil;

public final class HandleServiceConfigProxy
extends HandleServicePlugInProxy {
    public HandleServiceConfigProxy(Map<String, Map<String, Object>> pluginsMetas) {
        super(pluginsMetas);
    }

    public void createScDataService(Map<String, Object> scServiceConfigMap, String scDataConfigId) {
        for (Map.Entry<String, Object> entry : scServiceConfigMap.entrySet()) {
            String serviceClass;
            String entryKey = entry.getKey();
            ScDataServiceInfo dataServiceInfo = (ScDataServiceInfo)SerializationUtils.fromJsonString((String)entry.getValue().toString(), ScDataServiceInfo.class);
            if (dataServiceInfo == null || (serviceClass = dataServiceInfo.getServiceClass()) == null) continue;
            AbstractServiceDataHandlePlugin serviceDataHandlePlugin = null;
            try {
                serviceDataHandlePlugin = (AbstractServiceDataHandlePlugin)TypesContainer.createInstance((String)serviceClass);
                serviceDataHandlePlugin.setScDataServiceInfo(dataServiceInfo);
                serviceDataHandlePlugin.setScDataConfigId(scDataConfigId);
                String currDataHandleArgs = dataServiceInfo.getScDataHandleArgsMap().get(scDataConfigId);
                if (currDataHandleArgs == null || currDataHandleArgs.isEmpty()) continue;
                ScDataHandleArgs scDataHandleArgs = (ScDataHandleArgs)SerializationUtils.fromJsonString((String)currDataHandleArgs, ScDataHandleArgs.class);
                serviceDataHandlePlugin.setScDataHandleArgsClass(scDataHandleArgs.getClass());
                scDataHandleArgs.setEntity(dataServiceInfo.getEntityKey());
                serviceDataHandlePlugin.setScDataHandleArgs(scDataHandleArgs);
                this.registerPlugIn(entryKey, serviceDataHandlePlugin);
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public void fireAssembleCosmicHandleArgs(AssembleHandleArgs majorArgs) {
        for (AbstractServiceDataHandlePlugin dataHandlePlugin : this.plugIns.values()) {
            AssembleHandleArgs assembleHandleArgs = new AssembleHandleArgs(dataHandlePlugin.assembleRefHandleArgs());
            dataHandlePlugin.assembleCosmicHandleArgs(assembleHandleArgs);
        }
    }

    @Override
    public void fireAssembleEASHandleArgs(AssembleHandleArgs majorArgs) {
        for (AbstractServiceDataHandlePlugin dataHandlePlugin : this.plugIns.values()) {
            AssembleHandleArgs assembleHandleArgs = new AssembleHandleArgs(dataHandlePlugin.assembleRefHandleArgs());
            dataHandlePlugin.assembleEASHandleArgs(assembleHandleArgs);
        }
    }

    @Override
    public void fireAssembleXKHandleArgs(AssembleHandleArgs majorArgs) {
        for (AbstractServiceDataHandlePlugin dataHandlePlugin : this.plugIns.values()) {
            AssembleHandleArgs assembleHandleArgs = new AssembleHandleArgs(dataHandlePlugin.assembleRefHandleArgs());
            dataHandlePlugin.assembleXKHandleArgs(assembleHandleArgs);
        }
    }
}

