/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.mq;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfig;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleException;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.helper.scdatahandle.log.ScDataHandleLog;
import kd.scm.common.helper.scdatahandle.storedata.AbstractPushDataHandler;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ExceptionUtil;

public class ScDataHandleConsumer
implements MessageConsumer {
    private Log logger = LogFactory.getLog(ScDataHandleConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean b, MessageAcker messageAcker) {
        ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo = (ScStoreDataHandleMessageInfo)body;
        String scDataHandleFailId = scStoreDataHandleMessageInfo.getScDataHandleFailId();
        ScDataHandleLogInfo scDataHandleLogInfo = this.assembleScDataLog();
        try {
            scDataHandleLogInfo.setFailDataHandle(scDataHandleFailId);
            this.logger.info(scStoreDataHandleMessageInfo.toString());
            this.logger.info("messageId:" + messageId);
            ScDataHandleConfig scDataHandleConfig = scStoreDataHandleMessageInfo.getScDataHandleConfig();
            String channelClass = scDataHandleConfig.getScHandleDataInfo();
            scDataHandleLogInfo.setEntityDesc(scDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(scDataHandleConfig.getOperateDesc());
            AbstractPushDataHandler abstractHandlePlugin = (AbstractPushDataHandler)TypesContainer.createInstance((String)channelClass);
            ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
            abstractHandlePlugin.exec(scDataHandleResult, scStoreDataHandleMessageInfo.getScDataHandleArgs());
            scDataHandleLogInfo.setState("success");
            scDataHandleLogInfo.setResult("success");
            scDataHandleLogInfo.setResultTag("mqmessageId:" + messageId + "success");
            messageAcker.ack(messageId);
        }
        catch (ScDataHandleException e) {
            scDataHandleLogInfo.setState("fail");
            scDataHandleLogInfo.setResult(e.getMessage());
            scDataHandleLogInfo.setResultTag("mqmessageId:" + messageId + ExceptionUtil.getStackTrace((Throwable)e));
            this.logger.error(ExceptionUtil.getStackTrace((Throwable)e));
            this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u91cd\u8bd5\uff0cmessageId\uff1a" + messageId);
            messageAcker.ack(messageId);
        }
        catch (Throwable e) {
            scDataHandleLogInfo.setState("fail");
            scDataHandleLogInfo.setResult(e.getMessage());
            scDataHandleLogInfo.setResultTag("mqmessageId:" + messageId + ExceptionUtil.getStackTrace((Throwable)e));
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
            this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u4e22\u5f03\uff0cmessageId\uff1a" + messageId);
            messageAcker.discard(messageId);
        }
        finally {
            MutexHelper.release((String)"pbd_scdatahandlefail", (String)"modify", (String)scDataHandleFailId);
            ScDataHandleLog scDataHandleLog = new ScDataHandleLog();
            scDataHandleLog.info(scDataHandleLogInfo);
            this.logger.info("\u8bb0\u5f55\u534f\u540c\u6570\u636e\u5904\u7406\u961f\u5217\u6267\u884c\u6570\u636e\u7ed3\u675f");
        }
    }

    private ScDataHandleLogInfo assembleScDataLog() {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        RequestContext rc = RequestContext.get();
        scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
        scDataHandleLogInfo.setTraceId(rc.getTraceId());
        scDataHandleLogInfo.setUserName(rc.getUserName());
        scDataHandleLogInfo.setModifier(Long.valueOf(rc.getCurrUserId()));
        scDataHandleLogInfo.setModifyTime(TimeServiceHelper.now());
        scDataHandleLogInfo.setCreateTime(TimeServiceHelper.now());
        scDataHandleLogInfo.setCreator(Long.valueOf(rc.getCurrUserId()));
        scDataHandleLogInfo.setLogAppId("pbd");
        scDataHandleLogInfo.setLogDim("scdataframe");
        scDataHandleLogInfo.setLogType("successlog");
        return scDataHandleLogInfo;
    }
}

