/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.scmeta;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.scdatahandle.entity.ScDataChannelInfo;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;

public class ScDataChannelMeta {
    private static IAppCache getAppCache() {
        return AppCache.get((String)"scdatachannelmeta");
    }

    public static ScDataChannelInfo getScDataChannelInfo(String channelNumber) {
        String makeCacheKey = CacheKeyUtil.makeCacheKey(channelNumber);
        String channelInfoString = (String)ScDataChannelMeta.getAppCache().get(makeCacheKey, String.class);
        ScDataChannelInfo scDataChannelInfo = null;
        if (channelInfoString != null) {
            scDataChannelInfo = (ScDataChannelInfo)SerializationUtils.fromJsonString((String)channelInfoString, ScDataChannelInfo.class);
        }
        if (scDataChannelInfo != null) {
            return scDataChannelInfo;
        }
        scDataChannelInfo = ScDataChannelMeta.getDbScDataChannelInfo(channelNumber);
        ScDataChannelMeta.putScDataChannelInfoCache(makeCacheKey, scDataChannelInfo);
        return scDataChannelInfo;
    }

    public static void putScDataChannelInfoCache(String channelNumber, ScDataChannelInfo scDataChannelInfo) {
        String makeCacheKey = CacheKeyUtil.makeCacheKey(channelNumber);
        ScDataChannelMeta.getAppCache().put(makeCacheKey, (Object)SerializationUtils.toJsonString((Object)scDataChannelInfo));
    }

    private static ScDataChannelInfo getDbScDataChannelInfo(String channelNumber) {
        ScDataChannelInfo scDataChannelInfo = null;
        DynamicObject scdatachannel = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)channelNumber).and(new QFilter("enable", "=", (Object)"1"))});
        if (scdatachannel != null) {
            scDataChannelInfo = new ScDataChannelInfo();
            scDataChannelInfo.setChannelId(scdatachannel.getString("id"));
            scDataChannelInfo.setChannelNumber(scdatachannel.getString("number"));
            scDataChannelInfo.setChannelClass(scdatachannel.getString("channelclass"));
            DynamicObject isclink = scdatachannel.getDynamicObject("isclink");
            if (isclink != null) {
                scDataChannelInfo.setIscLink(isclink.getLong("id"));
                scDataChannelInfo.setIscLinkNumber(isclink.getString("number"));
                scDataChannelInfo.setDatabaseType(isclink.getString("database_type"));
            }
            scDataChannelInfo.setConnecterp(scdatachannel.getString("connecterp"));
        }
        return scDataChannelInfo;
    }
}

