/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.storedata;

import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleException;
import kd.scm.common.helper.scdatahandle.storedata.AbstractPushDataHandler;
import kd.scm.common.systemjoint.SystemJointServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class CosmicPushDataHandler
extends AbstractPushDataHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doExec(ScDataHandleResult scDataHandleResult, ScDataHandleArgs scDataHandleArgs) {
        if (scDataHandleArgs instanceof CosmicParamArgs) {
            CosmicParamArgs cosmicParamArgs = (CosmicParamArgs)scDataHandleArgs;
            try (TXHandle t = TX.required();){
                Object object = SystemJointServiceHelper.executeStdMService((String)"self", (String)cosmicParamArgs.getCloudId(), (String)cosmicParamArgs.getAppId(), (String)cosmicParamArgs.getServiceName(), (String)cosmicParamArgs.getMethodName(), (Object[])new Object[]{cosmicParamArgs.getParamMap()});
                if (!(object instanceof Map)) return;
                scDataHandleResult.setMessage(String.valueOf(((Map)object).get("message")));
                scDataHandleResult.setSuccess((Boolean)((Map)object).get("succed"));
                scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                return;
            }
            catch (RuntimeException e) {
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                scDataHandleResult.setMessage(e.getMessage());
                scDataHandleResult.setSuccess(Boolean.FALSE);
                scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                throw new ScDataHandleException("", e.getMessage(), e);
            }
        } else {
            log.warn("scDataHandleArgs not instanceof CosmicParamArgs");
        }
    }
}

