/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.storedata;

import java.util.HashMap;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleException;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.storedata.AbstractPushDataHandler;
import kd.scm.common.isc.util.IerpIscK3CloudSend;
import kd.scm.common.util.ExceptionUtil;

public class XKPushDataHandler
extends AbstractPushDataHandler {
    @Override
    public void doExec(ScDataHandleResult scDataHandleResult, ScDataHandleArgs scDataHandleArgs) {
        if (scDataHandleArgs instanceof XkParamArgs) {
            IerpIscK3CloudSend iscSend = new IerpIscK3CloudSend();
            HashMap<String, String> objectMap = new HashMap<String, String>(1);
            String iscDataLinkNumber = scDataHandleArgs.getIscDataLinkNumber();
            if (iscDataLinkNumber != null && !iscDataLinkNumber.isEmpty()) {
                objectMap.put("number", iscDataLinkNumber);
            }
            XkParamArgs xkParamArgs = (XkParamArgs)scDataHandleArgs;
            String msg = "";
            try {
                msg = iscSend.doExec(xkParamArgs.getParamMap(), xkParamArgs.getMethod(), xkParamArgs.getFacade(), objectMap);
                scDataHandleResult.setMessage(msg);
            }
            catch (RuntimeException e) {
                scDataHandleResult.setMessage(e.getMessage());
                scDataHandleResult.setSuccess(Boolean.FALSE);
                scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                throw new ScDataHandleException("", e.getMessage(), e);
            }
        } else {
            log.warn("scDataHandleArgs not instanceof XkParamArgs");
        }
    }
}

