/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.malcore.enums.SaleStatusEnum;

public class EntPackageSelectionImportOp
extends BatchImportPlugin {
    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billdata = iterator.next();
            JSONObject data = billdata.getData();
            if (Objects.isNull(data)) continue;
            StringBuilder msg = this.checkImportValid(billdata);
            if (msg.toString().length() > 0) {
                logger.log((Integer)data.getObject("rowNum", Integer.class), msg.toString());
                logger.fail();
                iterator.remove();
                continue;
            }
            JSONObject createorg = (JSONObject)data.getObject("createorg", JSONObject.class);
            boolean validEntryResult = this.validEntrys(data, logger, createorg);
            if (validEntryResult) continue;
            logger.fail();
            iterator.remove();
        }
    }

    private boolean validEntrys(JSONObject data, ImportLogger logger, JSONObject org) {
        List entryentity = (List)data.getObject("entryentity", List.class);
        DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)org.getString("number")), new QFilter("fispurchase", "=", (Object)true)});
        if (!CollectionUtils.isEmpty((Collection)entryentity)) {
            JSONObject goods = null;
            boolean isprimary = false;
            Iterator entryIts = entryentity.iterator();
            ArrayList<String> prodmanageList = new ArrayList<String>(entryentity.size());
            while (entryIts.hasNext()) {
                JSONObject entry = (JSONObject)entryIts.next();
                goods = entry.getJSONObject("goods");
                if (goods == null) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e3a\u7a7a\uff0c\u8be5\u884c\u4e0d\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_2", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                prodmanageList.add(goods.getString("number"));
                if (selfGoodsEntryCol == null || selfGoodsEntryCol.size() == 0) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5ba1\u6279\u5355\u4f4d\u201d\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_3", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty == null || BigDecimal.ZERO.compareTo(qty) >= 0) {
                    entry.put("qty", (Object)BigDecimal.ONE);
                } else {
                    qty = qty.setScale(0, 5);
                    entry.put("qty", (Object)qty);
                }
                if (isprimary && entry.getBooleanValue("isprimary")) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u4e00\u4e2a\u91c7\u8d2d\u5957\u9910\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u5546\u54c1\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_4", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!entry.getBooleanValue("isprimary")) continue;
                isprimary = true;
            }
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            Map<String, DynamicObject> goodsMap = this.getGoodsMap(prodmanageList);
            Iterator entryIt = entryentity.iterator();
            long firstSupplierid = 0L;
            long supplierid = 0L;
            boolean i = false;
            while (entryIt.hasNext()) {
                JSONObject entry = (JSONObject)entryIt.next();
                goods = entry.getJSONObject("goods");
                if (goods == null) {
                    entryIts.remove();
                    continue;
                }
                String goodsnumber = goods.getString("number");
                if (!goodsMap.containsKey(goodsnumber)) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u6b63\u786e\u6216\u8005\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_5", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                DynamicObject goodsData = goodsMap.get(goods.getString("number"));
                if (!i) {
                    firstSupplierid = goodsData.getLong("supplier.id");
                }
                supplierid = goodsData.getLong("supplier.id");
                if (!supIdList.contains(goodsData.get("supplier.id"))) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u6b63\u786e\u6216\u8005\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_6", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                if (supplierid != firstSupplierid) {
                    logger.log((Integer)data.getObject("rowNum", Integer.class), ResManager.loadKDString((String)"\u201c\u5546\u54c1\u7f16\u7801\u201d\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5546\u5bb6\uff0c\u8bf7\u68c0\u67e5\u540e\u5f15\u5165\u3002", (String)"EntPackageSelectionImportOp_7", (String)"scm-ent-opplugin", (Object[])new Object[0]));
                    return false;
                }
                HashMap<String, Object> supplierMap = new HashMap<String, Object>();
                supplierMap.put("importprop", "id");
                supplierMap.put("id", supplierid);
                data.put("headsupplier", supplierMap);
                entry.put("source", (Object)"pmm_prodmanage");
                HashMap<String, Object> unitMap = new HashMap<String, Object>();
                unitMap.put("importprop", "id");
                unitMap.put("id", goodsData.getLong("unit.id"));
                entry.put("unit", unitMap);
            }
        }
        return true;
    }

    private Map<String, DynamicObject> getGoodsMap(List<String> selfGoodsNumbers) {
        HashMap<String, DynamicObject> goodsMap = new HashMap<String, DynamicObject>();
        if (!selfGoodsNumbers.isEmpty()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("number", "in", selfGoodsNumbers));
            qFilters.add(new QFilter("source", "=", (Object)"1"));
            qFilters.add(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.SALE.getVal()).or(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.PARTSALE.getVal())));
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.id,supplier.id,number ,source", (QFilter[])qFilters.toArray(new QFilter[0]));
            for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                goodsMap.put(selfGoodsEntry.getString("number"), selfGoodsEntry);
            }
        }
        return goodsMap;
    }

    private StringBuilder checkImportValid(ImportBillData data) {
        Map createOrgData = (Map)data.getData().get((Object)"createorg");
        Map nameData = (Map)data.getData().get((Object)"name");
        StringBuilder msg = new StringBuilder();
        if (nameData == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5957\u9910\u540d\u79f0\u201d\u3002", (String)"EntPackageSelectionImportOp_0", (String)"scm-ent-opplugin", (Object[])new Object[0]));
        }
        if (createOrgData == null) {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ba1\u6279\u5355\u4f4d\u201d\u3002", (String)"EntPackageSelectionImportOp_1", (String)"scm-ent-opplugin", (Object[])new Object[0]));
        }
        return msg;
    }
}

