/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.malcore.util.prodinfochange.MalProdInfoChangeUtil;
import kd.scm.malcore.util.prodinfochange.factory.MalProdInfoChangeFactory;
import kd.scm.malcore.util.prodinfochange.handle.CommonFieldChangeHandle;
import kd.scm.malcore.util.prodinfochange.handle.Impl.PicturePropChangeHandleImpl;
import kd.scm.malcore.util.prodinfochange.handle.Impl.ProdAttributeEntryChangeHandleImpl;

public class EntProdManageChangeCfmAgreeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("prod");
        fieldKeys.add("srcdata");
        fieldKeys.add("cfmstatus");
        fieldKeys.add("cfmdate");
        fieldKeys.add("cfm");
        fieldKeys.add("entryentity.chgfield");
        fieldKeys.add("entryentity.oldvalue");
        fieldKeys.add("entryentity.newvalue");
        fieldKeys.add("entryentity.fieldname");
        fieldKeys.add("entryentity.infotype");
        fieldKeys.add("entryentity.basedataid");
        fieldKeys.add("entryentity.entryname");
        fieldKeys.add("entryentity.srcbillentryid");
        fieldKeys.add("entryentity.entryseq");
        fieldKeys.add("oldthumbnail");
        fieldKeys.add("thumbnail");
        fieldKeys.add("oldpicture1");
        fieldKeys.add("picture1");
        fieldKeys.add("oldpicture2");
        fieldKeys.add("picture2");
        fieldKeys.add("oldpicture3");
        fieldKeys.add("picture3");
        fieldKeys.add("oldpicture4");
        fieldKeys.add("picture4");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashMap<Long, DynamicObject> prodIdAndDynMap = new HashMap<Long, DynamicObject>(dynamicObjects.length);
        ArrayList<Long> prodIds = new ArrayList<Long>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            prodIdAndDynMap.put(dynamicObject.getLong("prod_id"), dynamicObject);
            prodIds.add(dynamicObject.getLong("prod_id"));
        }
        QFilter qFilter = new QFilter("id", "in", prodIdAndDynMap.keySet());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)(selectFields + ",mulmodel,prodattributeentry.seq,prodattributeentry.prodattribute,prodattributeentry.prodattributevalue,prodattributeentry.attributeremark,protocolentry.prodpool,protocolentry.protocol"), (QFilter[])qFilter.toArray());
        HashMap<String, Set<Long>> spuAndProdMap = new HashMap<String, Set<Long>>(prods.length);
        for (DynamicObject prod : prods) {
            this.chgEffect((DynamicObject)prodIdAndDynMap.get(prod.getLong("id")), prod, spuAndProdMap);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prods);
        if (!prodIds.isEmpty()) {
            PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", prodIds);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        QFilter qFilter1 = new QFilter("goods", "in", prodIds);
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id", (QFilter[])qFilter1.toArray());
        Object[] prodPoolIds = prodPools.stream().map(prodPool -> prodPool.getLong("id")).toArray();
        OperationResult operationResult1 = OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodPoolIds, (OperateOption)option);
        CommonUtil.check((OperationResult)operationResult1);
        if (!spuAndProdMap.isEmpty()) {
            DynamicObject[] spus;
            QFilter qFilter2 = new QFilter("number", "in", spuAndProdMap.keySet());
            for (DynamicObject spu : spus = BusinessDataServiceHelper.load((String)"pmm_spu", (String)"number,spuskumapentry.goods", (QFilter[])qFilter2.toArray())) {
                Set prodId = (Set)spuAndProdMap.get(spu.getString("number"));
                DynamicObjectCollection entry = spu.getDynamicObjectCollection("spuskumapentry");
                entry.removeIf(next -> prodId.contains(next.getLong("goods_id")));
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])spus);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private void chgEffect(DynamicObject chgDyn, DynamicObject prod, Map<String, Set<Long>> spuAndProdMap) {
        ProdAttributeEntryChangeHandleImpl fieldChangeHandle;
        DynamicObjectCollection entryEntity = chgDyn.getDynamicObjectCollection("entryentity");
        boolean attributeChange = false;
        for (DynamicObject entry : entryEntity) {
            if (StringUtils.isBlank((CharSequence)entry.getString("entryname"))) {
                CommonFieldChangeHandle fieldChangeHandle2 = MalProdInfoChangeFactory.getFieldChangeHandleByInfoType((String)entry.getString("infotype"));
                fieldChangeHandle2.changeEffectUpdateProd(entry, prod);
                continue;
            }
            if (!"prodattributeentry".equals(entry.getString("entryname"))) continue;
            attributeChange = true;
        }
        if (attributeChange) {
            fieldChangeHandle = new ProdAttributeEntryChangeHandleImpl();
            fieldChangeHandle.changeEffectUpdateProd(chgDyn, prod);
        }
        fieldChangeHandle = new PicturePropChangeHandleImpl();
        fieldChangeHandle.changeEffectUpdateProd(chgDyn, prod);
        if (MalProdInfoChangeUtil.checkAttributeChangeInfluenceSPU((DynamicObject)chgDyn)) {
            Set prodIds = spuAndProdMap.computeIfAbsent(prod.getString("spunumber"), s -> new HashSet());
            prodIds.add(prod.getLong("id"));
            prod.set("spunumber", null);
            prod.set("mulmodel", (Object)false);
        }
        chgDyn.set("cfmstatus", (Object)"B");
        chgDyn.set("cfmdate", (Object)TimeServiceHelper.now());
        chgDyn.set("cfm", (Object)RequestContext.get().getCurrUserId());
    }
}

