/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.ent.opplugin.validator.EntProdManageDownloadValidator;
import kd.scm.malcore.enums.MallStatusEnum;

public class EntProdManageDownloadOp
extends AbstractOperationServicePlugIn {
    private static final String PROTOCOLENTRY = "protocolentry";
    private static final String PROTOCOL = "protocol";
    private static final String MALLSTATUS = "mallstatus";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(MALLSTATUS);
        fieldKeys.add(PROTOCOLENTRY);
        fieldKeys.add("protocolentry.protocol");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntProdManageDownloadValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(PROTOCOLENTRY);
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject protocolId = entry.getDynamicObject(PROTOCOL);
                if (protocolId != null) continue;
                dynamicObject.set(MALLSTATUS, (Object)MallStatusEnum.SOLDOUT.getVal());
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> pkIds = new ArrayList<Long>(objs.length);
        for (DynamicObject dyo : objs) {
            pkIds.add(dyo.getLong("id"));
        }
        if (!pkIds.isEmpty()) {
            PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", pkIds);
        }
    }
}

