/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ent.opplugin;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.ent.business.service.impl.EntProdPoolCommandServiceImpl;
import kd.scm.ent.opplugin.validator.EntProdManageBarcodeValidator;

public class EntProdManageSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("taxprice");
        fieldKeys.add("barcode");
        fieldKeys.add("supplier");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new EntProdManageBarcodeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            if (dynamicObject.get("taxprice") != null) continue;
            dynamicObject.set("taxprice", (Object)BigDecimal.ZERO);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.createNewProdPool(e.getDataEntities());
    }

    private void createNewProdPool(DynamicObject[] dataEntities) {
        EntProdPoolCommandServiceImpl prodPoolCommandService = new EntProdPoolCommandServiceImpl();
        List successPkIds = prodPoolCommandService.addNoProtocolProdPool(dataEntities);
        prodPoolCommandService.addProdEntry(successPkIds, dataEntities);
    }
}

